/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.nondeterminism;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.DelegateAbstractDomain;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.nondeterminism.NondeterminismMergeOperator;
import org.sosy_lab.cpachecker.cpa.nondeterminism.NondeterminismPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.nondeterminism.NondeterminismState;
import org.sosy_lab.cpachecker.cpa.nondeterminism.NondeterminismTransferRelation;

public class NondeterminismCPA
implements ConfigurableProgramAnalysis {
    private final DelegateAbstractDomain<NondeterminismState> domain;
    private final NondeterminismTransferRelation transferRelation;
    private final MergeOperator mergeOperator = new NondeterminismMergeOperator();

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(NondeterminismCPA.class);
    }

    public NondeterminismCPA(CFA pCFA, Configuration pConfig) throws InvalidConfigurationException {
        this.domain = DelegateAbstractDomain.getInstance();
        NondeterminismOptions options = new NondeterminismOptions();
        pConfig.inject((Object)options);
        this.transferRelation = new NondeterminismTransferRelation(pCFA, options.acceptConstrained);
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) throws InterruptedException {
        return new NondeterminismState.NondeterminismAbstractionState((Set<String>)ImmutableSet.of());
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.domain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return NondeterminismPrecisionAdjustment.INSTANCE;
    }

    @Override
    public StopOperator getStopOperator() {
        return new StopSepOperator(this.domain);
    }

    @Options(prefix="cpa.nondeterminism")
    private static class NondeterminismOptions {
        @Option(secure=true, description="keep tracking nondeterministically-assigned variables even if they are used in assumptions")
        private boolean acceptConstrained = true;

        private NondeterminismOptions() {
        }
    }
}

