/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.nondeterminism;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.util.Optional;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.nondeterminism.NondeterminismState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;

public enum NondeterminismPrecisionAdjustment implements PrecisionAdjustment
{
    INSTANCE;


    @Override
    public Optional<PrecisionAdjustmentResult> prec(AbstractState pState, Precision pPrecision, UnmodifiableReachedSet pStates, Function<AbstractState, AbstractState> pStateProjection, AbstractState pFullState) throws CPAException, InterruptedException {
        AbstractState state = this.prec(pState, (Iterable<AbstractState>)AbstractStates.asIterable(pFullState));
        return Optional.of(PrecisionAdjustmentResult.create(state, pPrecision, PrecisionAdjustmentResult.Action.CONTINUE));
    }

    @Override
    public Optional<? extends AbstractState> strengthen(AbstractState pState, Precision pPrecision, Iterable<AbstractState> pOtherStates) {
        return Optional.of(this.prec(pState, pOtherStates));
    }

    private AbstractState prec(AbstractState pState, Iterable<AbstractState> pOtherStates) {
        AbstractState result = pState;
        if (pState instanceof NondeterminismState.NondeterminismNonAbstractionState && FluentIterable.from(pOtherStates).filter(PredicateAbstractState.class).anyMatch(PredicateAbstractState::isAbstractionState)) {
            result = new NondeterminismState.NondeterminismAbstractionState(((NondeterminismState.NondeterminismNonAbstractionState)pState).getNondetVariables());
        }
        return result;
    }
}

