/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.nondeterminism;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.SortedMapDifference;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public abstract class NondeterminismState
implements LatticeAbstractState<NondeterminismState> {
    private NondeterminismState() {
    }

    public abstract Set<String> getNondetVariables();

    public abstract Set<String> getBlockNondetVariables();

    public static class NondeterminismAbstractionState
    extends NondeterminismState {
        private final Set<String> nondetVariablesPreAbstraction;

        NondeterminismAbstractionState(Set<String> pNondetVariablesPreAbstraction) {
            this.nondetVariablesPreAbstraction = ImmutableSet.copyOf(pNondetVariablesPreAbstraction);
        }

        @Override
        public NondeterminismState join(NondeterminismState pOther) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isLessOrEqual(NondeterminismState pOther) throws CPAException, InterruptedException {
            return pOther instanceof NondeterminismAbstractionState;
        }

        @Override
        public Set<String> getNondetVariables() {
            return ImmutableSet.of();
        }

        public Set<String> getNondetVariablesPreAbstraction() {
            return this.nondetVariablesPreAbstraction;
        }

        @Override
        public int hashCode() {
            return this.nondetVariablesPreAbstraction.hashCode();
        }

        @Override
        public boolean equals(Object pObj) {
            if (pObj == this) {
                return true;
            }
            if (pObj instanceof NondeterminismAbstractionState) {
                NondeterminismAbstractionState other = (NondeterminismAbstractionState)pObj;
                return this.nondetVariablesPreAbstraction.equals(other.nondetVariablesPreAbstraction);
            }
            return super.equals(pObj);
        }

        @Override
        public String toString() {
            return "Abstraction of nondeterministic variables " + this.nondetVariablesPreAbstraction;
        }

        @Override
        public Set<String> getBlockNondetVariables() {
            return this.nondetVariablesPreAbstraction;
        }
    }

    public static class NondeterminismNonAbstractionState
    extends NondeterminismState {
        private final PersistentSortedMap<String, Object> nondetVariables;

        NondeterminismNonAbstractionState() {
            this.nondetVariables = PathCopyingPersistentTreeMap.of();
        }

        private NondeterminismNonAbstractionState(PersistentSortedMap<String, Object> pNondetVariables) {
            this.nondetVariables = Objects.requireNonNull(pNondetVariables);
        }

        private NondeterminismNonAbstractionState(Map<String, Object> pNondetVariables) {
            this.nondetVariables = PathCopyingPersistentTreeMap.copyOf(pNondetVariables);
        }

        public NondeterminismNonAbstractionState addNondetVariable(String pVariable) {
            Objects.requireNonNull(pVariable);
            return this.addNondetVariables(Collections.singleton(pVariable));
        }

        public NondeterminismNonAbstractionState addNondetVariables(Set<String> pVariables) {
            PersistentSortedMap extended = this.nondetVariables;
            for (String variable : pVariables) {
                extended = extended.putAndCopy((Object)variable, NondeterminismState.class);
            }
            if (extended == this.nondetVariables) {
                return this;
            }
            return new NondeterminismNonAbstractionState(extended);
        }

        public NondeterminismNonAbstractionState removeNondetVariable(String pVariable) {
            return this.removeNondetVariables(Collections.singleton(pVariable));
        }

        public NondeterminismNonAbstractionState removeNondetVariables(Set<String> pVariables) {
            PersistentSortedMap remaining = this.nondetVariables;
            for (String variable : pVariables) {
                remaining = remaining.removeAndCopy((Object)variable);
            }
            if (remaining == this.nondetVariables) {
                return this;
            }
            return new NondeterminismNonAbstractionState((PersistentSortedMap<String, Object>)remaining);
        }

        @Override
        public NondeterminismState join(NondeterminismState pOther) {
            if (pOther instanceof NondeterminismNonAbstractionState) {
                NondeterminismNonAbstractionState other = (NondeterminismNonAbstractionState)pOther;
                SortedMapDifference diff = Maps.difference(this.nondetVariables, other.nondetVariables);
                if (diff.entriesOnlyOnLeft().isEmpty()) {
                    return this;
                }
                return new NondeterminismNonAbstractionState(diff.entriesInCommon());
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isLessOrEqual(NondeterminismState pOther) throws CPAException, InterruptedException {
            return this.getNondetVariables().containsAll(pOther.getNondetVariables());
        }

        @Override
        public Set<String> getNondetVariables() {
            return this.nondetVariables.keySet();
        }

        @Override
        public int hashCode() {
            return this.nondetVariables.hashCode();
        }

        @Override
        public boolean equals(Object pObj) {
            if (pObj == this) {
                return true;
            }
            if (pObj instanceof NondeterminismNonAbstractionState) {
                NondeterminismNonAbstractionState other = (NondeterminismNonAbstractionState)pObj;
                return this.nondetVariables.equals(other.nondetVariables);
            }
            return super.equals(pObj);
        }

        @Override
        public String toString() {
            return "Nondeterministic variables " + this.getNondetVariables();
        }

        @Override
        public Set<String> getBlockNondetVariables() {
            return this.getNondetVariables();
        }
    }
}

