/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.nondeterminism;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AAssignment;
import org.sosy_lab.cpachecker.cfa.ast.AAstNode;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.AInitializer;
import org.sosy_lab.cpachecker.cfa.ast.ALeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.ARightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.nondeterminism.NondeterminismState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class NondeterminismTransferRelation
extends SingleEdgeTransferRelation {
    private final CFA cfa;
    private final boolean acceptConstrained;

    public NondeterminismTransferRelation(CFA pCFA, boolean pAcceptConstrained) {
        this.cfa = pCFA;
        this.acceptConstrained = pAcceptConstrained;
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pEdge) throws CPATransferException, InterruptedException {
        NondeterminismState.NondeterminismNonAbstractionState state = pState instanceof NondeterminismState.NondeterminismAbstractionState ? new NondeterminismState.NondeterminismNonAbstractionState() : (NondeterminismState.NondeterminismNonAbstractionState)pState;
        return Collections.singleton(this.handleEdge(state, pEdge));
    }

    private NondeterminismState.NondeterminismNonAbstractionState handleEdge(NondeterminismState.NondeterminismNonAbstractionState pState, CFAEdge pEdge) {
        Objects.requireNonNull(pState);
        switch (pEdge.getEdgeType()) {
            case DeclarationEdge: {
                return NondeterminismTransferRelation.handleDeclaration(pState, (ADeclarationEdge)pEdge);
            }
            case StatementEdge: {
                return this.handleStatement(pState, (AStatementEdge)pEdge);
            }
            case ReturnStatementEdge: {
                return NondeterminismTransferRelation.handleReturnStatement(pState, (AReturnStatementEdge)pEdge);
            }
            case FunctionCallEdge: {
                return NondeterminismTransferRelation.handleFunctionCall(pState, (FunctionCallEdge)pEdge);
            }
            case AssumeEdge: {
                return this.handleAssumption(pState, (AssumeEdge)pEdge);
            }
        }
        return pState;
    }

    private static NondeterminismState.NondeterminismNonAbstractionState handleDeclaration(NondeterminismState.NondeterminismNonAbstractionState pState, ADeclarationEdge pEdge) {
        AVariableDeclaration variableDeclaration;
        ADeclaration declaration = pEdge.getDeclaration();
        if (declaration instanceof AVariableDeclaration && (variableDeclaration = (AVariableDeclaration)declaration).getInitializer() != null) {
            AInitializer initializer = variableDeclaration.getInitializer();
            return NondeterminismTransferRelation.handleAssignment(pState, declaration.getQualifiedName(), NondeterminismTransferRelation.getVariables(initializer));
        }
        return pState;
    }

    private NondeterminismState.NondeterminismNonAbstractionState handleStatement(NondeterminismState.NondeterminismNonAbstractionState pState, AStatementEdge pEdge) {
        AStatement statement = pEdge.getStatement();
        if (statement instanceof AExpressionStatement) {
            return pState;
        }
        if (statement instanceof AAssignment) {
            AAssignment assignment = (AAssignment)((Object)statement);
            ALeftHandSide lhs = assignment.getLeftHandSide();
            if (!(lhs instanceof AIdExpression)) {
                return new NondeterminismState.NondeterminismNonAbstractionState();
            }
            String lhsVariable = ((AIdExpression)lhs).getDeclaration().getQualifiedName();
            if (assignment instanceof AExpressionAssignmentStatement) {
                AExpressionAssignmentStatement exprAssignment = (AExpressionAssignmentStatement)assignment;
                return NondeterminismTransferRelation.handleAssignment(pState, lhsVariable, exprAssignment.getRightHandSide());
            }
            if (assignment instanceof AFunctionCallAssignmentStatement) {
                AFunctionCallAssignmentStatement callAssignment = (AFunctionCallAssignmentStatement)assignment;
                AFunctionCallExpression callExpression = callAssignment.getRightHandSide();
                AExpression functionNameExpression = callExpression.getFunctionNameExpression();
                if (functionNameExpression instanceof AIdExpression) {
                    AIdExpression functionIdExpression = (AIdExpression)functionNameExpression;
                    String functionName = functionIdExpression.getName();
                    FunctionEntryNode functionEntryNode = (FunctionEntryNode)this.cfa.getAllFunctions().get(functionName);
                    if (functionEntryNode == null) {
                        return pState.addNondetVariable(lhsVariable).addNondetVariable(functionName);
                    }
                    Optional<? extends AVariableDeclaration> retVar = functionEntryNode.getReturnVariable();
                    if (!retVar.isPresent()) {
                        return pState.addNondetVariable(lhsVariable);
                    }
                    String varName = retVar.get().getQualifiedName();
                    return NondeterminismTransferRelation.handleAssignment(pState, lhsVariable, Collections.singleton(varName));
                }
                return pState.removeNondetVariable(lhsVariable);
            }
            return pState.removeNondetVariable(lhsVariable);
        }
        return pState;
    }

    private static NondeterminismState.NondeterminismNonAbstractionState handleReturnStatement(NondeterminismState.NondeterminismNonAbstractionState pState, AReturnStatementEdge pEdge) {
        if (!pEdge.getExpression().isPresent()) {
            return pState;
        }
        Optional<? extends AVariableDeclaration> retVar = pEdge.getSuccessor().getEntryNode().getReturnVariable();
        if (!retVar.isPresent()) {
            return pState;
        }
        return NondeterminismTransferRelation.handleAssignment(pState, retVar.get().getQualifiedName(), pEdge.getExpression().get());
    }

    private static NondeterminismState.NondeterminismNonAbstractionState handleAssignment(NondeterminismState.NondeterminismNonAbstractionState pState, String pLhsVariable, ARightHandSide pRhs) {
        Set<String> rhsVariables = NondeterminismTransferRelation.getVariables(pRhs);
        return NondeterminismTransferRelation.handleAssignment(pState, pLhsVariable, rhsVariables);
    }

    private static NondeterminismState.NondeterminismNonAbstractionState handleAssignment(NondeterminismState.NondeterminismNonAbstractionState pState, String pLhsVariable, Set<String> pRhsVariables) {
        if (!pRhsVariables.isEmpty() && pState.getNondetVariables().containsAll(pRhsVariables)) {
            return pState.addNondetVariable(pLhsVariable);
        }
        return pState.removeNondetVariable(pLhsVariable);
    }

    private static NondeterminismState.NondeterminismNonAbstractionState handleFunctionCall(NondeterminismState.NondeterminismNonAbstractionState pState, FunctionCallEdge pEdge) {
        FunctionSummaryEdge summaryEdge = pEdge.getSummaryEdge();
        if (summaryEdge == null) {
            return pState;
        }
        return NondeterminismTransferRelation.handleFunctionCall(pState, summaryEdge.getFunctionEntry().getFunctionParameters(), pEdge.getArguments());
    }

    private static NondeterminismState.NondeterminismNonAbstractionState handleFunctionCall(NondeterminismState.NondeterminismNonAbstractionState pState, List<? extends AParameterDeclaration> pFunctionParameters, List<? extends AExpression> pCallArguments) {
        Iterator<? extends AParameterDeclaration> parameterIt = pFunctionParameters.iterator();
        Iterator<? extends AExpression> argumentIt = pCallArguments.iterator();
        NondeterminismState.NondeterminismNonAbstractionState state = pState;
        while (parameterIt.hasNext()) {
            AParameterDeclaration paramDecl = parameterIt.next();
            if (!argumentIt.hasNext()) {
                state = state.addNondetVariable(paramDecl.getQualifiedName());
                continue;
            }
            state = NondeterminismTransferRelation.handleAssignment(state, paramDecl.getQualifiedName(), argumentIt.next());
        }
        return state;
    }

    private NondeterminismState.NondeterminismNonAbstractionState handleAssumption(NondeterminismState.NondeterminismNonAbstractionState pState, AssumeEdge pEdge) {
        if (this.acceptConstrained) {
            return pState;
        }
        return pState.removeNondetVariables(NondeterminismTransferRelation.getVariables(pEdge.getExpression()));
    }

    private static Set<String> getVariables(AAstNode pAstNode) {
        return CFAUtils.traverseRecursively(pAstNode).filter(CIdExpression.class).transform(id -> id.getDeclaration().getQualifiedName()).toSet();
    }
}

