/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.octagon;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.octagon.OctagonState;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.octagon.Octagon;

class OctagonDomain
implements AbstractDomain {
    private static long totaltime = 0L;
    private final LogManager logger;

    public OctagonDomain(LogManager log) {
        this.logger = log;
    }

    @Override
    public boolean isLessOrEqual(AbstractState element1, AbstractState element2) {
        HashMap covers = new HashMap();
        long start = System.currentTimeMillis();
        OctagonState octState1 = (OctagonState)element1;
        OctagonState octState2 = (OctagonState)element2;
        if (covers.containsKey(octState2) && ((Set)covers.get(octState2)).contains(octState1)) {
            return true;
        }
        int result = octState1.isLessOrEquals(octState2);
        if (result == 1) {
            totaltime += System.currentTimeMillis() - start;
            return true;
        }
        if (result == 2) {
            totaltime += System.currentTimeMillis() - start;
            return false;
        }
        assert (result == 3);
        boolean included = octState1.getOctagon().getManager().isIncludedIn(octState1.getOctagon(), octState2.getOctagon());
        if (included) {
            Set s = covers.containsKey(octState2) ? (Set)covers.get(octState2) : new HashSet();
            s.add(octState1);
            covers.put(octState2, s);
        }
        totaltime += System.currentTimeMillis() - start;
        return included;
    }

    @Override
    public AbstractState join(AbstractState successor, AbstractState reached) {
        Pair<OctagonState, OctagonState> shrinkedStates = this.getShrinkedStates((OctagonState)successor, (OctagonState)reached);
        Octagon newOctagon = shrinkedStates.getFirst().getOctagon().getManager().union(shrinkedStates.getFirst().getOctagon(), shrinkedStates.getSecond().getOctagon());
        if (shrinkedStates.getFirst().getOctagon().getManager().isEmpty(newOctagon)) {
            throw new AssertionError((Object)"bottom state occured where it should not be");
        }
        OctagonState newState = new OctagonState(newOctagon, shrinkedStates.getFirst().getVariableToIndexMap(), shrinkedStates.getFirst().getVariableToTypeMap(), this.logger);
        if (((OctagonState)reached).isLoopHead()) {
            newState = newState.asLoopHead();
        }
        if (newState.equals(reached)) {
            return reached;
        }
        if (newState.equals(successor)) {
            return successor;
        }
        return newState;
    }

    public AbstractState widening(OctagonState successorOct, OctagonState reachedOct) {
        Pair<OctagonState, OctagonState> shrinkedStates = this.getShrinkedStates(successorOct, reachedOct);
        successorOct = shrinkedStates.getFirst();
        reachedOct = shrinkedStates.getSecond();
        Octagon newOctagon = reachedOct.getOctagon().getManager().widening(reachedOct.getOctagon(), successorOct.getOctagon());
        if (reachedOct.getOctagon().getManager().isEmpty(newOctagon)) {
            newOctagon = reachedOct.getOctagon().getManager().union(reachedOct.getOctagon(), successorOct.getOctagon());
            this.logger.log(Level.WARNING, new Object[]{"bottom state occured where it should not be, using union instead of widening as a fallback"});
            if (reachedOct.getOctagon().getManager().isEmpty(newOctagon)) {
                throw new AssertionError((Object)"bottom state occured where it should not be");
            }
        }
        OctagonState newState = new OctagonState(newOctagon, successorOct.getVariableToIndexMap(), successorOct.getVariableToTypeMap(), this.logger);
        if (reachedOct.isLoopHead()) {
            newState = newState.asLoopHead();
        }
        if (newState.equals(successorOct)) {
            return successorOct;
        }
        if (newState.equals(reachedOct)) {
            return reachedOct;
        }
        return newState;
    }

    private Pair<OctagonState, OctagonState> getShrinkedStates(OctagonState succ, OctagonState reached) {
        if (succ.sizeOfVariables() > reached.sizeOfVariables()) {
            Pair<OctagonState, OctagonState> tmp = succ.shrinkToFittingSize(reached);
            succ = tmp.getFirst();
            reached = tmp.getSecond();
        } else {
            Pair<OctagonState, OctagonState> tmp = reached.shrinkToFittingSize(succ);
            succ = tmp.getSecond();
            reached = tmp.getFirst();
        }
        return Pair.of(succ, reached);
    }
}

