/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.octagon;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.octagon.coefficients.IOctagonCoefficients;
import org.sosy_lab.cpachecker.cpa.octagon.coefficients.OctagonIntervalCoefficients;
import org.sosy_lab.cpachecker.cpa.octagon.coefficients.OctagonSimpleCoefficients;
import org.sosy_lab.cpachecker.cpa.octagon.coefficients.OctagonUniversalCoefficients;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonDoubleValue;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonIntValue;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonInterval;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonNumericValue;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.octagon.NumArray;
import org.sosy_lab.cpachecker.util.octagon.Octagon;
import org.sosy_lab.cpachecker.util.octagon.OctagonManager;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class OctagonState
implements AbstractState {
    private Octagon octagon;
    private OctagonManager octagonManager;
    private final OctagonDoubleValue ASSUMPTION_DELTA = new OctagonDoubleValue(1.0E-15);
    private BiMap<MemoryLocation, Integer> variableToIndexMap;
    private Map<MemoryLocation, Type> variableToTypeMap;
    private final boolean isLoopHead;
    private LogManager logger;

    public OctagonState(LogManager log, OctagonManager manager) {
        this.octagon = manager.universe(0);
        this.octagonManager = manager;
        this.variableToIndexMap = HashBiMap.create();
        this.variableToTypeMap = new HashMap<MemoryLocation, Type>();
        this.isLoopHead = false;
        this.logger = log;
        Octagon.removePhantomReferences();
    }

    public OctagonState(Octagon oct, BiMap<MemoryLocation, Integer> map, Map<MemoryLocation, Type> typeMap, LogManager log) {
        this.octagon = oct;
        this.octagonManager = this.octagon.getManager();
        this.variableToIndexMap = map;
        this.variableToTypeMap = typeMap;
        this.isLoopHead = false;
        this.logger = log;
        Octagon.removePhantomReferences();
    }

    private OctagonState(Octagon oct, BiMap<MemoryLocation, Integer> map, Map<MemoryLocation, Type> typeMap, LogManager log, boolean pIsLoopHead) {
        this.octagon = oct;
        this.octagonManager = this.octagon.getManager();
        this.variableToIndexMap = map;
        this.variableToTypeMap = typeMap;
        this.isLoopHead = pIsLoopHead;
        this.logger = log;
        Octagon.removePhantomReferences();
    }

    public OctagonState asLoopHead() {
        return new OctagonState(this.octagon, this.variableToIndexMap, this.variableToTypeMap, this.logger, true);
    }

    public boolean isLoopHead() {
        return this.isLoopHead;
    }

    @Override
    public boolean equals(Object pObj) {
        if (!(pObj instanceof OctagonState)) {
            return false;
        }
        OctagonState otherOct = (OctagonState)pObj;
        return this.isLoopHead == otherOct.isLoopHead && Objects.equals(this.variableToIndexMap, otherOct.variableToIndexMap) && this.octagon.equals(otherOct.octagon);
    }

    protected int isLessOrEquals(OctagonState state) {
        assert (!this.isEmpty()) : "Empty states should not occur here!";
        if (this.variableToIndexMap.equals(state.variableToIndexMap)) {
            return this.octagon.getManager().isIncludedInLazy(this.octagon, state.octagon);
        }
        this.logger.log(Level.FINEST, new Object[]{"Removing some temporary (in the transferrelation) introduced variables from the octagon to compute #isLessOrEquals()"});
        if (this.variableToIndexMap.entrySet().containsAll(state.variableToIndexMap.entrySet())) {
            Pair<OctagonState, OctagonState> checkStates = this.shrinkToFittingSize(state);
            return this.octagon.getManager().isIncludedInLazy(checkStates.getFirst().octagon, checkStates.getSecond().octagon);
        }
        return 2;
    }

    public Pair<OctagonState, OctagonState> shrinkToFittingSize(OctagonState oct) {
        OctagonState newState2;
        OctagonState newState1;
        int maxEqualIndex = oct.sizeOfVariables() - 1;
        BiMap inverseThis = this.variableToIndexMap.inverse();
        BiMap inverseOther = oct.variableToIndexMap.inverse();
        for (int i = maxEqualIndex; i >= 0; --i) {
            if (((MemoryLocation)inverseThis.get((Object)i)).equals(inverseOther.get((Object)i))) continue;
            maxEqualIndex = i - 1;
        }
        if (this.variableToIndexMap.size() != maxEqualIndex + 1) {
            HashBiMap newMap1 = HashBiMap.create(this.variableToIndexMap);
            HashMap<MemoryLocation, Type> newTypeMap1 = new HashMap<MemoryLocation, Type>(this.variableToTypeMap);
            for (int i = this.variableToIndexMap.size() - 1; i > maxEqualIndex; --i) {
                newTypeMap1.remove(newMap1.inverse().remove((Object)i));
            }
            Octagon newOct1 = this.octagonManager.removeDimension(this.octagon, this.variableToIndexMap.size() - (maxEqualIndex + 1));
            newState1 = new OctagonState(newOct1, (BiMap<MemoryLocation, Integer>)newMap1, newTypeMap1, this.logger, this.isLoopHead);
        } else {
            newState1 = this;
        }
        if (oct.variableToIndexMap.size() != maxEqualIndex + 1) {
            HashBiMap newMap2 = HashBiMap.create(oct.variableToIndexMap);
            HashMap<MemoryLocation, Type> newTypeMap2 = new HashMap<MemoryLocation, Type>(oct.variableToTypeMap);
            for (int i = oct.variableToIndexMap.size() - 1; i > maxEqualIndex; --i) {
                newTypeMap2.remove(newMap2.inverse().remove((Object)i));
            }
            Octagon newOct2 = this.octagonManager.removeDimension(oct.octagon, oct.variableToIndexMap.size() - (maxEqualIndex + 1));
            newState2 = new OctagonState(newOct2, (BiMap<MemoryLocation, Integer>)newMap2, newTypeMap2, this.logger, this.isLoopHead);
        } else {
            newState2 = oct;
        }
        return Pair.of(newState1, newState2);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.variableToIndexMap);
        result = 31 * result + Objects.hashCode(this.variableToTypeMap);
        result = 31 * result + Boolean.hashCode(this.isLoopHead);
        return result;
    }

    @Override
    public String toString() {
        return this.octagonManager.print(this.octagon, (BiMap<Integer, MemoryLocation>)this.variableToIndexMap.inverse());
    }

    public Octagon getOctagon() {
        return this.octagon;
    }

    public int sizeOfVariables() {
        return this.variableToIndexMap.size();
    }

    public BiMap<MemoryLocation, Integer> getVariableToIndexMap() {
        return this.variableToIndexMap;
    }

    public Map<MemoryLocation, Type> getVariableToTypeMap() {
        return this.variableToTypeMap;
    }

    public boolean isEmpty() {
        return this.octagonManager.isEmpty(this.octagon);
    }

    public OctagonState forget(MemoryLocation pVariableName) {
        int varIdx = this.getVariableIndexFor(pVariableName);
        if (varIdx == -1) {
            return this;
        }
        return new OctagonState(this.octagonManager.forget(this.octagon, varIdx), (BiMap<MemoryLocation, Integer>)HashBiMap.create(this.variableToIndexMap), new HashMap<MemoryLocation, Type>(this.variableToTypeMap), this.logger);
    }

    protected int getVariableIndexFor(MemoryLocation pVariableName) {
        Integer result = (Integer)this.variableToIndexMap.get((Object)pVariableName);
        if (result == null) {
            return -1;
        }
        return result;
    }

    protected MemoryLocation getVariableNameFor(int index) {
        MemoryLocation result = (MemoryLocation)this.variableToIndexMap.inverse().get((Object)index);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0);
        return result;
    }

    protected boolean existsVariable(MemoryLocation pTempVarName) {
        return this.variableToIndexMap.containsKey((Object)pTempVarName);
    }

    public OctagonState declareVariable(MemoryLocation pTempVarName, Type type) {
        assert (!this.variableToIndexMap.containsKey((Object)pTempVarName));
        OctagonState newState = new OctagonState(this.octagonManager.addDimensionAndEmbed(this.octagon, 1), (BiMap<MemoryLocation, Integer>)HashBiMap.create(this.variableToIndexMap), new HashMap<MemoryLocation, Type>(this.variableToTypeMap), this.logger);
        newState.variableToIndexMap.put((Object)pTempVarName, (Object)this.sizeOfVariables());
        newState.variableToTypeMap.put(pTempVarName, type);
        return newState;
    }

    public OctagonState makeAssignment(MemoryLocation pTempVarName, IOctagonCoefficients oct) {
        if (this.getVariableIndexFor(pTempVarName) == -1) {
            return this;
        }
        if (oct instanceof OctagonSimpleCoefficients) {
            return this.makeAssignment(pTempVarName, (OctagonSimpleCoefficients)oct);
        }
        if (oct instanceof OctagonIntervalCoefficients) {
            return this.makeAssignment(pTempVarName, (OctagonIntervalCoefficients)oct);
        }
        if (oct instanceof OctagonUniversalCoefficients) {
            return this.forget(pTempVarName);
        }
        throw new IllegalArgumentException("Unkown subtype of OctCoefficients.");
    }

    private OctagonState makeAssignment(MemoryLocation leftVarName, OctagonSimpleCoefficients oct) {
        assert (this.sizeOfVariables() == oct.size()) : "coefficients do not have the right size";
        if (this.getVariableIndexFor(leftVarName) == -1) {
            return this;
        }
        NumArray arr = oct.getNumArray(this.octagonManager);
        int varIdx = this.getVariableIndexFor(leftVarName);
        if (varIdx == -1) {
            return this;
        }
        OctagonState newState = new OctagonState(this.octagonManager.assingVar(this.octagon, varIdx, arr), (BiMap<MemoryLocation, Integer>)HashBiMap.create(this.variableToIndexMap), new HashMap<MemoryLocation, Type>(this.variableToTypeMap), this.logger);
        this.octagonManager.num_clear_n(arr, oct.size());
        return newState;
    }

    private OctagonState makeAssignment(MemoryLocation leftVarName, OctagonIntervalCoefficients oct) {
        assert (this.sizeOfVariables() == oct.size()) : "coefficients do not have the right size";
        if (this.getVariableIndexFor(leftVarName) == -1) {
            return this;
        }
        NumArray arr = oct.getNumArray(this.octagonManager);
        int varIdx = this.getVariableIndexFor(leftVarName);
        if (varIdx == -1) {
            return this;
        }
        OctagonState newState = new OctagonState(this.octagonManager.intervAssingVar(this.octagon, varIdx, arr), (BiMap<MemoryLocation, Integer>)HashBiMap.create(this.variableToIndexMap), new HashMap<MemoryLocation, Type>(this.variableToTypeMap), this.logger);
        this.octagonManager.num_clear_n(arr, oct.size());
        return newState;
    }

    private OctagonState addConstraint(BinaryConstraints cons, int leftIndex, int rightIndex, OctagonNumericValue constantValue) {
        NumArray arr = this.octagonManager.init_num_t(4);
        this.octagonManager.num_set_int(arr, 0, cons.getNumber());
        this.octagonManager.num_set_int(arr, 1, leftIndex);
        this.octagonManager.num_set_int(arr, 2, rightIndex);
        if (constantValue instanceof OctagonDoubleValue) {
            this.octagonManager.num_set_float(arr, 3, ((Number)constantValue.getValue()).doubleValue());
        } else {
            this.octagonManager.num_set_int(arr, 3, ((Number)constantValue.getValue()).longValue());
        }
        OctagonState newState = new OctagonState(this.octagonManager.addBinConstraint(this.octagon, 1, arr), (BiMap<MemoryLocation, Integer>)HashBiMap.create(this.variableToIndexMap), new HashMap<MemoryLocation, Type>(this.variableToTypeMap), this.logger);
        this.octagonManager.num_clear_n(arr, 4);
        return newState;
    }

    public OctagonState addSmallerEqConstraint(MemoryLocation pLeftVarName, MemoryLocation pRightVarName) {
        return this.addSmallerEqConstraint0(pLeftVarName, pRightVarName, OctagonIntValue.ZERO);
    }

    private OctagonState addSmallerEqConstraint0(MemoryLocation pRightVariableName, MemoryLocation pLeftVariableName, OctagonNumericValue pConstant) {
        int rVarIdx = this.getVariableIndexFor(pRightVariableName);
        int lVarIdx = this.getVariableIndexFor(pLeftVariableName);
        if (rVarIdx == -1 || lVarIdx == -1) {
            return this;
        }
        return this.addConstraint(BinaryConstraints.PXMY, lVarIdx, rVarIdx, pConstant);
    }

    public OctagonState addSmallerEqConstraint(MemoryLocation pVariableName, OctagonNumericValue pValueOfLiteral) {
        int varIdx = this.getVariableIndexFor(pVariableName);
        if (varIdx == -1) {
            return this;
        }
        return this.addConstraint(BinaryConstraints.PX, varIdx, -1, pValueOfLiteral);
    }

    public OctagonState addSmallerEqConstraint(MemoryLocation pVariableName, IOctagonCoefficients oct) {
        if (oct instanceof OctagonUniversalCoefficients) {
            return this;
        }
        if (oct instanceof OctagonSimpleCoefficients) {
            oct = ((OctagonSimpleCoefficients)oct).convertToInterval();
        }
        oct = oct.add(new OctagonIntervalCoefficients(oct.size(), new OctagonInterval(Double.NEGATIVE_INFINITY, 0.0), this));
        OctagonState assignedState = this.makeAssignment(pVariableName, oct);
        return assignedState.intersect(this);
    }

    public OctagonState addSmallerConstraint(MemoryLocation pLeftVarName, MemoryLocation pRightVarName) {
        int rVarIdx = this.getVariableIndexFor(pLeftVarName);
        int lVarIdx = this.getVariableIndexFor(pRightVarName);
        if (rVarIdx == -1 || lVarIdx == -1) {
            return this;
        }
        if (this.variableToTypeMap.get(pLeftVarName) == Type.FLOAT || this.variableToTypeMap.get(pRightVarName) == Type.FLOAT) {
            return this.addSmallerEqConstraint0(pLeftVarName, pRightVarName, this.ASSUMPTION_DELTA);
        }
        return this.addConstraint(BinaryConstraints.PXMY, lVarIdx, rVarIdx, OctagonIntValue.NEG_ONE);
    }

    public OctagonState addSmallerConstraint(MemoryLocation pVariableName, OctagonNumericValue pValueOfLiteral) {
        int varIdx = this.getVariableIndexFor(pVariableName);
        if (varIdx == -1) {
            return this;
        }
        if (this.variableToTypeMap.get(pVariableName) == Type.FLOAT) {
            return this.addSmallerEqConstraint(pVariableName, pValueOfLiteral.subtract(this.ASSUMPTION_DELTA));
        }
        return this.addConstraint(BinaryConstraints.PX, varIdx, -1, pValueOfLiteral.subtract(OctagonIntValue.ONE));
    }

    public OctagonState addSmallerConstraint(MemoryLocation pVariableName, IOctagonCoefficients oct) {
        if (this.variableToTypeMap.get(pVariableName) == Type.FLOAT) {
            return this.addSmallerEqConstraint(pVariableName, oct.sub(new OctagonSimpleCoefficients(oct.size(), this.ASSUMPTION_DELTA, this)));
        }
        if (oct instanceof OctagonUniversalCoefficients) {
            return this;
        }
        if (oct instanceof OctagonSimpleCoefficients) {
            oct = ((OctagonSimpleCoefficients)oct).convertToInterval();
        }
        oct = oct.add(new OctagonIntervalCoefficients(oct.size(), new OctagonInterval(Double.NEGATIVE_INFINITY, -1.0), this));
        OctagonState assignedState = this.makeAssignment(pVariableName, oct);
        return assignedState.intersect(this);
    }

    public OctagonState addGreaterEqConstraint(MemoryLocation pLeftVarName, MemoryLocation pRightVarName) {
        return this.addGreaterEqConstraint0(pLeftVarName, pRightVarName, OctagonIntValue.ZERO);
    }

    private OctagonState addGreaterEqConstraint0(MemoryLocation pRightVariableName, MemoryLocation pLeftVariableName, OctagonNumericValue pConstant) {
        int rVarIdx = this.getVariableIndexFor(pRightVariableName);
        int lVarIdx = this.getVariableIndexFor(pLeftVariableName);
        if (rVarIdx == -1 || lVarIdx == -1) {
            return this;
        }
        return this.addConstraint(BinaryConstraints.MXPY, lVarIdx, rVarIdx, pConstant);
    }

    public OctagonState addGreaterEqConstraint(MemoryLocation pVariableName, OctagonNumericValue pValueOfLiteral) {
        int varIdx = this.getVariableIndexFor(pVariableName);
        if (varIdx == -1) {
            return this;
        }
        return this.addConstraint(BinaryConstraints.MX, varIdx, -1, pValueOfLiteral.mul(-1L));
    }

    public OctagonState addGreaterEqConstraint(MemoryLocation pVariableName, IOctagonCoefficients oct) {
        if (oct instanceof OctagonUniversalCoefficients) {
            return this;
        }
        if (oct instanceof OctagonSimpleCoefficients) {
            oct = ((OctagonSimpleCoefficients)oct).convertToInterval();
        }
        oct = oct.add(new OctagonIntervalCoefficients(oct.size(), new OctagonInterval(0.0, Double.POSITIVE_INFINITY), this));
        OctagonState assignedState = this.makeAssignment(pVariableName, oct);
        return assignedState.intersect(this);
    }

    public OctagonState addGreaterConstraint(MemoryLocation pLeftVarName, MemoryLocation pRightVarName) {
        int rVarIdx = this.getVariableIndexFor(pLeftVarName);
        int lVarIdx = this.getVariableIndexFor(pRightVarName);
        if (rVarIdx == -1 || lVarIdx == -1) {
            return this;
        }
        if (this.variableToTypeMap.get(pLeftVarName) == Type.FLOAT || this.variableToTypeMap.get(pRightVarName) == Type.FLOAT) {
            return this.addGreaterEqConstraint0(pLeftVarName, pRightVarName, this.ASSUMPTION_DELTA.mul(-1L));
        }
        return this.addConstraint(BinaryConstraints.MXPY, lVarIdx, rVarIdx, OctagonIntValue.NEG_ONE);
    }

    public OctagonState addGreaterConstraint(MemoryLocation pVariableName, OctagonNumericValue pValueOfLiteral) {
        int varIdx = this.getVariableIndexFor(pVariableName);
        if (varIdx == -1) {
            return this;
        }
        if (this.variableToTypeMap.get(pVariableName) == Type.FLOAT) {
            return this.addGreaterEqConstraint(pVariableName, pValueOfLiteral.add(this.ASSUMPTION_DELTA));
        }
        return this.addConstraint(BinaryConstraints.MX, varIdx, -1, pValueOfLiteral.add(OctagonIntValue.ONE).mul(-1L));
    }

    public OctagonState addGreaterConstraint(MemoryLocation pVariableName, IOctagonCoefficients oct) {
        if (this.variableToTypeMap.get(pVariableName) == Type.FLOAT) {
            return this.addGreaterEqConstraint(pVariableName, oct.add(new OctagonSimpleCoefficients(oct.size(), this.ASSUMPTION_DELTA, this)));
        }
        if (oct instanceof OctagonUniversalCoefficients) {
            return this;
        }
        if (oct instanceof OctagonSimpleCoefficients) {
            oct = ((OctagonSimpleCoefficients)oct).convertToInterval();
        }
        oct = oct.add(new OctagonIntervalCoefficients(oct.size(), new OctagonInterval(1.0, Double.POSITIVE_INFINITY), this));
        OctagonState assignedState = this.makeAssignment(pVariableName, oct);
        return assignedState.intersect(this);
    }

    public OctagonState addEqConstraint(MemoryLocation pLeftVarName, MemoryLocation pRightVarName) {
        return this.addSmallerEqConstraint(pLeftVarName, pRightVarName).addGreaterEqConstraint(pLeftVarName, pRightVarName);
    }

    public OctagonState addEqConstraint(MemoryLocation pVariableName, OctagonNumericValue constantValue) {
        return this.addSmallerEqConstraint(pVariableName, constantValue).addGreaterEqConstraint(pVariableName, constantValue);
    }

    public OctagonState addEqConstraint(MemoryLocation pVariableName, IOctagonCoefficients coeffs) {
        OctagonState assignedState = this.makeAssignment(pVariableName, coeffs);
        return assignedState.intersect(this);
    }

    public Set<OctagonState> addIneqConstraint(MemoryLocation pLeftVarName, MemoryLocation pRightVarName) {
        HashSet<OctagonState> set = new HashSet<OctagonState>();
        set.add(this.addSmallerConstraint(pLeftVarName, pRightVarName));
        set.add(this.addGreaterConstraint(pLeftVarName, pRightVarName));
        return set;
    }

    public Set<OctagonState> addIneqConstraint(MemoryLocation varname, OctagonNumericValue value) {
        HashSet<OctagonState> set = new HashSet<OctagonState>();
        set.add(this.addSmallerConstraint(varname, value));
        set.add(this.addGreaterConstraint(varname, value));
        return set;
    }

    public Set<OctagonState> addIneqConstraint(MemoryLocation varname, IOctagonCoefficients oct) {
        HashSet<OctagonState> set = new HashSet<OctagonState>();
        set.add(this.addSmallerConstraint(varname, oct));
        set.add(this.addGreaterConstraint(varname, oct));
        return set;
    }

    public OctagonState intersect(OctagonState other) {
        return new OctagonState(this.octagonManager.intersection(this.octagon, other.octagon), (BiMap<MemoryLocation, Integer>)HashBiMap.create(this.variableToIndexMap), new HashMap<MemoryLocation, Type>(this.variableToTypeMap), this.logger);
    }

    public OctagonState removeTempVars(String functionName, String varPrefix) {
        return this.removeVars(functionName + "::" + varPrefix);
    }

    public OctagonState removeLocalVars(String functionName) {
        return this.removeVars(functionName + "::");
    }

    public Map<MemoryLocation, OctagonInterval> getVariablesWithBounds() {
        HashMap<MemoryLocation, OctagonInterval> vars = new HashMap<MemoryLocation, OctagonInterval>();
        for (MemoryLocation varName : this.variableToIndexMap.keySet()) {
            vars.put(varName, this.octagonManager.getVariableBounds(this.octagon, this.getVariableIndexFor(varName)));
        }
        return vars;
    }

    public OctagonInterval getVariableBounds(int index) {
        assert (index < this.sizeOfVariables());
        return this.octagonManager.getVariableBounds(this.octagon, index);
    }

    private OctagonState removeVars(String varPrefix) {
        ArrayList<MemoryLocation> keysToRemove = new ArrayList<MemoryLocation>();
        for (MemoryLocation var : this.variableToIndexMap.keySet()) {
            if (!var.getExtendedQualifiedName().startsWith(varPrefix)) continue;
            keysToRemove.add(var);
        }
        if (keysToRemove.isEmpty()) {
            return this;
        }
        OctagonState newState = new OctagonState(this.octagonManager.removeDimension(this.octagon, keysToRemove.size()), (BiMap<MemoryLocation, Integer>)HashBiMap.create(this.variableToIndexMap), new HashMap<MemoryLocation, Type>(this.variableToTypeMap), this.logger);
        newState.variableToIndexMap.keySet().removeAll(keysToRemove);
        newState.variableToTypeMap.keySet().removeAll(keysToRemove);
        for (int i = 0; i < newState.variableToIndexMap.size(); ++i) {
            if (newState.variableToIndexMap.inverse().get((Object)i) == null) {
                throw new AssertionError();
            }
        }
        assert (this.octagonManager.dimension(newState.octagon) == newState.sizeOfVariables());
        return newState;
    }

    static enum Type {
        INT,
        FLOAT;

    }

    static enum BinaryConstraints {
        PX(0),
        MX(1),
        PXPY(2),
        PXMY(3),
        MXPY(4),
        MXMY(5);

        private final int num;

        private BinaryConstraints(int i) {
            this.num = i;
        }

        int getNumber() {
            return this.num;
        }
    }
}

