/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.octagon;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.core.defaults.ForwardingTransferRelation;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.cpa.octagon.OctagonState;
import org.sosy_lab.cpachecker.cpa.octagon.coefficients.AOctagonCoefficients;
import org.sosy_lab.cpachecker.cpa.octagon.coefficients.IOctagonCoefficients;
import org.sosy_lab.cpachecker.cpa.octagon.coefficients.OctagonIntervalCoefficients;
import org.sosy_lab.cpachecker.cpa.octagon.coefficients.OctagonSimpleCoefficients;
import org.sosy_lab.cpachecker.cpa.octagon.coefficients.OctagonUniversalCoefficients;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonDoubleValue;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonIntValue;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonNumericValue;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCodeException;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class OctagonTransferRelation
extends ForwardingTransferRelation<Collection<OctagonState>, OctagonState, VariableTrackingPrecision> {
    private static final String TEMP_VAR_PREFIX = "___cpa_temp_var_";
    private static int temporaryVariableCounter = 0;
    private static final ImmutableMap<String, String> UNSUPPORTED_FUNCTIONS = ImmutableMap.of();
    private final LogManager logger;
    private final ImmutableSet<CFANode> loopHeads;

    public OctagonTransferRelation(LogManager log, LoopStructure loops) {
        this.logger = log;
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (LoopStructure.Loop l : loops.getAllLoops()) {
            builder.addAll(l.getLoopHeads());
        }
        this.loopHeads = builder.build();
    }

    @Override
    protected Collection<OctagonState> postProcessing(Collection<OctagonState> successors, CFAEdge edge) {
        assert (!successors.contains(null));
        assert (!successors.removeAll(Collections.singleton(null)));
        Iterator<OctagonState> states = successors.iterator();
        while (states.hasNext()) {
            OctagonState st = states.next();
            if (!st.isEmpty()) continue;
            states.remove();
            this.logger.log(Level.FINER, new Object[]{"removing state because of unsatisfiable constraints:\n" + st + "________________\nEdge was:\n" + edge.getDescription()});
        }
        HashSet<OctagonState> cleanedUpStates = new HashSet<OctagonState>();
        for (OctagonState st : successors) {
            cleanedUpStates.add(st.removeTempVars(this.functionName, TEMP_VAR_PREFIX));
        }
        if (this.loopHeads.contains((Object)edge.getSuccessor())) {
            HashSet<OctagonState> newStates = new HashSet<OctagonState>();
            for (OctagonState s : cleanedUpStates) {
                newStates.add(s.asLoopHead());
            }
            cleanedUpStates = newStates;
        }
        return cleanedUpStates;
    }

    @Override
    protected Set<OctagonState> handleBlankEdge(BlankEdge cfaEdge) {
        return Collections.singleton((OctagonState)this.state);
    }

    @Override
    protected Set<OctagonState> handleAssumption(CAssumeEdge cfaEdge, CExpression expression, boolean truthAssumption) throws CPATransferException {
        if (expression instanceof CBinaryExpression) {
            return this.handleBinaryBooleanExpression((CBinaryExpression)expression, truthAssumption, (OctagonState)this.state);
        }
        if (expression instanceof CUnaryExpression) {
            CUnaryExpression unaryExp = (CUnaryExpression)expression;
            switch (unaryExp.getOperator()) {
                case MINUS: {
                    return this.handleAssumption(cfaEdge, unaryExp.getOperand(), truthAssumption);
                }
                case SIZEOF: 
                case TILDE: 
                case AMPER: {
                    return Collections.singleton((OctagonState)this.state);
                }
            }
            throw new CPATransferException("Unhandled case: " + unaryExp.getOperator());
        }
        if (expression instanceof CIdExpression || expression instanceof CFieldReference || expression instanceof CPointerExpression && ((CPointerExpression)expression).getOperand() instanceof CIdExpression) {
            if (this.isHandleableVariable(expression)) {
                MemoryLocation varName = this.buildVarName((CLeftHandSide)expression, this.functionName);
                return this.handleSingleBooleanExpression(varName, truthAssumption, (OctagonState)this.state);
            }
            return Collections.singleton((OctagonState)this.state);
        }
        if (expression instanceof CLiteralExpression) {
            if (expression instanceof CIntegerLiteralExpression) {
                return this.handleLiteralBooleanExpression(((CIntegerLiteralExpression)expression).asLong(), truthAssumption, (OctagonState)this.state);
            }
            if (expression instanceof CCharLiteralExpression) {
                return this.handleLiteralBooleanExpression(((CCharLiteralExpression)expression).getCharacter(), truthAssumption, (OctagonState)this.state);
            }
            if (expression instanceof CFloatLiteralExpression) {
                int val = Math.abs(((CFloatLiteralExpression)expression).getValue().signum());
                return this.handleLiteralBooleanExpression(val, truthAssumption, (OctagonState)this.state);
            }
            return Collections.singleton((OctagonState)this.state);
        }
        if (expression instanceof CCastExpression) {
            return this.handleAssumption(cfaEdge, ((CCastExpression)expression).getOperand(), truthAssumption);
        }
        throw new UnrecognizedCodeException("Unknown expression type in assumption", cfaEdge, expression);
    }

    private Set<OctagonState> handleLiteralBooleanExpression(long value, boolean truthAssumption, OctagonState pState) {
        if (value == 0L == truthAssumption) {
            return ImmutableSet.of();
        }
        return Collections.singleton(pState);
    }

    private OctagonState.Type getCorrespondingOctStateType(CType type) {
        if (type instanceof CSimpleType && (((CSimpleType)type).getType() == CBasicType.FLOAT || ((CSimpleType)type).getType() == CBasicType.DOUBLE)) {
            return OctagonState.Type.FLOAT;
        }
        return OctagonState.Type.INT;
    }

    private Set<OctagonState> handleBinaryBooleanExpression(CBinaryExpression binExp, boolean truthAssumption, OctagonState pState) throws CPATransferException {
        switch (binExp.getOperator()) {
            case BINARY_AND: 
            case BINARY_OR: 
            case BINARY_XOR: 
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: 
            case MODULO: {
                return Collections.singleton(pState);
            }
            case MINUS: 
            case PLUS: 
            case MULTIPLY: 
            case DIVIDE: {
                MemoryLocation tempVarName = MemoryLocation.forLocalVariable(this.functionName, TEMP_VAR_PREFIX + temporaryVariableCounter + "_");
                ++temporaryVariableCounter;
                COctagonCoefficientVisitor coeffVisitor = new COctagonCoefficientVisitor(pState, this.functionName);
                Set<Pair<IOctagonCoefficients, OctagonState>> coeffsList = binExp.accept(coeffVisitor);
                HashSet<OctagonState> possibleStates = new HashSet<OctagonState>();
                for (Pair<IOctagonCoefficients, OctagonState> pairs : coeffsList) {
                    IOctagonCoefficients coeffs = pairs.getFirst();
                    if (coeffs.equals(OctagonUniversalCoefficients.INSTANCE)) {
                        return Collections.singleton(pState);
                    }
                    OctagonState tmp = pairs.getSecond().declareVariable(tempVarName, this.getCorrespondingOctStateType(binExp.getExpressionType()));
                    tmp = tmp.makeAssignment(tempVarName, coeffs.expandToSize(tmp.sizeOfVariables(), tmp));
                    possibleStates.addAll(this.handleSingleBooleanExpression(tempVarName, truthAssumption, tmp));
                }
                return possibleStates;
            }
            case EQUALS: 
            case NOT_EQUALS: 
            case GREATER_EQUAL: 
            case GREATER_THAN: 
            case LESS_EQUAL: 
            case LESS_THAN: {
                CExpression left = binExp.getOperand1();
                CExpression right = binExp.getOperand2();
                CBinaryExpression.BinaryOperator op = binExp.getOperator();
                if (!this.isHandleableVariable(left) || !this.isHandleableVariable(right)) {
                    return Collections.singleton(pState);
                }
                if (left instanceof CLiteralExpression || right instanceof CLiteralExpression) {
                    return this.handleBinaryAssumptionWithLiteral(left, right, op, truthAssumption, pState);
                }
                return this.handleBinaryAssumptionWithoutLiteral(binExp, truthAssumption, left, right, pState);
            }
        }
        throw new CPATransferException("Unhandled case: " + binExp.getOperator());
    }

    private Set<OctagonState> handleBinaryAssumptionWithLiteral(CExpression left, CExpression right, CBinaryExpression.BinaryOperator op, boolean truthAssumption, OctagonState pState) throws CPATransferException {
        if (left instanceof CStringLiteralExpression || right instanceof CStringLiteralExpression) {
            return Collections.singleton(pState);
        }
        if (left instanceof CLiteralExpression && right instanceof CLiteralExpression) {
            return this.handleBinaryAssumptionWithTwoLiterals((CLiteralExpression)left, (CLiteralExpression)right, op, truthAssumption);
        }
        if (left instanceof CLiteralExpression) {
            switch (op) {
                case GREATER_EQUAL: {
                    op = CBinaryExpression.BinaryOperator.LESS_EQUAL;
                    break;
                }
                case GREATER_THAN: {
                    op = CBinaryExpression.BinaryOperator.LESS_THAN;
                    break;
                }
                case LESS_EQUAL: {
                    op = CBinaryExpression.BinaryOperator.GREATER_EQUAL;
                    break;
                }
                case LESS_THAN: {
                    op = CBinaryExpression.BinaryOperator.GREATER_THAN;
                    break;
                }
            }
            return this.handleBinaryAssumptionWithOneLiteral(right, (CLiteralExpression)left, op, truthAssumption, pState);
        }
        if (right instanceof CLiteralExpression) {
            return this.handleBinaryAssumptionWithOneLiteral(left, (CLiteralExpression)right, op, truthAssumption, pState);
        }
        return Collections.singleton(pState);
    }

    private boolean isHandleableVariable(CExpression var) {
        if (var instanceof CArraySubscriptExpression || var instanceof CFieldReference || var instanceof CPointerExpression || var instanceof CStringLiteralExpression || var instanceof CFieldReference && ((CFieldReference)var).isPointerDereference()) {
            return false;
        }
        return this.isHandleAbleType(var.getExpressionType());
    }

    private boolean isHandleAbleType(CType type) {
        type = type.getCanonicalType();
        while (type instanceof CTypedefType) {
            type = ((CTypedefType)type).getRealType();
        }
        return !(type instanceof CPointerType) && !(type instanceof CCompositeType) && !(type instanceof CArrayType);
    }

    private Set<OctagonState> handleBinaryAssumptionWithOneLiteral(CExpression left, CLiteralExpression right, CBinaryExpression.BinaryOperator op, boolean truthAssumption, OctagonState pState) throws CPATransferException {
        if (left.getExpressionType() instanceof CPointerType || left instanceof CFieldReference && ((CFieldReference)left).isPointerDereference()) {
            return Collections.singleton(pState);
        }
        MemoryLocation leftVarName = null;
        ArrayList<OctagonState> states = new ArrayList<OctagonState>();
        states.add(pState);
        if (left instanceof CIdExpression || left instanceof CFieldReference) {
            leftVarName = this.buildVarName((CLeftHandSide)left, this.functionName);
        } else {
            COctagonCoefficientVisitor coeffVisitor = new COctagonCoefficientVisitor(pState, this.functionName);
            Set<Pair<IOctagonCoefficients, OctagonState>> coeffsLeft = left.accept(coeffVisitor);
            MemoryLocation tempLeft = MemoryLocation.forLocalVariable(this.functionName, TEMP_VAR_PREFIX + temporaryVariableCounter + "_");
            ++temporaryVariableCounter;
            ArrayList<OctagonState> tmpList = new ArrayList<OctagonState>();
            for (Pair<IOctagonCoefficients, OctagonState> pairs : coeffsLeft) {
                IOctagonCoefficients coeffs = pairs.getFirst();
                if (coeffs.equals(OctagonUniversalCoefficients.INSTANCE)) {
                    return Collections.singleton(pState);
                }
                OctagonState tmpState = pairs.getSecond().declareVariable(tempLeft, this.getCorrespondingOctStateType(left.getExpressionType()));
                tmpList.add(tmpState.makeAssignment(tempLeft, coeffs.expandToSize(tmpState.sizeOfVariables(), tmpState)));
            }
            states = tmpList;
            leftVarName = tempLeft;
        }
        OctagonNumericValue rightVal = OctagonIntValue.ZERO;
        if (right instanceof CIntegerLiteralExpression) {
            rightVal = OctagonIntValue.of(((CIntegerLiteralExpression)right).asLong());
        } else if (right instanceof CCharLiteralExpression) {
            rightVal = OctagonIntValue.of(((CCharLiteralExpression)right).getCharacter());
        } else if (right instanceof CFloatLiteralExpression) {
            rightVal = new OctagonDoubleValue(((CFloatLiteralExpression)right).getValue().doubleValue());
        } else {
            return Collections.singleton(pState);
        }
        HashSet<OctagonState> possibleStates = new HashSet<OctagonState>();
        block9: for (OctagonState actState : states) {
            switch (op) {
                case EQUALS: {
                    if (truthAssumption) {
                        possibleStates.add(actState.addEqConstraint(leftVarName, rightVal));
                        continue block9;
                    }
                    possibleStates.addAll(actState.addIneqConstraint(leftVarName, rightVal));
                    continue block9;
                }
                case NOT_EQUALS: {
                    if (truthAssumption) {
                        possibleStates.addAll(actState.addIneqConstraint(leftVarName, rightVal));
                        continue block9;
                    }
                    possibleStates.add(actState.addEqConstraint(leftVarName, rightVal));
                    continue block9;
                }
                case LESS_EQUAL: {
                    if (truthAssumption) {
                        possibleStates.add(actState.addSmallerEqConstraint(leftVarName, rightVal));
                        continue block9;
                    }
                    possibleStates.add(actState.addGreaterConstraint(leftVarName, rightVal));
                    continue block9;
                }
                case LESS_THAN: {
                    if (truthAssumption) {
                        possibleStates.add(actState.addSmallerConstraint(leftVarName, rightVal));
                        continue block9;
                    }
                    possibleStates.add(actState.addGreaterEqConstraint(leftVarName, rightVal));
                    continue block9;
                }
                case GREATER_EQUAL: {
                    if (truthAssumption) {
                        possibleStates.add(actState.addGreaterEqConstraint(leftVarName, rightVal));
                        continue block9;
                    }
                    possibleStates.add(actState.addSmallerConstraint(leftVarName, rightVal));
                    continue block9;
                }
                case GREATER_THAN: {
                    if (truthAssumption) {
                        possibleStates.add(actState.addGreaterConstraint(leftVarName, rightVal));
                        continue block9;
                    }
                    possibleStates.add(actState.addSmallerEqConstraint(leftVarName, rightVal));
                    continue block9;
                }
            }
            throw new CPATransferException("Unhandled case statement: " + op);
        }
        return possibleStates;
    }

    private Set<OctagonState> handleBinaryAssumptionWithTwoLiterals(CLiteralExpression left, CLiteralExpression right, CBinaryExpression.BinaryOperator op, boolean truthAssumption) {
        OctagonNumericValue leftVal = OctagonIntValue.ZERO;
        if (left instanceof CIntegerLiteralExpression) {
            leftVal = OctagonIntValue.of(((CIntegerLiteralExpression)left).asLong());
        } else if (left instanceof CCharLiteralExpression) {
            leftVal = OctagonIntValue.of(((CCharLiteralExpression)left).getCharacter());
        } else if (left instanceof CFloatLiteralExpression) {
            leftVal = new OctagonDoubleValue(((CFloatLiteralExpression)left).getValue().doubleValue());
        }
        OctagonNumericValue rightVal = OctagonIntValue.ZERO;
        if (right instanceof CIntegerLiteralExpression) {
            rightVal = OctagonIntValue.of(((CIntegerLiteralExpression)right).asLong());
        } else if (right instanceof CCharLiteralExpression) {
            rightVal = OctagonIntValue.of(((CCharLiteralExpression)right).getCharacter());
        } else if (right instanceof CFloatLiteralExpression) {
            rightVal = new OctagonDoubleValue(((CFloatLiteralExpression)right).getValue().doubleValue());
        }
        if (truthAssumption == OctagonTransferRelation.isOperatorSatisfied(op, leftVal, rightVal)) {
            return Collections.singleton((OctagonState)this.state);
        }
        return ImmutableSet.of();
    }

    private static boolean isOperatorSatisfied(CBinaryExpression.BinaryOperator op, OctagonNumericValue leftVal, OctagonNumericValue rightVal) {
        switch (op) {
            case EQUALS: {
                return leftVal.isEqual(rightVal);
            }
            case GREATER_EQUAL: {
                return leftVal.greaterEqual(rightVal);
            }
            case GREATER_THAN: {
                return leftVal.greaterThan(rightVal);
            }
            case LESS_EQUAL: {
                return leftVal.lessEqual(rightVal);
            }
            case LESS_THAN: {
                return leftVal.lessThan(rightVal);
            }
            case NOT_EQUALS: {
                return !leftVal.isEqual(rightVal);
            }
        }
        throw new AssertionError((Object)("Unhandled case: " + op));
    }

    private Set<OctagonState> handleBinaryAssumptionWithoutLiteral(CBinaryExpression binExp, boolean truthAssumption, CExpression left, CExpression right, OctagonState pState) throws CPATransferException {
        CBinaryExpression.BinaryOperator op = binExp.getOperator();
        Object leftVarName = null;
        MemoryLocation rightVarName = null;
        if (!this.isHandleableVariable(left) || !this.isHandleableVariable(right)) {
            return Collections.singleton(pState);
        }
        HashSet<OctagonState> states = new HashSet<OctagonState>();
        states.add(pState);
        if (left instanceof CIdExpression || left instanceof CFieldReference) {
            leftVarName = this.buildVarName((CLeftHandSide)left, this.functionName);
        } else {
            COctagonCoefficientVisitor coeffVisitor = new COctagonCoefficientVisitor(pState, this.functionName);
            Set<Pair<IOctagonCoefficients, OctagonState>> coeffsLeft = left.accept(coeffVisitor);
            MemoryLocation tempLeft = MemoryLocation.forLocalVariable(this.functionName, TEMP_VAR_PREFIX + temporaryVariableCounter + "_");
            ++temporaryVariableCounter;
            HashSet<OctagonState> tmpSet = new HashSet<OctagonState>();
            for (Pair<IOctagonCoefficients, OctagonState> pairs : coeffsLeft) {
                IOctagonCoefficients coeffs = pairs.getFirst();
                if (coeffs.equals(OctagonUniversalCoefficients.INSTANCE)) {
                    return Collections.singleton(pState);
                }
                OctagonState tmp = pairs.getSecond().declareVariable(tempLeft, this.getCorrespondingOctStateType(left.getExpressionType()));
                tmpSet.add(tmp.makeAssignment(tempLeft, coeffs.expandToSize(tmp.sizeOfVariables(), tmp)));
            }
            states = tmpSet;
            leftVarName = tempLeft;
        }
        if (right instanceof CIdExpression || right instanceof CFieldReference) {
            rightVarName = this.buildVarName((CLeftHandSide)right, this.functionName);
        } else {
            MemoryLocation tempRight = MemoryLocation.forLocalVariable(this.functionName, TEMP_VAR_PREFIX + temporaryVariableCounter + "_", 0L);
            ++temporaryVariableCounter;
            HashSet<OctagonState> tmpSet = new HashSet<OctagonState>();
            for (OctagonState st : states) {
                COctagonCoefficientVisitor coeffVisitor = new COctagonCoefficientVisitor(st, this.functionName);
                Set<Pair<IOctagonCoefficients, OctagonState>> coeffsRight = right.accept(coeffVisitor);
                for (Pair<IOctagonCoefficients, OctagonState> pairs : coeffsRight) {
                    IOctagonCoefficients coeffs = pairs.getFirst();
                    if (coeffs.equals(OctagonUniversalCoefficients.INSTANCE)) {
                        return Collections.singleton(pState);
                    }
                    OctagonState tmp = pairs.getSecond().declareVariable(tempRight, this.getCorrespondingOctStateType(right.getExpressionType()));
                    tmpSet.add(tmp.makeAssignment(tempRight, coeffs.expandToSize(tmp.sizeOfVariables(), tmp)));
                }
            }
            states = tmpSet;
            rightVarName = tempRight;
        }
        if (((MemoryLocation)leftVarName).equals(rightVarName)) {
            switch (op) {
                case EQUALS: 
                case GREATER_EQUAL: 
                case LESS_EQUAL: {
                    if (truthAssumption) {
                        return Collections.singleton(pState);
                    }
                    return ImmutableSet.of();
                }
                case NOT_EQUALS: 
                case GREATER_THAN: 
                case LESS_THAN: {
                    if (truthAssumption) {
                        return ImmutableSet.of();
                    }
                    return Collections.singleton(pState);
                }
            }
        }
        HashSet<OctagonState> possibleStates = new HashSet<OctagonState>();
        block15: for (OctagonState actState : states) {
            switch (op) {
                case EQUALS: {
                    if (truthAssumption) {
                        possibleStates.add(actState.addEqConstraint(rightVarName, (MemoryLocation)leftVarName));
                        continue block15;
                    }
                    possibleStates.addAll(actState.addIneqConstraint(rightVarName, (MemoryLocation)leftVarName));
                    continue block15;
                }
                case GREATER_EQUAL: {
                    if (truthAssumption) {
                        possibleStates.add(actState.addGreaterEqConstraint(rightVarName, (MemoryLocation)leftVarName));
                        continue block15;
                    }
                    possibleStates.add(actState.addSmallerConstraint(rightVarName, (MemoryLocation)leftVarName));
                    continue block15;
                }
                case GREATER_THAN: {
                    if (truthAssumption) {
                        possibleStates.add(actState.addGreaterConstraint(rightVarName, (MemoryLocation)leftVarName));
                        continue block15;
                    }
                    possibleStates.add(actState.addSmallerEqConstraint(rightVarName, (MemoryLocation)leftVarName));
                    continue block15;
                }
                case LESS_EQUAL: {
                    if (truthAssumption) {
                        possibleStates.add(actState.addSmallerEqConstraint(rightVarName, (MemoryLocation)leftVarName));
                        continue block15;
                    }
                    possibleStates.add(actState.addGreaterConstraint(rightVarName, (MemoryLocation)leftVarName));
                    continue block15;
                }
                case LESS_THAN: {
                    if (truthAssumption) {
                        possibleStates.add(actState.addSmallerConstraint(rightVarName, (MemoryLocation)leftVarName));
                        continue block15;
                    }
                    possibleStates.add(actState.addGreaterEqConstraint(rightVarName, (MemoryLocation)leftVarName));
                    continue block15;
                }
                case NOT_EQUALS: {
                    if (truthAssumption) {
                        possibleStates.addAll(actState.addIneqConstraint(rightVarName, (MemoryLocation)leftVarName));
                        continue block15;
                    }
                    possibleStates.add(actState.addEqConstraint(rightVarName, (MemoryLocation)leftVarName));
                    continue block15;
                }
            }
            throw new CPATransferException("Unhandled case: " + binExp.getOperator());
        }
        return possibleStates;
    }

    private Set<OctagonState> handleSingleBooleanExpression(MemoryLocation variableName, boolean truthAssumption, OctagonState pState) {
        if (truthAssumption) {
            return pState.addIneqConstraint(variableName, OctagonIntValue.ZERO);
        }
        return Collections.singleton(pState.addEqConstraint(variableName, OctagonIntValue.ZERO));
    }

    @Override
    protected Set<OctagonState> handleFunctionCallEdge(CFunctionCallEdge cfaEdge, List<CExpression> arguments, List<CParameterDeclaration> parameters, String calledFunctionName) throws CPATransferException {
        CFunctionEntryNode functionEntryNode = cfaEdge.getSuccessor();
        List<String> paramNames = functionEntryNode.getFunctionParameterNames();
        CFunctionType functionType = cfaEdge.getSuccessor().getFunctionDefinition().getType();
        if (!functionType.takesVarArgs() ? !$assertionsDisabled && parameters.size() != arguments.size() : !$assertionsDisabled && parameters.size() > arguments.size()) {
            throw new AssertionError();
        }
        HashSet<OctagonState> possibleStates = new HashSet<OctagonState>();
        CType returnType = functionType.getReturnType().getCanonicalType();
        if (this.isHandleAbleType(returnType) && !(returnType instanceof CVoidType)) {
            this.state = ((OctagonState)this.state).declareVariable(MemoryLocation.forLocalVariable(calledFunctionName, functionEntryNode.getReturnVariable().orElseThrow().getName()), this.getCorrespondingOctStateType(cfaEdge.getSuccessor().getFunctionDefinition().getType().getReturnType()));
        }
        ArrayList<Pair<MemoryLocation, CExpression>> handleAbleParams = new ArrayList<Pair<MemoryLocation, CExpression>>();
        for (int i = 0; i < parameters.size(); ++i) {
            CType typeOfParam;
            MemoryLocation memoryLocation;
            if (!this.isHandleAbleType(parameters.get(i).getType()) || !((VariableTrackingPrecision)this.precision).isTracking(memoryLocation = MemoryLocation.forLocalVariable(calledFunctionName, paramNames.get(i)), typeOfParam = parameters.get(i).getType(), functionEntryNode) || !this.isHandleAbleType(parameters.get(i).getType())) continue;
            this.state = ((OctagonState)this.state).declareVariable(memoryLocation, this.getCorrespondingOctStateType(typeOfParam));
            handleAbleParams.add(Pair.of(memoryLocation, arguments.get(i)));
        }
        possibleStates.add((OctagonState)this.state);
        for (Pair pair : handleAbleParams) {
            MemoryLocation paramName = (MemoryLocation)pair.getFirst();
            CExpression argument = (CExpression)pair.getSecond();
            HashSet<OctagonState> newPossibleStates = new HashSet<OctagonState>();
            for (OctagonState st : possibleStates) {
                COctagonCoefficientVisitor coeffVisitor = new COctagonCoefficientVisitor(st, calledFunctionName);
                Set<Pair<IOctagonCoefficients, OctagonState>> coeffsList = argument.accept(coeffVisitor);
                for (Pair<IOctagonCoefficients, OctagonState> pairs : coeffsList) {
                    newPossibleStates.add(pairs.getSecond().makeAssignment(paramName, pairs.getFirst()));
                }
            }
            possibleStates = newPossibleStates;
        }
        return possibleStates;
    }

    @Override
    protected Set<OctagonState> handleFunctionReturnEdge(CFunctionReturnEdge cfaEdge, CFunctionSummaryEdge fnkCall, CFunctionCall summaryExpr, String callerFunctionName) throws CPATransferException {
        CFunctionCall exprOnSummary = fnkCall.getExpression();
        String calledFunctionName = cfaEdge.getPredecessor().getFunctionName();
        if (exprOnSummary instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement binExp = (CFunctionCallAssignmentStatement)exprOnSummary;
            CLeftHandSide op1 = binExp.getLeftHandSide();
            MemoryLocation assignedVarName = this.buildVarName(op1, callerFunctionName);
            if (!this.isHandleableVariable(op1) || !((VariableTrackingPrecision)this.precision).isTracking(assignedVarName, op1.getExpressionType(), cfaEdge.getSuccessor())) {
                return Collections.singleton(((OctagonState)this.state).removeLocalVars(calledFunctionName));
            }
            int returnVarIndex = ((OctagonState)this.state).getVariableIndexFor(MemoryLocation.forLocalVariable(calledFunctionName, fnkCall.getFunctionEntry().getReturnVariable().orElseThrow().getName()));
            if (returnVarIndex == -1) {
                this.state = ((OctagonState)this.state).forget(assignedVarName);
                return Collections.singleton(((OctagonState)this.state).removeLocalVars(calledFunctionName));
            }
            OctagonSimpleCoefficients right = new OctagonSimpleCoefficients(((OctagonState)this.state).sizeOfVariables(), returnVarIndex, OctagonIntValue.ONE, (OctagonState)this.state);
            this.state = ((OctagonState)this.state).makeAssignment(assignedVarName, (IOctagonCoefficients)right);
        } else if (!(exprOnSummary instanceof CFunctionCallStatement)) {
            throw new UnrecognizedCodeException("on function return", cfaEdge, exprOnSummary);
        }
        return Collections.singleton(((OctagonState)this.state).removeLocalVars(calledFunctionName));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected Set<OctagonState> handleDeclarationEdge(CDeclarationEdge cfaEdge, CDeclaration decl) throws CPATransferException {
        if (cfaEdge.getDeclaration() instanceof CVariableDeclaration) {
            HashSet<OctagonState> possibleStates;
            block12: {
                CVariableDeclaration declaration = (CVariableDeclaration)decl;
                MemoryLocation variableName = MemoryLocation.forDeclaration(declaration);
                if (!this.isHandleAbleType(declaration.getType())) {
                    return Collections.singleton((OctagonState)this.state);
                }
                if (!((VariableTrackingPrecision)this.precision).isTracking(variableName, declaration.getType(), cfaEdge.getSuccessor())) {
                    return Collections.singleton((OctagonState)this.state);
                }
                CInitializer init = declaration.getInitializer();
                if (!((OctagonState)this.state).existsVariable(variableName) && (init == null || init instanceof CInitializerExpression)) {
                    this.state = ((OctagonState)this.state).declareVariable(variableName, this.getCorrespondingOctStateType(declaration.getType()));
                }
                possibleStates = new HashSet<OctagonState>();
                if (init != null) {
                    if (init instanceof CInitializerExpression) {
                        CExpression exp = ((CInitializerExpression)init).getExpression();
                        COctagonCoefficientVisitor coeffVisitor = new COctagonCoefficientVisitor((OctagonState)this.state, this.functionName);
                        Set<Pair<IOctagonCoefficients, OctagonState>> initCoeffs = exp.accept(coeffVisitor);
                        for (Pair<IOctagonCoefficients, OctagonState> pairs : initCoeffs) {
                            possibleStates.add(pairs.getSecond().makeAssignment(variableName, pairs.getFirst()));
                        }
                        break block12;
                    } else {
                        if (init instanceof CInitializerList) {
                            return Collections.singleton((OctagonState)this.state);
                        }
                        throw new AssertionError((Object)("Unhandled Expression Type: " + init.getClass()));
                    }
                }
                if (decl.isGlobal()) {
                    possibleStates.add(((OctagonState)this.state).makeAssignment(variableName, (IOctagonCoefficients)new OctagonSimpleCoefficients(((OctagonState)this.state).sizeOfVariables(), (OctagonState)this.state).expandToSize(((OctagonState)this.state).sizeOfVariables(), (OctagonState)this.state)));
                }
            }
            if (possibleStates.isEmpty()) {
                possibleStates.add((OctagonState)this.state);
            }
            return possibleStates;
        }
        if (!(cfaEdge.getDeclaration() instanceof CTypeDeclaration) && !(cfaEdge.getDeclaration() instanceof CFunctionDeclaration)) {
            throw new AssertionError((Object)(cfaEdge.getDeclaration() + " (" + cfaEdge.getDeclaration().getClass() + ")"));
        }
        return Collections.singleton((OctagonState)this.state);
    }

    @Override
    protected Set<OctagonState> handleStatementEdge(CStatementEdge cfaEdge, CStatement statement) throws CPATransferException {
        String func;
        CExpression fn;
        if (statement instanceof CFunctionCall && (fn = ((CFunctionCall)statement).getFunctionCallExpression().getFunctionNameExpression()) instanceof CIdExpression && UNSUPPORTED_FUNCTIONS.containsKey((Object)(func = ((CIdExpression)fn).getName()))) {
            throw new UnsupportedCodeException((String)UNSUPPORTED_FUNCTIONS.get((Object)func), cfaEdge, fn);
        }
        if (statement instanceof CAssignment) {
            CLeftHandSide left = ((CAssignment)statement).getLeftHandSide();
            CRightHandSide right = ((CAssignment)statement).getRightHandSide();
            MemoryLocation variableName = this.buildVarName(left, this.functionName);
            if (!this.isHandleableVariable(left) || !((VariableTrackingPrecision)this.precision).isTracking(variableName, left.getExpressionType(), cfaEdge.getSuccessor())) {
                assert (!((OctagonState)this.state).existsVariable(variableName)) : "variablename '" + variableName + "' is in map although it can not be handled";
                return Collections.singleton((OctagonState)this.state);
            }
            COctagonCoefficientVisitor coeffVisitor = new COctagonCoefficientVisitor((OctagonState)this.state, this.functionName);
            Set<Pair<IOctagonCoefficients, OctagonState>> coeffsList = right.accept(coeffVisitor);
            HashSet<OctagonState> possibleStates = new HashSet<OctagonState>();
            for (Pair<IOctagonCoefficients, OctagonState> pairs : coeffsList) {
                OctagonState newState = pairs.getSecond().makeAssignment(variableName, pairs.getFirst());
                if (newState.isEmpty()) {
                    possibleStates.add(((OctagonState)this.state).forget(variableName));
                    break;
                }
                possibleStates.add(newState);
            }
            return possibleStates;
        }
        if (statement instanceof CFunctionCallStatement || statement instanceof CExpressionStatement) {
            return Collections.singleton((OctagonState)this.state);
        }
        throw new UnrecognizedCodeException("unknown statement", cfaEdge, statement);
    }

    private MemoryLocation buildVarName(CLeftHandSide left, String pFunctionName) {
        String variableName = null;
        variableName = left instanceof CArraySubscriptExpression ? ((CArraySubscriptExpression)left).getArrayExpression().toASTString() : (left instanceof CPointerExpression ? ((CPointerExpression)left).getOperand().toASTString() : (left instanceof CFieldReference ? ((CFieldReference)left).getFieldOwner().toASTString() : left.toASTString()));
        if (!OctagonTransferRelation.isGlobal(left)) {
            return MemoryLocation.forLocalVariable(pFunctionName, variableName);
        }
        return MemoryLocation.forIdentifier(variableName);
    }

    @Override
    protected Set<OctagonState> handleReturnStatementEdge(CReturnStatementEdge cfaEdge) throws CPATransferException {
        if (!cfaEdge.getExpression().isPresent()) {
            return Collections.singleton((OctagonState)this.state);
        }
        MemoryLocation tempVarName = MemoryLocation.forLocalVariable(cfaEdge.getPredecessor().getFunctionName(), ((CIdExpression)cfaEdge.asAssignment().orElseThrow().getLeftHandSide()).getName());
        if (!((OctagonState)this.state).existsVariable(tempVarName)) {
            return Collections.singleton((OctagonState)this.state);
        }
        HashSet<OctagonState> possibleStates = new HashSet<OctagonState>();
        COctagonCoefficientVisitor coeffVisitor = new COctagonCoefficientVisitor((OctagonState)this.state, cfaEdge.getPredecessor().getFunctionName());
        Set<Pair<IOctagonCoefficients, OctagonState>> coeffsList = cfaEdge.getExpression().orElseThrow().accept(coeffVisitor);
        for (Pair<IOctagonCoefficients, OctagonState> pairs : coeffsList) {
            possibleStates.add(pairs.getSecond().makeAssignment(tempVarName, pairs.getFirst()));
        }
        return possibleStates;
    }

    @Override
    protected Set<OctagonState> handleFunctionSummaryEdge(CFunctionSummaryEdge cfaEdge) throws CPATransferException {
        return ImmutableSet.of();
    }

    static class NotInstanceOfEmptyCoefficients
    implements Predicate<Pair<IOctagonCoefficients, OctagonState>> {
        NotInstanceOfEmptyCoefficients() {
        }

        public boolean apply(Pair<IOctagonCoefficients, OctagonState> pInput) {
            return !(pInput.getFirst() instanceof OctagonUniversalCoefficients);
        }
    }

    class COctagonCoefficientVisitor
    extends DefaultCExpressionVisitor<Set<Pair<IOctagonCoefficients, OctagonState>>, CPATransferException>
    implements CRightHandSideVisitor<Set<Pair<IOctagonCoefficients, OctagonState>>, CPATransferException> {
        private OctagonState visitorState;
        private String visitorFunctionName;

        public COctagonCoefficientVisitor(OctagonState pState, String pFunctionName) {
            this.visitorState = pState;
            this.visitorFunctionName = pFunctionName;
        }

        public OctagonState getState() {
            return this.visitorState;
        }

        @Override
        protected Set<Pair<IOctagonCoefficients, OctagonState>> visitDefault(CExpression pExp) throws CPATransferException {
            return ImmutableSet.of(Pair.of(OctagonUniversalCoefficients.INSTANCE, this.visitorState));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<Pair<IOctagonCoefficients, OctagonState>> visit(CBinaryExpression e) throws CPATransferException {
            switch (e.getOperator()) {
                case BINARY_AND: 
                case BINARY_OR: 
                case BINARY_XOR: 
                case SHIFT_LEFT: 
                case SHIFT_RIGHT: 
                case MODULO: {
                    return ImmutableSet.of(Pair.of(OctagonUniversalCoefficients.INSTANCE, this.visitorState));
                }
            }
            ImmutableSet left = e.getOperand1().accept(this);
            HashSet<Pair<IOctagonCoefficients, ImmutableSet>> right = new HashSet<Pair<IOctagonCoefficients, ImmutableSet>>();
            int origSize = left.size();
            left = FluentIterable.from(left).filter((Predicate)new NotInstanceOfEmptyCoefficients()).toSet();
            if (left.isEmpty() || origSize != left.size()) {
                return ImmutableSet.of(Pair.of(OctagonUniversalCoefficients.INSTANCE, this.visitorState));
            }
            for (Pair pair : left) {
                Set<Pair<IOctagonCoefficients, OctagonState>> set = e.getOperand2().accept(new COctagonCoefficientVisitor((OctagonState)pair.getSecond(), this.visitorFunctionName));
                origSize = set.size();
                ImmutableSet immutableSet = FluentIterable.from(set).filter((Predicate)new NotInstanceOfEmptyCoefficients()).toSet();
                if (immutableSet.isEmpty() || origSize != immutableSet.size()) {
                    return ImmutableSet.of(Pair.of(OctagonUniversalCoefficients.INSTANCE, this.visitorState));
                }
                right.add(Pair.of((IOctagonCoefficients)pair.getFirst(), immutableSet));
            }
            switch (e.getOperator()) {
                case EQUALS: 
                case NOT_EQUALS: 
                case GREATER_EQUAL: 
                case GREATER_THAN: 
                case LESS_EQUAL: 
                case LESS_THAN: {
                    HashSet<Pair<IOctagonCoefficients, OctagonState>> returnCoefficients = new HashSet<Pair<IOctagonCoefficients, OctagonState>>();
                    MemoryLocation tempVarLeft = MemoryLocation.forLocalVariable(this.visitorFunctionName, OctagonTransferRelation.TEMP_VAR_PREFIX + temporaryVariableCounter + "_");
                    ++temporaryVariableCounter;
                    CBinaryExpression.BinaryOperator binaryOperator = e.getOperator();
                    for (Pair pair : right) {
                        IOctagonCoefficients leftCoeffs = (IOctagonCoefficients)pair.getFirst();
                        block19: for (Pair rightPair : (Set)pair.getSecond()) {
                            void var7_10;
                            OctagonState rightVisitorState = (OctagonState)rightPair.getSecond();
                            IOctagonCoefficients rightCoeffs = (IOctagonCoefficients)rightPair.getFirst();
                            if (leftCoeffs.expandToSize(rightVisitorState.sizeOfVariables(), rightVisitorState).equals(rightCoeffs)) {
                                switch (1.$SwitchMap$org$sosy_lab$cpachecker$cfa$ast$c$CBinaryExpression$BinaryOperator[var7_10.ordinal()]) {
                                    case 11: 
                                    case 13: 
                                    case 15: {
                                        returnCoefficients.add(Pair.of(OctagonSimpleCoefficients.getBoolTRUECoeffs(rightVisitorState.sizeOfVariables(), rightVisitorState), rightVisitorState));
                                        continue block19;
                                    }
                                    case 12: 
                                    case 14: 
                                    case 16: {
                                        returnCoefficients.add(Pair.of(OctagonSimpleCoefficients.getBoolFALSECoeffs(rightVisitorState.sizeOfVariables(), rightVisitorState), rightVisitorState));
                                        continue block19;
                                    }
                                }
                                throw new AssertionError((Object)"Unhandled case in switch clause.");
                            }
                            if (leftCoeffs.hasOnlyOneValue() && !leftCoeffs.hasOnlyConstantValue()) {
                                tempVarLeft = rightVisitorState.getVariableNameFor(leftCoeffs.getVariableIndex());
                            } else if (rightCoeffs.hasOnlyOneValue() && !rightCoeffs.hasOnlyConstantValue()) {
                                tempVarLeft = rightVisitorState.getVariableNameFor(rightCoeffs.getVariableIndex());
                                rightCoeffs = leftCoeffs.expandToSize(rightVisitorState.sizeOfVariables(), rightVisitorState);
                                switch (1.$SwitchMap$org$sosy_lab$cpachecker$cfa$ast$c$CBinaryExpression$BinaryOperator[var7_10.ordinal()]) {
                                    case 13: {
                                        CBinaryExpression.BinaryOperator binaryOperator2 = CBinaryExpression.BinaryOperator.LESS_EQUAL;
                                        break;
                                    }
                                    case 14: {
                                        CBinaryExpression.BinaryOperator binaryOperator3 = CBinaryExpression.BinaryOperator.LESS_THAN;
                                        break;
                                    }
                                    case 15: {
                                        CBinaryExpression.BinaryOperator binaryOperator4 = CBinaryExpression.BinaryOperator.GREATER_EQUAL;
                                        break;
                                    }
                                    case 16: {
                                        CBinaryExpression.BinaryOperator binaryOperator5 = CBinaryExpression.BinaryOperator.GREATER_THAN;
                                        break;
                                    }
                                }
                            } else {
                                rightVisitorState = rightVisitorState.declareVariable(tempVarLeft, OctagonTransferRelation.this.getCorrespondingOctStateType(e.getOperand1().getExpressionType()));
                                rightVisitorState = rightVisitorState.makeAssignment(tempVarLeft, leftCoeffs.expandToSize(rightVisitorState.sizeOfVariables(), rightVisitorState));
                                rightCoeffs = rightCoeffs.expandToSize(rightVisitorState.sizeOfVariables(), rightVisitorState);
                            }
                            returnCoefficients.addAll(this.handleLogicalOperators(tempVarLeft, (CBinaryExpression.BinaryOperator)var7_10, rightVisitorState, rightCoeffs));
                        }
                    }
                    return returnCoefficients;
                }
                case MINUS: 
                case PLUS: 
                case MULTIPLY: 
                case DIVIDE: {
                    HashSet<Pair<IOctagonCoefficients, OctagonState>> returnCoefficients = new HashSet();
                    for (Pair pair : right) {
                        IOctagonCoefficients leftCoeffs = (IOctagonCoefficients)pair.getFirst();
                        for (Pair rightPair : (Set)pair.getSecond()) {
                            IOctagonCoefficients rightCoeffs = (IOctagonCoefficients)rightPair.getFirst();
                            OctagonState rightVisitorState = (OctagonState)rightPair.getSecond();
                            if (leftCoeffs.size() < rightCoeffs.size()) {
                                leftCoeffs = leftCoeffs.expandToSize(rightCoeffs.size(), rightVisitorState);
                            } else {
                                rightCoeffs = rightCoeffs.expandToSize(leftCoeffs.size(), rightVisitorState);
                            }
                            if (e.getOperator() == CBinaryExpression.BinaryOperator.MINUS) {
                                returnCoefficients.add(Pair.of(leftCoeffs.sub(rightCoeffs), rightVisitorState));
                                continue;
                            }
                            if (e.getOperator() == CBinaryExpression.BinaryOperator.PLUS) {
                                returnCoefficients.add(Pair.of(leftCoeffs.add(rightCoeffs), rightVisitorState));
                                continue;
                            }
                            if (e.getOperator() == CBinaryExpression.BinaryOperator.MULTIPLY) {
                                if (leftCoeffs.hasOnlyOneValue() || rightCoeffs.hasOnlyOneValue()) {
                                    returnCoefficients.add(Pair.of(leftCoeffs.mul(rightCoeffs), rightVisitorState));
                                    continue;
                                }
                                MemoryLocation tempVarLeft = MemoryLocation.forLocalVariable(this.visitorFunctionName, OctagonTransferRelation.TEMP_VAR_PREFIX + temporaryVariableCounter + "_", 0L);
                                ++temporaryVariableCounter;
                                rightVisitorState = rightVisitorState.declareVariable(tempVarLeft, OctagonTransferRelation.this.getCorrespondingOctStateType(e.getOperand1().getExpressionType()));
                                rightVisitorState = rightVisitorState.makeAssignment(tempVarLeft, leftCoeffs.expandToSize(rightVisitorState.sizeOfVariables(), rightVisitorState));
                                returnCoefficients.add(Pair.of(new OctagonSimpleCoefficients(rightVisitorState.sizeOfVariables(), rightVisitorState.getVariableIndexFor(tempVarLeft), OctagonIntValue.ONE, rightVisitorState).mul(rightCoeffs.expandToSize(rightVisitorState.sizeOfVariables(), rightVisitorState)), rightVisitorState));
                                continue;
                            }
                            if (e.getOperator() != CBinaryExpression.BinaryOperator.DIVIDE) continue;
                            if (rightCoeffs.hasOnlyOneValue()) {
                                returnCoefficients.add(Pair.of(leftCoeffs.div(rightCoeffs), rightVisitorState));
                                continue;
                            }
                            MemoryLocation tempVarRight = MemoryLocation.forLocalVariable(this.visitorFunctionName, OctagonTransferRelation.TEMP_VAR_PREFIX + temporaryVariableCounter + "_", 0L);
                            ++temporaryVariableCounter;
                            rightVisitorState = rightVisitorState.declareVariable(tempVarRight, OctagonTransferRelation.this.getCorrespondingOctStateType(e.getOperand2().getExpressionType()));
                            rightVisitorState = rightVisitorState.makeAssignment(tempVarRight, rightCoeffs.expandToSize(rightVisitorState.sizeOfVariables(), rightVisitorState));
                            IOctagonCoefficients expandedleftCoeffs = leftCoeffs.expandToSize(rightVisitorState.sizeOfVariables(), rightVisitorState);
                            returnCoefficients.add(Pair.of(expandedleftCoeffs.div(new OctagonSimpleCoefficients(rightVisitorState.sizeOfVariables(), rightVisitorState.getVariableIndexFor(tempVarRight), OctagonIntValue.ONE, rightVisitorState)), rightVisitorState));
                        }
                    }
                    return returnCoefficients;
                }
            }
            throw new AssertionError((Object)"Unhandled case statement");
        }

        private Set<Pair<IOctagonCoefficients, OctagonState>> handleLogicalOperators(MemoryLocation pTempVarLeft, CBinaryExpression.BinaryOperator binOp, OctagonState pState, IOctagonCoefficients constraintCoeffs) {
            HashSet<Pair<IOctagonCoefficients, OctagonState>> returnCoefficients = new HashSet<Pair<IOctagonCoefficients, OctagonState>>();
            switch (binOp) {
                case EQUALS: {
                    OctagonState tmpState = pState.addEqConstraint(pTempVarLeft, constraintCoeffs);
                    if (tmpState.isEmpty()) {
                        returnCoefficients.add(Pair.of(OctagonSimpleCoefficients.getBoolFALSECoeffs(pState.sizeOfVariables(), pState), pState));
                        break;
                    }
                    returnCoefficients.add(Pair.of(OctagonSimpleCoefficients.getBoolTRUECoeffs(pState.sizeOfVariables(), tmpState), tmpState));
                    OctagonState smaller = pState.addSmallerConstraint(pTempVarLeft, constraintCoeffs);
                    if (!smaller.isEmpty()) {
                        returnCoefficients.add(Pair.of(OctagonSimpleCoefficients.getBoolFALSECoeffs(smaller.sizeOfVariables(), smaller), smaller));
                        break;
                    }
                    OctagonState greater = pState.addGreaterConstraint(pTempVarLeft, constraintCoeffs);
                    if (greater.isEmpty()) break;
                    returnCoefficients.add(Pair.of(OctagonSimpleCoefficients.getBoolFALSECoeffs(greater.sizeOfVariables(), greater), greater));
                    break;
                }
                case GREATER_EQUAL: {
                    OctagonState tmpState = pState.addGreaterEqConstraint(pTempVarLeft, constraintCoeffs);
                    if (tmpState.isEmpty()) {
                        returnCoefficients.add(Pair.of(OctagonSimpleCoefficients.getBoolFALSECoeffs(pState.sizeOfVariables(), pState), pState));
                        break;
                    }
                    returnCoefficients.add(Pair.of(OctagonSimpleCoefficients.getBoolTRUECoeffs(pState.sizeOfVariables(), tmpState), tmpState));
                    OctagonState smaller = pState.addSmallerConstraint(pTempVarLeft, constraintCoeffs);
                    if (smaller.isEmpty()) break;
                    returnCoefficients.add(Pair.of(OctagonSimpleCoefficients.getBoolFALSECoeffs(smaller.sizeOfVariables(), smaller), smaller));
                    break;
                }
                case GREATER_THAN: {
                    OctagonState tmpState = pState.addGreaterConstraint(pTempVarLeft, constraintCoeffs);
                    if (tmpState.isEmpty()) {
                        returnCoefficients.add(Pair.of(OctagonSimpleCoefficients.getBoolFALSECoeffs(pState.sizeOfVariables(), pState), pState));
                        break;
                    }
                    returnCoefficients.add(Pair.of(OctagonSimpleCoefficients.getBoolTRUECoeffs(pState.sizeOfVariables(), tmpState), tmpState));
                    OctagonState smaller = pState.addSmallerEqConstraint(pTempVarLeft, constraintCoeffs);
                    if (smaller.isEmpty()) break;
                    returnCoefficients.add(Pair.of(OctagonSimpleCoefficients.getBoolFALSECoeffs(smaller.sizeOfVariables(), smaller), smaller));
                    break;
                }
                case LESS_EQUAL: {
                    OctagonState tmpState = pState.addSmallerEqConstraint(pTempVarLeft, constraintCoeffs);
                    if (tmpState.isEmpty()) {
                        returnCoefficients.add(Pair.of(OctagonSimpleCoefficients.getBoolFALSECoeffs(pState.sizeOfVariables(), pState), pState));
                        break;
                    }
                    returnCoefficients.add(Pair.of(OctagonSimpleCoefficients.getBoolTRUECoeffs(pState.sizeOfVariables(), tmpState), tmpState));
                    OctagonState greater = pState.addGreaterConstraint(pTempVarLeft, constraintCoeffs);
                    if (greater.isEmpty()) break;
                    returnCoefficients.add(Pair.of(OctagonSimpleCoefficients.getBoolFALSECoeffs(greater.sizeOfVariables(), greater), greater));
                    break;
                }
                case LESS_THAN: {
                    OctagonState tmpState = pState.addSmallerConstraint(pTempVarLeft, constraintCoeffs);
                    if (tmpState.isEmpty()) {
                        returnCoefficients.add(Pair.of(OctagonSimpleCoefficients.getBoolFALSECoeffs(pState.sizeOfVariables(), pState), pState));
                        break;
                    }
                    returnCoefficients.add(Pair.of(OctagonSimpleCoefficients.getBoolTRUECoeffs(pState.sizeOfVariables(), tmpState), tmpState));
                    OctagonState greater = pState.addGreaterEqConstraint(pTempVarLeft, constraintCoeffs);
                    if (greater.isEmpty()) break;
                    returnCoefficients.add(Pair.of(OctagonSimpleCoefficients.getBoolFALSECoeffs(greater.sizeOfVariables(), greater), greater));
                    break;
                }
                case NOT_EQUALS: {
                    OctagonState smaller = pState.addSmallerConstraint(pTempVarLeft, constraintCoeffs);
                    OctagonState bigger = pState.addGreaterConstraint(pTempVarLeft, constraintCoeffs);
                    OctagonState equal = pState.addEqConstraint(pTempVarLeft, constraintCoeffs);
                    if (!smaller.isEmpty()) {
                        returnCoefficients.add(Pair.of(OctagonSimpleCoefficients.getBoolTRUECoeffs(smaller.sizeOfVariables(), smaller), smaller));
                    }
                    if (!bigger.isEmpty()) {
                        returnCoefficients.add(Pair.of(OctagonSimpleCoefficients.getBoolTRUECoeffs(bigger.sizeOfVariables(), bigger), bigger));
                    }
                    if (equal.isEmpty()) break;
                    returnCoefficients.add(Pair.of(OctagonSimpleCoefficients.getBoolFALSECoeffs(equal.sizeOfVariables(), equal), equal));
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unhandled case statement");
                }
            }
            return returnCoefficients;
        }

        @Override
        public Set<Pair<IOctagonCoefficients, OctagonState>> visit(CCastExpression e) throws CPATransferException {
            return e.getOperand().accept(this);
        }

        @Override
        public Set<Pair<IOctagonCoefficients, OctagonState>> visit(CIdExpression e) throws CPATransferException {
            MemoryLocation varName = OctagonTransferRelation.this.buildVarName(e, OctagonTransferRelation.this.functionName);
            Integer varIndex = this.visitorState.getVariableIndexFor(varName);
            if (varIndex == -1) {
                varName = OctagonTransferRelation.this.buildVarName(e, this.visitorFunctionName);
                varIndex = this.visitorState.getVariableIndexFor(varName);
            }
            if (varIndex == -1) {
                return ImmutableSet.of(Pair.of(OctagonUniversalCoefficients.INSTANCE, this.visitorState));
            }
            return ImmutableSet.of(Pair.of(new OctagonSimpleCoefficients(this.visitorState.sizeOfVariables(), varIndex, OctagonIntValue.ONE, this.visitorState), this.visitorState));
        }

        @Override
        public Set<Pair<IOctagonCoefficients, OctagonState>> visit(CCharLiteralExpression e) throws CPATransferException {
            OctagonIntValue value = OctagonIntValue.of(e.getCharacter());
            return ImmutableSet.of(Pair.of(new OctagonSimpleCoefficients(this.visitorState.sizeOfVariables(), value, this.visitorState), this.visitorState));
        }

        @Override
        public Set<Pair<IOctagonCoefficients, OctagonState>> visit(CFloatLiteralExpression e) throws CPATransferException {
            return ImmutableSet.of(Pair.of(new OctagonSimpleCoefficients(this.visitorState.sizeOfVariables(), new OctagonDoubleValue(e.getValue().doubleValue()), this.visitorState), this.visitorState));
        }

        @Override
        public Set<Pair<IOctagonCoefficients, OctagonState>> visit(CIntegerLiteralExpression e) throws CPATransferException {
            return ImmutableSet.of(Pair.of(new OctagonSimpleCoefficients(this.visitorState.sizeOfVariables(), OctagonIntValue.of(e.asLong()), this.visitorState), this.visitorState));
        }

        @Override
        public Set<Pair<IOctagonCoefficients, OctagonState>> visit(CUnaryExpression e) throws CPATransferException {
            switch (e.getOperator()) {
                case SIZEOF: 
                case TILDE: 
                case AMPER: {
                    return ImmutableSet.of(Pair.of(OctagonUniversalCoefficients.INSTANCE, this.visitorState));
                }
            }
            assert (e.getOperator() == CUnaryExpression.UnaryOperator.MINUS);
            ImmutableSet operand = e.getOperand().accept(this);
            int origSize = operand.size();
            if ((operand = FluentIterable.from(operand).filter((Predicate)new NotInstanceOfEmptyCoefficients()).toSet()).isEmpty() || origSize != operand.size()) {
                return ImmutableSet.of(Pair.of(OctagonUniversalCoefficients.INSTANCE, this.visitorState));
            }
            HashSet<Pair<IOctagonCoefficients, OctagonState>> returnValues = new HashSet<Pair<IOctagonCoefficients, OctagonState>>();
            for (Pair pair : operand) {
                returnValues.add(Pair.of(((IOctagonCoefficients)pair.getFirst()).mul(OctagonIntValue.NEG_ONE), (OctagonState)pair.getSecond()));
            }
            return returnValues;
        }

        @Override
        public Set<Pair<IOctagonCoefficients, OctagonState>> visit(CFunctionCallExpression e) throws CPATransferException {
            AOctagonCoefficients coefficients = OctagonUniversalCoefficients.INSTANCE;
            if (e.getFunctionNameExpression() instanceof CIdExpression) {
                switch (((CIdExpression)e.getFunctionNameExpression()).getName()) {
                    case "__VERIFIER_nondet_uint": {
                        coefficients = OctagonIntervalCoefficients.getNondetUIntCoeffs(this.visitorState.sizeOfVariables(), this.visitorState);
                        break;
                    }
                    case "__VERIFIER_nondet_bool": {
                        coefficients = OctagonIntervalCoefficients.getNondetBoolCoeffs(this.visitorState.sizeOfVariables(), this.visitorState);
                        break;
                    }
                }
            }
            return ImmutableSet.of(Pair.of(coefficients, this.visitorState));
        }
    }
}

