/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.octagon.coefficients;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import org.sosy_lab.cpachecker.cpa.octagon.OctagonState;
import org.sosy_lab.cpachecker.cpa.octagon.coefficients.AOctagonCoefficients;
import org.sosy_lab.cpachecker.cpa.octagon.coefficients.IOctagonCoefficients;
import org.sosy_lab.cpachecker.cpa.octagon.coefficients.OctagonSimpleCoefficients;
import org.sosy_lab.cpachecker.cpa.octagon.coefficients.OctagonUniversalCoefficients;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonDoubleValue;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonIntValue;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonInterval;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonNumericValue;
import org.sosy_lab.cpachecker.util.octagon.NumArray;
import org.sosy_lab.cpachecker.util.octagon.OctagonManager;

public class OctagonIntervalCoefficients
extends AOctagonCoefficients {
    protected OctagonInterval[] coefficients;

    public OctagonIntervalCoefficients(int size, OctagonState oct) {
        super(size, oct);
        this.coefficients = new OctagonInterval[size + 1];
        Arrays.fill(this.coefficients, OctagonInterval.FALSE);
    }

    public OctagonIntervalCoefficients(int size, int index, OctagonInterval bounds, OctagonState oct) {
        super(size, oct);
        Preconditions.checkArgument((index < size ? 1 : 0) != 0, (Object)"Index too big");
        this.coefficients = new OctagonInterval[size + 1];
        Arrays.fill(this.coefficients, OctagonInterval.FALSE);
        this.coefficients[index] = bounds;
    }

    public OctagonIntervalCoefficients(int size, OctagonInterval bounds, OctagonState oct) {
        super(size, oct);
        this.coefficients = new OctagonInterval[size + 1];
        Arrays.fill(this.coefficients, OctagonInterval.FALSE);
        this.coefficients[size] = bounds;
    }

    @Override
    public OctagonIntervalCoefficients expandToSize(int pSize, OctagonState pOct) {
        Preconditions.checkArgument((this.size <= pSize ? 1 : 0) != 0, (Object)"new size too small");
        if (this.size == pSize) {
            return this;
        }
        OctagonIntervalCoefficients newCoeffs = new OctagonIntervalCoefficients(pSize, pOct);
        for (int i = 0; i < this.coefficients.length - 1; ++i) {
            newCoeffs.coefficients[i] = this.coefficients[i];
        }
        newCoeffs.coefficients[newCoeffs.coefficients.length - 1] = this.coefficients[this.coefficients.length - 1];
        return newCoeffs;
    }

    @Override
    public IOctagonCoefficients add(IOctagonCoefficients other) {
        if (other instanceof OctagonSimpleCoefficients) {
            return this.add((OctagonSimpleCoefficients)other);
        }
        if (other instanceof OctagonIntervalCoefficients) {
            return this.add((OctagonIntervalCoefficients)other);
        }
        if (other instanceof OctagonUniversalCoefficients) {
            return OctagonUniversalCoefficients.INSTANCE;
        }
        throw new IllegalArgumentException("Unkown subtype of OctCoefficients");
    }

    private IOctagonCoefficients add(OctagonSimpleCoefficients other) {
        Preconditions.checkArgument((other.size() == this.size ? 1 : 0) != 0, (Object)"Different size of coefficients.");
        OctagonIntervalCoefficients ret = new OctagonIntervalCoefficients(this.size, this.oct);
        for (int i = 0; i < this.coefficients.length; ++i) {
            ret.coefficients[i] = this.coefficients[i].plus(new OctagonInterval(other.coefficients[i]));
        }
        return ret;
    }

    private IOctagonCoefficients add(OctagonIntervalCoefficients other) {
        Preconditions.checkArgument((other.size() == this.size ? 1 : 0) != 0, (Object)"Different size of coefficients.");
        OctagonIntervalCoefficients ret = new OctagonIntervalCoefficients(this.size, this.oct);
        for (int i = 0; i < this.coefficients.length; ++i) {
            ret.coefficients[i] = this.coefficients[i].plus(other.coefficients[i]);
        }
        return ret;
    }

    @Override
    public IOctagonCoefficients sub(IOctagonCoefficients other) {
        if (other instanceof OctagonSimpleCoefficients) {
            return this.sub((OctagonSimpleCoefficients)other);
        }
        if (other instanceof OctagonIntervalCoefficients) {
            return this.sub((OctagonIntervalCoefficients)other);
        }
        if (other instanceof OctagonUniversalCoefficients) {
            return OctagonUniversalCoefficients.INSTANCE;
        }
        throw new IllegalArgumentException("Unkown subtype of OctCoefficients");
    }

    private IOctagonCoefficients sub(OctagonSimpleCoefficients other) {
        Preconditions.checkArgument((other.size() == this.size ? 1 : 0) != 0, (Object)"Different size of coefficients.");
        OctagonIntervalCoefficients ret = new OctagonIntervalCoefficients(this.size, this.oct);
        for (int i = 0; i < this.coefficients.length; ++i) {
            ret.coefficients[i] = this.coefficients[i].minus(new OctagonInterval(other.coefficients[i]));
        }
        return ret;
    }

    private IOctagonCoefficients sub(OctagonIntervalCoefficients other) {
        Preconditions.checkArgument((other.size() == this.size ? 1 : 0) != 0, (Object)"Different size of coefficients.");
        OctagonIntervalCoefficients ret = new OctagonIntervalCoefficients(this.size, this.oct);
        for (int i = 0; i < this.coefficients.length; ++i) {
            ret.coefficients[i] = this.coefficients[i].minus(other.coefficients[i]);
        }
        return ret;
    }

    @Override
    protected IOctagonCoefficients mulInner(IOctagonCoefficients other) {
        int index;
        assert (this.hasOnlyOneValue());
        OctagonInterval bounds = null;
        for (index = 0; index < this.coefficients.length && (bounds = this.coefficients[index]).equals(OctagonInterval.FALSE); ++index) {
        }
        assert (bounds != null);
        if (index >= this.oct.sizeOfVariables()) {
            return other.mul(bounds);
        }
        OctagonInterval infBounds = this.oct.getVariableBounds(index);
        if (infBounds.isInfinite()) {
            return OctagonUniversalCoefficients.INSTANCE;
        }
        return other.mul(bounds.times(infBounds));
    }

    @Override
    public IOctagonCoefficients mul(OctagonNumericValue factor) {
        return this.mul(new OctagonInterval(factor));
    }

    @Override
    public IOctagonCoefficients mul(OctagonInterval interval) {
        OctagonIntervalCoefficients ret = new OctagonIntervalCoefficients(this.size, this.oct);
        for (int i = 0; i < this.coefficients.length; ++i) {
            ret.coefficients[i] = this.coefficients[i].times(interval);
        }
        return ret;
    }

    @Override
    protected IOctagonCoefficients divInner(IOctagonCoefficients coeffs) {
        assert (coeffs.hasOnlyOneValue());
        if (coeffs instanceof OctagonSimpleCoefficients) {
            return this.divInner((OctagonSimpleCoefficients)coeffs);
        }
        if (coeffs instanceof OctagonIntervalCoefficients) {
            return this.divInner((OctagonIntervalCoefficients)coeffs);
        }
        if (coeffs instanceof OctagonUniversalCoefficients) {
            return OctagonUniversalCoefficients.INSTANCE;
        }
        throw new IllegalArgumentException("Unkown subtype of OctCoefficients");
    }

    private IOctagonCoefficients divInner(OctagonSimpleCoefficients coeffs) {
        int index;
        OctagonNumericValue value = null;
        for (index = 0; index < coeffs.coefficients.length && (value = coeffs.coefficients[index]).isEqual(OctagonIntValue.ZERO); ++index) {
        }
        if (index == coeffs.oct.sizeOfVariables()) {
            return this.div(value);
        }
        if (index > this.oct.sizeOfVariables()) {
            return OctagonUniversalCoefficients.INSTANCE;
        }
        OctagonInterval bounds = coeffs.oct.getVariableBounds(index);
        if (bounds.isInfinite()) {
            return OctagonUniversalCoefficients.INSTANCE;
        }
        return this.div(bounds.times(new OctagonInterval(value)));
    }

    private IOctagonCoefficients divInner(OctagonIntervalCoefficients coeffs) {
        int index;
        assert (coeffs.hasOnlyOneValue());
        OctagonInterval bounds = null;
        for (index = 0; index < coeffs.coefficients.length && (bounds = coeffs.coefficients[index]).equals(OctagonInterval.FALSE); ++index) {
        }
        if (index == coeffs.oct.sizeOfVariables()) {
            return this.div(bounds);
        }
        if (index > coeffs.oct.sizeOfVariables()) {
            throw new ArithmeticException("Division by zero");
        }
        OctagonInterval infBounds = coeffs.oct.getVariableBounds(index);
        if (infBounds.isInfinite()) {
            return OctagonUniversalCoefficients.INSTANCE;
        }
        return this.div(infBounds.times(bounds));
    }

    @Override
    public IOctagonCoefficients div(OctagonNumericValue pDivisor) {
        OctagonIntervalCoefficients ret = new OctagonIntervalCoefficients(this.size, this.oct);
        for (int i = 0; i < this.coefficients.length; ++i) {
            ret.coefficients[i] = this.coefficients[i].divide(new OctagonInterval(pDivisor));
        }
        return ret;
    }

    @Override
    public IOctagonCoefficients div(OctagonInterval interval) {
        if (interval.isInfinite()) {
            return OctagonUniversalCoefficients.INSTANCE;
        }
        if (interval.intersects(OctagonInterval.DELTA)) {
            return OctagonUniversalCoefficients.INSTANCE;
        }
        OctagonIntervalCoefficients ret = new OctagonIntervalCoefficients(this.size, this.oct);
        for (int i = 0; i < this.coefficients.length; ++i) {
            ret.coefficients[i] = this.coefficients[i].divide(interval);
        }
        return ret;
    }

    public OctagonIntervalCoefficients withConstantValue(OctagonInterval bounds) {
        OctagonIntervalCoefficients ret = new OctagonIntervalCoefficients(this.size, this.oct);
        ret.coefficients = Arrays.copyOf(this.coefficients, this.coefficients.length);
        ret.coefficients[this.coefficients.length - 1] = bounds;
        return ret;
    }

    @Override
    public boolean hasOnlyConstantValue() {
        for (int i = 0; i < this.coefficients.length - 1; ++i) {
            if (this.coefficients[i].equals(OctagonInterval.FALSE)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getVariableIndex() {
        int counter;
        assert (this.hasOnlyOneValue() && !this.hasOnlyConstantValue()) : "is no variable!";
        for (counter = 0; counter < this.size && this.coefficients[counter].equals(OctagonInterval.FALSE); ++counter) {
        }
        return counter;
    }

    public OctagonInterval getConstantValue() {
        return this.coefficients[this.coefficients.length - 1];
    }

    @Override
    public boolean hasOnlyOneValue() {
        boolean foundValue = false;
        for (OctagonInterval coefficient : this.coefficients) {
            if (coefficient.equals(OctagonInterval.FALSE)) continue;
            if (foundValue) {
                return false;
            }
            foundValue = true;
        }
        return true;
    }

    public static OctagonIntervalCoefficients getNondetUIntCoeffs(int size, OctagonState oct) {
        OctagonIntervalCoefficients result = new OctagonIntervalCoefficients(size, oct);
        result.coefficients[result.coefficients.length - 1] = new OctagonInterval(0.0, Double.POSITIVE_INFINITY);
        return result;
    }

    public static OctagonIntervalCoefficients getNondetBoolCoeffs(int size, OctagonState oct) {
        OctagonIntervalCoefficients result = new OctagonIntervalCoefficients(size, oct);
        result.coefficients[result.coefficients.length - 1] = new OctagonInterval(0.0, 1.0);
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Arrays.hashCode(this.coefficients);
        result = 31 * result + Objects.hash(this.size);
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OctagonIntervalCoefficients) || !super.equals(other)) {
            return false;
        }
        OctagonIntervalCoefficients octCoefficients = (OctagonIntervalCoefficients)other;
        return Arrays.equals(this.coefficients, octCoefficients.coefficients) && this.size == octCoefficients.size;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.coefficients.length; ++i) {
            String a = this.coefficients[i].getLow().isInfinite() ? "INFINITY" : this.coefficients[i].getLow().toString();
            String b = this.coefficients[i].getHigh().isInfinite() ? "INFINITY" : this.coefficients[i].getHigh().toString();
            if (i < this.size) {
                builder.append(this.oct.getVariableToIndexMap().inverse().get((Object)i) + " -> [" + a + ", " + b + "]\n");
                continue;
            }
            builder.append("CONSTANT_VAL -> [" + a + ", " + b + "]\n");
        }
        return builder.toString();
    }

    @Override
    public NumArray getNumArray(OctagonManager manager) {
        NumArray arr = manager.init_num_t(this.coefficients.length * 2);
        for (int i = 0; i < this.coefficients.length; ++i) {
            OctagonNumericValue<?> low = this.coefficients[i].getLow();
            OctagonNumericValue<?> high = this.coefficients[i].getHigh();
            if (low.isInfinite()) {
                manager.num_set_inf(arr, i * 2 + 1);
            } else if (low instanceof OctagonDoubleValue) {
                manager.num_set_float(arr, i * 2 + 1, ((Number)low.getValue()).doubleValue() * -1.0);
            } else {
                manager.num_set_int(arr, i * 2 + 1, ((Number)low.getValue()).longValue() * -1L);
            }
            if (high.isInfinite()) {
                manager.num_set_inf(arr, i * 2);
                continue;
            }
            if (high instanceof OctagonDoubleValue) {
                manager.num_set_float(arr, i * 2, ((Number)high.getValue()).doubleValue());
                continue;
            }
            manager.num_set_int(arr, i * 2, ((Number)high.getValue()).longValue());
        }
        return arr;
    }
}

