/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.octagon.coefficients;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import org.sosy_lab.cpachecker.cpa.octagon.OctagonState;
import org.sosy_lab.cpachecker.cpa.octagon.coefficients.AOctagonCoefficients;
import org.sosy_lab.cpachecker.cpa.octagon.coefficients.IOctagonCoefficients;
import org.sosy_lab.cpachecker.cpa.octagon.coefficients.OctagonIntervalCoefficients;
import org.sosy_lab.cpachecker.cpa.octagon.coefficients.OctagonUniversalCoefficients;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonDoubleValue;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonIntValue;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonInterval;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonNumericValue;
import org.sosy_lab.cpachecker.util.octagon.NumArray;
import org.sosy_lab.cpachecker.util.octagon.OctagonManager;

public class OctagonSimpleCoefficients
extends AOctagonCoefficients {
    protected OctagonNumericValue[] coefficients;

    public OctagonSimpleCoefficients(int size, OctagonState oct) {
        super(size, oct);
        this.coefficients = new OctagonNumericValue[size + 1];
        Arrays.fill(this.coefficients, OctagonIntValue.ZERO);
    }

    public OctagonSimpleCoefficients(int size, int index, OctagonNumericValue value, OctagonState oct) {
        super(size, oct);
        Preconditions.checkArgument((index < size ? 1 : 0) != 0, (Object)"Index too big");
        this.coefficients = new OctagonNumericValue[size + 1];
        Arrays.fill(this.coefficients, OctagonIntValue.ZERO);
        this.coefficients[index] = value;
    }

    public OctagonSimpleCoefficients(int size, OctagonNumericValue value, OctagonState oct) {
        super(size, oct);
        this.coefficients = new OctagonNumericValue[size + 1];
        Arrays.fill(this.coefficients, OctagonIntValue.ZERO);
        this.coefficients[size] = value;
    }

    @Override
    public OctagonSimpleCoefficients expandToSize(int pSize, OctagonState pOct) {
        Preconditions.checkArgument((this.size <= pSize ? 1 : 0) != 0, (Object)"new size too small");
        if (this.size == pSize) {
            return this;
        }
        OctagonSimpleCoefficients newCoeffs = new OctagonSimpleCoefficients(pSize, pOct);
        for (int i = 0; i < this.coefficients.length - 1; ++i) {
            newCoeffs.coefficients[i] = this.coefficients[i];
        }
        newCoeffs.coefficients[pSize] = this.coefficients[this.size];
        return newCoeffs;
    }

    public OctagonIntervalCoefficients convertToInterval() {
        OctagonIntervalCoefficients octCoeffs = new OctagonIntervalCoefficients(this.size, this.oct);
        for (int i = 0; i < this.coefficients.length; ++i) {
            octCoeffs.coefficients[i] = new OctagonInterval(this.coefficients[i]);
        }
        return octCoeffs;
    }

    @Override
    public IOctagonCoefficients add(IOctagonCoefficients other) {
        if (other instanceof OctagonSimpleCoefficients) {
            return this.add((OctagonSimpleCoefficients)other);
        }
        if (other instanceof OctagonIntervalCoefficients) {
            return this.add((OctagonIntervalCoefficients)other);
        }
        if (other instanceof OctagonUniversalCoefficients) {
            return OctagonUniversalCoefficients.INSTANCE;
        }
        throw new IllegalArgumentException("Unkown subtype of OctCoefficients");
    }

    private IOctagonCoefficients add(OctagonSimpleCoefficients other) {
        Preconditions.checkArgument((other.size() == this.size ? 1 : 0) != 0, (Object)"Different size of coefficients.");
        OctagonSimpleCoefficients ret = new OctagonSimpleCoefficients(this.size, this.oct);
        for (int i = 0; i < this.coefficients.length; ++i) {
            ret.coefficients[i] = this.coefficients[i].add(other.coefficients[i]);
        }
        return ret;
    }

    private IOctagonCoefficients add(OctagonIntervalCoefficients other) {
        Preconditions.checkArgument((other.size() == this.size ? 1 : 0) != 0, (Object)"Different size of coefficients.");
        OctagonIntervalCoefficients ret = new OctagonIntervalCoefficients(this.size, this.oct);
        for (int i = 0; i < this.coefficients.length; ++i) {
            ret.coefficients[i] = other.coefficients[i].plus(new OctagonInterval(this.coefficients[i]));
        }
        return ret;
    }

    @Override
    public IOctagonCoefficients sub(IOctagonCoefficients other) {
        if (other instanceof OctagonSimpleCoefficients) {
            return this.sub((OctagonSimpleCoefficients)other);
        }
        if (other instanceof OctagonIntervalCoefficients) {
            return this.sub((OctagonIntervalCoefficients)other);
        }
        if (other instanceof OctagonUniversalCoefficients) {
            return OctagonUniversalCoefficients.INSTANCE;
        }
        throw new IllegalArgumentException("Unkown subtype of OctCoefficients");
    }

    private IOctagonCoefficients sub(OctagonSimpleCoefficients other) {
        Preconditions.checkArgument((other.size() == this.size ? 1 : 0) != 0, (Object)"Different size of coefficients.");
        OctagonSimpleCoefficients ret = new OctagonSimpleCoefficients(this.size, this.oct);
        for (int i = 0; i < this.coefficients.length; ++i) {
            ret.coefficients[i] = this.coefficients[i].subtract(other.coefficients[i]);
        }
        return ret;
    }

    private IOctagonCoefficients sub(OctagonIntervalCoefficients other) {
        Preconditions.checkArgument((other.size() == this.size ? 1 : 0) != 0, (Object)"Different size of coefficients.");
        OctagonIntervalCoefficients ret = new OctagonIntervalCoefficients(this.size, this.oct);
        for (int i = 0; i < this.coefficients.length; ++i) {
            ret.coefficients[i] = new OctagonInterval(this.coefficients[i]).minus(other.coefficients[i]);
        }
        return ret;
    }

    @Override
    protected IOctagonCoefficients mulInner(IOctagonCoefficients other) {
        int index;
        assert (this.hasOnlyOneValue());
        OctagonNumericValue value = null;
        for (index = 0; index < this.coefficients.length && (value = this.coefficients[index]).isEqual(OctagonIntValue.ZERO); ++index) {
        }
        if (index >= this.oct.sizeOfVariables()) {
            return other.mul(value);
        }
        OctagonInterval bounds = this.oct.getVariableBounds(index);
        if (bounds.isInfinite()) {
            return OctagonUniversalCoefficients.INSTANCE;
        }
        if (bounds.isSingular()) {
            return other.mul(bounds.getLow().mul(value));
        }
        return other.mul(bounds.times(new OctagonInterval(value)));
    }

    @Override
    public IOctagonCoefficients mul(OctagonNumericValue factor) {
        OctagonSimpleCoefficients newCoeffs = new OctagonSimpleCoefficients(this.size, this.oct);
        for (int i = 0; i < this.coefficients.length; ++i) {
            newCoeffs.coefficients[i] = this.coefficients[i].mul(factor);
        }
        return newCoeffs;
    }

    @Override
    public IOctagonCoefficients mul(OctagonInterval interval) {
        OctagonIntervalCoefficients ret = new OctagonIntervalCoefficients(this.size, this.oct);
        for (int i = 0; i < this.coefficients.length; ++i) {
            ret.coefficients[i] = interval.times(new OctagonInterval(this.coefficients[i]));
        }
        return ret;
    }

    @Override
    protected IOctagonCoefficients divInner(IOctagonCoefficients coeffs) {
        assert (coeffs.hasOnlyOneValue());
        if (coeffs instanceof OctagonSimpleCoefficients) {
            return this.divInner((OctagonSimpleCoefficients)coeffs);
        }
        if (coeffs instanceof OctagonIntervalCoefficients) {
            return this.divInner((OctagonIntervalCoefficients)coeffs);
        }
        if (coeffs instanceof OctagonUniversalCoefficients) {
            return OctagonUniversalCoefficients.INSTANCE;
        }
        throw new IllegalArgumentException("Unkown subtype of OctCoefficients");
    }

    private IOctagonCoefficients divInner(OctagonSimpleCoefficients coeffs) {
        int index;
        OctagonNumericValue value = null;
        for (index = 0; index < coeffs.coefficients.length && (value = coeffs.coefficients[index]).isEqual(OctagonIntValue.ZERO); ++index) {
        }
        if (index == coeffs.oct.sizeOfVariables()) {
            return this.div(value);
        }
        if (index > this.oct.sizeOfVariables()) {
            return OctagonUniversalCoefficients.INSTANCE;
        }
        OctagonInterval bounds = coeffs.oct.getVariableBounds(index);
        if (bounds.isInfinite()) {
            return OctagonUniversalCoefficients.INSTANCE;
        }
        if (bounds.contains(OctagonInterval.FALSE)) {
            return OctagonUniversalCoefficients.INSTANCE;
        }
        if (bounds.isSingular()) {
            return this.div(bounds.getLow().mul(value));
        }
        return this.div(bounds.times(new OctagonInterval(value)));
    }

    private IOctagonCoefficients divInner(OctagonIntervalCoefficients coeffs) {
        int index;
        assert (coeffs.hasOnlyOneValue());
        OctagonInterval bounds = null;
        for (index = 0; index < coeffs.coefficients.length && (bounds = coeffs.coefficients[index]).equals(OctagonInterval.FALSE); ++index) {
        }
        if (index == coeffs.oct.sizeOfVariables()) {
            return this.div(bounds);
        }
        if (index > coeffs.oct.sizeOfVariables()) {
            throw new ArithmeticException("Division by zero");
        }
        OctagonInterval infBounds = coeffs.oct.getVariableBounds(index);
        if (infBounds.isInfinite()) {
            return OctagonUniversalCoefficients.INSTANCE;
        }
        return this.div(infBounds.times(bounds));
    }

    @Override
    public IOctagonCoefficients div(OctagonNumericValue pDivisor) {
        OctagonSimpleCoefficients newCoeffs = new OctagonSimpleCoefficients(this.size, this.oct);
        for (int i = 0; i < this.coefficients.length; ++i) {
            newCoeffs.coefficients[i] = this.coefficients[i].div(pDivisor);
        }
        return newCoeffs;
    }

    @Override
    public IOctagonCoefficients div(OctagonInterval interval) {
        if (interval.isInfinite()) {
            return OctagonUniversalCoefficients.INSTANCE;
        }
        if (interval.intersects(OctagonInterval.DELTA)) {
            return OctagonUniversalCoefficients.INSTANCE;
        }
        OctagonIntervalCoefficients ret = new OctagonIntervalCoefficients(this.size, this.oct);
        for (int i = 0; i < this.coefficients.length; ++i) {
            ret.coefficients[i] = new OctagonInterval(this.coefficients[i]).divide(interval);
        }
        return ret;
    }

    public OctagonNumericValue get(int index) {
        Preconditions.checkArgument((index < this.size ? 1 : 0) != 0, (Object)"Index too big");
        return this.coefficients[index];
    }

    public OctagonNumericValue getConstantValue() {
        return this.coefficients[this.size];
    }

    @Override
    public boolean hasOnlyConstantValue() {
        for (int i = 0; i < this.coefficients.length - 1; ++i) {
            if (this.coefficients[i].isEqual(OctagonIntValue.ZERO)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasOnlyOneValue() {
        boolean foundValue = false;
        for (OctagonNumericValue coefficient : this.coefficients) {
            if (coefficient.isEqual(OctagonIntValue.ZERO)) continue;
            if (foundValue) {
                return false;
            }
            foundValue = true;
        }
        return true;
    }

    @Override
    public int getVariableIndex() {
        int counter;
        assert (this.hasOnlyOneValue() && !this.hasOnlyConstantValue()) : "is no variable!";
        for (counter = 0; counter < this.size && this.coefficients[counter].isEqual(OctagonIntValue.ZERO); ++counter) {
        }
        return counter;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Arrays.hashCode(this.coefficients);
        result = 31 * result + Objects.hash(this.size);
        return result;
    }

    public static OctagonSimpleCoefficients getBoolTRUECoeffs(int size, OctagonState oct) {
        OctagonSimpleCoefficients result = new OctagonSimpleCoefficients(size, oct);
        result.coefficients[size] = OctagonIntValue.ONE;
        return result;
    }

    public static OctagonSimpleCoefficients getBoolFALSECoeffs(int size, OctagonState oct) {
        OctagonSimpleCoefficients result = new OctagonSimpleCoefficients(size, oct);
        result.coefficients[size] = OctagonIntValue.ZERO;
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OctagonSimpleCoefficients) || !super.equals(other)) {
            return false;
        }
        OctagonSimpleCoefficients octCoefficients = (OctagonSimpleCoefficients)other;
        return Arrays.equals(this.coefficients, octCoefficients.coefficients) && this.size == octCoefficients.size;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.coefficients.length; ++i) {
            String tmp = this.coefficients[i].toString();
            if (i < this.coefficients.length - 1) {
                builder.append(this.oct.getVariableToIndexMap().inverse().get((Object)i) + " -> " + tmp + "\n");
                continue;
            }
            builder.append("CONSTANT_VAL -> " + tmp + "\n");
        }
        return builder.toString();
    }

    @Override
    public NumArray getNumArray(OctagonManager manager) {
        NumArray arr = manager.init_num_t(this.coefficients.length);
        for (int i = 0; i < this.coefficients.length; ++i) {
            if (this.coefficients[i] instanceof OctagonDoubleValue) {
                manager.num_set_float(arr, i, ((Number)this.coefficients[i].getValue()).doubleValue());
                continue;
            }
            manager.num_set_int(arr, i, ((Number)this.coefficients[i].getValue()).longValue());
        }
        return arr;
    }
}

