/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.octagon.refiner;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.refinement.UseDefRelation;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;

public class OctagonAnalysisFeasibilityChecker {
    private final TransferRelation transfer;
    private final ShutdownNotifier shutdownNotifier;
    private final ARGPath checkedPath;
    private final ARGPath foundPath;

    public OctagonAnalysisFeasibilityChecker(Configuration pConfig, ShutdownNotifier pShutdownNotifier, ARGPath pPath, Class<? extends ConfigurableProgramAnalysis> pClass, Optional<VariableClassification> pVarClass, TransferRelation pTransfer, AbstractState pInitialState) throws InvalidConfigurationException, CPAException, InterruptedException {
        this.shutdownNotifier = pShutdownNotifier;
        this.transfer = pTransfer;
        this.checkedPath = pPath;
        this.foundPath = this.getInfeasiblePrefix(VariableTrackingPrecision.createStaticPrecision(pConfig, pVarClass, pClass), pInitialState);
    }

    public boolean isFeasible() {
        return this.checkedPath.size() == this.foundPath.size();
    }

    public Multimap<CFANode, MemoryLocation> getPrecisionIncrement() {
        if (this.isFeasible()) {
            return ArrayListMultimap.create();
        }
        ArrayListMultimap increment = ArrayListMultimap.create();
        for (MemoryLocation loc : this.getMemoryLocationsFromUseDefRelation()) {
            increment.put((Object)CFANode.newDummyCFANode("BOGUS-NODE"), (Object)loc);
        }
        return increment;
    }

    private FluentIterable<MemoryLocation> getMemoryLocationsFromUseDefRelation() {
        UseDefRelation useDefRelation = new UseDefRelation(this.foundPath, (Set<String>)ImmutableSet.of(), false);
        return FluentIterable.from(useDefRelation.getUsesAsQualifiedName()).transform(MemoryLocation::parseExtendedQualifiedName);
    }

    private ARGPath getInfeasiblePrefix(VariableTrackingPrecision pPrecision, AbstractState pInitial) throws CPAException, InterruptedException {
        try {
            ArrayList next = Lists.newArrayList((Object[])new AbstractState[]{pInitial});
            HashSet<? extends AbstractState> successors = new HashSet<AbstractState>();
            PathIterator pathIt = this.checkedPath.fullPathIterator();
            while (pathIt.hasNext()) {
                CFAEdge edge = pathIt.getOutgoingEdge();
                successors.clear();
                for (AbstractState st : next) {
                    successors.addAll(this.transfer.getAbstractSuccessorsForEdge(st, pPrecision, edge));
                    this.shutdownNotifier.shutdownIfNecessary();
                }
                pathIt.advance();
                if (successors.isEmpty()) break;
                next.clear();
                next.addAll(successors);
            }
            return pathIt.getPrefixInclusive();
        }
        catch (CPATransferException e) {
            throw new CPAException("Computation of successor failed for checking path: " + e.getMessage(), e);
        }
    }
}

