/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.overflow;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithAssumptions;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;

public final class OverflowState
implements AbstractStateWithAssumptions,
Graphable,
AbstractQueryableState {
    private final ImmutableSet<? extends AExpression> assumptions;
    private final OverflowState parent;
    private final boolean nextHasOverflow;
    private static final String PROPERTY_OVERFLOW = "overflow";

    public OverflowState(Set<? extends AExpression> pAssumptions, boolean pNextHasOverflow) {
        this(pAssumptions, pNextHasOverflow, null);
    }

    public OverflowState(Set<? extends AExpression> pAssumptions, boolean pNextHasOverflow, OverflowState pParent) {
        this.assumptions = ImmutableSet.copyOf(pAssumptions);
        this.parent = pParent;
        this.nextHasOverflow = pNextHasOverflow;
    }

    public boolean hasOverflow() {
        return this.parent != null && this.parent.nextHasOverflow;
    }

    public boolean nextHasOverflow() {
        return this.nextHasOverflow;
    }

    public AbstractStateWithAssumptions getParent() {
        return this.parent;
    }

    @Override
    public List<? extends AExpression> getAssumptions() {
        return this.assumptions.asList();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.assumptions, this.nextHasOverflow);
    }

    @Override
    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        OverflowState that = (OverflowState)pO;
        return this.nextHasOverflow == that.nextHasOverflow && this.assumptions.equals(that.assumptions);
    }

    @Override
    public String toString() {
        return "OverflowState{assumeEdges=[" + this.getReadableAssumptions() + "], nextHasOverflow=" + this.nextHasOverflow + "}";
    }

    @Override
    public String toDOTLabel() {
        if (this.hasOverflow()) {
            return "Assumptions:\n" + OverflowState.getReadableAssumptions(this).replace(", ", "\n");
        }
        return "";
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }

    private String getReadableAssumptions() {
        return OverflowState.getReadableAssumptions(this);
    }

    private static String getReadableAssumptions(OverflowState s) {
        StringBuilder sb = new StringBuilder();
        Joiner.on((String)", ").appendTo(sb, s.assumptions.stream().map(x -> x.toASTString()).iterator());
        return sb.toString();
    }

    @Override
    public String getCPAName() {
        return "OverflowCPA";
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        if (pProperty.equals(PROPERTY_OVERFLOW)) {
            return this.hasOverflow();
        }
        throw new InvalidQueryException("Query '" + pProperty + "' is invalid.");
    }
}

