/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.overflow;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.overflow.OverflowState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.ArithmeticOverflowAssumptionBuilder;

public class OverflowTransferRelation
extends SingleEdgeTransferRelation {
    private final CBinaryExpressionBuilder expressionBuilder;
    private final ArithmeticOverflowAssumptionBuilder noOverflowAssumptionBuilder;

    public OverflowTransferRelation(ArithmeticOverflowAssumptionBuilder pNoOverflowAssumptionBuilder, CBinaryExpressionBuilder pExpressionBuilder) {
        this.expressionBuilder = pExpressionBuilder;
        this.noOverflowAssumptionBuilder = pNoOverflowAssumptionBuilder;
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState state, Precision precision, CFAEdge cfaEdge) throws CPATransferException, InterruptedException {
        OverflowState prev = (OverflowState)state;
        if (prev.hasOverflow()) {
            return ImmutableList.of();
        }
        boolean nextHasOverflow = prev.nextHasOverflow();
        int leavingEdgesOfNextState = cfaEdge.getSuccessor().getNumLeavingEdges();
        ImmutableList.Builder outStates = ImmutableList.builder();
        if (leavingEdgesOfNextState == 0) {
            return ImmutableList.of((Object)new OverflowState((Set<? extends AExpression>)ImmutableSet.of(), nextHasOverflow, prev));
        }
        for (int i = 0; i < leavingEdgesOfNextState; ++i) {
            Set<CExpression> assumptions = this.noOverflowAssumptionBuilder.assumptionsForEdge(cfaEdge.getSuccessor().getLeavingEdge(i));
            if (assumptions.isEmpty()) {
                outStates.add((Object)new OverflowState((Set<? extends AExpression>)ImmutableSet.of(), nextHasOverflow, prev));
                continue;
            }
            for (CExpression assumption : assumptions) {
                outStates.add((Object)new OverflowState((Set<? extends AExpression>)ImmutableSet.of((Object)this.mkNot(assumption)), true, prev));
            }
            outStates.add((Object)new OverflowState(assumptions, nextHasOverflow, prev));
        }
        return outStates.build();
    }

    private CExpression mkNot(CExpression arg) {
        try {
            return this.expressionBuilder.negateExpressionAndSimplify(arg);
        }
        catch (UnrecognizedCodeException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState state, Iterable<AbstractState> otherStates, @Nullable CFAEdge cfaEdge, Precision precision) throws CPATransferException, InterruptedException {
        OverflowState overflowState = (OverflowState)state;
        return Collections.singleton(overflowState);
    }
}

