/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.pointer2;

import java.util.Map;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.pointer2.PointerState;
import org.sosy_lab.cpachecker.cpa.pointer2.util.LocationSet;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public enum PointerDomain implements AbstractDomain
{
    INSTANCE;


    @Override
    public AbstractState join(AbstractState pState1, AbstractState pState2) throws CPAException {
        PointerState state2;
        PointerState state1 = (PointerState)pState1;
        PointerState result = state2 = (PointerState)pState2;
        for (Map.Entry<MemoryLocation, LocationSet> pointsToEntry : state1.getPointsToMap().entrySet()) {
            result = result.addPointsToInformation(pointsToEntry.getKey(), pointsToEntry.getValue());
        }
        if (result.equals(state2)) {
            return state2;
        }
        if (result.equals(state1)) {
            return state1;
        }
        return result;
    }

    @Override
    public boolean isLessOrEqual(AbstractState pState1, AbstractState pState2) throws CPAException, InterruptedException {
        if (pState1 == pState2) {
            return true;
        }
        PointerState state1 = (PointerState)pState1;
        PointerState state2 = (PointerState)pState2;
        for (Map.Entry<MemoryLocation, LocationSet> pointsToEntry : state1.getPointsToMap().entrySet()) {
            LocationSet rightSide = state2.getPointsToSet(pointsToEntry.getKey());
            if (rightSide.containsAll(pointsToEntry.getValue())) continue;
            return false;
        }
        return true;
    }
}

