/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.pointer2;

import com.google.common.collect.FluentIterable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.pointer2.util.ExplicitLocationSet;
import org.sosy_lab.cpachecker.cpa.pointer2.util.LocationSet;
import org.sosy_lab.cpachecker.cpa.pointer2.util.LocationSetBot;
import org.sosy_lab.cpachecker.cpa.pointer2.util.LocationSetTop;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class PointerState
implements AbstractState {
    public static final PointerState INITIAL_STATE = new PointerState();
    private final PersistentSortedMap<MemoryLocation, LocationSet> pointsToMap;

    private PointerState() {
        this.pointsToMap = PathCopyingPersistentTreeMap.of();
    }

    private PointerState(PersistentSortedMap<MemoryLocation, LocationSet> pPointsToMap) {
        this.pointsToMap = pPointsToMap;
    }

    public PointerState addPointsToInformation(MemoryLocation pSource, MemoryLocation pTarget) {
        LocationSet previousPointsToSet = this.getPointsToSet(pSource);
        LocationSet newPointsToSet = previousPointsToSet.addElement(pTarget);
        return new PointerState((PersistentSortedMap<MemoryLocation, LocationSet>)this.pointsToMap.putAndCopy((Object)pSource, (Object)newPointsToSet));
    }

    public PointerState addPointsToInformation(MemoryLocation pSource, Iterable<MemoryLocation> pTargets) {
        LocationSet previousPointsToSet = this.getPointsToSet(pSource);
        LocationSet newPointsToSet = previousPointsToSet.addElements(pTargets);
        return new PointerState((PersistentSortedMap<MemoryLocation, LocationSet>)this.pointsToMap.putAndCopy((Object)pSource, (Object)newPointsToSet));
    }

    public PointerState addPointsToInformation(MemoryLocation pSource, LocationSet pTargets) {
        if (pTargets.isBot()) {
            return this;
        }
        if (pTargets.isTop()) {
            return new PointerState((PersistentSortedMap<MemoryLocation, LocationSet>)this.pointsToMap.putAndCopy((Object)pSource, (Object)LocationSetTop.INSTANCE));
        }
        LocationSet previousPointsToSet = this.getPointsToSet(pSource);
        return new PointerState((PersistentSortedMap<MemoryLocation, LocationSet>)this.pointsToMap.putAndCopy((Object)pSource, (Object)previousPointsToSet.addElements(pTargets)));
    }

    public LocationSet getPointsToSet(MemoryLocation pSource) {
        LocationSet result = (LocationSet)this.pointsToMap.get((Object)pSource);
        if (result == null) {
            return LocationSetBot.INSTANCE;
        }
        return result;
    }

    public @Nullable Boolean pointsTo(MemoryLocation pSource, MemoryLocation pTarget) {
        LocationSet pointsToSet = this.getPointsToSet(pSource);
        if (pointsToSet.equals(LocationSetBot.INSTANCE)) {
            return false;
        }
        if (pointsToSet instanceof ExplicitLocationSet) {
            ExplicitLocationSet explicitLocationSet = (ExplicitLocationSet)pointsToSet;
            if (explicitLocationSet.mayPointTo(pTarget)) {
                return explicitLocationSet.getSize() == 1 ? Boolean.valueOf(true) : null;
            }
            return false;
        }
        return null;
    }

    public boolean definitelyPointsTo(MemoryLocation pSource, MemoryLocation pTarget) {
        return Boolean.TRUE.equals(this.pointsTo(pSource, pTarget));
    }

    public boolean definitelyNotPointsTo(MemoryLocation pSource, MemoryLocation pTarget) {
        return Boolean.FALSE.equals(this.pointsTo(pSource, pTarget));
    }

    public boolean mayPointTo(MemoryLocation pSource, MemoryLocation pTarget) {
        return !Boolean.FALSE.equals(this.pointsTo(pSource, pTarget));
    }

    public Set<MemoryLocation> getKnownLocations() {
        return FluentIterable.concat((Iterable)this.pointsToMap.keySet(), (Iterable)FluentIterable.concat((Iterable)FluentIterable.from((Iterable)this.pointsToMap.values()).filter(ExplicitLocationSet.class))).toSet();
    }

    public Map<MemoryLocation, LocationSet> getPointsToMap() {
        return Collections.unmodifiableMap(this.pointsToMap);
    }

    @Override
    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO instanceof PointerState) {
            return this.pointsToMap.equals(((PointerState)pO).pointsToMap);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.pointsToMap.hashCode();
    }

    @Override
    public String toString() {
        return this.pointsToMap.toString();
    }
}

