/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.pointer2;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.ABinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AbstractExpression;
import org.sosy_lab.cpachecker.cfa.ast.AbstractSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CAddressOfLabelExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackState;
import org.sosy_lab.cpachecker.cpa.pointer2.PointerState;
import org.sosy_lab.cpachecker.cpa.pointer2.util.ExplicitLocationSet;
import org.sosy_lab.cpachecker.cpa.pointer2.util.LocationSet;
import org.sosy_lab.cpachecker.cpa.pointer2.util.LocationSetBot;
import org.sosy_lab.cpachecker.cpa.pointer2.util.LocationSetTop;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class PointerTransferRelation
extends SingleEdgeTransferRelation {
    static final TransferRelation INSTANCE = new PointerTransferRelation();

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        PointerState pointerState = (PointerState)pState;
        PointerState resultState = this.getAbstractSuccessor(pointerState, pCfaEdge);
        return resultState == null ? ImmutableSet.of() : Collections.singleton(resultState);
    }

    private PointerState getAbstractSuccessor(PointerState pState, CFAEdge pCfaEdge) throws CPATransferException {
        PointerState resultState = pState;
        switch (pCfaEdge.getEdgeType()) {
            case AssumeEdge: {
                resultState = this.handleAssumeEdge(pState, (AssumeEdge)pCfaEdge);
                break;
            }
            case BlankEdge: {
                break;
            }
            case CallToReturnEdge: {
                break;
            }
            case DeclarationEdge: {
                resultState = this.handleDeclarationEdge(pState, (CDeclarationEdge)pCfaEdge);
                break;
            }
            case FunctionCallEdge: {
                resultState = this.handleFunctionCallEdge(pState, (CFunctionCallEdge)pCfaEdge);
                break;
            }
            case FunctionReturnEdge: {
                resultState = this.handleFunctionReturnEdge(pState, (CFunctionReturnEdge)pCfaEdge);
                break;
            }
            case ReturnStatementEdge: {
                resultState = this.handleReturnStatementEdge(pState, (CReturnStatementEdge)pCfaEdge);
                break;
            }
            case StatementEdge: {
                resultState = this.handleStatementEdge(pState, (CStatementEdge)pCfaEdge);
                break;
            }
            default: {
                throw new UnrecognizedCodeException("Unrecognized CFA edge.", pCfaEdge);
            }
        }
        return resultState;
    }

    private PointerState handleFunctionReturnEdge(PointerState pState, CFunctionReturnEdge pCfaEdge) throws UnrecognizedCodeException {
        CFunctionSummaryEdge summaryEdge = pCfaEdge.getSummaryEdge();
        CFunctionCall callEdge = summaryEdge.getExpression();
        if (callEdge instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement callAssignment = (CFunctionCallAssignmentStatement)callEdge;
            Optional<MemoryLocation> returnVar = this.getFunctionReturnVariable(summaryEdge.getFunctionEntry());
            assert (returnVar.isPresent()) : "Return edge with assignment, but no return variable: " + summaryEdge;
            LocationSet pointedTo = pState.getPointsToSet(returnVar.orElseThrow());
            return this.handleAssignment(pState, (CExpression)callAssignment.getLeftHandSide(), pointedTo);
        }
        return pState;
    }

    private PointerState handleAssumeEdge(PointerState pState, AssumeEdge pAssumeEdge) throws UnrecognizedCodeException {
        Optional<Boolean> areEq;
        ABinaryExpression binOp;
        AExpression expression = pAssumeEdge.getExpression();
        if (expression instanceof ABinaryExpression && (binOp = (ABinaryExpression)expression).getOperator() == CBinaryExpression.BinaryOperator.EQUALS && (areEq = this.areEqual(pState, binOp.getOperand1(), binOp.getOperand2())).isPresent() && areEq.orElseThrow().booleanValue() != pAssumeEdge.getTruthAssumption()) {
            return null;
        }
        return pState;
    }

    private Optional<Boolean> areEqual(PointerState pPointerState, AExpression pOperand1, AExpression pOperand2) throws UnrecognizedCodeException {
        if (pOperand1 instanceof CBinaryExpression) {
            CIntegerLiteralExpression op2;
            CBinaryExpression op1 = (CBinaryExpression)pOperand1;
            if (op1.getOperator() == CBinaryExpression.BinaryOperator.EQUALS && (pOperand2 instanceof CIntegerLiteralExpression ? (op2 = (CIntegerLiteralExpression)pOperand2).getValue().equals(BigInteger.ZERO) : pOperand2 instanceof CCharLiteralExpression && (op2 = (CCharLiteralExpression)pOperand2).getCharacter() == '\u0000')) {
                return this.negate(this.areEqual(pPointerState, op1.getOperand1(), op1.getOperand2()));
            }
            return Optional.empty();
        }
        if (pOperand1 instanceof CExpression && pOperand2 instanceof CExpression) {
            CUnaryExpression op2;
            AbstractExpression op1;
            CExpression operand1 = (CExpression)pOperand1;
            CExpression operand2 = (CExpression)pOperand2;
            LocationSet op1LocationSet = PointerTransferRelation.asLocations(operand1, pPointerState);
            LocationSet op2LocationSet = PointerTransferRelation.asLocations(operand2, pPointerState);
            if (op1LocationSet instanceof ExplicitLocationSet && op2LocationSet instanceof ExplicitLocationSet && op1LocationSet.equals(op2LocationSet)) {
                if (operand1 instanceof CIdExpression && operand2 instanceof CIdExpression) {
                    return Optional.of(true);
                }
                if (operand1 instanceof CFieldReference && operand2 instanceof CFieldReference) {
                    op1 = (CFieldReference)operand1;
                    CFieldReference op22 = (CFieldReference)operand2;
                    if (((CFieldReference)op1).isPointerDereference() == op22.isPointerDereference()) {
                        return this.areEqual(pPointerState, ((CFieldReference)op1).getFieldOwner(), op22.getFieldOwner());
                    }
                }
            }
            if (operand1 instanceof CUnaryExpression && op2LocationSet instanceof ExplicitLocationSet && ((CUnaryExpression)(op1 = (CUnaryExpression)operand1)).getOperator() == CUnaryExpression.UnaryOperator.AMPER) {
                return PointerTransferRelation.pointsTo(pPointerState, (ExplicitLocationSet)op2LocationSet, ((CUnaryExpression)op1).getOperand());
            }
            if (operand2 instanceof CUnaryExpression && op1LocationSet instanceof ExplicitLocationSet && (op2 = (CUnaryExpression)operand2).getOperator() == CUnaryExpression.UnaryOperator.AMPER) {
                return PointerTransferRelation.pointsTo(pPointerState, (ExplicitLocationSet)op1LocationSet, op2.getOperand());
            }
        }
        return Optional.empty();
    }

    private static Optional<Boolean> pointsTo(PointerState pState, ExplicitLocationSet pLocations, CExpression pCandidateTarget) throws UnrecognizedCodeException {
        LocationSet candidateTargets;
        if (pLocations.getSize() == 1 && (candidateTargets = PointerTransferRelation.asLocations(pCandidateTarget, pState)) instanceof ExplicitLocationSet) {
            ExplicitLocationSet explicitCandidateTargets = (ExplicitLocationSet)candidateTargets;
            MemoryLocation location = pLocations.iterator().next();
            LocationSet actualTargets = pState.getPointsToSet(location);
            if (actualTargets.isBot()) {
                return Optional.empty();
            }
            if (actualTargets instanceof ExplicitLocationSet && !explicitCandidateTargets.isBot()) {
                boolean containsAny = false;
                boolean containsAll = true;
                for (MemoryLocation candidateTarget : explicitCandidateTargets) {
                    boolean contains = actualTargets.mayPointTo(candidateTarget);
                    containsAny = containsAny || contains;
                    containsAll = containsAll && contains;
                }
                if (!containsAny) {
                    return Optional.of(false);
                }
                if (containsAll && ((ExplicitLocationSet)actualTargets).getSize() == 1) {
                    if (PointerTransferRelation.isStructOrUnion(pCandidateTarget.getExpressionType())) {
                        return Optional.empty();
                    }
                    return Optional.of(true);
                }
            }
        }
        return Optional.empty();
    }

    private Optional<Boolean> negate(Optional<Boolean> pAreEqual) {
        return pAreEqual.map(b -> b == false);
    }

    private PointerState handleReturnStatementEdge(PointerState pState, CReturnStatementEdge pCfaEdge) throws UnrecognizedCodeException {
        if (!pCfaEdge.getExpression().isPresent()) {
            return pState;
        }
        Optional<MemoryLocation> returnVariable = this.getFunctionReturnVariable(pCfaEdge.getSuccessor().getEntryNode());
        if (!returnVariable.isPresent()) {
            return pState;
        }
        return this.handleAssignment(pState, returnVariable.orElseThrow(), (CRightHandSide)pCfaEdge.getExpression().orElseThrow());
    }

    private Optional<MemoryLocation> getFunctionReturnVariable(FunctionEntryNode pFunctionEntryNode) {
        Optional<? extends AVariableDeclaration> returnVariable = pFunctionEntryNode.getReturnVariable();
        if (!returnVariable.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(MemoryLocation.forDeclaration(returnVariable.get()));
    }

    private PointerState handleFunctionCallEdge(PointerState pState, CFunctionCallEdge pCFunctionCallEdge) throws UnrecognizedCodeException {
        PointerState newState = pState;
        ImmutableList formalParams = pCFunctionCallEdge.getSuccessor().getFunctionParameters();
        ImmutableList actualParams = pCFunctionCallEdge.getArguments();
        int limit = Math.min(formalParams.size(), actualParams.size());
        formalParams = FluentIterable.from(formalParams).limit(limit).toList();
        actualParams = FluentIterable.from(actualParams).limit(limit).toList();
        for (Pair param : Pair.zipList(formalParams, actualParams)) {
            CExpression actualParam = (CExpression)param.getSecond();
            CParameterDeclaration formalParam = (CParameterDeclaration)param.getFirst();
            MemoryLocation location = this.toLocation(formalParam);
            newState = this.handleAssignment(newState, location, PointerTransferRelation.asLocations(actualParam, pState, 1));
        }
        for (CParameterDeclaration formalParam : FluentIterable.from((Iterable)formalParams).skip(limit)) {
            MemoryLocation location = this.toLocation(formalParam);
            newState = this.handleAssignment(newState, location, (LocationSet)LocationSetBot.INSTANCE);
        }
        return newState;
    }

    private MemoryLocation toLocation(AbstractSimpleDeclaration pDeclaration) {
        return this.toLocation(pDeclaration.getType(), pDeclaration.getQualifiedName());
    }

    private MemoryLocation toLocation(CCompositeType pParent, CCompositeType.CCompositeTypeMemberDeclaration pMemberDecl) {
        CType memberType = pMemberDecl.getType().getCanonicalType();
        if (memberType instanceof CCompositeType) {
            return this.toLocation(pMemberDecl.getType(), pMemberDecl.getName());
        }
        return PointerTransferRelation.fieldReferenceToMemoryLocation(pParent, false, pMemberDecl.getName());
    }

    private MemoryLocation toLocation(Type pType, String name) {
        Type type = pType;
        if (type instanceof CType) {
            type = ((CType)type).getCanonicalType();
        }
        if (PointerTransferRelation.isStructOrUnion(type)) {
            return MemoryLocation.parseExtendedQualifiedName(type.toString());
        }
        return MemoryLocation.parseExtendedQualifiedName(name);
    }

    private static boolean isStructOrUnion(Type pType) {
        Type type;
        Type type2 = type = pType instanceof CType ? ((CType)pType).getCanonicalType() : pType;
        if (type instanceof CComplexType) {
            return EnumSet.of(CComplexType.ComplexTypeKind.STRUCT, CComplexType.ComplexTypeKind.UNION).contains((Object)((CComplexType)type).getKind());
        }
        return false;
    }

    private PointerState handleStatementEdge(PointerState pState, CStatementEdge pCfaEdge) throws UnrecognizedCodeException {
        if (pCfaEdge.getStatement() instanceof CAssignment) {
            CAssignment assignment = (CAssignment)pCfaEdge.getStatement();
            if (assignment instanceof CFunctionCallAssignmentStatement) {
                if (this.isNondetPointerReturn(((CFunctionCallAssignmentStatement)assignment).getFunctionCallExpression().getFunctionNameExpression())) {
                    return this.handleAssignment(pState, (CExpression)assignment.getLeftHandSide(), (LocationSet)LocationSetTop.INSTANCE);
                }
                return pState;
            }
            return this.handleAssignment(pState, (CExpression)assignment.getLeftHandSide(), assignment.getRightHandSide());
        }
        return pState;
    }

    private boolean isNondetPointerReturn(CExpression pFunctionNameExpression) {
        if (pFunctionNameExpression instanceof CIdExpression) {
            String functionName = ((CIdExpression)pFunctionNameExpression).getName();
            return functionName.equals("__VERIFIER_nondet_pointer");
        }
        return false;
    }

    private PointerState handleAssignment(PointerState pState, CExpression pLeftHandSide, CRightHandSide pRightHandSide) throws UnrecognizedCodeException {
        return this.handleAssignment(pState, pLeftHandSide, PointerTransferRelation.asLocations(pRightHandSide, pState, 1));
    }

    private PointerState handleAssignment(PointerState pState, CExpression pLeftHandSide, LocationSet pRightHandSide) throws UnrecognizedCodeException {
        LocationSet locationSet = PointerTransferRelation.asLocations(pLeftHandSide, pState);
        Object locations = locationSet.isTop() ? pState.getKnownLocations() : (locationSet instanceof ExplicitLocationSet ? (ExplicitLocationSet)locationSet : ImmutableSet.of());
        PointerState result = pState;
        Iterator iterator = locations.iterator();
        while (iterator.hasNext()) {
            MemoryLocation location = (MemoryLocation)iterator.next();
            result = this.handleAssignment(result, location, pRightHandSide);
        }
        return result;
    }

    private PointerState handleAssignment(PointerState pState, MemoryLocation pLhsLocation, CRightHandSide pRightHandSide) throws UnrecognizedCodeException {
        return this.handleAssignment(pState, pLhsLocation, PointerTransferRelation.asLocations(pRightHandSide, pState, 1));
    }

    private PointerState handleAssignment(PointerState pState, MemoryLocation pLeftHandSide, LocationSet pRightHandSide) {
        return pState.addPointsToInformation(pLeftHandSide, pRightHandSide);
    }

    private PointerState handleDeclarationEdge(PointerState pState, CDeclarationEdge pCfaEdge) throws UnrecognizedCodeException {
        if (!(pCfaEdge.getDeclaration() instanceof CVariableDeclaration)) {
            return pState;
        }
        CVariableDeclaration declaration = (CVariableDeclaration)pCfaEdge.getDeclaration();
        CInitializer initializer = declaration.getInitializer();
        if (initializer != null) {
            MemoryLocation location = this.toLocation(declaration);
            return this.handleWithInitializer(pState, location, declaration.getType(), initializer);
        }
        return pState;
    }

    private PointerState handleWithInitializer(final PointerState pState, MemoryLocation pLeftHandSide, CType pType, CInitializer pInitializer) throws UnrecognizedCodeException {
        CCompositeType compositeType;
        if (pInitializer instanceof CInitializerList && pType.getCanonicalType() instanceof CCompositeType && (compositeType = (CCompositeType)pType.getCanonicalType()).getKind() == CComplexType.ComplexTypeKind.STRUCT) {
            CInitializerList initializerList = (CInitializerList)pInitializer;
            Iterator<CCompositeType.CCompositeTypeMemberDeclaration> memberDecls = compositeType.getMembers().iterator();
            Iterator<CInitializer> initializers = initializerList.getInitializers().iterator();
            PointerState current = pState;
            while (memberDecls.hasNext() && initializers.hasNext()) {
                CCompositeType.CCompositeTypeMemberDeclaration memberDecl = memberDecls.next();
                CInitializer initializer = initializers.next();
                if (initializer == null) continue;
                current = this.handleWithInitializer(current, this.toLocation(compositeType, memberDecl), memberDecl.getType(), initializer);
            }
            return current;
        }
        LocationSet rhs = pInitializer.accept(new CInitializerVisitor<LocationSet, UnrecognizedCodeException>(){

            @Override
            public LocationSet visit(CInitializerExpression pInitializerExpression) throws UnrecognizedCodeException {
                return PointerTransferRelation.asLocations(pInitializerExpression.getExpression(), pState, 1);
            }

            @Override
            public LocationSet visit(CInitializerList pInitializerList) throws UnrecognizedCodeException {
                return LocationSetTop.INSTANCE;
            }

            @Override
            public LocationSet visit(CDesignatedInitializer pCStructInitializerPart) throws UnrecognizedCodeException {
                return LocationSetTop.INSTANCE;
            }
        });
        return this.handleAssignment(pState, pLeftHandSide, rhs);
    }

    private static LocationSet toLocationSet(Iterable<? extends MemoryLocation> pLocations) {
        if (pLocations == null) {
            return LocationSetTop.INSTANCE;
        }
        Iterator<? extends MemoryLocation> locationIterator = pLocations.iterator();
        if (!locationIterator.hasNext()) {
            return LocationSetBot.INSTANCE;
        }
        return ExplicitLocationSet.from(pLocations);
    }

    public static MemoryLocation fieldReferenceToMemoryLocation(CFieldReference pFieldReference) {
        return PointerTransferRelation.fieldReferenceToMemoryLocation(pFieldReference.getFieldOwner().getExpressionType(), pFieldReference.isPointerDereference(), pFieldReference.getFieldName());
    }

    private static MemoryLocation fieldReferenceToMemoryLocation(CType pFieldOwnerType, boolean pIsPointerDeref, String pFieldName) {
        String prefix;
        CType type = pFieldOwnerType.getCanonicalType();
        if (pIsPointerDeref) {
            if (!(type instanceof CPointerType)) {
                throw new AssertionError();
            }
            CType innerType = ((CPointerType)type).getType().getCanonicalType();
            if (innerType instanceof CPointerType) {
                throw new AssertionError();
            }
            prefix = innerType.toString();
        } else {
            prefix = type.toString();
        }
        String infix = ".";
        String suffix = pFieldName;
        return MemoryLocation.parseExtendedQualifiedName(prefix + infix + suffix);
    }

    private static LocationSet asLocations(CRightHandSide pExpression, final PointerState pState, final int pDerefCounter) throws UnrecognizedCodeException {
        return pExpression.accept(new CRightHandSideVisitor<LocationSet, UnrecognizedCodeException>(){

            @Override
            public LocationSet visit(CArraySubscriptExpression pIastArraySubscriptExpression) throws UnrecognizedCodeException {
                CLiteralExpression literal;
                if (pIastArraySubscriptExpression.getSubscriptExpression() instanceof CLiteralExpression && (literal = (CLiteralExpression)pIastArraySubscriptExpression.getSubscriptExpression()) instanceof CIntegerLiteralExpression && ((CIntegerLiteralExpression)literal).getValue().equals(BigInteger.ZERO)) {
                    LocationSet starredLocations = PointerTransferRelation.asLocations(pIastArraySubscriptExpression.getArrayExpression(), pState, pDerefCounter);
                    if (starredLocations.isBot() || starredLocations.isTop()) {
                        return starredLocations;
                    }
                    if (!(starredLocations instanceof ExplicitLocationSet)) {
                        return LocationSetTop.INSTANCE;
                    }
                    HashSet<MemoryLocation> result = new HashSet<MemoryLocation>();
                    for (MemoryLocation location : (ExplicitLocationSet)starredLocations) {
                        LocationSet pointsToSet = pState.getPointsToSet(location);
                        if (pointsToSet.isTop()) {
                            result.addAll(pState.getKnownLocations());
                            break;
                        }
                        if (pointsToSet.isBot() || !(pointsToSet instanceof ExplicitLocationSet)) continue;
                        ExplicitLocationSet explicitLocationSet = (ExplicitLocationSet)pointsToSet;
                        Iterables.addAll(result, (Iterable)explicitLocationSet);
                    }
                    return PointerTransferRelation.toLocationSet(result);
                }
                return LocationSetTop.INSTANCE;
            }

            @Override
            public LocationSet visit(CFieldReference pIastFieldReference) throws UnrecognizedCodeException {
                MemoryLocation memoryLocation = PointerTransferRelation.fieldReferenceToMemoryLocation(pIastFieldReference);
                return PointerTransferRelation.toLocationSet(Collections.singleton(memoryLocation));
            }

            @Override
            public LocationSet visit(CIdExpression pIastIdExpression) throws UnrecognizedCodeException {
                CSimpleDeclaration declaration;
                CType type = pIastIdExpression.getExpressionType();
                MemoryLocation location = PointerTransferRelation.isStructOrUnion(type) ? MemoryLocation.parseExtendedQualifiedName(((Object)type).toString()) : ((declaration = pIastIdExpression.getDeclaration()) != null ? MemoryLocation.forDeclaration(declaration) : MemoryLocation.forIdentifier(pIastIdExpression.getName()));
                return this.visit(location);
            }

            private LocationSet visit(MemoryLocation pLocation) {
                Set<MemoryLocation> result = Collections.singleton(pLocation);
                for (int deref = pDerefCounter; deref > 0 && !result.isEmpty(); --deref) {
                    HashSet<MemoryLocation> newResult = new HashSet<MemoryLocation>();
                    for (MemoryLocation location : result) {
                        LocationSet targets = pState.getPointsToSet(location);
                        if (targets.isTop() || targets.isBot()) {
                            return targets;
                        }
                        if (!(targets instanceof ExplicitLocationSet)) {
                            return LocationSetTop.INSTANCE;
                        }
                        Iterables.addAll(newResult, (Iterable)((ExplicitLocationSet)targets));
                    }
                    result = newResult;
                }
                return PointerTransferRelation.toLocationSet(result);
            }

            @Override
            public LocationSet visit(CPointerExpression pPointerExpression) throws UnrecognizedCodeException {
                return PointerTransferRelation.asLocations(pPointerExpression.getOperand(), pState, pDerefCounter + 1);
            }

            @Override
            public LocationSet visit(CComplexCastExpression pComplexCastExpression) throws UnrecognizedCodeException {
                return PointerTransferRelation.asLocations(pComplexCastExpression.getOperand(), pState, pDerefCounter);
            }

            @Override
            public LocationSet visit(CBinaryExpression pIastBinaryExpression) throws UnrecognizedCodeException {
                return PointerTransferRelation.toLocationSet(Iterables.concat(PointerTransferRelation.toNormalSet(pState, PointerTransferRelation.asLocations(pIastBinaryExpression.getOperand1(), pState, pDerefCounter)), PointerTransferRelation.toNormalSet(pState, PointerTransferRelation.asLocations(pIastBinaryExpression.getOperand2(), pState, pDerefCounter))));
            }

            @Override
            public LocationSet visit(CCastExpression pIastCastExpression) throws UnrecognizedCodeException {
                return PointerTransferRelation.asLocations(pIastCastExpression.getOperand(), pState, pDerefCounter);
            }

            @Override
            public LocationSet visit(CCharLiteralExpression pIastCharLiteralExpression) {
                return LocationSetBot.INSTANCE;
            }

            @Override
            public LocationSet visit(CFloatLiteralExpression pIastFloatLiteralExpression) {
                return LocationSetBot.INSTANCE;
            }

            @Override
            public LocationSet visit(CIntegerLiteralExpression pIastIntegerLiteralExpression) {
                return LocationSetBot.INSTANCE;
            }

            @Override
            public LocationSet visit(CStringLiteralExpression pIastStringLiteralExpression) {
                return LocationSetBot.INSTANCE;
            }

            @Override
            public LocationSet visit(CTypeIdExpression pIastTypeIdExpression) {
                return LocationSetBot.INSTANCE;
            }

            @Override
            public LocationSet visit(CUnaryExpression pIastUnaryExpression) throws UnrecognizedCodeException {
                if (pDerefCounter > 0 && pIastUnaryExpression.getOperator() == CUnaryExpression.UnaryOperator.AMPER) {
                    return PointerTransferRelation.asLocations(pIastUnaryExpression.getOperand(), pState, pDerefCounter - 1);
                }
                return LocationSetBot.INSTANCE;
            }

            @Override
            public LocationSet visit(CImaginaryLiteralExpression PIastLiteralExpression) {
                return LocationSetBot.INSTANCE;
            }

            @Override
            public LocationSet visit(CFunctionCallExpression pIastFunctionCallExpression) throws UnrecognizedCodeException {
                CFunctionDeclaration declaration = pIastFunctionCallExpression.getDeclaration();
                if (declaration == null) {
                    LocationSet result = pIastFunctionCallExpression.getFunctionNameExpression().accept(this);
                    if (result.isTop() || result.isBot()) {
                        return result;
                    }
                    return PointerTransferRelation.toLocationSet((Iterable<? extends MemoryLocation>)FluentIterable.from(PointerTransferRelation.toNormalSet(pState, result)).filter(Predicates.notNull()));
                }
                return this.visit(MemoryLocation.forDeclaration(declaration));
            }

            @Override
            public LocationSet visit(CAddressOfLabelExpression pAddressOfLabelExpression) throws UnrecognizedCodeException {
                throw new UnrecognizedCodeException("Address of labels not supported by pointer analysis", pAddressOfLabelExpression);
            }
        });
    }

    public static LocationSet asLocations(CExpression pExpression, PointerState pState) throws UnrecognizedCodeException {
        return PointerTransferRelation.asLocations(pExpression, pState, 0);
    }

    public static Iterable<MemoryLocation> toNormalSet(PointerState pState, LocationSet pLocationSet) {
        if (pLocationSet.isBot()) {
            return ImmutableSet.of();
        }
        if (pLocationSet.isTop() || !(pLocationSet instanceof ExplicitLocationSet)) {
            return pState.getKnownLocations();
        }
        return (ExplicitLocationSet)pLocationSet;
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pState, Iterable<AbstractState> pOtherStates, @Nullable CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException, InterruptedException {
        CExpression derefNameExpr;
        AFunctionCallExpression functionCallExpression;
        AExpression functionNameExpression;
        Optional<AFunctionCall> functionCall;
        if (pCfaEdge != null && (functionCall = PointerTransferRelation.asFunctionCall(pCfaEdge)).isPresent() && (functionNameExpression = (functionCallExpression = functionCall.orElseThrow().getFunctionCallExpression()).getFunctionNameExpression()) instanceof CPointerExpression && (derefNameExpr = ((CPointerExpression)functionNameExpression).getOperand()) instanceof CFieldReference) {
            CFieldReference fieldReference = (CFieldReference)derefNameExpr;
            Optional<CallstackState> callstackState = PointerTransferRelation.find(pOtherStates, CallstackState.class);
            if (callstackState.isPresent()) {
                return PointerTransferRelation.strengthenFieldReference((PointerState)pState, callstackState.orElseThrow(), fieldReference);
            }
        }
        return super.strengthen(pState, pOtherStates, pCfaEdge, pPrecision);
    }

    private static Optional<AFunctionCall> asFunctionCall(CFAEdge pEdge) {
        if (pEdge instanceof AStatementEdge) {
            AStatementEdge statementEdge = (AStatementEdge)pEdge;
            if (statementEdge.getStatement() instanceof AFunctionCall) {
                return Optional.of((AFunctionCall)statementEdge.getStatement());
            }
        } else {
            if (pEdge instanceof FunctionCallEdge) {
                FunctionCallEdge functionCallEdge = (FunctionCallEdge)pEdge;
                return Optional.of(functionCallEdge.getSummaryEdge().getExpression());
            }
            if (pEdge instanceof FunctionSummaryEdge) {
                FunctionSummaryEdge functionSummaryEdge = (FunctionSummaryEdge)pEdge;
                return Optional.of(functionSummaryEdge.getExpression());
            }
        }
        return Optional.empty();
    }

    private static Collection<? extends AbstractState> strengthenFieldReference(PointerState pPointerState, CallstackState pCallstackState, CFieldReference pFieldReference) {
        MemoryLocation memoryLocation = PointerTransferRelation.fieldReferenceToMemoryLocation(pFieldReference);
        LocationSet targets = pPointerState.getPointsToSet(memoryLocation);
        if (targets instanceof ExplicitLocationSet) {
            ExplicitLocationSet explicitTargets = (ExplicitLocationSet)targets;
            for (MemoryLocation target : explicitTargets) {
                if (!target.getIdentifier().equals(pCallstackState.getCurrentFunction())) continue;
                return Collections.singleton(pPointerState);
            }
            return ImmutableSet.of();
        }
        return Collections.singleton(pPointerState);
    }

    private static <T> Optional<T> find(Iterable<? super T> pIterable, Class<T> pClass) {
        return FluentIterable.from(pIterable).filter(pClass).first().toJavaUtil();
    }
}

