/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.policyiteration;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyIterationStatistics;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.Tactic;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaTransformationVisitor;
import org.sosy_lab.java_smt.api.visitors.DefaultFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;

public class FormulaLinearizationManager {
    private final BooleanFormulaManager bfmgr;
    private final FormulaManagerView fmgr;
    private final PolicyIterationStatistics statistics;
    private static final String CHOICE_VAR_NAME = "__POLICY_CHOICE_";
    private final UniqueIdGenerator choiceVarCounter = new UniqueIdGenerator();

    public FormulaLinearizationManager(FormulaManagerView pFmgr, PolicyIterationStatistics pStatistics) {
        this.bfmgr = pFmgr.getBooleanFormulaManager();
        this.fmgr = pFmgr;
        this.statistics = pStatistics;
    }

    public BooleanFormula linearize(BooleanFormula input) {
        return this.bfmgr.transformRecursively(input, (BooleanFormulaTransformationVisitor)new BooleanFormulaManagerView.BooleanFormulaTransformationVisitor(this.fmgr){

            public BooleanFormula visitNot(BooleanFormula pOperand) {
                List<BooleanFormula> split = FormulaLinearizationManager.this.fmgr.splitNumeralEqualityIfPossible(pOperand);
                if (split.size() == 2) {
                    return FormulaLinearizationManager.this.bfmgr.or(FormulaLinearizationManager.this.bfmgr.not(split.get(0)), FormulaLinearizationManager.this.bfmgr.not(split.get(1)));
                }
                return super.visitNot(pOperand);
            }
        });
    }

    public BooleanFormula annotateDisjunctions(BooleanFormula input) throws InterruptedException {
        input = this.fmgr.applyTactic(input, Tactic.NNF);
        return this.bfmgr.transformRecursively(input, (BooleanFormulaTransformationVisitor)new BooleanFormulaManagerView.BooleanFormulaTransformationVisitor(this.fmgr){

            public BooleanFormula visitOr(List<BooleanFormula> processedOperands) {
                return FormulaLinearizationManager.this.annotateDisjunction(processedOperands);
            }
        });
    }

    private BooleanFormula annotateDisjunction(List<BooleanFormula> args) {
        assert (!args.isEmpty());
        if (args.size() == 1) {
            return args.get(0);
        }
        BooleanFormula choiceVar = this.bfmgr.makeVariable(this.getFreshVarName());
        int pivot = args.size() / 2;
        return this.bfmgr.or(this.bfmgr.and(choiceVar, this.annotateDisjunction(args.subList(0, pivot))), this.bfmgr.and(this.bfmgr.not(choiceVar), this.annotateDisjunction(args.subList(pivot, args.size()))));
    }

    private String getFreshVarName() {
        return CHOICE_VAR_NAME + this.choiceVarCounter.getFreshId();
    }

    public BooleanFormula enforceChoice(BooleanFormula input, Model model) throws InterruptedException {
        HashMap<BooleanFormula, BooleanFormula> mapping = new HashMap<BooleanFormula, BooleanFormula>();
        for (Model.ValueAssignment entry : model) {
            String termName = entry.getName();
            if (!termName.contains(CHOICE_VAR_NAME)) continue;
            mapping.put(this.bfmgr.makeVariable(termName), this.bfmgr.makeBoolean(((Boolean)entry.getValue()).booleanValue()));
        }
        BooleanFormula pathSelected = this.fmgr.substitute(input, mapping);
        pathSelected = this.fmgr.simplify(pathSelected);
        return pathSelected;
    }

    public BooleanFormula convertToPolicy(BooleanFormula f, Model pModel) throws InterruptedException {
        this.statistics.ackermannizationTimer.start();
        f = this.fmgr.applyTactic(f, Tactic.NNF);
        BooleanFormula out = this.processUFs(f, pModel);
        this.statistics.ackermannizationTimer.stop();
        return out;
    }

    private BooleanFormula processUFs(BooleanFormula f, Model model) {
        Multimap<String, Pair<Formula, List<Formula>>> UFs = this.findUFs((Formula)f);
        HashMap<Formula, Formula> substitution = new HashMap<Formula, Formula>();
        ArrayList<BooleanFormula> extraConstraints = new ArrayList<BooleanFormula>();
        for (String funcName : UFs.keySet()) {
            ArrayList ufList = new ArrayList(UFs.get((Object)funcName));
            for (int idx1 = 0; idx1 < ufList.size(); ++idx1) {
                Pair p = (Pair)ufList.get(idx1);
                Formula uf = (Formula)p.getFirst();
                List args = (List)p.getSecondNotNull();
                Formula freshVar = this.fmgr.makeVariable(this.fmgr.getFormulaType(uf), this.freshUFName(idx1));
                substitution.put(uf, freshVar);
                for (int idx2 = idx1 + 1; idx2 < ufList.size(); ++idx2) {
                    Pair p2 = (Pair)ufList.get(idx2);
                    List otherArgs = (List)p2.getSecondNotNull();
                    Formula otherUF = (Formula)p2.getFirst();
                    Preconditions.checkState((args.size() == otherArgs.size() ? 1 : 0) != 0);
                    boolean argsEqual = true;
                    for (int i = 0; i < args.size(); ++i) {
                        Object evalA = model.evaluate((Formula)args.get(i));
                        Object evalB = model.evaluate((Formula)otherArgs.get(i));
                        if (evalA == null || evalB == null || evalA.equals(evalB)) continue;
                        argsEqual = false;
                    }
                    if (!argsEqual) continue;
                    Formula otherFreshVar = this.fmgr.makeVariable(this.fmgr.getFormulaType(otherUF), this.freshUFName(idx2));
                    extraConstraints.add(this.fmgr.makeEqual(freshVar, otherFreshVar));
                }
            }
        }
        BooleanFormula formulaNoUFs = this.fmgr.substitute(f, substitution);
        return this.bfmgr.and(formulaNoUFs, this.bfmgr.and(extraConstraints));
    }

    private Multimap<String, Pair<Formula, List<Formula>>> findUFs(Formula f) {
        HashMultimap UFs = HashMultimap.create();
        this.fmgr.visitRecursively(f, (FormulaVisitor<TraversalProcess>)new DefaultFormulaVisitor<TraversalProcess>((Multimap)UFs){
            final /* synthetic */ Multimap val$UFs;
            {
                this.val$UFs = multimap;
            }

            protected TraversalProcess visitDefault(Formula pFormula) {
                return TraversalProcess.CONTINUE;
            }

            public TraversalProcess visitFunction(Formula pFormula, List<Formula> args, FunctionDeclaration<?> decl) {
                if (decl.getKind() == FunctionDeclarationKind.UF) {
                    this.val$UFs.put((Object)decl.getName(), Pair.of(pFormula, args));
                }
                return TraversalProcess.CONTINUE;
            }
        });
        return UFs;
    }

    private String freshUFName(int idx) {
        return "__UF_fresh_" + idx;
    }
}

