/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.policyiteration;

import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.FormulaReportingState;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyBound;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyIntermediateState;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyState;
import org.sosy_lab.cpachecker.cpa.policyiteration.StateFormulaConversionManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.templates.Template;
import org.sosy_lab.java_smt.api.BooleanFormula;

public final class PolicyAbstractedState
extends PolicyState
implements Iterable<Map.Entry<Template, PolicyBound>>,
FormulaReportingState {
    private final StateFormulaConversionManager manager;
    private final ImmutableMap<Template, PolicyBound> upperBounds;
    private final SSAMap ssaMap;
    private final PointerTargetSet pointerTargetSet;
    private final BooleanFormula extraInvariant;
    private final @Nullable PolicyIntermediateState generator;
    private final int locationID;
    private final transient @Nullable PolicyAbstractedState sibling;
    private transient int hashCache = 0;
    private static final UniqueIdGenerator idGenerator = new UniqueIdGenerator();
    private final int stateId;

    private PolicyAbstractedState(CFANode node, Map<Template, PolicyBound> pUpperBounds, int pLocationID, StateFormulaConversionManager pManager, SSAMap pSsaMap, PointerTargetSet pPointerTargetSet, BooleanFormula pPredicate, PolicyIntermediateState pGenerator, PolicyAbstractedState pSibling) {
        super(node);
        this.ssaMap = pSsaMap;
        this.pointerTargetSet = pPointerTargetSet;
        this.extraInvariant = pPredicate;
        this.generator = pGenerator;
        this.upperBounds = ImmutableMap.copyOf(pUpperBounds);
        this.locationID = pLocationID;
        this.manager = pManager;
        this.sibling = pSibling;
        this.stateId = idGenerator.getFreshId();
    }

    int getStateId() {
        return this.stateId;
    }

    public Optional<PolicyAbstractedState> getSibling() {
        return Optional.ofNullable(this.sibling);
    }

    int getLocationID() {
        return this.locationID;
    }

    public static PolicyAbstractedState of(Map<Template, PolicyBound> data, CFANode node, int pLocationID, StateFormulaConversionManager pManager, SSAMap pSSAMap, PointerTargetSet pPointerTargetSet, BooleanFormula pPredicate, Optional<PolicyIntermediateState> pPredecessor, Optional<PolicyAbstractedState> pSibling) {
        return new PolicyAbstractedState(node, data, pLocationID, pManager, pSSAMap, pPointerTargetSet, pPredicate, pPredecessor.orElse(null), pSibling.orElse(null));
    }

    PolicyAbstractedState withNewAbstraction(Map<Template, PolicyBound> newAbstraction) {
        return new PolicyAbstractedState(this.getNode(), newAbstraction, this.locationID, this.manager, this.ssaMap, this.pointerTargetSet, this.extraInvariant, this.generator, this.sibling);
    }

    public ImmutableMap<Template, PolicyBound> getAbstraction() {
        return this.upperBounds;
    }

    BooleanFormula getExtraInvariant() {
        return this.extraInvariant;
    }

    public SSAMap getSSA() {
        return this.ssaMap;
    }

    public PointerTargetSet getPointerTargetSet() {
        return this.pointerTargetSet;
    }

    Optional<PolicyBound> getBound(Template e) {
        return Optional.ofNullable((PolicyBound)this.upperBounds.get((Object)e));
    }

    public static PolicyAbstractedState top(CFANode node, int pLocationID, StateFormulaConversionManager pManager, SSAMap pSSAMap, PointerTargetSet pPointerTargetSet, BooleanFormula pPredicate, PolicyIntermediateState pPredecessor, Optional<PolicyAbstractedState> pSibling) {
        return new PolicyAbstractedState(node, (Map<Template, PolicyBound>)ImmutableMap.of(), pLocationID, pManager, pSSAMap, pPointerTargetSet, pPredicate, pPredecessor, pSibling.orElse(null));
    }

    public static PolicyAbstractedState empty(CFANode node, BooleanFormula pPredicate, StateFormulaConversionManager pManager) {
        return new PolicyAbstractedState(node, (Map<Template, PolicyBound>)ImmutableMap.of(), -1, pManager, SSAMap.emptySSAMap(), PointerTargetSet.emptyPointerTargetSet(), pPredicate, null, null);
    }

    public int size() {
        return this.upperBounds.size();
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public String toDOTLabel() {
        return String.format("(node=%s, locID=%s)%s%n", this.getNode(), this.locationID, this.manager.toDOTLabel((Map<Template, PolicyBound>)this.upperBounds));
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }

    @Override
    public String toString() {
        return String.format("(loc=%s, node=%s)%s", this.locationID, this.getNode(), this.upperBounds);
    }

    @Override
    public Iterator<Map.Entry<Template, PolicyBound>> iterator() {
        return this.upperBounds.entrySet().iterator();
    }

    Optional<PolicyIntermediateState> getGeneratingState() {
        return Optional.ofNullable(this.generator);
    }

    @Override
    public BooleanFormula getFormulaApproximation(FormulaManagerView fmgr) {
        return fmgr.uninstantiate(fmgr.getBooleanFormulaManager().and(this.manager.abstractStateToConstraints(fmgr, this, false)));
    }

    @Override
    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (!(pO instanceof PolicyAbstractedState)) {
            return false;
        }
        PolicyAbstractedState entries = (PolicyAbstractedState)pO;
        return Objects.equals(this.upperBounds, entries.upperBounds) && Objects.equals(this.ssaMap, entries.ssaMap) && Objects.equals(this.pointerTargetSet, entries.pointerTargetSet) && Objects.equals(this.extraInvariant, entries.extraInvariant) && Objects.equals(this.getNode(), entries.getNode());
    }

    @Override
    public int hashCode() {
        if (this.hashCache == 0) {
            this.hashCache = Objects.hash(this.getNode(), this.upperBounds, this.ssaMap, this.pointerTargetSet, this.extraInvariant);
        }
        return this.hashCache;
    }
}

