/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.policyiteration;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyAbstractedState;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.templates.Template;
import org.sosy_lab.java_smt.api.BooleanFormula;

public final class PolicyBound {
    private final PolicyAbstractedState predecessor;
    private final PathFormula formula;
    private final Rational bound;
    private final ImmutableSet<Template> dependencies;
    private final boolean computedByValueDetermination;
    private int hashCache = 0;
    private static final Map<Triple<PolicyAbstractedState, BooleanFormula, PolicyAbstractedState>, Integer> serializationMap = new HashMap<Triple<PolicyAbstractedState, BooleanFormula, PolicyAbstractedState>, Integer>();
    private static final UniqueIdGenerator pathCounter = new UniqueIdGenerator();

    private PolicyBound(PathFormula pFormula, Rational pBound, PolicyAbstractedState pPredecessor, Collection<Template> pDependencies, boolean pComputedByValueDetermination) {
        this.formula = pFormula;
        this.bound = pBound;
        this.predecessor = pPredecessor;
        this.dependencies = ImmutableSet.copyOf(pDependencies);
        this.computedByValueDetermination = pComputedByValueDetermination;
    }

    boolean isComputedByValueDetermination() {
        return this.computedByValueDetermination;
    }

    public static PolicyBound of(PathFormula pFormula, Rational bound, PolicyAbstractedState pUpdatedFrom, Collection<Template> pDependencies) {
        return new PolicyBound(pFormula, bound, pUpdatedFrom, pDependencies, false);
    }

    PolicyBound updateValueFromValueDetermination(Rational newValue) {
        return new PolicyBound(this.formula, newValue, this.predecessor, (Collection<Template>)this.dependencies, true);
    }

    PolicyBound withNoDependencies() {
        return new PolicyBound(this.formula, this.bound, this.predecessor, (Collection<Template>)ImmutableSet.of(), false);
    }

    int serializePolicy(PolicyAbstractedState toState) {
        Triple<PolicyAbstractedState, BooleanFormula, PolicyAbstractedState> p = Triple.of(this.predecessor, this.formula.getFormula(), toState);
        Integer serialization = serializationMap.get(p);
        if (serialization == null) {
            serialization = pathCounter.getFreshId();
            serializationMap.put(p, serialization);
        }
        return serialization;
    }

    public PolicyAbstractedState getPredecessor() {
        return this.predecessor;
    }

    public PathFormula getFormula() {
        return this.formula;
    }

    public Rational getBound() {
        return this.bound;
    }

    public ImmutableSet<Template> getDependencies() {
        return this.dependencies;
    }

    public int hashCode() {
        if (this.hashCache == 0) {
            this.hashCache = Objects.hash(this.predecessor, this.bound, this.formula);
        }
        return this.hashCache;
    }

    public String toString() {
        return String.format("%s (<- %s)", this.bound.toString(), this.predecessor.getNode());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        PolicyBound o = (PolicyBound)other;
        return this.predecessor.equals(o.predecessor) && this.bound.equals((Object)o.bound) && this.formula.equals(o.formula);
    }
}

