/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.policyiteration;

import com.google.common.base.Function;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithBAM;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AdjustableConditionCPA;
import org.sosy_lab.cpachecker.core.interfaces.conditions.ReachedSetAdjustingCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.policyiteration.FormulaLinearizationManager;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyIterationManager;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyIterationStatistics;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyReducer;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyState;
import org.sosy_lab.cpachecker.cpa.policyiteration.StateFormulaConversionManager;
import org.sosy_lab.cpachecker.cpa.policyiteration.ValueDeterminationManager;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.predicates.pathformula.CachingPathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.templates.TemplatePrecision;
import org.sosy_lab.cpachecker.util.templates.TemplateToFormulaConversionManager;

@Options(prefix="cpa.lpi")
public class PolicyCPA
extends SingleEdgeTransferRelation
implements ConfigurableProgramAnalysisWithBAM,
AdjustableConditionCPA,
ReachedSetAdjustingCPA,
StatisticsProvider,
AbstractDomain,
PrecisionAdjustment,
MergeOperator,
AutoCloseable {
    @Option(secure=true, description="Cache formulas produced by path formula manager")
    private boolean useCachingPathFormulaManager = true;
    private final Configuration config;
    private final PolicyIterationManager policyIterationManager;
    private final LogManager logger;
    private final PolicyIterationStatistics statistics;
    private final StopOperator stopOperator;
    private final Solver solver;
    private final FormulaManagerView fmgr;
    private final PathFormulaManager pfmgr;
    private final StateFormulaConversionManager stateFormulaConversionManager;
    private final TemplatePrecision templatePrecision;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(PolicyCPA.class);
    }

    private PolicyCPA(Configuration pConfig, LogManager pLogger, ShutdownNotifier shutdownNotifier, CFA cfa) throws InvalidConfigurationException, CPAException {
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.config = pConfig;
        this.solver = Solver.create(this.config, pLogger, shutdownNotifier);
        this.fmgr = this.solver.getFormulaManager();
        PathFormulaManager pathFormulaManager = new PathFormulaManagerImpl(this.fmgr, pConfig, pLogger, shutdownNotifier, cfa, AnalysisDirection.FORWARD);
        if (this.useCachingPathFormulaManager) {
            pathFormulaManager = new CachingPathFormulaManager(pathFormulaManager);
        }
        this.pfmgr = pathFormulaManager;
        this.statistics = new PolicyIterationStatistics(cfa);
        TemplateToFormulaConversionManager pTemplateToFormulaConversionManager = new TemplateToFormulaConversionManager(cfa, pLogger);
        this.stateFormulaConversionManager = new StateFormulaConversionManager(this.fmgr, pTemplateToFormulaConversionManager, pConfig, cfa, this.logger, shutdownNotifier, this.pfmgr, this.solver);
        ValueDeterminationManager valueDeterminationFormulaManager = new ValueDeterminationManager(this.config, this.fmgr, pLogger, this.pfmgr, this.stateFormulaConversionManager, pTemplateToFormulaConversionManager);
        FormulaLinearizationManager formulaLinearizationManager = new FormulaLinearizationManager(this.fmgr, this.statistics);
        this.templatePrecision = new TemplatePrecision(this.logger, this.config, cfa, pTemplateToFormulaConversionManager);
        this.policyIterationManager = new PolicyIterationManager(pConfig, this.fmgr, cfa, this.pfmgr, this.solver, pLogger, shutdownNotifier, valueDeterminationFormulaManager, this.statistics, formulaLinearizationManager, this.stateFormulaConversionManager, pTemplateToFormulaConversionManager, this.templatePrecision);
        this.stopOperator = new StopSepOperator(this);
    }

    @Override
    public AbstractState getInitialState(CFANode node, StateSpacePartition pPartition) {
        return this.policyIterationManager.getInitialState(node);
    }

    @Override
    public AbstractState join(AbstractState state1, AbstractState state2) throws CPAException, InterruptedException {
        throw new UnsupportedOperationException("PolicyCPA should be used with its own merge operator");
    }

    @Override
    public boolean isLessOrEqual(AbstractState state1, AbstractState state2) throws CPAException, InterruptedException {
        return this.policyIterationManager.isLessOrEqual((PolicyState)state1, (PolicyState)state2);
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pEdge) throws CPATransferException, InterruptedException {
        return this.policyIterationManager.getAbstractSuccessors((PolicyState)pState, pEdge);
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this;
    }

    @Override
    public Precision getInitialPrecision(CFANode node, StateSpacePartition pPartition) {
        return this.policyIterationManager.getInitialPrecision();
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        statsCollection.add(this.statistics);
    }

    @Override
    public Optional<PrecisionAdjustmentResult> prec(AbstractState state, Precision precision, UnmodifiableReachedSet states, Function<AbstractState, AbstractState> projection, AbstractState fullState) throws CPAException, InterruptedException {
        return this.policyIterationManager.precisionAdjustment((PolicyState)state, (TemplatePrecision)precision, states, fullState);
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState state, Iterable<AbstractState> otherStates, CFAEdge cfaEdge, Precision precision) throws CPATransferException, InterruptedException {
        return this.policyIterationManager.strengthen(((PolicyState)state).asIntermediate(), otherStates);
    }

    public Optional<AbstractState> strengthen(AbstractState pState, Precision pPrecision, Iterable<AbstractState> otherStates) throws CPAException, InterruptedException {
        return this.policyIterationManager.strengthen((PolicyState)pState, (TemplatePrecision)pPrecision, otherStates);
    }

    @Override
    public boolean adjustPrecision() {
        return this.templatePrecision.adjustPrecision();
    }

    boolean injectPrecisionFromInterpolant(CFANode pNode, Set<String> vars) {
        return this.templatePrecision.injectPrecisionFromInterpolant(pNode, vars);
    }

    @Override
    public void adjustReachedSet(ReachedSet pReachedSet) {
        pReachedSet.clear();
    }

    LogManager getLogger() {
        return this.logger;
    }

    Configuration getConfig() {
        return this.config;
    }

    Solver getSolver() {
        return this.solver;
    }

    @Override
    public AbstractState merge(AbstractState state1, AbstractState state2, Precision precision) throws CPAException, InterruptedException {
        return this.policyIterationManager.merge((PolicyState)state1, (PolicyState)state2);
    }

    @Override
    public Reducer getReducer() {
        return new PolicyReducer(this.policyIterationManager, this.fmgr, this.stateFormulaConversionManager, this.pfmgr);
    }

    @Override
    public void setPartitioning(BlockPartitioning pPartitioning) {
        this.policyIterationManager.setPartitioning(pPartitioning);
    }

    @Override
    public void close() {
        this.solver.close();
    }
}

