/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.policyiteration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyAbstractedState;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyCPA;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyIntermediateState;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.refinement.PathExtractor;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.api.Tactic;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaTransformationVisitor;

@Options(prefix="cpa.lpi.refinement")
public class PolicyInterpolationRefiner
implements Refiner {
    @Option(secure=true, description="Attempt to weaken interpolants in order to make them more general")
    private boolean generalizeInterpolants = true;
    private final PathExtractor pathExtractor;
    private final ARGCPA argCpa;
    private final Solver solver;
    private final PolicyCPA policyCPA;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManager bfmgr;
    private final Map<BooleanFormula, Set<String>> extractedVarsCache;

    public static PolicyInterpolationRefiner create(ConfigurableProgramAnalysis pConfigurableProgramAnalysis) throws InvalidConfigurationException {
        PolicyCPA policyCPA = CPAs.retrieveCPAOrFail(pConfigurableProgramAnalysis, PolicyCPA.class, PolicyInterpolationRefiner.class);
        ARGCPA argCPA = CPAs.retrieveCPAOrFail(pConfigurableProgramAnalysis, ARGCPA.class, PolicyInterpolationRefiner.class);
        Configuration config = policyCPA.getConfig();
        LogManager logger = policyCPA.getLogger();
        Solver solver = policyCPA.getSolver();
        PathExtractor pathExtractor = new PathExtractor(logger, config);
        return new PolicyInterpolationRefiner(config, policyCPA, pathExtractor, argCPA, solver);
    }

    private PolicyInterpolationRefiner(Configuration config, PolicyCPA pPolicyCPA, PathExtractor pPathExtractor, ARGCPA pArgCpa, Solver pSolver) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.fmgr = pSolver.getFormulaManager();
        this.solver = pSolver;
        this.policyCPA = pPolicyCPA;
        this.pathExtractor = pPathExtractor;
        this.argCpa = pArgCpa;
        this.extractedVarsCache = new HashMap<BooleanFormula, Set<String>>();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
    }

    @Override
    public boolean performRefinement(ReachedSet pReached) throws CPAException, InterruptedException {
        ARGReachedSet argReached = new ARGReachedSet(pReached, this.argCpa);
        Collection<ARGState> targets = this.pathExtractor.getTargetStates(argReached);
        for (ARGState target : targets) {
            try {
                if (!this.handleTarget(target)) continue;
                this.forceRestart(pReached);
                return true;
            }
            catch (SolverException pE) {
                throw new CPAException("Got solver exception during interpolation", pE);
            }
        }
        this.forceRestart(pReached);
        return false;
    }

    private boolean handleTarget(ARGState target) throws SolverException, InterruptedException {
        PolicyState policyState = AbstractStates.extractStateByType(target, PolicyState.class);
        assert (policyState != null);
        Preconditions.checkState((!policyState.isAbstract() ? 1 : 0) != 0, (Object)"Property violation should be associated with an intermediate state.");
        try (InterpolatingProverEnvironment<?> itp = this.solver.newProverEnvironmentWithInterpolation(new SolverContext.ProverOptions[0]);){
            boolean bl = this.injectPrecision(itp, policyState.asIntermediate());
            return bl;
        }
    }

    private <T> boolean injectPrecision(InterpolatingProverEnvironment<T> itp, PolicyIntermediateState iState) throws SolverException, InterruptedException {
        Optional<List<BooleanFormula>> weakerInterpolants;
        ArrayList<ImmutableSet> handles = new ArrayList<ImmutableSet>();
        int pushed = 0;
        for (PolicyIntermediateState predecessor : iState.allStatesToRoot()) {
            Object handle = itp.push(predecessor.getPathFormula().getFormula());
            assert (handle != null);
            handles.add(ImmutableSet.of((Object)handle));
            ++pushed;
        }
        Preconditions.checkState((boolean)itp.isUnsat());
        List interpolants = itp.getSeqInterpolants(handles);
        boolean changed = this.injectPrecisionFromInterpolants(interpolants, iState);
        for (int i = 0; i < pushed; ++i) {
            itp.pop();
        }
        if (this.generalizeInterpolants && (weakerInterpolants = this.getGeneralizedInterpolants(iState, itp)).isPresent()) {
            changed |= this.injectPrecisionFromInterpolants(weakerInterpolants.orElseThrow(), iState);
        }
        return changed;
    }

    private boolean injectPrecisionFromInterpolants(List<BooleanFormula> interpolants, PolicyIntermediateState iState) {
        boolean changed = false;
        for (BooleanFormula interpolant : interpolants) {
            for (PolicyIntermediateState iterState : iState.allStatesToRoot()) {
                CFANode node = iterState.getBackpointerState().getNode();
                Set<String> interpolantVars = this.fmgr.extractVariableNames((Formula)this.fmgr.uninstantiate(interpolant));
                boolean precisionChanged = this.policyCPA.injectPrecisionFromInterpolant(node, interpolantVars);
                changed |= precisionChanged;
            }
        }
        return changed;
    }

    private <T> Optional<List<BooleanFormula>> getGeneralizedInterpolants(PolicyIntermediateState pState, InterpolatingProverEnvironment<T> itp) throws SolverException, InterruptedException {
        ArrayList<ImmutableSet> handles = new ArrayList<ImmutableSet>();
        for (PolicyIntermediateState predecessor : pState.allStatesToRoot()) {
            BooleanFormula f = predecessor.getPathFormula().getFormula();
            Set<String> varsToRemove = this.getRelevantInstantiatedVars(predecessor.getBackpointerState());
            BooleanFormula weakened = this.weaken(f, varsToRemove);
            Object handle = itp.push(weakened);
            assert (handle != null);
            handles.add(ImmutableSet.of((Object)handle));
        }
        if (itp.isUnsat()) {
            return Optional.of(itp.getSeqInterpolants(handles));
        }
        return Optional.empty();
    }

    private Set<String> getRelevantInstantiatedVars(PolicyAbstractedState pState) {
        return (Set)pState.getAbstraction().keySet().stream().flatMap(t -> t.getLinearExpression().getMap().keySet().stream()).map(id -> id.getDeclaration().getQualifiedName()).map(var -> FormulaManagerView.instantiateVariableName(var, pState.getSSA())).collect(ImmutableSet.toImmutableSet());
    }

    private BooleanFormula weaken(BooleanFormula input, Set<String> varsToDrop) throws InterruptedException {
        if (varsToDrop.isEmpty()) {
            return input;
        }
        if (Sets.intersection(this.extractVariableNames(input), varsToDrop).isEmpty()) {
            return input;
        }
        input = this.fmgr.simplify(input);
        input = this.fmgr.applyTactic(input, Tactic.NNF);
        input = this.bfmgr.transformRecursively(input, (BooleanFormulaTransformationVisitor)new FormulaWeakeningManager(this.fmgr, varsToDrop));
        return this.fmgr.simplify(input);
    }

    private Set<String> extractVariableNames(BooleanFormula pFormula) {
        Set<String> cache = this.extractedVarsCache.get(pFormula);
        if (cache == null) {
            cache = this.fmgr.extractVariableNames((Formula)pFormula);
            this.extractedVarsCache.put(pFormula, cache);
        }
        return cache;
    }

    private void forceRestart(ReachedSet reached) throws InterruptedException {
        ARGState firstChild = (ARGState)Iterables.getOnlyElement(((ARGState)reached.getFirstState()).getChildren());
        new ARGReachedSet(reached).removeSubtree(firstChild);
    }

    private class FormulaWeakeningManager
    extends BooleanFormulaManagerView.BooleanFormulaTransformationVisitor {
        private final Set<String> varsToDrop;

        FormulaWeakeningManager(FormulaManagerView pFmgr, Set<String> pVarsToDrop) {
            super(pFmgr);
            this.varsToDrop = pVarsToDrop;
        }

        public BooleanFormula visitAtom(BooleanFormula pAtom, FunctionDeclaration<BooleanFormula> decl) {
            if (!Sets.intersection(this.varsToDrop, PolicyInterpolationRefiner.this.extractVariableNames(pAtom)).isEmpty()) {
                return PolicyInterpolationRefiner.this.bfmgr.makeTrue();
            }
            return pAtom;
        }

        public BooleanFormula visitNot(BooleanFormula input) {
            if (PolicyInterpolationRefiner.this.bfmgr.isTrue(input)) {
                return PolicyInterpolationRefiner.this.bfmgr.makeTrue();
            }
            return input;
        }
    }
}

