/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.policyiteration;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.rationals.LinearExpression;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithAssumptions;
import org.sosy_lab.cpachecker.core.interfaces.FormulaReportingState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.loopbound.LoopBoundState;
import org.sosy_lab.cpachecker.cpa.policyiteration.FormulaLinearizationManager;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyAbstractedState;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyBound;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyIntermediateState;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyIterationStatistics;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyState;
import org.sosy_lab.cpachecker.cpa.policyiteration.StateFormulaConversionManager;
import org.sosy_lab.cpachecker.cpa.policyiteration.ValueDeterminationManager;
import org.sosy_lab.cpachecker.cpa.policyiteration.polyhedra.PolyhedraWideningManager;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.RCNFManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.templates.Template;
import org.sosy_lab.cpachecker.util.templates.TemplatePrecision;
import org.sosy_lab.cpachecker.util.templates.TemplateToFormulaConversionManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.api.Tactic;

@Options(prefix="cpa.lpi")
public class PolicyIterationManager {
    @Option(secure=true, description="Where to perform abstraction")
    private AbstractionLocations abstractionLocations = AbstractionLocations.LOOPHEAD;
    @Option(secure=true, name="epsilon", description="Value to substitute for the epsilon")
    private Rational EPSILON = Rational.ONE;
    @Option(secure=true, description="Run naive value determination first, switch to namespaced if it fails.")
    private boolean runHopefulValueDetermination = true;
    @Option(secure=true, description="Check target states reachability")
    private boolean checkTargetStates = true;
    @Option(secure=true, description="Syntactically pre-compute dependencies for value determination")
    private boolean valDetSyntacticCheck = true;
    @Option(secure=true, description="Check whether the policy depends on the initial value")
    private boolean checkPolicyInitialCondition = true;
    @Option(secure=true, description="Remove UFs and ITEs from policies.")
    private boolean linearizePolicy = true;
    @Option(secure=true, description="Generate new templates using polyhedra convex hull")
    private boolean generateTemplatesUsingConvexHull = false;
    @Option(secure=true, description="Compute abstraction for larger templates using decomposition")
    private boolean computeAbstractionByDecomposition = false;
    @Option(secure=true, description="Number of value determination steps allowed before widening is run. Value of '-1' runs value determination until convergence.")
    private int wideningThreshold = -1;
    @Option(secure=true, description="Algorithm for converting a formula to a set of lemmas", toUppercase=true, values={"CNF", "RCNF", "NONE"})
    private String toLemmasAlgorithm = "RCNF";
    @Option(secure=true, description="Do not compute the abstraction until strengthen is called. This speeds up the computation, but does not let other CPAs use the output of LPI.")
    private boolean delayAbstractionUntilStrengthen = false;
    private final FormulaManagerView fmgr;
    private final CFA cfa;
    private final PathFormulaManager pfmgr;
    private final BooleanFormulaManager bfmgr;
    private final Solver solver;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final ValueDeterminationManager vdfmgr;
    private final PolicyIterationStatistics statistics;
    private final FormulaLinearizationManager linearizationManager;
    private final @Nullable PolyhedraWideningManager pwm;
    private final StateFormulaConversionManager stateFormulaConversionManager;
    private final RCNFManager rcnfManager;
    private final TemplatePrecision initialPrecision;
    private final TemplateToFormulaConversionManager templateToFormulaConversionManager;
    private @Nullable BlockPartitioning partitioning;
    private final UniqueIdGenerator locationIDGenerator = new UniqueIdGenerator();
    private final Map<Formula, Set<String>> functionNamesCache = new HashMap<Formula, Set<String>>();

    public PolicyIterationManager(Configuration pConfig, FormulaManagerView pFormulaManager, CFA pCfa, PathFormulaManager pPfmgr, Solver pSolver, LogManager pLogger, ShutdownNotifier pShutdownNotifier, ValueDeterminationManager pValueDeterminationFormulaManager, PolicyIterationStatistics pStatistics, FormulaLinearizationManager pLinearizationManager, StateFormulaConversionManager pStateFormulaConversionManager, TemplateToFormulaConversionManager pTemplateToFormulaConversionManager, TemplatePrecision pPrecision) throws InvalidConfigurationException {
        this.templateToFormulaConversionManager = pTemplateToFormulaConversionManager;
        pConfig.inject((Object)this, PolicyIterationManager.class);
        this.stateFormulaConversionManager = pStateFormulaConversionManager;
        this.fmgr = pFormulaManager;
        this.cfa = pCfa;
        this.pfmgr = pPfmgr;
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.solver = pSolver;
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.vdfmgr = pValueDeterminationFormulaManager;
        this.statistics = pStatistics;
        this.linearizationManager = pLinearizationManager;
        this.rcnfManager = new RCNFManager(pConfig);
        this.initialPrecision = pPrecision;
        this.pwm = this.generateTemplatesUsingConvexHull ? new PolyhedraWideningManager(this.statistics, this.logger) : null;
    }

    public PolicyState getInitialState(CFANode pNode) {
        return PolicyAbstractedState.empty(pNode, this.bfmgr.makeTrue(), this.stateFormulaConversionManager);
    }

    public Precision getInitialPrecision() {
        return this.initialPrecision;
    }

    public Collection<? extends PolicyState> getAbstractSuccessors(PolicyState oldState, CFAEdge edge) throws CPATransferException, InterruptedException {
        CFANode node = edge.getSuccessor();
        PolicyIntermediateState iOldState = oldState.isAbstract() ? this.stateFormulaConversionManager.abstractStateToIntermediate(oldState.asAbstracted(), false) : oldState.asIntermediate();
        PathFormula outPath = this.pfmgr.makeAnd(iOldState.getPathFormula(), edge);
        PolicyIntermediateState out = PolicyIntermediateState.of(node, outPath, iOldState.getBackpointerState());
        return Collections.singleton(out);
    }

    Collection<? extends AbstractState> strengthen(PolicyIntermediateState pState, Iterable<AbstractState> pOtherStates) throws CPATransferException, InterruptedException {
        FluentIterable assumptions = FluentIterable.from(pOtherStates).filter(AbstractStateWithAssumptions.class).transformAndConcat(AbstractStateWithAssumptions::getAssumptions).filter(CExpression.class);
        if (assumptions.isEmpty()) {
            return Collections.singleton(pState);
        }
        PathFormula pf = pState.getPathFormula();
        for (CExpression assumption : assumptions) {
            pf = this.pfmgr.makeAnd(pf, assumption);
        }
        return Collections.singleton(pState.withPathFormula(pf));
    }

    public Optional<PrecisionAdjustmentResult> precisionAdjustment(PolicyState inputState, TemplatePrecision inputPrecision, UnmodifiableReachedSet states, AbstractState pArgState) throws CPAException, InterruptedException {
        return this.precisionAdjustment0(inputState, inputPrecision, states, pArgState).flatMap(s -> Optional.of(PrecisionAdjustmentResult.create(s, inputPrecision, PrecisionAdjustmentResult.Action.CONTINUE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<PolicyState> precisionAdjustment0(PolicyState inputState, TemplatePrecision inputPrecision, UnmodifiableReachedSet states, AbstractState pArgState) throws CPAException, InterruptedException {
        boolean isTarget;
        if (inputState.isAbstract()) {
            return Optional.of(inputState);
        }
        Preconditions.checkState((!inputState.isAbstract() ? 1 : 0) != 0);
        PolicyIntermediateState iState = inputState.asIntermediate();
        boolean hasTargetState = !AbstractStates.asIterable(pArgState).filter(AbstractStates::isTargetState).isEmpty();
        BooleanFormula extraInvariant = this.extractFormula(pArgState);
        CFANode node = iState.getNode();
        boolean shouldAbstract = this.shouldPerformAbstraction(iState, pArgState);
        boolean bl = isTarget = hasTargetState && this.checkTargetStates;
        if ((isTarget || shouldAbstract) && this.isUnreachable(iState, extraInvariant, isTarget)) {
            this.logger.log(Level.FINE, new Object[]{"Returning bottom state"});
            return Optional.empty();
        }
        if (shouldAbstract) {
            PolicyAbstractedState abstraction;
            Optional<PolicyAbstractedState> sibling = this.findSibling(iState, states, pArgState);
            int locationID = this.getLocationID(sibling, node);
            if (this.delayAbstractionUntilStrengthen) {
                return Optional.of(PolicyAbstractedState.top(node, locationID, this.stateFormulaConversionManager, iState.getPathFormula().getSsa(), iState.getPathFormula().getPointerTargetSet(), extraInvariant, iState, sibling));
            }
            this.statistics.abstractionTimer.start();
            try {
                abstraction = this.performAbstraction(iState, locationID, inputPrecision, extraInvariant, sibling);
                this.logger.log(Level.FINE, new Object[]{">>> Abstraction produced a state: ", abstraction});
            }
            finally {
                this.statistics.abstractionTimer.stop();
            }
            PolicyAbstractedState outState = sibling.isPresent() ? this.emulateLargeStep(abstraction, sibling.orElseThrow(), inputPrecision, extraInvariant) : abstraction;
            return Optional.of(outState);
        }
        return Optional.of(iState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<AbstractState> strengthen(PolicyState pState, TemplatePrecision pPrecision, Iterable<AbstractState> pOtherStates) throws CPAException, InterruptedException {
        PolicyAbstractedState abstraction;
        if (!pState.isAbstract()) {
            return Optional.of(pState);
        }
        PolicyAbstractedState aState = pState.asAbstracted();
        PolicyIntermediateState iState = aState.getGeneratingState().orElseThrow();
        BooleanFormula strengthening = (BooleanFormula)Streams.stream(pOtherStates).map(state -> AbstractStates.extractReportedFormulas(this.fmgr, state)).filter(state -> !this.bfmgr.isTrue(state)).collect(this.bfmgr.toConjunction());
        if (this.bfmgr.isTrue(strengthening) && !this.delayAbstractionUntilStrengthen) {
            return Optional.of(pState);
        }
        if (this.isUnreachable(iState, strengthening, false)) {
            this.logger.log(Level.FINE, new Object[]{"Returning bottom state"});
            return Optional.empty();
        }
        this.statistics.abstractionTimer.start();
        try {
            abstraction = this.performAbstraction(iState, aState.getLocationID(), pPrecision, strengthening, aState.getSibling());
        }
        finally {
            this.statistics.abstractionTimer.stop();
        }
        PolicyAbstractedState outState = aState.getSibling().isPresent() ? this.emulateLargeStep(abstraction, aState.getSibling().orElseThrow(), pPrecision, strengthening) : abstraction;
        if (outState.equals(pState)) {
            return Optional.of(pState);
        }
        return Optional.of(outState);
    }

    private int getLocationID(Optional<PolicyAbstractedState> sibling, CFANode node) {
        int locationID;
        if (sibling.isPresent()) {
            locationID = sibling.orElseThrow().getLocationID();
        } else {
            locationID = this.getFreshLocationID();
            this.logger.log(Level.INFO, new Object[]{"Generating new location ID", locationID, " for node ", node});
        }
        return locationID;
    }

    int getFreshLocationID() {
        return this.locationIDGenerator.getFreshId();
    }

    private PolicyAbstractedState emulateLargeStep(PolicyAbstractedState newState, PolicyAbstractedState latestSibling, TemplatePrecision precision, BooleanFormula extraInvariant) throws CPATransferException, InterruptedException {
        PolicyAbstractedState out;
        HashMap<Template, PolicyBound> updated = new HashMap<Template, PolicyBound>();
        PolicyAbstractedState merged = this.unionAbstractedStates(newState, latestSibling, precision, updated, extraInvariant);
        if (updated.isEmpty()) {
            out = merged;
        } else {
            ValueDeterminationManager.ValueDeterminationConstraints constraints;
            Optional<Object> element = Optional.empty();
            if (this.runHopefulValueDetermination && !(element = this.performValueDetermination(merged, updated, constraints = this.vdfmgr.valueDeterminationFormulaCheap(newState, merged, updated.keySet()))).isPresent()) {
                this.logger.log(Level.INFO, new Object[]{"Switching to more expensive value determination strategy."});
            }
            if (!element.isPresent() && !(element = this.performValueDetermination(merged, updated, constraints = this.vdfmgr.valueDeterminationFormula(newState, merged, updated.keySet()))).isPresent()) {
                throw new CPATransferException("Value determination problem is unfeasible at node " + newState.getNode());
            }
            out = (PolicyAbstractedState)element.orElseThrow();
        }
        return out;
    }

    private PolicyIntermediateState joinIntermediateStates(PolicyIntermediateState newState, PolicyIntermediateState oldState) throws InterruptedException {
        Preconditions.checkState((boolean)Objects.equals(newState.getNode(), oldState.getNode()));
        if (!newState.getBackpointerState().equals(oldState.getBackpointerState())) {
            return oldState;
        }
        if (newState.isMergedInto(oldState)) {
            return oldState;
        }
        if (oldState.isMergedInto(newState)) {
            return newState;
        }
        PathFormula mergedPath = this.pfmgr.makeOr(newState.getPathFormula(), oldState.getPathFormula());
        PolicyIntermediateState out = PolicyIntermediateState.of(newState.getNode(), mergedPath, oldState.getBackpointerState());
        newState.setMergedInto(out);
        oldState.setMergedInto(out);
        return out;
    }

    private PolicyAbstractedState unionAbstractedStates(PolicyAbstractedState newState, PolicyAbstractedState oldState, TemplatePrecision precision, Map<Template, PolicyBound> updated, BooleanFormula extraInvariant) {
        Preconditions.checkState((boolean)Objects.equals(newState.getNode(), oldState.getNode()));
        Preconditions.checkState((newState.getLocationID() == oldState.getLocationID() ? 1 : 0) != 0);
        if (this.isLessOrEqualAbstracted(newState, oldState)) {
            return oldState;
        }
        this.statistics.abstractMergeCounter.add((Object)oldState.getLocationID());
        HashMap<Template, PolicyBound> newAbstraction = new HashMap<Template, PolicyBound>();
        for (Template template : precision.getTemplatesForNode(newState.getNode())) {
            PolicyBound mergedBound;
            Optional<PolicyBound> oldValue = oldState.getBound(template);
            Optional<PolicyBound> newValue = newState.getBound(template);
            if (!newValue.isPresent() || !oldValue.isPresent()) continue;
            if (newValue.orElseThrow().getBound().compareTo(oldValue.orElseThrow().getBound()) > 0) {
                PolicyIterationStatistics.TemplateUpdateEvent updateEvent = PolicyIterationStatistics.TemplateUpdateEvent.of(newState.getLocationID(), template);
                if (this.statistics.templateUpdateCounter.count((Object)updateEvent) == this.wideningThreshold) {
                    this.logger.log(Level.FINE, new Object[]{"Widening threshold for template", template, "at", newState.getNode(), "was reached, widening to infinity."});
                    continue;
                }
                mergedBound = newValue.orElseThrow();
                updated.put(template, mergedBound);
                this.logger.log(Level.FINE, new Object[]{"Updating template", template, "at", newState.getNode(), "to", newValue.orElseThrow().getBound(), "(was: ", oldValue.orElseThrow().getBound(), ")"});
                this.statistics.templateUpdateCounter.add((Object)updateEvent);
            } else {
                mergedBound = oldValue.orElseThrow();
            }
            newAbstraction.put(template, mergedBound);
        }
        SSAMap mergedSSA = newState.getSSA();
        PolicyAbstractedState merged = PolicyAbstractedState.of(newAbstraction, oldState.getNode(), newState.getLocationID(), this.stateFormulaConversionManager, mergedSSA, newState.getPointerTargetSet(), extraInvariant, newState.getGeneratingState(), Optional.of(oldState));
        if (this.generateTemplatesUsingConvexHull) {
            precision.addGeneratedTemplates(this.pwm.generateWideningTemplates(oldState, newState));
        }
        assert (this.isLessOrEqualAbstracted(newState, merged) && this.isLessOrEqualAbstracted(oldState, merged)) : "Merged state should be larger than the subsumed one";
        return merged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<PolicyAbstractedState> performValueDetermination(PolicyAbstractedState stateWithUpdates, Map<Template, PolicyBound> updated, ValueDeterminationManager.ValueDeterminationConstraints valDetConstraints) throws InterruptedException, CPATransferException {
        this.logger.log(Level.INFO, new Object[]{"Value determination at node", stateWithUpdates.getNode(), ", #constraints = ", valDetConstraints.constraints.size()});
        HashMap<Template, PolicyBound> newAbstraction = new HashMap<Template, PolicyBound>((Map<Template, PolicyBound>)stateWithUpdates.getAbstraction());
        int locId = stateWithUpdates.getLocationID();
        this.statistics.valueDeterminationTimer.start();
        try (OptimizationProverEnvironment optEnvironment = this.solver.newOptEnvironment();){
            for (BooleanFormula c : valDetConstraints.constraints) {
                optEnvironment.addConstraint(c);
            }
            for (Map.Entry entry : updated.entrySet()) {
                OptimizationProverEnvironment.OptStatus result;
                this.shutdownNotifier.shutdownIfNecessary();
                optEnvironment.push();
                Template template = (Template)entry.getKey();
                PolicyBound mergedBound = (PolicyBound)entry.getValue();
                Formula objective = (Formula)valDetConstraints.outVars.get((Object)template, (Object)locId);
                BooleanFormula consistencyConstraint = this.fmgr.makeGreaterOrEqual(objective, this.fmgr.makeNumber(objective, mergedBound.getBound()), true);
                optEnvironment.addConstraint(consistencyConstraint);
                int handle = optEnvironment.maximize(objective);
                try {
                    this.statistics.optTimer.start();
                    result = optEnvironment.check();
                }
                finally {
                    this.statistics.optTimer.stop();
                }
                if (result == OptimizationProverEnvironment.OptStatus.UNSAT) {
                    this.shutdownNotifier.shutdownIfNecessary();
                    Optional<PolicyAbstractedState> optional = Optional.empty();
                    return optional;
                }
                if (result == OptimizationProverEnvironment.OptStatus.UNDEF) {
                    this.shutdownNotifier.shutdownIfNecessary();
                    this.logger.log(Level.WARNING, new Object[]{"Solver returned undefined status on the problem: "});
                    this.logger.log(Level.INFO, new Object[]{optEnvironment});
                    throw new CPATransferException("Unexpected solver state");
                }
                assert (result == OptimizationProverEnvironment.OptStatus.OPT);
                Optional value = optEnvironment.upper(handle, this.EPSILON);
                if (value.isPresent() && !this.templateToFormulaConversionManager.isOverflowing(template, (Rational)value.orElseThrow())) {
                    Rational v = (Rational)value.orElseThrow();
                    this.logger.log(Level.FINE, new Object[]{"Updating", template, "to value", v});
                    newAbstraction.put(template, mergedBound.updateValueFromValueDetermination(v));
                } else {
                    newAbstraction.remove(template);
                }
                optEnvironment.pop();
            }
        }
        catch (SolverException e) {
            throw new CPATransferException("Failed maximization ", e);
        }
        finally {
            this.statistics.valueDeterminationTimer.stop();
        }
        return Optional.of(stateWithUpdates.withNewAbstraction(newAbstraction));
    }

    private boolean isUnreachable(PolicyIntermediateState state, BooleanFormula extraInvariant, boolean pIsTarget) throws CPAException, InterruptedException {
        BooleanFormula startConstraints = this.stateFormulaConversionManager.getStartConstraintsWithExtraInvariant(state);
        PathFormula pf = state.getPathFormula();
        BooleanFormula constraint = this.bfmgr.and(new BooleanFormula[]{startConstraints, pf.getFormula(), this.fmgr.instantiate(extraInvariant, pf.getSsa())});
        try {
            this.statistics.checkSATTimer.start();
            boolean out = this.solver.isUnsat(this.bfmgr.toConjunctionArgs(constraint, true), state.getNode());
            if (!out && pIsTarget) {
                try (ProverEnvironment env = this.solver.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
                    env.push(constraint);
                    Preconditions.checkState((!env.isUnsat() ? 1 : 0) != 0);
                    state.setCounterexample((ImmutableList<Model.ValueAssignment>)env.getModelAssignments());
                }
            }
            boolean bl = out;
            return bl;
        }
        catch (SolverException e) {
            throw new CPATransferException("Failed solving", e);
        }
        finally {
            this.statistics.checkSATTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<PolicyBound> getPolicyBound(Template template, TemplatePrecision precision, OptimizationProverEnvironment optEnvironment, Optional<Rational> bound, BooleanFormula annotatedFormula, PathFormula p, PolicyIntermediateState state, Formula objective) throws SolverException, InterruptedException {
        this.statistics.getBoundTimer.start();
        try {
            boolean unsignedAndLower;
            boolean bl = unsignedAndLower = template.isUnsigned() && (template.getKind() == Template.Kind.NEG_LOWER_BOUND || template.getKind() == Template.Kind.NEG_SUM_LOWER_BOUND);
            if (bound.isPresent() && !this.templateToFormulaConversionManager.isOverflowing(template, bound.orElseThrow()) || unsignedAndLower) {
                Rational boundValue = bound.isPresent() && unsignedAndLower ? Rational.max((Rational)bound.orElseThrow(), (Rational)Rational.ZERO) : (bound.isPresent() ? bound.orElseThrow() : Rational.ZERO);
                try (Model model = optEnvironment.getModel();){
                    BooleanFormula linearizedFormula = annotatedFormula;
                    if (this.linearizePolicy) {
                        this.statistics.linearizationTimer.start();
                        linearizedFormula = this.linearizationManager.convertToPolicy(annotatedFormula, model);
                        this.statistics.linearizationTimer.stop();
                    }
                    PolicyBound policyBound = this.modelToPolicyBound(objective, state, precision, p, linearizedFormula, model, boundValue);
                    Optional<PolicyBound> optional = Optional.of(policyBound);
                    return optional;
                }
            }
            Optional<PolicyBound> optional = Optional.empty();
            return optional;
        }
        finally {
            this.statistics.getBoundTimer.stop();
        }
    }

    private Set<BooleanFormula> toLemmas(BooleanFormula formula) throws InterruptedException {
        switch (this.toLemmasAlgorithm) {
            case "CNF": {
                return this.bfmgr.toConjunctionArgs(this.fmgr.applyTactic(formula, Tactic.TSEITIN_CNF), true);
            }
            case "RCNF": {
                return this.rcnfManager.toLemmas(formula, this.fmgr);
            }
            case "NONE": {
                return ImmutableSet.of((Object)formula);
            }
        }
        throw new UnsupportedOperationException("Unexpected state");
    }

    private Set<String> extractFunctionNames(Formula f) {
        Set<String> out = this.functionNamesCache.get(f);
        if (out == null) {
            out = this.fmgr.extractFunctionNames(f);
            this.functionNamesCache.put(f, out);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolicyAbstractedState performAbstraction(PolicyIntermediateState generatorState, int locationID, TemplatePrecision precision, BooleanFormula extraInvariant, Optional<PolicyAbstractedState> pSibling) throws CPAException, InterruptedException {
        this.logger.log(Level.FINE, new Object[]{"Performing abstraction at node: ", generatorState.getNode()});
        CFANode node = generatorState.getNode();
        PathFormula p = generatorState.getPathFormula();
        BooleanFormula startConstraints = this.stateFormulaConversionManager.getStartConstraintsWithExtraInvariant(generatorState);
        Set<BooleanFormula> startConstraintLemmas = this.toLemmas(startConstraints);
        Set<BooleanFormula> lemmas = this.toLemmas(p.getFormula());
        HashMap<Template, PolicyBound> abstraction = new HashMap<Template, PolicyBound>();
        try (OptimizationProverEnvironment optEnvironment = this.solver.newOptEnvironment();){
            optEnvironment.push();
            optEnvironment.addConstraint(startConstraints);
            optEnvironment.push();
            block20: for (Template template : precision.getTemplatesForNode(node)) {
                OptimizationProverEnvironment.OptStatus status;
                optEnvironment.pop();
                optEnvironment.push();
                Formula objective = this.templateToFormulaConversionManager.toFormula(this.pfmgr, this.fmgr, template, p);
                Set<String> objectiveVars = this.extractFunctionNames(objective);
                if (this.computeAbstractionByDecomposition) {
                    Pair<DecompositionStatus, PolicyBound> res = this.computeByDecomposition(template, p, lemmas, startConstraintLemmas, abstraction);
                    switch (res.getFirstNotNull()) {
                        case BOUND_COMPUTED: {
                            PolicyBound bound = res.getSecondNotNull();
                            if (this.checkPolicyInitialCondition) {
                                bound = this.updatePolicyBoundDependencies(bound, objective);
                            }
                            abstraction.put(template, bound);
                            continue block20;
                        }
                        case UNBOUNDED: {
                            continue block20;
                        }
                        case ABSTRACTION_REQUIRED: {
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Unexpected case");
                        }
                    }
                }
                Set<BooleanFormula> slicedConstraint = this.computeRelevantSubset(lemmas, startConstraintLemmas, objectiveVars);
                BooleanFormula f = this.bfmgr.and(slicedConstraint);
                this.statistics.linearizationTimer.start();
                BooleanFormula annotatedFormula = this.linearizationManager.annotateDisjunctions(this.linearizationManager.linearize(f));
                this.statistics.linearizationTimer.stop();
                if (this.bfmgr.isTrue(f)) {
                    if (generatorState.getBackpointerState().getAbstraction().get((Object)template) == null) continue;
                    PolicyBound bound = (PolicyBound)generatorState.getBackpointerState().getAbstraction().get((Object)template);
                    abstraction.put(template, bound);
                }
                optEnvironment.addConstraint(annotatedFormula);
                int handle = optEnvironment.maximize(objective);
                try {
                    this.statistics.optTimer.start();
                    status = optEnvironment.check();
                }
                finally {
                    this.statistics.optTimer.stop();
                }
                switch (status) {
                    case OPT: {
                        Optional bound = optEnvironment.upper(handle, this.EPSILON);
                        Optional<PolicyBound> policyBound = this.getPolicyBound(template, precision, optEnvironment, bound, annotatedFormula, p, generatorState, objective);
                        if (policyBound.isPresent()) {
                            abstraction.put(template, policyBound.orElseThrow());
                        }
                        this.logger.log(Level.FINE, new Object[]{"Got bound: ", bound});
                        continue block20;
                    }
                    case UNSAT: {
                        throw new CPAException("Unexpected UNSAT");
                    }
                    case UNDEF: {
                        this.logger.log(Level.WARNING, new Object[]{"Solver returned undefined status on the problem: "});
                        this.logger.log(Level.INFO, new Object[]{optEnvironment.toString()});
                        throw new CPATransferException("Solver returned undefined status");
                    }
                }
                throw new AssertionError((Object)("Unhandled enum value in switch: " + status));
            }
        }
        catch (SolverException e) {
            throw new CPATransferException("Solver error: ", e);
        }
        this.statistics.updateCounter.add((Object)locationID);
        return PolicyAbstractedState.of(abstraction, generatorState.getNode(), locationID, this.stateFormulaConversionManager, generatorState.getPathFormula().getSsa(), generatorState.getPathFormula().getPointerTargetSet(), extraInvariant, Optional.of(generatorState), pSibling);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolicyBound updatePolicyBoundDependencies(PolicyBound bound, Formula objective) throws SolverException, InterruptedException {
        this.statistics.checkIndependenceTimer.start();
        try {
            if (this.solver.isUnsat(this.bfmgr.and(bound.getFormula().getFormula(), this.fmgr.makeGreaterThan(objective, this.fmgr.makeNumber(objective, bound.getBound()), true)))) {
                PolicyBound policyBound = bound.withNoDependencies();
                return policyBound;
            }
            PolicyBound policyBound = bound;
            return policyBound;
        }
        finally {
            this.statistics.checkIndependenceTimer.stop();
        }
    }

    private Pair<DecompositionStatus, PolicyBound> computeByDecomposition(Template pTemplate, PathFormula pFormula, Set<BooleanFormula> lemmas, Set<BooleanFormula> startConstraintLemmas, Map<Template, PolicyBound> currentAbstraction) {
        if (pTemplate.size() == 1) {
            return Pair.of(DecompositionStatus.ABSTRACTION_REQUIRED, null);
        }
        ArrayList<Set<BooleanFormula>> slices = new ArrayList<Set<BooleanFormula>>(pTemplate.size());
        ArrayList<PolicyBound> policyBounds = new ArrayList<PolicyBound>();
        ArrayList<Rational> coefficients = new ArrayList<Rational>();
        for (Map.Entry e : pTemplate.getLinearExpression()) {
            CIdExpression c = (CIdExpression)e.getKey();
            Rational r = (Rational)e.getValue();
            LinearExpression le = LinearExpression.ofVariable((Object)c);
            Template singleton = r.signum() < 0 ? Template.of((LinearExpression<CIdExpression>)le.negate()) : Template.of((LinearExpression<CIdExpression>)le);
            Set<String> variables = this.extractFunctionNames(this.templateToFormulaConversionManager.toFormula(this.pfmgr, this.fmgr, singleton, pFormula));
            Set<BooleanFormula> lemmasSubset = this.computeRelevantSubset(lemmas, startConstraintLemmas, variables);
            slices.add(lemmasSubset);
            policyBounds.add(currentAbstraction.get(singleton));
            coefficients.add(r);
        }
        for (int sliceIdx = 0; sliceIdx < slices.size(); ++sliceIdx) {
            for (int otherSliceIdx = sliceIdx + 1; otherSliceIdx < slices.size(); ++otherSliceIdx) {
                Set sliceB;
                Set sliceA = (Set)slices.get(sliceIdx);
                if (Sets.intersection((Set)sliceA, (Set)(sliceB = (Set)slices.get(otherSliceIdx))).isEmpty()) continue;
                return Pair.of(DecompositionStatus.ABSTRACTION_REQUIRED, null);
            }
        }
        if (policyBounds.contains(null)) {
            return Pair.of(DecompositionStatus.UNBOUNDED, null);
        }
        PolicyBound firstBound = (PolicyBound)policyBounds.get(0);
        for (PolicyBound bound : policyBounds) {
            if (bound.getPredecessor().equals(firstBound.getPredecessor()) && bound.getFormula().getSsa().equals(firstBound.getFormula().getSsa()) && bound.getFormula().getPointerTargetSet().equals(firstBound.getFormula().getPointerTargetSet())) continue;
            return Pair.of(DecompositionStatus.ABSTRACTION_REQUIRED, null);
        }
        HashSet<Template> allDependencies = new HashSet<Template>();
        HashSet<BooleanFormula> policies = new HashSet<BooleanFormula>();
        Rational combinedBound = Rational.ZERO;
        for (int i = 0; i < policyBounds.size(); ++i) {
            PolicyBound bound = (PolicyBound)policyBounds.get(i);
            combinedBound = combinedBound.plus(bound.getBound().times((Rational)coefficients.get(i)));
            allDependencies.addAll((Collection<Template>)bound.getDependencies());
            policies.add(bound.getFormula().getFormula());
        }
        BooleanFormula policy = this.bfmgr.and(policies);
        return Pair.of(DecompositionStatus.BOUND_COMPUTED, PolicyBound.of(firstBound.getFormula().withFormula(policy), combinedBound, firstBound.getPredecessor(), allDependencies));
    }

    private Set<BooleanFormula> computeRelevantSubset(Set<BooleanFormula> input, Set<BooleanFormula> supportingLemmas, Set<String> vars) {
        Set<String> closure = this.relatedClosure((Set<BooleanFormula>)Sets.union(input, supportingLemmas), vars);
        return (Set)input.stream().filter(l -> !Sets.intersection(this.extractFunctionNames((Formula)l), (Set)closure).isEmpty()).collect(ImmutableSet.toImmutableSet());
    }

    private Set<String> relatedClosure(Set<BooleanFormula> input, Set<String> vars) {
        boolean modified;
        HashSet<String> related = new HashSet<String>(vars);
        do {
            modified = false;
            for (BooleanFormula atom : input) {
                Set<String> containedVars = this.extractFunctionNames((Formula)atom);
                if (Sets.intersection(containedVars, related).isEmpty()) continue;
                modified |= related.addAll(containedVars);
            }
        } while (modified);
        return related;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolicyBound modelToPolicyBound(Formula templateObjective, PolicyIntermediateState inputState, TemplatePrecision precision, PathFormula inputPathFormula, BooleanFormula annotatedFormula, Model model, Rational bound) throws SolverException, InterruptedException {
        ArrayList<Template> dependencies;
        boolean dependsOnInitial;
        this.statistics.linearizationTimer.start();
        BooleanFormula policyFormula = this.linearizationManager.enforceChoice(annotatedFormula, model);
        this.statistics.linearizationTimer.stop();
        if (this.checkPolicyInitialCondition) {
            this.statistics.checkIndependenceTimer.start();
            try {
                dependsOnInitial = !this.solver.isUnsat(this.bfmgr.and(policyFormula, this.fmgr.makeGreaterThan(templateObjective, this.fmgr.makeNumber(templateObjective, bound), true)));
            }
            finally {
                this.statistics.checkIndependenceTimer.stop();
            }
        } else {
            dependsOnInitial = true;
        }
        PolicyAbstractedState backpointer = inputState.getBackpointerState();
        Set<String> policyVars = this.extractFunctionNames((Formula)policyFormula);
        if (!dependsOnInitial) {
            dependencies = new ArrayList<Template>();
        } else if (!this.valDetSyntacticCheck) {
            dependencies = precision.getTemplatesForNode(backpointer.getNode());
        } else {
            dependencies = new ArrayList();
            PathFormula contextFormula = this.stateFormulaConversionManager.getPathFormula(backpointer, false);
            for (Map.Entry<Template, PolicyBound> entry : backpointer) {
                Template t = entry.getKey();
                Set<String> fVars = this.extractFunctionNames(this.templateToFormulaConversionManager.toFormula(this.pfmgr, this.fmgr, t, contextFormula));
                if (Sets.intersection(fVars, policyVars).isEmpty()) continue;
                dependencies.add(t);
            }
        }
        return PolicyBound.of(inputPathFormula.withFormula(policyFormula), bound, backpointer, dependencies);
    }

    private boolean shouldPerformAbstraction(PolicyIntermediateState iState, AbstractState totalState) {
        CFANode node = iState.getNode();
        if (this.partitioning != null && (this.partitioning.isCallNode(node) || this.partitioning.isReturnNode(node))) {
            return true;
        }
        switch (this.abstractionLocations) {
            case ALL: {
                return true;
            }
            case LOOPHEAD: {
                LoopBoundState loopState = AbstractStates.extractStateByType(totalState, LoopBoundState.class);
                return this.cfa.getAllLoopHeads().orElseThrow().contains((Object)node) && (loopState == null || loopState.isLoopCounterAbstracted());
            }
            case MERGE: {
                return node.getNumEnteringEdges() > 1;
            }
        }
        throw new UnsupportedOperationException("Unexpected state");
    }

    private Optional<PolicyAbstractedState> findSibling(PolicyIntermediateState state, UnmodifiableReachedSet states, AbstractState pArgState) {
        ImmutableSet filteredSiblings = ImmutableSet.copyOf(AbstractStates.projectToType(states.getReached(pArgState), PolicyAbstractedState.class));
        if (filteredSiblings.isEmpty()) {
            return Optional.empty();
        }
        PolicyState a = state;
        while (true) {
            if (((PolicyState)a).isAbstract()) {
                PolicyAbstractedState aState = a.asAbstracted();
                if (filteredSiblings.contains(aState)) {
                    return Optional.of(aState);
                }
                Optional<PolicyIntermediateState> genState = aState.getGeneratingState();
                if (!genState.isPresent()) {
                    return Optional.empty();
                }
                a = genState.orElseThrow().getBackpointerState();
                continue;
            }
            PolicyIntermediateState iState = a.asIntermediate();
            a = iState.getBackpointerState();
        }
    }

    public boolean isLessOrEqual(PolicyState state1, PolicyState state2) {
        Preconditions.checkState((state1.isAbstract() == state2.isAbstract() ? 1 : 0) != 0);
        boolean out = state1.isAbstract() ? this.isLessOrEqualAbstracted(state1.asAbstracted(), state2.asAbstracted()) : this.isLessOrEqualIntermediate(state1.asIntermediate(), state2.asIntermediate());
        return out;
    }

    public PolicyState merge(PolicyState state1, PolicyState state2) throws InterruptedException {
        Preconditions.checkState((state1.isAbstract() == state2.isAbstract() ? 1 : 0) != 0, (Object)"Only states with the same abstraction status should be allowed to merge");
        if (state1.isAbstract()) {
            return state2;
        }
        return this.joinIntermediateStates(state1.asIntermediate(), state2.asIntermediate());
    }

    private boolean isLessOrEqualIntermediate(PolicyIntermediateState state1, PolicyIntermediateState state2) {
        return state1.isMergedInto(state2) || state1.getPathFormula().getFormula().equals(state2.getPathFormula().getFormula()) && this.isLessOrEqualAbstracted(state1.getBackpointerState(), state2.getBackpointerState());
    }

    private boolean isLessOrEqualAbstracted(PolicyAbstractedState aState1, PolicyAbstractedState aState2) {
        for (Map.Entry<Template, PolicyBound> e : aState2) {
            Template t = e.getKey();
            PolicyBound bound2 = e.getValue();
            Optional<PolicyBound> bound1 = aState1.getBound(t);
            if (bound1.isPresent() && bound1.orElseThrow().getBound().compareTo(bound2.getBound()) <= 0) continue;
            return false;
        }
        return true;
    }

    private BooleanFormula extractFormula(AbstractState pFormulaState) {
        ArrayList<BooleanFormula> constraints = new ArrayList<BooleanFormula>();
        for (AbstractState a : AbstractStates.asIterable(pFormulaState)) {
            if (a instanceof PolicyAbstractedState || !(a instanceof FormulaReportingState)) continue;
            constraints.add(((FormulaReportingState)a).getFormulaApproximation(this.fmgr));
        }
        return this.bfmgr.and(constraints);
    }

    void setPartitioning(BlockPartitioning pPartitioning) {
        this.partitioning = pPartitioning;
    }

    static enum DecompositionStatus {
        BOUND_COMPUTED,
        ABSTRACTION_REQUIRED,
        UNBOUNDED;

    }

    public static enum AbstractionLocations {
        ALL,
        LOOPHEAD,
        MERGE;

    }
}

