/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.policyiteration;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.util.templates.Template;

public class PolicyIterationStatistics
implements Statistics {
    final Multiset<TemplateUpdateEvent> templateUpdateCounter = HashMultiset.create();
    final Multiset<Integer> abstractMergeCounter = HashMultiset.create();
    final Multiset<Integer> updateCounter = HashMultiset.create();
    final Timer valueDeterminationTimer = new Timer();
    final Timer abstractionTimer = new Timer();
    final Timer checkSATTimer = new Timer();
    public final Timer polyhedraWideningTimer = new Timer();
    final Timer optTimer = new Timer();
    final Timer checkIndependenceTimer = new Timer();
    final Timer ackermannizationTimer = new Timer();
    final Timer linearizationTimer = new Timer();
    final Timer getBoundTimer = new Timer();
    private final CFA cfa;
    private BigInteger wideningTemplatesGenerated = BigInteger.ZERO;

    public PolicyIterationStatistics(CFA pCFA) {
        this.cfa = pCFA;
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
        this.printTimer(out, this.getBoundTimer, "getting policy bound");
        this.printTimer(out, this.valueDeterminationTimer, "value determination");
        this.printTimer(out, this.abstractionTimer, "abstraction");
        this.printTimer(out, this.optTimer, "optimization (OPT-SMT)");
        this.printTimer(out, this.checkSATTimer, "checking bad states (SMT)");
        this.printTimer(out, this.checkIndependenceTimer, "checking independence");
        this.printTimer(out, this.polyhedraWideningTimer, "computing polyhedra widening");
        this.printTimer(out, this.ackermannizationTimer, "performing ackermannization on policies");
        out.printf("Number of templates generated through widening: %s%n", this.wideningTemplatesGenerated);
        UpdateStats<Integer> updateStats = this.getUpdateStats(this.updateCounter);
        UpdateStats<TemplateUpdateEvent> templateUpdateStats = this.getUpdateStats(this.templateUpdateCounter);
        UpdateStats<Integer> mergeUpdateStats = this.getUpdateStats(this.abstractMergeCounter);
        this.printStats(out, updateStats, "abstractions on a given location");
        this.printStats(out, templateUpdateStats, "updates for given template on a given location");
        this.printStats(out, mergeUpdateStats, "merges of abstract states on a given location");
        out.printf("Number of loop heads: %d%n", this.cfa.getAllLoopHeads().orElseThrow().size());
        this.printTimer(out, this.linearizationTimer, "formula linearization");
    }

    private void printStats(PrintStream out, UpdateStats<?> stats, String description) {
        out.printf("Max number of %s: %d, for object: %s%n", description, stats.max, stats.maxObject);
        out.printf("Min number of %s: %d, for object: %s%n", description, stats.min, stats.minObject);
        out.printf("Avg number of %s: %.1f%n", description, stats.avg);
    }

    private <T> UpdateStats<T> getUpdateStats(Multiset<T> updateStats) {
        if (updateStats.elementSet().isEmpty()) {
            return new UpdateStats<Object>(0, 0, 0.0, null, null);
        }
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        Object maxObject = null;
        Object minObject = null;
        double sum = 0.0;
        for (Object l : updateStats.elementSet()) {
            int count = updateStats.count(l);
            if (count > max) {
                max = count;
                maxObject = l;
            }
            if (count < min) {
                min = count;
                minObject = l;
            }
            sum += (double)count;
        }
        double avg = sum / (double)updateStats.elementSet().size();
        return new UpdateStats<Object>(max, min, avg, maxObject, minObject);
    }

    private void printTimer(PrintStream out, Timer t, String name) {
        out.printf("Time spent in %s: %s (Max: %s), (Avg: %s), (#intervals = %s)%n", name, t, t.getMaxTime().formatAs(TimeUnit.SECONDS), t.getAvgTime().formatAs(TimeUnit.SECONDS), t.getNumberOfIntervals());
    }

    @Override
    public String getName() {
        return "PolicyIterationCPA";
    }

    static final class TemplateUpdateEvent {
        final int locationID;
        final Template template;

        private TemplateUpdateEvent(int pLocationID, Template pTemplate) {
            this.locationID = pLocationID;
            this.template = pTemplate;
        }

        public static TemplateUpdateEvent of(int pLocationID, Template pTemplate) {
            return new TemplateUpdateEvent(pLocationID, pTemplate);
        }

        public boolean equals(Object o) {
            if (!(o instanceof TemplateUpdateEvent)) {
                return false;
            }
            TemplateUpdateEvent other = (TemplateUpdateEvent)o;
            return this.locationID == other.locationID && this.template.equals(other.template);
        }

        public int hashCode() {
            return Objects.hash(this.locationID, this.template);
        }

        public String toString() {
            return String.format("%s (loc=%s)", this.template, this.locationID);
        }
    }

    private static class UpdateStats<T> {
        final T maxObject;
        final T minObject;
        final int max;
        final int min;
        final double avg;

        UpdateStats(int pMax, int pMin, double pAvg, T pMaxObject, T pMinObject) {
            this.max = pMax;
            this.min = pMin;
            this.avg = pAvg;
            this.maxObject = pMaxObject;
            this.minObject = pMinObject;
        }
    }
}

