/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.policyiteration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.common.rationals.LinearExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyAbstractedState;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyBound;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyIntermediateState;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyIterationManager;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyState;
import org.sosy_lab.cpachecker.cpa.policyiteration.StateFormulaConversionManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.templates.Template;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;

class PolicyReducer
implements Reducer {
    private final PolicyIterationManager policyIterationManager;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManager bfmgr;
    private final StateFormulaConversionManager stateFormulaConversionManager;
    private final PathFormulaManager pfmgr;
    private static final int STARTING_SSA_IDX = 1;

    PolicyReducer(PolicyIterationManager pPolicyIterationManager, FormulaManagerView pFormulaManager, StateFormulaConversionManager pStateFormulaConversionManager, PathFormulaManager pPathFormulaManager) {
        this.policyIterationManager = pPolicyIterationManager;
        this.fmgr = pFormulaManager;
        this.stateFormulaConversionManager = pStateFormulaConversionManager;
        this.pfmgr = pPathFormulaManager;
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
    }

    @Override
    public PolicyAbstractedState getVariableReducedState(AbstractState expandedState, Block context, CFANode callNode) {
        PolicyState pState = (PolicyState)expandedState;
        Preconditions.checkState((boolean)pState.isAbstract());
        PolicyAbstractedState aState = pState.asAbstracted();
        Set<String> blockVars = context.getVariables();
        Map newAbstraction = Maps.filterEntries((Map)Maps.filterKeys(aState.getAbstraction(), key -> blockVars.containsAll(key.getUsedVars())), e -> !this.isUpperBoundOnEquality((Template)e.getKey(), (PolicyBound)e.getValue(), (Map<Template, PolicyBound>)aState.getAbstraction()));
        return PolicyAbstractedState.of(newAbstraction, aState.getNode(), this.policyIterationManager.getFreshLocationID(), this.stateFormulaConversionManager, SSAMap.emptySSAMap().withDefault(1), aState.getPointerTargetSet(), this.bfmgr.makeTrue(), Optional.empty(), Optional.empty());
    }

    private boolean isUpperBoundOnEquality(Template t, PolicyBound bound, Map<Template, PolicyBound> abstraction) {
        if (t.getKind() != Template.Kind.UPPER_BOUND) {
            return false;
        }
        Template negated = Template.of((LinearExpression<CIdExpression>)t.getLinearExpression().negate());
        PolicyBound negatedValue = abstraction.get(negated);
        return negatedValue != null && negatedValue.getBound().equals((Object)bound.getBound());
    }

    @Override
    public PolicyState getVariableExpandedState(AbstractState entryState, Block reducedContext, AbstractState summaryState) {
        PolicyState pEntryState = (PolicyState)entryState;
        PolicyState pReturnState = (PolicyState)summaryState;
        if (!pReturnState.isAbstract()) {
            return pReturnState;
        }
        Preconditions.checkState((boolean)pEntryState.isAbstract());
        Preconditions.checkState((boolean)pReturnState.isAbstract());
        PolicyAbstractedState aEntryState = pEntryState.asAbstracted();
        PolicyAbstractedState aSummaryState = pReturnState.asAbstracted();
        ImmutableMap<Template, PolicyBound> summaryAbstraction = aSummaryState.getAbstraction();
        SSAMap summarySSA = aSummaryState.getSSA();
        CFANode node = aSummaryState.getNode();
        SSAMap.SSAMapBuilder builder = aEntryState.getSSA().builder();
        for (String var : builder.allVariables()) {
            if (aEntryState.getSSA().getIndex(var) <= 1) continue;
            builder = builder.setIndex(var, builder.getType(var), builder.getFreshIndex(var));
        }
        SSAMap ssa = builder.build();
        int locationID = aSummaryState.getLocationID();
        Optional<PolicyAbstractedState> sibling = Optional.empty();
        PointerTargetSet pointerTargetSet = aEntryState.getPointerTargetSet();
        BooleanFormula formula = this.bfmgr.and(this.stateFormulaConversionManager.abstractStateToConstraints(this.fmgr, aSummaryState, false));
        PathFormula pf = PathFormula.createManually(formula, ssa, pointerTargetSet, 1);
        PolicyIntermediateState generator = PolicyIntermediateState.of(node, pf, aEntryState);
        Map<Template, PolicyBound> newAbstraction = this.updateAbstractionForExpanded(pf, aEntryState, (Map<Template, PolicyBound>)summaryAbstraction, summarySSA);
        return PolicyAbstractedState.of(newAbstraction, node, locationID, this.stateFormulaConversionManager, ssa, pointerTargetSet, this.bfmgr.makeTrue(), Optional.of(generator), sibling);
    }

    private Map<Template, PolicyBound> updateAbstractionForExpanded(PathFormula inputPath, PolicyAbstractedState pParent, Map<Template, PolicyBound> summaryAbstraction, SSAMap summarySSA) {
        ImmutableMap.Builder newAbstraction = ImmutableMap.builder();
        Sets.SetView allTemplates = Sets.union((Set)pParent.getAbstraction().keySet(), summaryAbstraction.keySet());
        for (Template template : allTemplates) {
            PolicyBound pBound = summaryAbstraction.get(template);
            PolicyBound insertedBound = null;
            if (pBound != null) {
                BooleanFormula policyFormula = this.stateFormulaConversionManager.templateToConstraint(template, pBound, this.pfmgr, this.fmgr, inputPath);
                PathFormula policy = inputPath.withFormula(policyFormula);
                insertedBound = PolicyBound.of(policy, pBound.getBound(), pParent, (Collection<Template>)pParent.getAbstraction().keySet());
            } else if (template.getUsedVars().stream().noneMatch(v -> summarySSA.getIndex((String)v) > 1)) {
                insertedBound = pParent.getBound(template).orElseThrow();
            }
            if (insertedBound == null) continue;
            newAbstraction.put((Object)template, (Object)insertedBound);
        }
        return newAbstraction.buildOrThrow();
    }

    @Override
    public Precision getVariableReducedPrecision(Precision precision, Block context) {
        return precision;
    }

    @Override
    public Precision getVariableExpandedPrecision(Precision rootPrecision, Block rootContext, Precision reducedPrecision) {
        return rootPrecision;
    }

    @Override
    public Object getHashCodeForState(AbstractState stateKey, Precision precisionKey) {
        PolicyState pState = (PolicyState)stateKey;
        return ImmutableMap.copyOf((Map)Maps.transformValues(pState.asAbstracted().getAbstraction(), PolicyBound::getBound));
    }

    @Override
    public PolicyAbstractedState rebuildStateAfterFunctionCall(AbstractState rootState, AbstractState entryState, AbstractState expandedState, FunctionExitNode exitLocation) {
        PolicyState pRootState = (PolicyState)rootState;
        PolicyState pExpandedState = (PolicyState)expandedState;
        PolicyState pEntryState = (PolicyState)entryState;
        Preconditions.checkState((boolean)pRootState.isAbstract());
        Preconditions.checkState((boolean)pEntryState.isAbstract());
        Preconditions.checkState((boolean)pExpandedState.isAbstract());
        throw new UnsupportedOperationException("Recursion is not supported by LPI+BAM yet.");
    }
}

