/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.policyiteration;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyAbstractedState;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyBound;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyDotWriter;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyIntermediateState;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.templates.Template;
import org.sosy_lab.cpachecker.util.templates.TemplateToFormulaConversionManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="cpa.lpi")
public class StateFormulaConversionManager {
    @Option(secure=true, description="Remove redundant items when abstract values.")
    private boolean simplifyDotOutput = false;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManagerView bfmgr;
    private final TemplateToFormulaConversionManager templateToFormulaConversionManager;
    private final Configuration configuration;
    private final CFA cfa;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final PolicyDotWriter dotWriter;
    private final PathFormulaManager pfmgr;
    private final Solver solver;

    public StateFormulaConversionManager(FormulaManagerView pFormulaManager, TemplateToFormulaConversionManager pTemplateToFormulaConversionManager, Configuration pConfiguration, CFA pCfa, LogManager pLogger, ShutdownNotifier pShutdownNotifier, PathFormulaManager pPathFormulaManager, Solver pSolver) throws InvalidConfigurationException {
        pConfiguration.inject((Object)this);
        this.fmgr = pFormulaManager;
        this.bfmgr = pFormulaManager.getBooleanFormulaManager();
        this.templateToFormulaConversionManager = pTemplateToFormulaConversionManager;
        this.configuration = pConfiguration;
        this.cfa = pCfa;
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.pfmgr = pPathFormulaManager;
        this.solver = pSolver;
        this.dotWriter = new PolicyDotWriter();
    }

    List<BooleanFormula> abstractStateToConstraints(FormulaManagerView fmgrv, PolicyAbstractedState abstractState, boolean attachExtraInvariant) {
        PathFormulaManagerImpl pfmgrv;
        ArrayList<BooleanFormula> constraints = new ArrayList<BooleanFormula>();
        try {
            pfmgrv = new PathFormulaManagerImpl(fmgrv, this.configuration, this.logger, this.shutdownNotifier, this.cfa, AnalysisDirection.FORWARD);
        }
        catch (InvalidConfigurationException pE) {
            throw new UnsupportedOperationException("Could not construct path formula manager", pE);
        }
        PathFormula inputPath = this.getPathFormula(abstractState, attachExtraInvariant);
        if (!fmgrv.getBooleanFormulaManager().isTrue(inputPath.getFormula())) {
            constraints.add(inputPath.getFormula());
        }
        if (attachExtraInvariant) {
            constraints.add(fmgrv.instantiate(abstractState.getExtraInvariant(), inputPath.getSsa()));
        }
        for (Map.Entry<Template, PolicyBound> entry : abstractState) {
            Template template = entry.getKey();
            PolicyBound bound = entry.getValue();
            constraints.add(this.templateToConstraint(template, bound, pfmgrv, fmgrv, inputPath));
        }
        return constraints;
    }

    BooleanFormula templateToConstraint(Template template, PolicyBound bound, PathFormulaManager pfmgrv, FormulaManagerView fmgrv, PathFormula inputPath) {
        Formula t = this.templateToFormulaConversionManager.toFormula(pfmgrv, fmgrv, template, inputPath);
        return fmgrv.makeLessOrEqual(t, fmgrv.makeNumber(t, bound.getBound()), true);
    }

    public BooleanFormula getStartConstraintsWithExtraInvariant(PolicyIntermediateState state) {
        return this.bfmgr.and(this.abstractStateToConstraints(this.fmgr, state.getBackpointerState(), true));
    }

    PolicyIntermediateState abstractStateToIntermediate(PolicyAbstractedState abstractState, boolean attachExtraInvariant) {
        CFANode node = abstractState.getNode();
        PathFormula generatingFormula = this.getPathFormula(abstractState, attachExtraInvariant);
        return PolicyIntermediateState.of(node, generatingFormula, abstractState);
    }

    PathFormula getPathFormula(PolicyAbstractedState abstractState, boolean attachExtraInvariant) {
        PathFormula result = this.pfmgr.makeEmptyPathFormulaWithContext(abstractState.getSSA(), abstractState.getPointerTargetSet());
        if (attachExtraInvariant) {
            result = this.pfmgr.makeAnd(result, abstractState.getExtraInvariant());
        }
        return result;
    }

    public String toDOTLabel(Map<Template, PolicyBound> pAbstraction) {
        if (!this.simplifyDotOutput) {
            return this.dotWriter.toDOTLabel(pAbstraction);
        }
        PathFormula inputPath = this.pfmgr.makeEmptyPathFormula();
        ImmutableMap templatesToConstraints = ImmutableMap.copyOf((Map)Maps.transformEntries(pAbstraction, (key, value) -> this.templateToConstraint((Template)key, (PolicyBound)value, this.pfmgr, this.fmgr, inputPath)));
        ArrayList<Template> templates = new ArrayList<Template>(pAbstraction.keySet());
        HashSet<Template> nonRedundant = new HashSet<Template>(templates);
        for (Template t3 : templates) {
            BooleanFormula constraint = (BooleanFormula)templatesToConstraints.get(t3);
            BooleanFormula othersConstraint = nonRedundant.stream().filter(t2 -> t2 != t3).map(((Map)templatesToConstraints)::get).collect(this.bfmgr.toConjunction());
            try {
                if (!this.solver.implies(othersConstraint, constraint)) continue;
                nonRedundant.remove(t3);
            }
            catch (InterruptedException | SolverException pE) {
                this.logger.logException(Level.WARNING, pE, "Failed simplifying the abstraction before rendering, converting as it is.");
                this.simplifyDotOutput = false;
                return this.dotWriter.toDOTLabel(pAbstraction);
            }
        }
        Map filteredAbstraction = Maps.filterKeys(pAbstraction, t -> nonRedundant.contains(t));
        return this.dotWriter.toDOTLabel(filteredAbstraction);
    }
}

