/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.policyiteration;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyAbstractedState;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyBound;
import org.sosy_lab.cpachecker.cpa.policyiteration.StateFormulaConversionManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.templates.Template;
import org.sosy_lab.cpachecker.util.templates.TemplateToFormulaConversionManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;

@Options(prefix="cpa.lpi")
public class ValueDeterminationManager {
    @Option(secure=true, description="Attach extra invariant from other CPAs during the value determination computation")
    private boolean attachExtraInvariantDuringValueDetermination = true;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManagerView bfmgr;
    private final LogManager logger;
    private final PathFormulaManager pfmgr;
    private final StateFormulaConversionManager stateFormulaConversionManager;
    private final TemplateToFormulaConversionManager templateToFormulaConversionManager;
    private static final String VISIT_PREFIX = "[%d]_";

    public ValueDeterminationManager(Configuration pConfiguration, FormulaManagerView fmgr, LogManager logger, PathFormulaManager pPfmgr, StateFormulaConversionManager pStateFormulaConversionManager, TemplateToFormulaConversionManager pTemplateToFormulaConversionManager) throws InvalidConfigurationException {
        this.templateToFormulaConversionManager = pTemplateToFormulaConversionManager;
        pConfiguration.inject((Object)this);
        this.fmgr = fmgr;
        this.stateFormulaConversionManager = pStateFormulaConversionManager;
        this.bfmgr = fmgr.getBooleanFormulaManager();
        this.logger = logger;
        this.pfmgr = pPfmgr;
    }

    ValueDeterminationConstraints valueDeterminationFormulaCheap(PolicyAbstractedState newState, PolicyAbstractedState stateWithUpdates, Set<Template> updated) {
        return this.valueDeterminationFormula(newState, stateWithUpdates, updated, false);
    }

    ValueDeterminationConstraints valueDeterminationFormula(PolicyAbstractedState newState, PolicyAbstractedState stateWithUpdates, Set<Template> updated) {
        return this.valueDeterminationFormula(newState, stateWithUpdates, updated, true);
    }

    private ValueDeterminationConstraints valueDeterminationFormula(PolicyAbstractedState newState, PolicyAbstractedState mergedState, Set<Template> updated, boolean useUniquePrefix) {
        HashSet<BooleanFormula> outConstraints = new HashSet<BooleanFormula>();
        Map<Integer, PolicyAbstractedState> stronglyConnectedComponent = this.findScc2(newState);
        HashBasedTable outVars = HashBasedTable.create();
        long uniquePrefix = 0L;
        HashSet<Integer> visitedLocationIDs = new HashSet<Integer>();
        LinkedHashSet<PolicyAbstractedState> queue = new LinkedHashSet<PolicyAbstractedState>();
        queue.add(mergedState);
        while (!queue.isEmpty()) {
            Iterator it = queue.iterator();
            PolicyAbstractedState state = (PolicyAbstractedState)it.next();
            it.remove();
            visitedLocationIDs.add(state.getLocationID());
            for (Map.Entry<Template, PolicyBound> incoming : state) {
                boolean valueIsFixed;
                Template template = incoming.getKey();
                PolicyBound bound = incoming.getValue();
                PolicyAbstractedState backpointer = bound.getPredecessor();
                boolean bl = valueIsFixed = bound.getDependencies().isEmpty() || state == mergedState && !updated.contains(template) && !bound.isComputedByValueDetermination() || !stronglyConnectedComponent.containsKey(backpointer.getLocationID());
                if (!valueIsFixed && bound.getDependencies().contains((Object)template) && !visitedLocationIDs.contains(backpointer.getLocationID())) {
                    queue.add(backpointer);
                }
                String prefix = useUniquePrefix ? String.format(VISIT_PREFIX, ++uniquePrefix) : String.format(VISIT_PREFIX, bound.serializePolicy(state));
                this.generateConstraintsFromPolicyBound(bound, state.getLocationID(), template, backpointer.getLocationID(), prefix, valueIsFixed, outConstraints, (Table<Template, Integer, Formula>)outVars);
            }
        }
        return new ValueDeterminationConstraints((ImmutableTable<Template, Integer, Formula>)ImmutableTable.copyOf((Table)outVars), (ImmutableSet<BooleanFormula>)ImmutableSet.copyOf(outConstraints));
    }

    private Map<Integer, PolicyAbstractedState> findScc2(PolicyAbstractedState newState) {
        int startLocId = newState.getLocationID();
        HashMap<Integer, PolicyAbstractedState> stateMap = new HashMap<Integer, PolicyAbstractedState>();
        HashMultimap backwDepsEdges = HashMultimap.create();
        this.populateGraph(newState, stateMap, (SetMultimap<Integer, Integer>)backwDepsEdges);
        Set<Integer> backwardsReachable = this.backwardsDfs(startLocId, (Multimap<Integer, Integer>)backwDepsEdges);
        return Maps.filterKeys(stateMap, locId -> backwardsReachable.contains(locId));
    }

    private Set<Integer> backwardsDfs(int startLocId, Multimap<Integer, Integer> backwEdges) {
        LinkedHashSet<Integer> queue = new LinkedHashSet<Integer>();
        queue.add(startLocId);
        HashSet<Integer> out = new HashSet<Integer>();
        while (!queue.isEmpty()) {
            Iterator it = queue.iterator();
            int locId = (Integer)it.next();
            it.remove();
            out.add(locId);
            Iterator iterator = backwEdges.get((Object)locId).iterator();
            while (iterator.hasNext()) {
                int b = (Integer)iterator.next();
                if (out.contains(b)) continue;
                queue.add(b);
            }
        }
        return out;
    }

    private void populateGraph(PolicyAbstractedState newState, Map<Integer, PolicyAbstractedState> stateMap, SetMultimap<Integer, Integer> backwDepsEdges) {
        LinkedHashSet<PolicyAbstractedState> queue = new LinkedHashSet<PolicyAbstractedState>();
        queue.add(newState);
        while (!queue.isEmpty()) {
            Iterator it = queue.iterator();
            PolicyAbstractedState toProcess = (PolicyAbstractedState)it.next();
            it.remove();
            int locId = toProcess.getLocationID();
            PolicyAbstractedState prev = stateMap.get(locId);
            if (prev != null && prev.getStateId() >= toProcess.getStateId()) continue;
            stateMap.put(locId, toProcess);
            toProcess.getAbstraction().values().stream().filter(b -> !b.getDependencies().isEmpty()).forEach(b -> {
                PolicyAbstractedState pred = b.getPredecessor();
                queue.add(pred);
                backwDepsEdges.put((Object)pred.getLocationID(), (Object)locId);
            });
        }
    }

    private void generateConstraintsFromPolicyBound(PolicyBound bound, int locationID, Template template, int policyBackpointerLocationID, String prefix, boolean valueFixed, Set<BooleanFormula> outConstraints, Table<Template, Integer, Formula> outVars) {
        PathFormula policyFormula = bound.getFormula();
        PathFormula startPathFormula = this.stateFormulaConversionManager.getPathFormula(bound.getPredecessor(), this.attachExtraInvariantDuringValueDetermination);
        Formula policyOutTemplate = this.addPrefix(this.templateToFormulaConversionManager.toFormula(this.pfmgr, this.fmgr, template, policyFormula), prefix);
        Formula outVar = this.fmgr.makeVariable(this.fmgr.getFormulaType(policyOutTemplate), this.absDomainVarName(locationID, template));
        outVars.put((Object)template, (Object)locationID, (Object)outVar);
        if (valueFixed) {
            this.logger.log(Level.FINE, new Object[]{"Fixed value for template", template});
            BooleanFormula constraint = this.fmgr.makeLessOrEqual(outVar, this.fmgr.makeNumber(policyOutTemplate, bound.getBound()), true);
            outConstraints.add(constraint);
            return;
        }
        BooleanFormula outConstraint = this.fmgr.makeLessOrEqual(outVar, policyOutTemplate, true);
        outConstraints.add(outConstraint);
        BooleanFormula namespacedPolicy = this.addPrefix(policyFormula.getFormula(), prefix);
        if (!this.bfmgr.isTrue(namespacedPolicy)) {
            outConstraints.add(namespacedPolicy);
        }
        for (Template incomingTemplate : bound.getDependencies()) {
            String prevAbstractDomainElement = this.absDomainVarName(policyBackpointerLocationID, incomingTemplate);
            Formula incomingTemplateFormula = this.addPrefix(this.templateToFormulaConversionManager.toFormula(this.pfmgr, this.fmgr, incomingTemplate, startPathFormula), prefix);
            Formula upperBound = this.fmgr.makeVariable(this.fmgr.getFormulaType(incomingTemplateFormula), prevAbstractDomainElement);
            BooleanFormula constraint = this.fmgr.makeLessOrEqual(incomingTemplateFormula, upperBound, true);
            outConstraints.add(constraint);
        }
    }

    private <T extends Formula> T addPrefix(T formula, String prefix) {
        return this.fmgr.renameFreeVariablesAndUFs(formula, v -> prefix + v);
    }

    private String absDomainVarName(int locId, Template template) {
        return String.format("BOUND_[%s]_[%s]", locId, template.toString());
    }

    static class ValueDeterminationConstraints {
        final ImmutableTable<Template, Integer, Formula> outVars;
        final ImmutableSet<BooleanFormula> constraints;

        private ValueDeterminationConstraints(ImmutableTable<Template, Integer, Formula> pOutVars, ImmutableSet<BooleanFormula> pConstraints) {
            this.outVars = pOutVars;
            this.constraints = pConstraints;
        }
    }
}

