/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.policyiteration.polyhedra;

import apron.Abstract1;
import apron.Coeff;
import apron.Environment;
import apron.Lincons1;
import apron.Linexpr1;
import apron.Linterm1;
import apron.Manager;
import apron.MpqScalar;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.rationals.LinearExpression;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyAbstractedState;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyBound;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyIterationStatistics;
import org.sosy_lab.cpachecker.util.ApronManager;
import org.sosy_lab.cpachecker.util.templates.Template;

public class PolyhedraWideningManager {
    private final Manager manager;
    private final Map<String, CIdExpression> types;
    private final PolicyIterationStatistics statistics;
    private final LogManager logger;

    public PolyhedraWideningManager(PolicyIterationStatistics pStatistics, LogManager pLogger) {
        this.statistics = pStatistics;
        this.logger = pLogger;
        ApronManager apronManager = new ApronManager(ApronManager.AbstractDomain.POLKA);
        this.manager = apronManager.getManager();
        this.types = new HashMap<String, CIdExpression>();
    }

    Manager getManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Template> generateWideningTemplates(PolicyAbstractedState oldState, PolicyAbstractedState newState) {
        Abstract1 widened;
        Sets.SetView allTemplates = Sets.union((Set)oldState.getAbstraction().keySet(), (Set)newState.getAbstraction().keySet());
        Map oldData = Maps.transformValues(oldState.getAbstraction(), PolicyBound::getBound);
        Map newData = Maps.transformValues(newState.getAbstraction(), PolicyBound::getBound);
        try {
            this.statistics.polyhedraWideningTimer.start();
            Environment env = this.generateEnvironment((List<Map<Template, Rational>>)ImmutableList.of((Object)oldData, (Object)newData));
            Abstract1 abs1 = this.fromTemplates(env, oldData);
            Abstract1 abs2 = this.fromTemplates(env, newData);
            abs2.join(this.manager, abs1);
            widened = abs1.widening(this.manager, abs2);
        }
        finally {
            this.statistics.polyhedraWideningTimer.stop();
        }
        Map<Template, Rational> generated = this.toTemplates(widened);
        this.logger.log(Level.FINE, new Object[]{"Generated templates", generated});
        Sets.SetView diff = Sets.difference(generated.keySet(), (Set)allTemplates);
        HashSet<Template> out = new HashSet<Template>();
        for (Template t : diff) {
            out.add(t);
            out.add(Template.of((LinearExpression<CIdExpression>)t.getLinearExpression().negate()));
        }
        return out;
    }

    Environment generateEnvironment(List<Map<Template, Rational>> t) {
        Environment out = new Environment();
        for (Map<Template, Rational> m : t) {
            for (Template template : m.keySet()) {
                out = this.generateEnvironment(out, template);
            }
        }
        return out;
    }

    Map<Template, Rational> toTemplates(Abstract1 abs) {
        Lincons1[] values;
        HashMap<Template, Rational> out = new HashMap<Template, Rational>();
        for (Lincons1 constraint : values = abs.toLincons(this.manager)) {
            Rational coeff = this.ofCoeff(constraint.getCst());
            Template t = this.ofExpression(constraint);
            Template tNegated = Template.of((LinearExpression<CIdExpression>)t.getLinearExpression().negate());
            out.put(tNegated, coeff);
        }
        return out;
    }

    Abstract1 fromTemplates(Environment environment, Map<Template, Rational> state) {
        Lincons1[] values = new Lincons1[state.size()];
        int i = -1;
        for (Map.Entry<Template, Rational> e : state.entrySet()) {
            Template t = e.getKey();
            Rational bound = e.getValue();
            values[++i] = this.fromTemplateBound(environment, t, bound);
        }
        Abstract1 out = new Abstract1(this.manager, environment);
        out.meet(this.manager, values);
        return out;
    }

    private Template ofExpression(Lincons1 expr) {
        expr.minimize();
        LinearExpression out = LinearExpression.empty();
        for (Linterm1 term : expr.getLinterms()) {
            String varName = term.getVariable();
            Rational coeff = this.ofCoeff(term.getCoefficient());
            out = out.add(LinearExpression.monomial((Object)this.types.get(varName), (Rational)coeff));
        }
        return Template.of((LinearExpression<CIdExpression>)out);
    }

    private Rational ofCoeff(Coeff c) {
        assert (c instanceof MpqScalar);
        MpqScalar mpq = (MpqScalar)c;
        return Rational.of((BigInteger)mpq.get().getNum().bigIntegerValue(), (BigInteger)mpq.get().getDen().bigIntegerValue());
    }

    private Lincons1 fromTemplateBound(Environment environment, Template t, Rational bound) {
        Linexpr1 expr = this.fromLinearExpression(environment, (LinearExpression<CIdExpression>)t.getLinearExpression().negate());
        expr.setCst((Coeff)this.ofRational(bound));
        return new Lincons1(1, expr);
    }

    private Linexpr1 fromLinearExpression(Environment environment, LinearExpression<CIdExpression> input) {
        Linexpr1 expr = new Linexpr1(environment, input.size());
        expr.setCst((Coeff)this.ofRational(Rational.ZERO));
        for (Map.Entry e : input) {
            CIdExpression id = (CIdExpression)e.getKey();
            Rational bound = (Rational)e.getValue();
            String varName = id.getDeclaration().getQualifiedName();
            this.types.put(varName, id);
            expr.setCoeff(varName, (Coeff)this.ofRational(bound));
        }
        return expr;
    }

    private Environment generateEnvironment(Environment environment, Template t) {
        for (Map.Entry e : t.getLinearExpression()) {
            CIdExpression id = (CIdExpression)e.getKey();
            String varName = id.getDeclaration().getQualifiedName();
            this.types.put(varName, id);
            if (environment.hasVar(varName)) continue;
            if (this.isIntegral(id)) {
                environment = environment.add(new String[]{varName}, new String[0]);
                continue;
            }
            environment = environment.add(new String[0], new String[]{varName});
        }
        return environment;
    }

    private MpqScalar ofRational(Rational r) {
        return new MpqScalar(r.getNum(), r.getDen());
    }

    private boolean isIntegral(CIdExpression id) {
        CSimpleType type = (CSimpleType)id.getExpressionType();
        return type.getType().isIntegerType();
    }
}

