/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.policyiteration.polyhedra;

import apron.Abstract1;
import apron.Environment;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.util.List;
import java.util.Map;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.rationals.LinearExpression;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyIterationStatistics;
import org.sosy_lab.cpachecker.cpa.policyiteration.polyhedra.PolyhedraWideningManager;
import org.sosy_lab.cpachecker.util.templates.Template;

public class PolyhedraWideningManagerTest {
    private PolyhedraWideningManager pwm;

    @Before
    public void setUp() {
        PolicyIterationStatistics stats = (PolicyIterationStatistics)Mockito.mock(PolicyIterationStatistics.class);
        try {
            this.pwm = new PolyhedraWideningManager(stats, LogManager.createTestLogManager());
        }
        catch (UnsatisfiedLinkError e) {
            Assume.assumeNoException((String)"missing binary dependency for old apron binary", (Throwable)e);
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void test_polyhedra() {
        CIdExpression x = this.makeVar("x", CNumericTypes.INT);
        CIdExpression y = this.makeVar("y", CNumericTypes.INT);
        LinearExpression linX = LinearExpression.ofVariable((Object)x);
        LinearExpression linY = LinearExpression.ofVariable((Object)y);
        ImmutableMap point1 = ImmutableMap.of((Object)Template.of((LinearExpression<CIdExpression>)linX), (Object)Rational.ZERO, (Object)Template.of((LinearExpression<CIdExpression>)linX.negate()), (Object)Rational.ZERO, (Object)Template.of((LinearExpression<CIdExpression>)linY), (Object)Rational.ZERO, (Object)Template.of((LinearExpression<CIdExpression>)linY.negate()), (Object)Rational.ZERO);
        ImmutableMap point2 = ImmutableMap.of((Object)Template.of((LinearExpression<CIdExpression>)linX), (Object)Rational.ONE, (Object)Template.of((LinearExpression<CIdExpression>)linX.negate()), (Object)Rational.NEG_ONE, (Object)Template.of((LinearExpression<CIdExpression>)linY), (Object)Rational.ONE, (Object)Template.of((LinearExpression<CIdExpression>)linY.negate()), (Object)Rational.NEG_ONE);
        Environment env = this.pwm.generateEnvironment((List<Map<Template, Rational>>)ImmutableList.of((Object)point1, (Object)point2));
        Abstract1 abs1 = this.pwm.fromTemplates(env, (Map<Template, Rational>)point1);
        Abstract1 abs2 = this.pwm.fromTemplates(env, (Map<Template, Rational>)point2);
        Abstract1 union = abs1.joinCopy(this.pwm.getManager(), abs2);
        Map<Template, Rational> unionMap = this.pwm.toTemplates(union);
        Truth.assertThat(unionMap).containsEntry((Object)Template.of((LinearExpression<CIdExpression>)linX), (Object)Rational.ONE);
        Truth.assertThat(unionMap).containsEntry((Object)Template.of((LinearExpression<CIdExpression>)linX.negate()), (Object)Rational.ZERO);
        Truth.assertThat(unionMap).containsEntry((Object)Template.of((LinearExpression<CIdExpression>)linX.sub(linY)), (Object)Rational.ZERO);
        Abstract1 widened = abs1.widening(this.pwm.getManager(), union);
        Map<Template, Rational> widenedMap = this.pwm.toTemplates(widened);
        Truth.assertThat(widenedMap).containsEntry((Object)Template.of((LinearExpression<CIdExpression>)linX.sub(linY)), (Object)Rational.ZERO);
    }

    private CIdExpression makeVar(String varName, CSimpleType type) {
        return new CIdExpression(FileLocation.DUMMY, new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, type, varName, varName, varName, null));
    }
}

