/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.powerset;

import java.util.Collections;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.MergeJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.powerset.PowerSetDomain;
import org.sosy_lab.cpachecker.cpa.powerset.PowerSetPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.powerset.PowerSetState;
import org.sosy_lab.cpachecker.cpa.powerset.PowerSetTransferRelation;

public class PowerSetCPA
extends AbstractSingleWrapperCPA {
    private final PowerSetDomain domain;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(PowerSetCPA.class);
    }

    public PowerSetCPA(ConfigurableProgramAnalysis pCpa) {
        super(pCpa);
        this.domain = new PowerSetDomain(pCpa.getStopOperator());
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.domain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return new PowerSetTransferRelation(this.getWrappedCpa().getTransferRelation());
    }

    @Override
    public MergeOperator getMergeOperator() {
        return new MergeJoinOperator(this.getAbstractDomain());
    }

    @Override
    public StopOperator getStopOperator() {
        return new StopSepOperator(this.getAbstractDomain());
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return new PowerSetPrecisionAdjustment(this.getWrappedCpa().getPrecisionAdjustment());
    }

    @Override
    public AbstractState getInitialState(CFANode node, StateSpacePartition partition) throws InterruptedException {
        return new PowerSetState(Collections.singleton(super.getInitialState(node, partition)));
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) throws InterruptedException {
        Precision prec = super.getInitialPrecision(pNode, pPartition);
        this.domain.setPrecision(prec);
        return prec;
    }
}

