/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.powerset;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.cpa.powerset.PowerSetState;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class PowerSetDomain
implements AbstractDomain {
    private final StopOperator stop;
    private Precision prec;

    public PowerSetDomain(StopOperator pStop) {
        this.stop = pStop;
    }

    @Override
    public AbstractState join(AbstractState pState1, AbstractState pState2) throws CPAException, InterruptedException {
        Preconditions.checkState((this.prec != null ? 1 : 0) != 0);
        PowerSetState state1 = (PowerSetState)pState1;
        PowerSetState state2 = (PowerSetState)pState2;
        ImmutableSet<AbstractState> coverSet = state2.getWrappedStates();
        HashSet stateSet = Sets.newHashSetWithExpectedSize((int)(coverSet.size() + state1.getWrappedStates().size()));
        for (AbstractState state : state1.getWrappedStates()) {
            if (coverSet.contains(state) || this.stop.stop(state, (Collection<AbstractState>)coverSet, this.prec)) continue;
            stateSet.add(state);
        }
        if (stateSet.isEmpty()) {
            return pState2;
        }
        stateSet.addAll(coverSet);
        return new PowerSetState(stateSet, state1, state2);
    }

    @Override
    public boolean isLessOrEqual(AbstractState pState1, AbstractState pState2) throws CPAException, InterruptedException {
        PowerSetState state1 = (PowerSetState)pState1;
        PowerSetState state2 = (PowerSetState)pState2;
        return state1.isMergedInto(state2) || this.isCoverage(state1, state2);
    }

    private boolean isCoverage(PowerSetState pCovered, PowerSetState pCovering) throws CPAException, InterruptedException {
        if (this.prec == null) {
            return false;
        }
        ImmutableSet<AbstractState> coverSet = pCovering.getWrappedStates();
        for (AbstractState state : pCovered.getWrappedStates()) {
            if (coverSet.contains(state) || this.stop.stop(state, (Collection<AbstractState>)coverSet, this.prec)) continue;
            return false;
        }
        return true;
    }

    public void setPrecision(Precision pPrec) {
        this.prec = pPrec;
    }
}

