/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.powerset;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.powerset.PowerSetState;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class PowerSetPrecisionAdjustment
implements PrecisionAdjustment {
    private final PrecisionAdjustment wrappedPrec;

    public PowerSetPrecisionAdjustment(PrecisionAdjustment pPrecisionAdjustment) {
        this.wrappedPrec = pPrecisionAdjustment;
    }

    @Override
    public Optional<PrecisionAdjustmentResult> prec(AbstractState pState, Precision pPrecision, UnmodifiableReachedSet pStates, Function<AbstractState, AbstractState> pStateProjection, AbstractState pFullState) throws CPAException, InterruptedException {
        PowerSetState states = (PowerSetState)pState;
        PrecisionAdjustmentResult.Action action = PrecisionAdjustmentResult.Action.CONTINUE;
        HashSet newStates = Sets.newHashSetWithExpectedSize((int)states.getWrappedStates().size());
        boolean present = false;
        boolean changed = false;
        for (AbstractState state : states.getWrappedStates()) {
            Optional<PrecisionAdjustmentResult> wrappedRes = this.wrappedPrec.prec(state, pPrecision, pStates, (Function<AbstractState, AbstractState>)Functions.compose(abstractState -> state, pStateProjection), pFullState);
            if (!wrappedRes.isPresent()) continue;
            present = true;
            if (wrappedRes.orElseThrow().abstractState() != pState) {
                changed = true;
                newStates.add(wrappedRes.orElseThrow().abstractState());
            } else {
                newStates.add(state);
            }
            if (wrappedRes.orElseThrow().action() != PrecisionAdjustmentResult.Action.BREAK) continue;
            action = PrecisionAdjustmentResult.Action.BREAK;
        }
        if (!present) {
            return Optional.empty();
        }
        PowerSetState newState = changed ? new PowerSetState(newStates) : states;
        return Optional.of(PrecisionAdjustmentResult.create(newState, pPrecision, action));
    }
}

