/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.powerset;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractWrapperState;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class PowerSetState
implements AbstractWrapperState,
Targetable {
    private final transient PowerSetState merged1;
    private final transient PowerSetState merged2;
    private final ImmutableSet<AbstractState> setOfStates;

    public PowerSetState(Set<AbstractState> states) {
        this.merged2 = null;
        this.merged1 = null;
        this.setOfStates = ImmutableSet.copyOf(states);
    }

    public PowerSetState(Set<AbstractState> states, PowerSetState state1, PowerSetState state2) {
        this.merged1 = state1;
        this.merged2 = state2;
        this.setOfStates = ImmutableSet.copyOf(states);
    }

    public boolean isMergedInto(PowerSetState pState) {
        return pState == this.merged1 || pState == this.merged2;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.setOfStates);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof PowerSetState && Objects.equals(this.setOfStates, ((PowerSetState)obj).setOfStates);
    }

    public ImmutableSet<AbstractState> getWrappedStates() {
        return this.setOfStates;
    }

    @Override
    public boolean isTarget() {
        return Iterables.any(this.setOfStates, AbstractStates::isTargetState);
    }

    @Override
    public @NonNull Set<Targetable.TargetInformation> getTargetInformation() throws IllegalStateException {
        return FluentIterable.from(this.setOfStates).filter(AbstractStates::isTargetState).transformAndConcat(s -> ((Targetable)((Object)s)).getTargetInformation()).toSet();
    }
}

