/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.powerset;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.powerset.PowerSetState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class PowerSetTransferRelation
extends SingleEdgeTransferRelation {
    private final TransferRelation wrapperTransfer;

    public PowerSetTransferRelation(TransferRelation pTransferRelation) {
        this.wrapperTransfer = pTransferRelation;
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        PowerSetState state = (PowerSetState)pState;
        HashSet successors = Sets.newHashSetWithExpectedSize((int)state.getWrappedStates().size());
        for (AbstractState wrappedState : state.getWrappedStates()) {
            successors.addAll(this.wrapperTransfer.getAbstractSuccessorsForEdge(wrappedState, pPrecision, pCfaEdge));
        }
        return ImmutableSet.of((Object)new PowerSetState(successors));
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState state, Iterable<AbstractState> otherStates, @Nullable CFAEdge cfaEdge, Precision precision) throws CPATransferException, InterruptedException {
        PowerSetState setStates = (PowerSetState)state;
        HashSet newStates = Sets.newHashSetWithExpectedSize((int)setStates.getWrappedStates().size());
        boolean changed = false;
        for (AbstractState stateInSet : setStates.getWrappedStates()) {
            Collection<? extends AbstractState> strengtheningRes = this.wrapperTransfer.strengthen(stateInSet, Collections.singletonList(stateInSet), cfaEdge, precision);
            if (strengtheningRes == null || strengtheningRes.isEmpty()) continue;
            changed = true;
            newStates.addAll(strengtheningRes);
        }
        return changed ? ImmutableSet.of((Object)new PowerSetState(newStates)) : ImmutableSet.of();
    }
}

