/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.overflow.OverflowState;
import org.sosy_lab.cpachecker.cpa.predicate.BAMPredicateReducer;
import org.sosy_lab.cpachecker.cpa.predicate.BlockFormulaStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.java_smt.api.BooleanFormula;

public final class BAMBlockFormulaStrategy
extends BlockFormulaStrategy {
    private final PathFormulaManager pfmgr;

    public BAMBlockFormulaStrategy(PathFormulaManager pPfmgr) {
        this.pfmgr = pPfmgr;
    }

    @Override
    BlockFormulaStrategy.BlockFormulas getFormulasForPath(ARGState pRoot, List<ARGState> pPath) throws CPATransferException, InterruptedException {
        HashMap<ARGState, ARGState> callStacks = new HashMap<ARGState, ARGState>();
        HashMap<ARGState, PathFormula> finishedFormulas = new HashMap<ARGState, PathFormula>();
        ImmutableList.Builder abstractionFormulas = ImmutableList.builder();
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        ImmutableMap.Builder branchingFormulas = ImmutableMap.builder();
        assert (pRoot.getParents().isEmpty()) : "rootState must be the first state of the program";
        callStacks.put(pRoot, null);
        finishedFormulas.put(pRoot, this.pfmgr.makeEmptyPathFormula());
        waitlist.addAll(pRoot.getChildren());
        while (!waitlist.isEmpty()) {
            PathFormula currentFormula;
            ARGState currentState = (ARGState)waitlist.pollFirst();
            if (finishedFormulas.containsKey(currentState)) continue;
            if (!finishedFormulas.keySet().containsAll(currentState.getParents())) {
                waitlist.addLast(currentState);
                continue;
            }
            ArrayList<PathFormula> currentFormulas = new ArrayList<PathFormula>(currentState.getParents().size());
            ArrayList<ARGState> currentStacks = new ArrayList<ARGState>(currentState.getParents().size());
            for (ARGState parentElement : currentState.getParents()) {
                ARGState prevCallState;
                boolean isSingleEdge;
                PathFormula parentFormula = (PathFormula)finishedFormulas.get(parentElement);
                List<CFAEdge> edges = parentElement.getEdgesToChild(currentState);
                assert (!edges.isEmpty()) : "ARG is invalid: parent has no edge to child";
                boolean bl = isSingleEdge = edges.size() == 1;
                if (isSingleEdge && ((CFAEdge)Iterables.getOnlyElement(edges)).getEdgeType() == CFAEdgeType.FunctionCallEdge) {
                    prevCallState = parentElement;
                } else if (isSingleEdge && ((CFAEdge)Iterables.getOnlyElement(edges)).getEdgeType() == CFAEdgeType.FunctionReturnEdge) {
                    assert (callStacks.containsKey(parentElement));
                    ARGState callState = (ARGState)callStacks.get(parentElement);
                    assert (Objects.equals(AbstractStates.extractLocation(callState).getLeavingSummaryEdge().getSuccessor(), AbstractStates.extractLocation(currentState))) : "callstack does not match entry of current function-exit.";
                    assert (callState != null || currentState.getChildren().isEmpty()) : "returning from empty callstack is only possible at program-exit";
                    prevCallState = (ARGState)callStacks.get(callState);
                    parentFormula = BAMBlockFormulaStrategy.rebuildStateAfterFunctionCall(parentFormula, (PathFormula)finishedFormulas.get(callState), (FunctionExitNode)AbstractStates.extractLocation(parentElement));
                } else {
                    assert (callStacks.containsKey(parentElement));
                    prevCallState = (ARGState)callStacks.get(parentElement);
                }
                PathFormula currentFormula2 = this.strengthen(parentElement, parentFormula);
                for (CFAEdge edge : edges) {
                    currentFormula2 = this.pfmgr.makeAnd(currentFormula2, edge);
                    if (edge.getEdgeType() != CFAEdgeType.AssumeEdge) continue;
                    PathFormula f = this.pfmgr.makeEmptyPathFormulaWithContextFrom(parentFormula);
                    f = this.pfmgr.makeAnd(f, edge);
                    Pair<ARGState, CFAEdge> key = Pair.of(parentElement, edge);
                    branchingFormulas.put(key, (Object)f);
                }
                currentFormulas.add(currentFormula2);
                currentStacks.add(prevCallState);
            }
            assert (currentFormulas.size() >= 1) : "each state except root must have parents";
            assert (currentStacks.size() == currentFormulas.size()) : "number of callstacks must match predecessors";
            assert (new HashSet(currentStacks).size() <= 1) : "function with multiple entry-states not supported";
            callStacks.put(currentState, (ARGState)currentStacks.get(0));
            PredicateAbstractState predicateElement = PredicateAbstractState.getPredicateState(currentState);
            if (predicateElement.isAbstractionState()) {
                assert (waitlist.isEmpty()) : "todo should be empty, because of the special ARG structure";
                assert (currentState.getParents().size() == 1) : "there should be only one parent, because of the special ARG structure";
                currentFormula = (PathFormula)Iterables.getOnlyElement(currentFormulas);
                BooleanFormula bFormula = this.pfmgr.addBitwiseAxiomsIfNeeded(currentFormula.getFormula(), currentFormula.getFormula());
                abstractionFormulas.add((Object)bFormula);
                currentFormula = this.pfmgr.makeEmptyPathFormulaWithContextFrom(currentFormula);
            } else {
                Iterator it = currentFormulas.iterator();
                currentFormula = (PathFormula)it.next();
                while (it.hasNext()) {
                    currentFormula = this.pfmgr.makeOr(currentFormula, (PathFormula)it.next());
                }
            }
            assert (!finishedFormulas.containsKey(currentState)) : "a state should only be finished once";
            finishedFormulas.put(currentState, currentFormula);
            waitlist.addAll(currentState.getChildren());
        }
        return new BlockFormulaStrategy.BlockFormulas((List<BooleanFormula>)abstractionFormulas.build(), (Map<Pair<ARGState, CFAEdge>, PathFormula>)branchingFormulas.buildOrThrow());
    }

    private PathFormula strengthen(ARGState currentState, PathFormula currentFormula) throws CPATransferException, InterruptedException {
        OverflowState other = AbstractStates.extractStateByType(currentState, OverflowState.class);
        if (other != null) {
            for (CExpression assumption : Iterables.filter(other.getAssumptions(), CExpression.class)) {
                currentFormula = this.pfmgr.makeAnd(currentFormula, assumption);
            }
        }
        return currentFormula;
    }

    public static PathFormula rebuildStateAfterFunctionCall(PathFormula parentFormula, PathFormula rootFormula, FunctionExitNode functionExitNode) {
        SSAMap newSSA = BAMPredicateReducer.updateIndices(rootFormula.getSsa(), parentFormula.getSsa(), functionExitNode);
        return parentFormula.withContext(newSSA, parentFormula.getPointerTargetSet());
    }
}

