/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Preconditions;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.util.predicates.BlockOperator;

@Options
public class BAMBlockOperator
extends BlockOperator {
    private BlockPartitioning partitioning = null;

    void setPartitioning(BlockPartitioning pPartitioning) {
        Preconditions.checkState((this.partitioning == null ? 1 : 0) != 0);
        this.partitioning = pPartitioning;
    }

    @Override
    public boolean isBlockEnd(CFANode loc, int thresholdValue) {
        return super.isBlockEnd(loc, thresholdValue) || this.partitioning.isCallNode(loc) || this.partitioning.isReturnNode(loc);
    }

    @Override
    public boolean alwaysReturnsFalse() {
        return super.alwaysReturnsFalse() && this.partitioning.getBlocks().isEmpty();
    }

    public BlockPartitioning getPartitioning() {
        Preconditions.checkState((this.partitioning != null ? 1 : 0) != 0);
        return this.partitioning;
    }
}

