/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.GenericReducer;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.predicate.BAMPredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.pathformula.FreshValueProvider;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="cpa.predicate.bam")
public class BAMPredicateReducer
extends GenericReducer<PredicateAbstractState, PredicatePrecision> {
    private final PathFormulaManager pmgr;
    private final PredicateAbstractionManager pamgr;
    private final LogManager logger;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManager bfmgr;
    private final RegionManager rmgr;
    private final ShutdownNotifier shutdownNotifier;
    private final Set<String> addressedVariables;
    private final Map<BooleanFormula, Set<String>> variableCache = new HashMap<BooleanFormula, Set<String>>();
    @Option(description="Enable/disable precision reduction at the BAM block entry", secure=true)
    private boolean usePrecisionReduction = true;
    @Option(description="Enable/disable abstraction reduction at the BAM block entry", secure=true)
    private boolean useAbstractionReduction = true;

    public BAMPredicateReducer(BAMPredicateCPA cpa, Configuration pConfig) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.pmgr = cpa.getPathFormulaManager();
        this.pamgr = cpa.getPredicateManager();
        this.fmgr = cpa.getSolver().getFormulaManager();
        this.bfmgr = cpa.getSolver().getFormulaManager().getBooleanFormulaManager();
        this.rmgr = cpa.getAbstractionManager().getRegionCreator();
        this.logger = cpa.getLogger();
        this.shutdownNotifier = cpa.getShutdownNotifier();
        this.addressedVariables = cpa.getCfa().getVarClassification().orElseThrow().getAddressedVariables();
    }

    @Override
    public PredicateAbstractState getVariableReducedState0(PredicateAbstractState predicateElement, Block pContext, CFANode pLocation) throws InterruptedException {
        PathFormula pathFormula = predicateElement.getPathFormula();
        PersistentMap abstractionLocations = predicateElement.getAbstractionLocationsOnPath().empty();
        Preconditions.checkState((boolean)predicateElement.isAbstractionState());
        Preconditions.checkState((boolean)this.bfmgr.isTrue(pathFormula.getFormula()));
        AbstractionFormula abstraction = predicateElement.getAbstractionFormula();
        if (this.useAbstractionReduction) {
            Region reducedAbstraction = this.splitAbstractionForReduction(abstraction.asRegion(), pContext).getFirst();
            abstraction = this.pamgr.makeAbstractionFormula(reducedAbstraction, pathFormula.getSsa(), abstraction.getBlockFormula());
        }
        return PredicateAbstractState.mkAbstractionState(pathFormula, abstraction.copyOf(), (PersistentMap<CFANode, Integer>)abstractionLocations);
    }

    private Pair<Region, Region> splitAbstractionForReduction(Region abstraction, Block context) throws InterruptedException {
        Set<AbstractionPredicate> predicates = this.pamgr.extractPredicates(abstraction);
        Sets.SetView irrelevantPredicates = Sets.difference(predicates, this.getRelevantPredicates(context, predicates));
        Region conjunction = this.rmgr.makeTrue();
        for (AbstractionPredicate predicate : irrelevantPredicates) {
            this.shutdownNotifier.shutdownIfNecessary();
            boolean abstractionImpliesPredicate = false;
            try {
                abstractionImpliesPredicate = this.rmgr.entails(abstraction, predicate.getAbstractVariable());
            }
            catch (SolverException e) {
                this.logger.logException(Level.INFO, (Throwable)e, "cannot check implication for predicate, predicate is relevant");
            }
            if (!abstractionImpliesPredicate) continue;
            conjunction = this.rmgr.makeAnd(conjunction, predicate.getAbstractVariable());
            abstraction = this.rmgr.makeExists(abstraction, predicate.getAbstractVariable());
        }
        return Pair.of(abstraction, conjunction);
    }

    private Set<AbstractionPredicate> getRelevantPredicates(Block pContext, Collection<AbstractionPredicate> predicates) throws InterruptedException {
        LinkedHashSet<AbstractionPredicate> relevantPredicates = new LinkedHashSet<AbstractionPredicate>();
        LinkedHashSet<String> relevantVariables = new LinkedHashSet<String>();
        LinkedHashSet<AbstractionPredicate> irrelevantPredicates = new LinkedHashSet<AbstractionPredicate>();
        for (AbstractionPredicate predicate : predicates) {
            Set<String> variables = this.getVariables(predicate);
            if (this.isAnyVariableRelevant(pContext.getVariables(), variables)) {
                relevantPredicates.add(predicate);
                relevantVariables.addAll(variables);
                continue;
            }
            irrelevantPredicates.add(predicate);
        }
        while (!relevantVariables.isEmpty()) {
            this.shutdownNotifier.shutdownIfNecessary();
            LinkedHashSet newRelevantVariables = new LinkedHashSet();
            LinkedHashSet<AbstractionPredicate> newIrrelevantPredicates = new LinkedHashSet<AbstractionPredicate>();
            for (AbstractionPredicate predicate : irrelevantPredicates) {
                Set<String> variables = this.getVariables(predicate);
                if (this.isAnyVariableRelevant(relevantVariables, variables)) {
                    relevantPredicates.add(predicate);
                    newRelevantVariables.addAll(Sets.difference(variables, relevantVariables));
                    continue;
                }
                newIrrelevantPredicates.add(predicate);
            }
            relevantVariables = newRelevantVariables;
            irrelevantPredicates = newIrrelevantPredicates;
        }
        return relevantPredicates;
    }

    private Set<String> getVariables(AbstractionPredicate predicate) {
        BooleanFormula atom = predicate.getSymbolicAtom();
        Set<String> variables = this.variableCache.get(atom);
        if (variables == null) {
            variables = this.fmgr.extractVariableNames((Formula)atom);
            this.variableCache.put(atom, variables);
        }
        return variables;
    }

    private boolean isAnyVariableRelevant(Set<String> relevantVariables, Set<String> newVariables) {
        for (String var : Sets.union(this.addressedVariables, relevantVariables)) {
            if (newVariables.contains(var)) {
                return true;
            }
            for (String variable : newVariables) {
                if (!variable.contains(var)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public PredicateAbstractState getVariableExpandedState0(PredicateAbstractState rootState, Block pReducedContext, PredicateAbstractState reducedState) throws InterruptedException {
        Preconditions.checkState((boolean)reducedState.isAbstractionState());
        Preconditions.checkState((boolean)rootState.isAbstractionState());
        PathFormula pathFormula = reducedState.getPathFormula();
        Preconditions.checkState((boolean)this.bfmgr.isTrue(pathFormula.getFormula()), (String)"Formula should be TRUE, but formula is %s", (Object)pathFormula.getFormula());
        SSAMap ssa = pathFormula.getSsa();
        AbstractionFormula abstractionFormula = reducedState.getAbstractionFormula();
        if (this.useAbstractionReduction) {
            ssa = BAMPredicateReducer.copyMissingIndizes(rootState.getPathFormula().getSsa(), ssa);
            Region removedPredicates = this.splitAbstractionForReduction(rootState.getAbstractionFormula().asRegion(), pReducedContext).getSecond();
            Region expandedAbstraction = this.rmgr.makeAnd(abstractionFormula.asRegion(), removedPredicates);
            abstractionFormula = this.pamgr.makeAbstractionFormula(expandedAbstraction, ssa, abstractionFormula.getBlockFormula());
        }
        PointerTargetSet rootPts = rootState.getPathFormula().getPointerTargetSet();
        PointerTargetSet reducedPts = reducedState.getPathFormula().getPointerTargetSet();
        SSAMap.SSAMapBuilder ssaBuilder = ssa.builder();
        PointerTargetSet newPts = this.pmgr.mergePts(rootPts, reducedPts, ssaBuilder);
        ssa = ssaBuilder.build();
        pathFormula = pathFormula.withContext(ssa, newPts);
        return PredicateAbstractState.mkAbstractionState(pathFormula, abstractionFormula.copyOf(), reducedState.getAbstractionLocationsOnPath());
    }

    @Override
    public Object getHashCodeForState0(PredicateAbstractState state, PredicatePrecision precision) {
        return Pair.of(state.getAbstractionFormula().asRegion(), precision);
    }

    @Override
    public PredicatePrecision getVariableExpandedPrecision0(PredicatePrecision rootPrecision, Block pRootContext, PredicatePrecision reducedPrecision) {
        if (this.usePrecisionReduction) {
            return rootPrecision.mergeWith(reducedPrecision);
        }
        return reducedPrecision;
    }

    @Override
    public Precision getVariableReducedPrecision0(PredicatePrecision pPrecision, Block context) {
        if (this.usePrecisionReduction) {
            assert (pPrecision.getLocationInstancePredicates().isEmpty()) : "TODO: need to handle location-instance-specific predicates in ReducedPredicatePrecision";
            ImmutableSet<AbstractionPredicate> globalPredicates = pPrecision.getGlobalPredicates();
            ImmutableSetMultimap.Builder functionPredicates = ImmutableSetMultimap.builder();
            for (String functionname : pPrecision.getFunctionPredicates().keySet()) {
                if (!context.getFunctions().contains(functionname)) continue;
                functionPredicates.putAll((Object)functionname, (Iterable)pPrecision.getFunctionPredicates().get((Object)functionname));
            }
            ImmutableSetMultimap.Builder localPredicates = ImmutableSetMultimap.builder();
            for (CFANode node : pPrecision.getLocalPredicates().keySet()) {
                if (!context.getNodes().contains(node)) continue;
                localPredicates.putAll((Object)node, pPrecision.getPredicates(node, 0));
            }
            return new PredicatePrecision((Multimap<PredicatePrecision.LocationInstance, AbstractionPredicate>)ImmutableSetMultimap.of(), (Multimap<CFANode, AbstractionPredicate>)localPredicates.build(), (Multimap<String, AbstractionPredicate>)functionPredicates.build(), (Iterable<AbstractionPredicate>)globalPredicates);
        }
        return pPrecision;
    }

    @Override
    public int measurePrecisionDifference0(PredicatePrecision pPrecision, PredicatePrecision pOtherPrecision) {
        return pPrecision.calculateDifferenceTo(pOtherPrecision);
    }

    @Override
    public AbstractState getVariableReducedStateForProofChecking(AbstractState pExpandedState, Block pContext, CFANode pCallNode) {
        return pExpandedState;
    }

    @Override
    public AbstractState getVariableExpandedStateForProofChecking(AbstractState pRootState, Block pReducedContext, AbstractState pReducedState) throws InterruptedException {
        PredicateAbstractState rootState = (PredicateAbstractState)pRootState;
        PredicateAbstractState reducedState = (PredicateAbstractState)pReducedState;
        if (!reducedState.isAbstractionState()) {
            return reducedState;
        }
        AbstractionFormula rootAbstraction = rootState.getAbstractionFormula();
        AbstractionFormula reducedAbstraction = reducedState.getAbstractionFormula();
        rootAbstraction = this.pamgr.asAbstraction(rootAbstraction.asFormula(), rootAbstraction.getBlockFormula());
        reducedAbstraction = this.pamgr.asAbstraction(reducedAbstraction.asFormula(), reducedAbstraction.getBlockFormula());
        PathFormula oldPathFormula = reducedState.getPathFormula();
        SSAMap oldSSA = oldPathFormula.getSsa();
        SSAMap newSSA = BAMPredicateReducer.copyMissingIndizes(rootState.getPathFormula().getSsa(), oldSSA);
        PathFormula newPathFormula = this.pmgr.makeEmptyPathFormulaWithContext(newSSA, PointerTargetSet.emptyPointerTargetSet());
        Region removedPredicates = this.splitAbstractionForReduction(rootAbstraction.asRegion(), pReducedContext).getSecond();
        Region expandedAbstraction = this.rmgr.makeAnd(reducedAbstraction.asRegion(), removedPredicates);
        AbstractionFormula newAbstractionFormula = this.pamgr.makeAbstractionFormula(expandedAbstraction, newSSA, reducedAbstraction.getBlockFormula());
        PersistentMap<CFANode, Integer> abstractionLocations = rootState.getAbstractionLocationsOnPath();
        return PredicateAbstractState.mkAbstractionState(newPathFormula, newAbstractionFormula.copyOf(), abstractionLocations);
    }

    @Override
    public PredicateAbstractState rebuildStateAfterFunctionCall0(PredicateAbstractState rootState, PredicateAbstractState entryState, PredicateAbstractState expandedState, FunctionExitNode exitLocation) {
        Preconditions.checkState((boolean)rootState.isAbstractionState());
        Preconditions.checkState((boolean)entryState.isAbstractionState());
        Preconditions.checkState((boolean)expandedState.isAbstractionState());
        PersistentMap<CFANode, Integer> abstractionLocations = expandedState.getAbstractionLocationsOnPath();
        String calledFunction = exitLocation.getFunctionName();
        PathFormula functionCall = entryState.getAbstractionFormula().getBlockFormula();
        SSAMap entrySsaWithRet = functionCall.getSsa();
        SSAMap.SSAMapBuilder entrySsaWithRetBuilder = entrySsaWithRet.builder();
        SSAMap.SSAMapBuilder summSsa = rootState.getAbstractionFormula().getBlockFormula().getSsa().builder();
        SSAMap expandedSSA = expandedState.getAbstractionFormula().getBlockFormula().getSsa();
        for (String var : expandedSSA.allVariables()) {
            int newIndex;
            CType type = expandedSSA.getType(var);
            if (var.startsWith(calledFunction + "::") && var.endsWith("__param__")) {
                newIndex = entrySsaWithRet.getIndex(var);
                assert (entrySsaWithRet.containsVariable(var)) : "param for function is not used in functioncall";
                entrySsaWithRetBuilder.setIndex(var, type, newIndex);
                BAMPredicateReducer.setFreshValueBasis(summSsa, var, newIndex);
                continue;
            }
            if (exitLocation.getEntryNode().getReturnVariable().isPresent() && exitLocation.getEntryNode().getReturnVariable().get().getQualifiedName().equals(var)) {
                newIndex = Math.max(expandedSSA.getIndex(var), entrySsaWithRetBuilder.getFreshIndex(var));
                entrySsaWithRetBuilder.setIndex(var, type, newIndex);
                summSsa.setIndex(var, type, newIndex);
                continue;
            }
            if (!entrySsaWithRet.containsVariable(var)) {
                newIndex = expandedSSA.getIndex(var);
                entrySsaWithRetBuilder.setIndex(var, type, newIndex);
                summSsa.setIndex(var, type, newIndex);
                continue;
            }
            newIndex = entrySsaWithRetBuilder.getFreshIndex(var);
            entrySsaWithRetBuilder.setIndex(var, type, newIndex);
            BAMPredicateReducer.setFreshValueBasis(summSsa, var, newIndex);
        }
        SSAMap newEntrySsaWithRet = entrySsaWithRetBuilder.build();
        SSAMap newSummSsa = summSsa.build();
        PathFormula functionCallWithSSA = functionCall.withContext(newEntrySsaWithRet, functionCall.getPointerTargetSet());
        PathFormula executedFunction = this.pmgr.makeAnd(functionCallWithSSA, expandedState.getAbstractionFormula().asFormula());
        PathFormula executedFunctionWithSSA = executedFunction.withContext(newSummSsa, executedFunction.getPointerTargetSet());
        PredicateAbstractState rebuildState = PredicateAbstractState.mkNonAbstractionState(executedFunctionWithSSA, rootState.getAbstractionFormula(), abstractionLocations);
        this.logger.log(Level.ALL, new Object[]{"\noldAbs: ", rootState.getAbstractionFormula().asInstantiatedFormula(), "\ncall: ", functionCallWithSSA, "\nsumm: ", expandedState.getAbstractionFormula().asFormula(), "\nexe: ", executedFunction, "\nentrySsaRet", newEntrySsaWithRet, "\nsummSsaRet", newSummSsa});
        return rebuildState;
    }

    private static SSAMap copyMissingIndizes(SSAMap from, SSAMap to) {
        SSAMap.SSAMapBuilder builder = to.builder();
        for (String var : from.allVariables()) {
            if (to.containsVariable(var)) continue;
            builder.setIndex(var, from.getType(var), from.getIndex(var));
        }
        return builder.build();
    }

    static SSAMap updateIndices(SSAMap rootSSA, SSAMap expandedSSA, FunctionExitNode functionExitNode) {
        SSAMap.SSAMapBuilder rootBuilder = rootSSA.builder();
        for (String var : expandedSSA.allVariables()) {
            CType type = expandedSSA.getType(var);
            if (var.contains("::") && !BAMPredicateReducer.isReturnVar(var, functionExitNode)) {
                if (!rootSSA.containsVariable(var)) {
                    rootBuilder.setIndex(var, type, expandedSSA.builder().getFreshIndex(var));
                    continue;
                }
                BAMPredicateReducer.setFreshValueBasis(rootBuilder, var, Math.max(expandedSSA.builder().getFreshIndex(var), rootSSA.getIndex(var)));
                continue;
            }
            rootBuilder.setIndex(var, type, expandedSSA.getIndex(var));
        }
        return rootBuilder.build();
    }

    private static boolean isReturnVar(String var, FunctionExitNode functionExitNode) {
        return functionExitNode.getEntryNode().getReturnVariable().isPresent() && functionExitNode.getEntryNode().getReturnVariable().get().getQualifiedName().equals(var);
    }

    private static void setFreshValueBasis(SSAMap.SSAMapBuilder ssa, String name, int idx) {
        Preconditions.checkArgument((idx > 0 ? 1 : 0) != 0, (String)"Non-positive index %s for variable %s", (int)idx, (Object)name);
        int oldIdx = ssa.getIndex(name);
        Preconditions.checkArgument((idx >= oldIdx ? 1 : 0) != 0, (String)"Non-monotonic SSAMap update for variable %s from %s to %s", (Object)name, (Object)oldIdx, (Object)idx);
        if (idx > oldIdx) {
            PersistentSortedMap newMapping = PathCopyingPersistentTreeMap.of().putAndCopy((Object)name, (Object)idx);
            ssa.mergeFreshValueProviderWith(new FreshValueProvider((PersistentSortedMap<String, Integer>)newMapping));
        }
    }

    @Override
    public boolean canBeUsedInCache0(PredicateAbstractState predicateState) {
        return !predicateState.getPathFormula().getPointerTargetSet().hasEmptyDeferredAllocationsSet();
    }
}

