/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.cpa.arg.ARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.bam.BAMBasedRefiner;
import org.sosy_lab.cpachecker.cpa.predicate.BAMBlockFormulaStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.BAMPredicateAbstractionRefinementStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.BAMPredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPARefinerFactory;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;

public abstract class BAMPredicateRefiner
implements Refiner {
    public static Refiner create(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        return BAMBasedRefiner.forARGBasedRefiner(BAMPredicateRefiner.create0(pCpa), pCpa);
    }

    public static ARGBasedRefiner create0(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        BAMPredicateCPA predicateCpa = CPAs.retrieveCPAOrFail(pCpa, BAMPredicateCPA.class, BAMPredicateRefiner.class);
        Configuration config = predicateCpa.getConfiguration();
        LogManager logger = predicateCpa.getLogger();
        Solver solver = predicateCpa.getSolver();
        PathFormulaManager pfmgr = predicateCpa.getPathFormulaManager();
        BAMBlockFormulaStrategy blockFormulaStrategy = new BAMBlockFormulaStrategy(pfmgr);
        BAMPredicateAbstractionRefinementStrategy strategy = new BAMPredicateAbstractionRefinementStrategy(config, logger, solver, predicateCpa.getPredicateManager());
        return new PredicateCPARefinerFactory(pCpa).setBlockFormulaStrategy(blockFormulaStrategy).create(strategy);
    }
}

