/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.predicate.BlockFormulaStrategy;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;

class BlockFormulaSlicer
extends BlockFormulaStrategy {
    private static final boolean IS_BLANK_EDGE_IMPORTANT = false;
    private final PathFormulaManager pfmgr;

    BlockFormulaSlicer(PathFormulaManager pPfmgr) {
        this.pfmgr = pPfmgr;
    }

    @Override
    BlockFormulaStrategy.BlockFormulas getFormulasForPath(ARGState initialState, List<ARGState> path) throws CPATransferException, InterruptedException {
        ArrayListMultimap importantEdges = ArrayListMultimap.create();
        ArrayList<Set<ARGState>> blocks = new ArrayList<Set<ARGState>>(path.size());
        for (int i = 0; i < path.size(); ++i) {
            ARGState start = i > 0 ? path.get(i - 1) : initialState;
            ARGState end = path.get(i);
            blocks.add(this.getARGStatesOfBlock(start, end));
        }
        assert (path.size() == blocks.size());
        Collection<String> importantVars = new LinkedHashSet<String>();
        for (int i = path.size() - 1; i >= 0; --i) {
            ARGState start = i > 0 ? path.get(i - 1) : initialState;
            ARGState end = path.get(i);
            Set block = (Set)blocks.get(i);
            importantVars = this.sliceBlock(start, end, block, importantVars, (Multimap<ARGState, ARGState>)importantEdges);
        }
        PathFormula pf = this.pfmgr.makeEmptyPathFormula();
        ImmutableList.Builder pfs = ImmutableList.builder();
        for (int i = 0; i < path.size(); ++i) {
            ARGState start = i > 0 ? path.get(i - 1) : initialState;
            ARGState end = path.get(i);
            Set block = (Set)blocks.get(i);
            PathFormula oldPf = this.pfmgr.makeEmptyPathFormulaWithContextFrom(pf);
            pf = this.buildFormula(start, end, block, oldPf, (Multimap<ARGState, ARGState>)importantEdges);
            pfs.add((Object)pf.getFormula());
        }
        return new BlockFormulaStrategy.BlockFormulas((List<BooleanFormula>)pfs.build());
    }

    private Set<ARGState> getARGStatesOfBlock(ARGState start, ARGState end) {
        HashSet<ARGState> states = new HashSet<ARGState>();
        states.add(start);
        states.add(end);
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        waitlist.add(end);
        while (!waitlist.isEmpty()) {
            ARGState current = (ARGState)waitlist.removeFirst();
            for (ARGState parent : current.getParents()) {
                if (!states.add(parent)) continue;
                waitlist.add(parent);
            }
        }
        return states;
    }

    private Collection<String> sliceBlock(ARGState start, ARGState end, Set<ARGState> block, Collection<String> importantVars, Multimap<ARGState, ARGState> importantEdges) {
        HashMap s2v = Maps.newHashMapWithExpectedSize((int)block.size());
        HashMultimap s2s = HashMultimap.create((int)block.size(), (int)1);
        LinkedHashSet<ARGState> waitlist = new LinkedHashSet<ARGState>();
        s2v.put(end, importantVars);
        s2s.put((Object)end, (Object)end);
        for (ARGState aRGState : end.getParents()) {
            if (!block.contains(aRGState)) continue;
            waitlist.add(aRGState);
        }
        while (!waitlist.isEmpty()) {
            ARGState current = (ARGState)Iterables.getFirst(waitlist, null);
            waitlist.remove(current);
            assert (!s2v.containsKey(current));
            if (!this.isAllChildrenDone(current, s2v.keySet(), block)) {
                waitlist.add(current);
                continue;
            }
            for (ARGState parent : current.getParents()) {
                if (!block.contains(parent)) continue;
                waitlist.add(parent);
            }
            Collection<String> collection = this.handleEdgesForState(current, s2v, (SetMultimap<ARGState, ARGState>)s2s, block, importantEdges);
            s2v.put(current, collection);
            for (ARGState child : current.getChildren()) {
                if (!block.contains(child) || !this.isAllParentsDone(child, s2v.keySet(), block)) continue;
                s2v.remove(child);
                s2s.removeAll((Object)child);
            }
        }
        return (Collection)s2v.get(start);
    }

    private Collection<String> handleEdgesForState(ARGState current, Map<ARGState, Collection<String>> s2v, SetMultimap<ARGState, ARGState> s2s, Set<ARGState> block, Multimap<ARGState, ARGState> importantEdges) {
        ImmutableList usedChildren = FluentIterable.from(current.getChildren()).filter(Predicates.in(block)).toList();
        assert (!usedChildren.isEmpty()) : "no child for " + current.getStateId();
        if (this.isAssumptionWithSameImpChild((List<ARGState>)usedChildren, current, s2s)) {
            ARGState child1 = (ARGState)usedChildren.get(0);
            s2s.putAll((Object)current, (Iterable)s2s.get((Object)child1));
            return new LinkedHashSet<String>(s2v.get(child1));
        }
        Collection<String> iVars = null;
        for (ARGState child : usedChildren) {
            Collection<String> oldVars = s2v.get(child);
            Collection<String> newVars = child.getParents().size() == 1 ? oldVars : new LinkedHashSet<String>(oldVars);
            CFAEdge edge = current.getEdgeToChild(child);
            boolean isImportant = this.handleEdge(edge, newVars);
            assert (!importantEdges.containsEntry((Object)current, (Object)child));
            if (isImportant) {
                importantEdges.put((Object)current, (Object)child);
                s2s.put((Object)current, (Object)current);
            } else {
                s2s.putAll((Object)current, (Iterable)s2s.get((Object)child));
            }
            if (iVars == null) {
                iVars = newVars;
                continue;
            }
            iVars.addAll(newVars);
        }
        Preconditions.checkNotNull(iVars);
        return iVars;
    }

    private boolean isAssumptionWithSameImpChild(List<ARGState> usedChildren, ARGState current, SetMultimap<ARGState, ARGState> s2s) {
        if (usedChildren.size() == 2) {
            ARGState child1 = usedChildren.get(0);
            ARGState child2 = usedChildren.get(1);
            CFAEdge edge1 = current.getEdgeToChild(child1);
            CFAEdge edge2 = current.getEdgeToChild(child2);
            if (edge1.getEdgeType() == CFAEdgeType.AssumeEdge && edge2.getEdgeType() == CFAEdgeType.AssumeEdge) {
                CAssumeEdge assume1 = (CAssumeEdge)edge1;
                CAssumeEdge assume2 = (CAssumeEdge)edge2;
                return assume1.getExpression() == assume2.getExpression() && assume1.getTruthAssumption() != assume2.getTruthAssumption() && s2s.get((Object)child1).equals(s2s.get((Object)child2));
            }
        }
        return false;
    }

    private boolean handleEdge(CFAEdge edge, Collection<String> importantVars) {
        boolean result;
        switch (edge.getEdgeType()) {
            case DeclarationEdge: {
                result = this.handleDeclaration((CDeclarationEdge)edge, importantVars);
                break;
            }
            case AssumeEdge: {
                result = this.handleAssumption((CAssumeEdge)edge, importantVars);
                break;
            }
            case StatementEdge: {
                result = this.handleStatement((CStatementEdge)edge, importantVars);
                break;
            }
            case ReturnStatementEdge: {
                result = this.handleReturnStatement((CReturnStatementEdge)edge, importantVars);
                break;
            }
            case FunctionReturnEdge: {
                result = this.handleFunctionReturn((CFunctionReturnEdge)edge, importantVars);
                break;
            }
            case FunctionCallEdge: {
                result = this.handleFunctionCall((CFunctionCallEdge)edge, importantVars);
                break;
            }
            case BlankEdge: {
                result = false;
                break;
            }
            default: {
                throw new AssertionError((Object)("unhandled edge: " + edge.getRawStatement()));
            }
        }
        return result;
    }

    private boolean handleDeclaration(CDeclarationEdge edge, Collection<String> importantVars) {
        CDeclaration decl = edge.getDeclaration();
        if (decl instanceof CVariableDeclaration) {
            CVariableDeclaration vdecl = (CVariableDeclaration)decl;
            if (importantVars.remove(vdecl.getQualifiedName())) {
                CInitializer initializer = vdecl.getInitializer();
                if (initializer instanceof CInitializerExpression) {
                    CExpression init = ((CInitializerExpression)initializer).getExpression();
                    CFAUtils.getVariableNamesOfExpression(init).copyInto(importantVars);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean handleAssumption(CAssumeEdge edge, Collection<String> importantVars) {
        CFAUtils.getVariableNamesOfExpression(edge.getExpression()).copyInto(importantVars);
        return true;
    }

    private boolean handleStatement(CStatementEdge edge, Collection<String> importantVars) {
        CStatement statement = edge.getStatement();
        if (statement instanceof CAssignment) {
            return this.handleAssignment((CAssignment)statement, importantVars);
        }
        if (statement instanceof CFunctionCallStatement) {
            return true;
        }
        if (statement instanceof CExpressionStatement) {
            return false;
        }
        throw new AssertionError((Object)("unhandled statement: " + edge.getRawStatement()));
    }

    private boolean handleAssignment(CAssignment statement, Collection<String> importantVars) {
        CLeftHandSide lhs = statement.getLeftHandSide();
        if (lhs instanceof CIdExpression) {
            if (importantVars.remove(((CIdExpression)lhs).getDeclaration().getQualifiedName())) {
                CRightHandSide rhs = statement.getRightHandSide();
                if (rhs instanceof CExpression) {
                    CFAUtils.getVariableNamesOfExpression((CExpression)rhs).copyInto(importantVars);
                    return true;
                }
                if (rhs instanceof CFunctionCallExpression) {
                    return true;
                }
                throw new AssertionError((Object)"unknown class");
            }
            return false;
        }
        return true;
    }

    private boolean handleReturnStatement(CReturnStatementEdge edge, Collection<String> importantVars) {
        if (!edge.asAssignment().isPresent()) {
            return false;
        }
        return this.handleAssignment(edge.asAssignment().orElseThrow(), importantVars);
    }

    private boolean handleFunctionReturn(CFunctionReturnEdge edge, Collection<String> importantVars) {
        CFunctionSummaryEdge fnkCall = edge.getSummaryEdge();
        CFunctionCall call = fnkCall.getExpression();
        if (call instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement cAssignment = (CFunctionCallAssignmentStatement)call;
            CLeftHandSide lhs = cAssignment.getLeftHandSide();
            if (lhs instanceof CIdExpression) {
                Optional<CVariableDeclaration> returnVar;
                if (importantVars.remove(((CIdExpression)lhs).getDeclaration().getQualifiedName()) && (returnVar = edge.getFunctionEntry().getReturnVariable()).isPresent()) {
                    importantVars.add(returnVar.orElseThrow().getQualifiedName());
                    return true;
                }
                return false;
            }
            return true;
        }
        if (call instanceof CFunctionCallStatement) {
            return false;
        }
        throw new AssertionError((Object)("unhandled functionreturn " + call));
    }

    private boolean handleFunctionCall(CFunctionCallEdge edge, Collection<String> importantVars) {
        List<CExpression> args = edge.getArguments();
        List<CParameterDeclaration> params = edge.getSuccessor().getFunctionParameters();
        assert (args.size() >= params.size());
        for (int i = 0; i < params.size(); ++i) {
            if (!importantVars.remove(params.get(i).getQualifiedName())) continue;
            CFAUtils.getVariableNamesOfExpression(args.get(i)).copyInto(importantVars);
        }
        return true;
    }

    private PathFormula buildFormula(ARGState start, ARGState end, Collection<ARGState> block, PathFormula oldPf, Multimap<ARGState, ARGState> importantEdges) throws CPATransferException, InterruptedException {
        HashMap s2f = Maps.newHashMapWithExpectedSize((int)block.size());
        LinkedHashSet<ARGState> waitlist = new LinkedHashSet<ARGState>();
        s2f.put(start, oldPf);
        for (ARGState aRGState : start.getChildren()) {
            if (!block.contains(aRGState)) continue;
            waitlist.add(aRGState);
        }
        while (!waitlist.isEmpty()) {
            ARGState current = (ARGState)Iterables.getFirst(waitlist, null);
            waitlist.remove(current);
            assert (!s2f.containsKey(current));
            if (!this.isAllParentsDone(current, s2f.keySet(), block)) {
                waitlist.add(current);
                continue;
            }
            for (ARGState child : current.getChildren()) {
                if (!block.contains(child)) continue;
                waitlist.add(child);
            }
            PathFormula pathFormula = this.makeFormulaForState(current, s2f, importantEdges);
            s2f.put(current, pathFormula);
            for (ARGState parent : current.getParents()) {
                if (!block.contains(parent) || !this.isAllChildrenDone(parent, s2f.keySet(), block)) continue;
                s2f.remove(parent);
            }
        }
        return (PathFormula)s2f.get(end);
    }

    private PathFormula makeFormulaForState(ARGState current, Map<ARGState, PathFormula> s2f, Multimap<ARGState, ARGState> importantEdges) throws CPATransferException, InterruptedException {
        assert (!current.getParents().isEmpty()) : "no parent for " + current.getStateId();
        ArrayList<PathFormula> pfs = new ArrayList<PathFormula>(current.getParents().size());
        for (ARGState parent : current.getParents()) {
            PathFormula oldPf = s2f.get(parent);
            pfs.add(this.buildFormulaForEdge(parent, current, oldPf, importantEdges));
        }
        PathFormula joined = (PathFormula)pfs.get(0);
        for (int i = 1; i < pfs.size(); ++i) {
            joined = this.pfmgr.makeOr(joined, (PathFormula)pfs.get(i));
        }
        return joined;
    }

    private PathFormula buildFormulaForEdge(ARGState parent, ARGState child, PathFormula oldFormula, Multimap<ARGState, ARGState> importantEdges) throws CPATransferException, InterruptedException {
        if (!importantEdges.containsEntry((Object)parent, (Object)child)) {
            return oldFormula;
        }
        List<CFAEdge> edges = parent.getEdgesToChild(child);
        for (CFAEdge edge : edges) {
            oldFormula = this.pfmgr.makeAnd(oldFormula, edge);
        }
        return oldFormula;
    }

    private boolean isAllChildrenDone(ARGState s, Collection<ARGState> done, Collection<ARGState> subset) {
        for (ARGState child : s.getChildren()) {
            if (!subset.contains(child) || done.contains(child)) continue;
            return false;
        }
        return true;
    }

    private boolean isAllParentsDone(ARGState s, Collection<ARGState> done, Collection<ARGState> subset) {
        for (ARGState parent : s.getParents()) {
            if (!subset.contains(parent) || done.contains(parent)) continue;
            return false;
        }
        return true;
    }

    private static String printFormula(String formula) {
        StringBuilder str = new StringBuilder();
        String IND = "    ";
        int indent = 0;
        int pos = 0;
        boolean closed = false;
        while (pos != -1) {
            int i;
            int open = formula.indexOf(40, pos + 1);
            int close = formula.indexOf(41, pos + 1);
            if (open != -1 && open < close) {
                str.append('\n');
                for (i = 0; i < indent; ++i) {
                    str.append("    ");
                }
                ++indent;
                if (closed) {
                    str.append("    ");
                }
                closed = false;
                str.append(formula.substring(pos, open));
                pos = open;
                continue;
            }
            if (close == -1) break;
            str.append('\n');
            for (i = 0; i < indent; ++i) {
                str.append("    ");
            }
            --indent;
            if (closed) {
                str.append("    ");
            }
            closed = true;
            str.append(formula.substring(pos, close));
            pos = close;
        }
        return str.toString();
    }
}

