/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.predicate.ImpactRefiner;
import org.sosy_lab.cpachecker.cpa.predicate.ImpactUtility;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

public class ImpactGlobalRefiner
implements Refiner,
StatisticsProvider {
    private final LogManager logger;
    private final BooleanFormulaManagerView bfmgr;
    private final Solver solver;
    private final ARGCPA argCpa;
    private final ImpactUtility impact;
    private int refinementCalls = 0;
    private int refinementIterations = 0;
    private int totalNumberOfTargetStates = 0;
    private int pathsRefined = 0;
    private int totalPathLengthToInfeasibility = 0;
    private int totalNumberOfAffectedStates = 0;
    private final Timer totalTime = new Timer();
    private final Timer satCheckTime = new Timer();
    private final Timer getInterpolantTime = new Timer();
    private final Timer coverTime = new Timer();
    private final Timer argUpdate = new Timer();

    private void printStatistics(PrintStream out) {
        if (this.refinementCalls > 0) {
            out.println("Avg. number of iterations per refinement:   " + StatisticsUtils.div(this.refinementIterations, this.refinementCalls));
            out.println("Avg. number of target states per iteration: " + StatisticsUtils.div(this.totalNumberOfTargetStates, this.refinementIterations));
            out.println("Avg. number of refined paths per iteration: " + StatisticsUtils.div(this.pathsRefined, this.refinementIterations));
            out.println("Avg. number of sat checks per iteration:    " + StatisticsUtils.div(this.satCheckTime.getNumberOfIntervals(), this.refinementIterations));
            out.println("Avg. length of refined path (in blocks):    " + StatisticsUtils.div(this.totalPathLengthToInfeasibility, this.pathsRefined));
            out.println("Avg. number of affected states per path:    " + StatisticsUtils.div(this.totalNumberOfAffectedStates, this.pathsRefined));
            out.println();
            out.println("Total time for predicate refinement:  " + this.totalTime);
            out.println("  Refinement sat check:               " + this.satCheckTime);
            out.println("  Interpolant computation:            " + this.getInterpolantTime);
            out.println("  Checking whether itp is new:        " + this.impact.itpCheckTime);
            out.println("  Coverage checks:                    " + this.coverTime);
            out.println("  ARG update:                         " + this.argUpdate);
        }
    }

    public static ImpactGlobalRefiner create(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        PredicateCPA predicateCpa = CPAs.retrieveCPAOrFail(pCpa, PredicateCPA.class, ImpactRefiner.class);
        return new ImpactGlobalRefiner(predicateCpa.getConfiguration(), predicateCpa.getLogger(), (ARGCPA)pCpa, predicateCpa.getSolver(), predicateCpa.getPredicateManager());
    }

    private ImpactGlobalRefiner(Configuration config, LogManager pLogger, ARGCPA pArgCpa, Solver pSolver, PredicateAbstractionManager pPredAbsMgr) throws InvalidConfigurationException {
        this.logger = pLogger;
        this.argCpa = pArgCpa;
        this.solver = pSolver;
        this.bfmgr = this.solver.getFormulaManager().getBooleanFormulaManager();
        this.impact = new ImpactUtility(config, this.solver.getFormulaManager(), pPredAbsMgr);
        if (this.impact.requiresPreviousBlockAbstraction()) {
            throw new InvalidConfigurationException("Computing block abstractionsduring refinement is not supported when using global refinements.");
        }
    }

    @Override
    public boolean performRefinement(ReachedSet pReached) throws CPAException, InterruptedException {
        this.totalTime.start();
        ++this.refinementCalls;
        try {
            ImmutableList targets = FluentIterable.from((Iterable)pReached).filter(AbstractStates::isTargetState).toList();
            assert (!targets.isEmpty());
            do {
                ++this.refinementIterations;
                this.totalNumberOfTargetStates += targets.size();
                boolean successful = this.performRefinement0(pReached, (List<AbstractState>)targets);
                if (successful) continue;
                boolean bl = false;
                return bl;
            } while (!(targets = FluentIterable.from((Iterable)pReached).filter(AbstractStates::isTargetState).toList()).isEmpty());
            boolean bl = true;
            return bl;
        }
        catch (SolverException e) {
            throw new CPAException("Solver Exception", e);
        }
        finally {
            this.totalTime.stop();
        }
    }

    private boolean performRefinement0(ReachedSet pReached, List<AbstractState> targets) throws CPAException, InterruptedException, SolverException {
        this.logger.log(Level.FINE, new Object[]{"Starting refinement for", targets.size(), "elements."});
        HashMap<ARGState, ARGState> predecessors = new HashMap<ARGState, ARGState>();
        HashMultimap successors = HashMultimap.create();
        ArrayDeque<AbstractState> todo = new ArrayDeque<AbstractState>(targets);
        while (!todo.isEmpty()) {
            ARGState currentAbstractionState = (ARGState)todo.removeFirst();
            assert (currentAbstractionState.mayCover());
            ARGState currentState = currentAbstractionState;
            while (!PredicateAbstractState.getPredicateState(currentState = currentState.getParents().iterator().next()).isAbstractionState()) {
            }
            if (!currentState.getParents().isEmpty() && !predecessors.containsKey(currentState)) {
                todo.add(currentState);
            }
            predecessors.put(currentAbstractionState, currentState);
            successors.put((Object)currentState, (Object)currentAbstractionState);
        }
        ARGState root = (ARGState)pReached.getFirstState();
        assert (successors.containsKey((Object)root));
        try (InterpolatingProverEnvironment<?> itpProver = this.solver.newProverEnvironmentWithInterpolation(new SolverContext.ProverOptions[0]);){
            boolean bl = this.performRefinement0(root, (SetMultimap<ARGState, ARGState>)successors, predecessors, pReached, targets, itpProver);
            return bl;
        }
    }

    private <T> boolean performRefinement0(ARGState current, SetMultimap<ARGState, ARGState> successors, Map<ARGState, ARGState> predecessors, ReachedSet pReached, List<AbstractState> targets, InterpolatingProverEnvironment<T> itpProver) throws InterruptedException, SolverException, CPAException {
        ArrayList itpStack = new ArrayList();
        boolean successful = this.step(current, itpStack, successors, predecessors, pReached, targets, itpProver);
        assert (itpStack.isEmpty());
        return successful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> boolean step(ARGState current, List<T> itpStack, SetMultimap<ARGState, ARGState> successors, Map<ARGState, ARGState> predecessors, ReachedSet pReached, List<AbstractState> targets, InterpolatingProverEnvironment<T> itpProver) throws InterruptedException, SolverException, CPAException {
        for (ARGState succ : successors.get((Object)current)) {
            assert (succ.getChildren().isEmpty() == targets.contains(succ));
            assert (succ.mayCover());
            BooleanFormula blockFormula = PredicateAbstractState.getPredicateState(succ).getAbstractionFormula().getBlockFormula().getFormula();
            itpStack.add(itpProver.push(blockFormula));
            try {
                this.satCheckTime.start();
                boolean isUnsat = itpProver.isUnsat();
                this.satCheckTime.stop();
                if (isUnsat) {
                    this.logger.log(Level.FINE, new Object[]{"Found unreachable state", succ});
                    this.performRefinementOnPath(Collections.unmodifiableList(itpStack), succ, predecessors, pReached, itpProver);
                } else {
                    if (targets.contains(succ)) {
                        this.logger.log(Level.FINE, new Object[]{"Found reachable target state", succ});
                        boolean bl = false;
                        return bl;
                    }
                    boolean successful = this.step(succ, itpStack, successors, predecessors, pReached, targets, itpProver);
                    if (!successful) {
                        boolean bl = false;
                        return bl;
                    }
                }
                if (current.mayCover()) continue;
                break;
            }
            finally {
                itpStack.remove(itpStack.size() - 1);
                itpProver.pop();
            }
        }
        return true;
    }

    private <T> void performRefinementOnPath(List<T> itpStack, ARGState unreachableState, Map<ARGState, ARGState> predecessors, ReachedSet reached, InterpolatingProverEnvironment<T> itpProver) throws CPAException, SolverException, InterruptedException {
        assert (!itpStack.isEmpty());
        assert (this.bfmgr.isFalse(itpProver.getInterpolant(itpStack)));
        ++this.pathsRefined;
        this.totalPathLengthToInfeasibility += itpStack.size();
        itpStack = new ArrayList<T>(itpStack);
        ArrayList<ARGState> affectedStates = new ArrayList();
        ARGState currentState = unreachableState;
        do {
            itpStack.remove(itpStack.size() - 1);
            currentState = predecessors.get(currentState);
            if (itpStack.isEmpty()) {
                assert (currentState.getParents().isEmpty());
                assert (this.bfmgr.isTrue(itpProver.getInterpolant(itpStack)));
                break;
            }
            this.getInterpolantTime.start();
            BooleanFormula currentItp = itpProver.getInterpolant(itpStack);
            this.getInterpolantTime.stop();
            if (this.bfmgr.isTrue(currentItp) || this.performRefinementForState(currentItp, currentState)) break;
            affectedStates.add(currentState);
        } while (!itpStack.isEmpty());
        this.totalNumberOfAffectedStates += affectedStates.size();
        affectedStates = Lists.reverse(affectedStates);
        this.finishRefinementOfPath(unreachableState, affectedStates, reached);
    }

    private boolean performRefinementForState(BooleanFormula interpolant, ARGState state) throws SolverException, InterruptedException {
        boolean stateChanged = this.impact.strengthenStateWithInterpolant(interpolant, state, null);
        return !stateChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishRefinementOfPath(ARGState unreachableState, List<ARGState> affectedStates, ReachedSet reached) throws CPAException, InterruptedException {
        ARGReachedSet arg = new ARGReachedSet(reached, this.argCpa);
        this.argUpdate.start();
        for (ARGState w : affectedStates) {
            arg.removeCoverageOf(w);
        }
        arg.removeInfeasiblePartofARG(unreachableState);
        this.argUpdate.stop();
        this.coverTime.start();
        try {
            for (ARGState w : affectedStates) {
                if (!arg.tryToCover(w)) continue;
                break;
            }
        }
        finally {
            this.coverTime.stop();
        }
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(new Statistics(){

            @Override
            public String getName() {
                return "ImpactGlobalRefiner";
            }

            @Override
            public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
                ImpactGlobalRefiner.this.printStatistics(pOut);
            }
        });
    }
}

