/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Preconditions;
import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.predicate.ImpactUtility;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.RefinementStrategy;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverException;

class ImpactRefinementStrategy
extends RefinementStrategy
implements StatisticsProvider {
    private final Stats stats = new Stats();
    private final BooleanFormulaManagerView bfmgr;
    private final PredicateAbstractionManager predAbsMgr;
    private final ImpactUtility impact;
    private AbstractionFormula lastAbstraction = null;

    protected ImpactRefinementStrategy(Configuration config, Solver pSolver, PredicateAbstractionManager pPredAbsMgr) throws InvalidConfigurationException {
        super(pSolver);
        this.bfmgr = pSolver.getFormulaManager().getBooleanFormulaManager();
        this.predAbsMgr = pPredAbsMgr;
        this.impact = new ImpactUtility(config, pSolver.getFormulaManager(), pPredAbsMgr);
    }

    @Override
    protected void startRefinementOfPath() {
        Preconditions.checkState((this.lastAbstraction == null ? 1 : 0) != 0);
        this.lastAbstraction = this.predAbsMgr.makeTrueAbstractionFormula(null);
    }

    @Override
    protected boolean performRefinementForState(BooleanFormula itp, ARGState s) throws SolverException, InterruptedException {
        Preconditions.checkArgument((!this.bfmgr.isTrue(itp) ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.bfmgr.isFalse(itp) ? 1 : 0) != 0);
        boolean stateChanged = this.impact.strengthenStateWithInterpolant(itp, s, this.lastAbstraction);
        this.lastAbstraction = PredicateAbstractState.getPredicateState(s).getAbstractionFormula();
        return !stateChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finishRefinementOfPath(ARGState infeasiblePartOfART, List<ARGState> changedElements, ARGReachedSet pReached, List<ARGState> abstractionStatesTrace, boolean pRepeatedCounterexample) throws CPAException, InterruptedException {
        Preconditions.checkState((this.lastAbstraction != null ? 1 : 0) != 0);
        this.lastAbstraction = null;
        this.stats.argUpdate.start();
        LinkedHashSet<ARGState> alsoAffectedStates = new LinkedHashSet<ARGState>();
        for (ARGState w : changedElements) {
            alsoAffectedStates.addAll(w.getCoveredByThis());
            pReached.removeCoverageOf(w);
        }
        pReached.removeInfeasiblePartofARG(infeasiblePartOfART);
        this.stats.argUpdate.stop();
        this.stats.coverTime.start();
        try {
            for (ARGState w : alsoAffectedStates) {
                if (w.isDestroyed()) continue;
                pReached.tryToCover(w);
            }
            for (ARGState w : changedElements) {
                if (!pReached.tryToCover(w)) continue;
                break;
            }
        }
        finally {
            this.stats.coverTime.stop();
        }
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    private class Stats
    implements Statistics {
        private final Timer coverTime = new Timer();
        private final Timer argUpdate = new Timer();

        private Stats() {
        }

        @Override
        public String getName() {
            return "Impact Refiner";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            out.println("  Computing abstraction of itp:       " + ImpactRefinementStrategy.this.impact.abstractionTime);
            out.println("  Checking whether itp is new:        " + ImpactRefinementStrategy.this.impact.itpCheckTime);
            out.println("  Coverage checks:                    " + this.coverTime);
            out.println("  ARG update:                         " + this.argUpdate);
            out.println();
            out.println("Number of abstractions during refinements:  " + ImpactRefinementStrategy.this.impact.abstractionTime.getNumberOfIntervals());
            ImpactRefinementStrategy.this.printStatistics(out);
        }
    }
}

