/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateStatistics;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.statistics.ThreadSafeTimerContainer;
import org.sosy_lab.java_smt.api.SolverException;

public class PredicateAbstractDomain
implements AbstractDomain {
    private final PredicateAbstractionManager mgr;
    private final boolean symbolicCoverageCheck;
    private final PredicateStatistics statistics;
    private final ThreadSafeTimerContainer.TimerWrapper coverageCheckTimer;
    private final ThreadSafeTimerContainer.TimerWrapper bddCoverageCheckTimer;
    private final ThreadSafeTimerContainer.TimerWrapper symbolicCoverageCheckTimer;

    public PredicateAbstractDomain(PredicateAbstractionManager pPredAbsManager, boolean pSymbolicCoverageCheck, PredicateStatistics pStatistics) {
        this.mgr = pPredAbsManager;
        this.symbolicCoverageCheck = pSymbolicCoverageCheck;
        this.statistics = pStatistics;
        this.coverageCheckTimer = this.statistics.coverageCheckTimer.getNewTimer();
        this.bddCoverageCheckTimer = this.statistics.bddCoverageCheckTimer.getNewTimer();
        this.symbolicCoverageCheckTimer = this.statistics.symbolicCoverageCheckTimer.getNewTimer();
    }

    @Override
    public boolean isLessOrEqual(AbstractState element1, AbstractState element2) throws CPAException, InterruptedException {
        this.coverageCheckTimer.start();
        try {
            PredicateAbstractState e1 = (PredicateAbstractState)element1;
            PredicateAbstractState e2 = (PredicateAbstractState)element2;
            if (e1.isAbstractionState() && e2.isAbstractionState()) {
                this.bddCoverageCheckTimer.start();
                boolean result = this.mgr.checkCoverage(e1.getAbstractionFormula(), e2.getAbstractionFormula());
                this.bddCoverageCheckTimer.stop();
                boolean bl = result;
                return bl;
            }
            if (e2.isAbstractionState()) {
                if (this.symbolicCoverageCheck) {
                    this.symbolicCoverageCheckTimer.start();
                    boolean result = this.mgr.checkCoverage(e1.getAbstractionFormula(), e1.getPathFormula(), e2.getAbstractionFormula());
                    this.symbolicCoverageCheckTimer.stop();
                    boolean bl = result;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            if (e1.isAbstractionState()) {
                boolean bl = false;
                return bl;
            }
            if (e1.getPathFormula().equals(e2.getPathFormula())) {
                boolean bl = true;
                return bl;
            }
            boolean bl = e1.getMergedInto() == e2;
            return bl;
        }
        catch (SolverException e) {
            throw new CPAException("Solver Exception", e);
        }
        finally {
            this.coverageCheckTimer.stop();
        }
    }

    @Override
    public AbstractState join(AbstractState pElement1, AbstractState pElement2) throws CPAException {
        throw new UnsupportedOperationException();
    }
}

