/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collection;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ExpressionTreeReportingState;
import org.sosy_lab.cpachecker.core.interfaces.FormulaReportingState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.core.interfaces.NonMergeableAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Partitionable;
import org.sosy_lab.cpachecker.cpa.arg.Splitable;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public abstract class PredicateAbstractState
implements AbstractState,
Partitionable,
Serializable,
Splitable {
    private static final long serialVersionUID = -265763837277453447L;
    private PathFormula pathFormula;
    private AbstractionFormula abstractionFormula;
    private final transient PersistentMap<CFANode, Integer> abstractionLocations;
    private final AbstractionState previousAbstractionState;

    public static boolean containsAbstractionState(AbstractState state) {
        return AbstractStates.extractStateByType(state, PredicateAbstractState.class).isAbstractionState();
    }

    public static PredicateAbstractState getPredicateState(AbstractState pState) {
        return (PredicateAbstractState)Preconditions.checkNotNull((Object)AbstractStates.extractStateByType(pState, PredicateAbstractState.class));
    }

    public static BooleanFormula getBlockFormula(PredicateAbstractState pState) {
        Preconditions.checkArgument((boolean)pState.isAbstractionState());
        return pState.getAbstractionFormula().getBlockFormula().getFormula();
    }

    public static PredicateAbstractState mkAbstractionState(PathFormula pF, AbstractionFormula pA, PersistentMap<CFANode, Integer> pAbstractionLocations) {
        return new AbstractionState(pF, pA, pAbstractionLocations);
    }

    public static PredicateAbstractState mkAbstractionState(PathFormula pF, AbstractionFormula pA, PersistentMap<CFANode, Integer> pAbstractionLocations, PredicateAbstractState pPreviousAbstractionState) {
        return new AbstractionState(pF, pA, pAbstractionLocations, pPreviousAbstractionState);
    }

    public static PredicateAbstractState mkNonAbstractionStateWithNewPathFormula(PathFormula pF, PredicateAbstractState oldState) {
        return new NonAbstractionState(pF, oldState.getAbstractionFormula(), oldState.getAbstractionLocationsOnPath());
    }

    public static PredicateAbstractState mkNonAbstractionStateWithNewPathFormula(PathFormula pF, PredicateAbstractState oldState, PredicateAbstractState pPreviousAbstractionState) {
        return new NonAbstractionState(pF, oldState.getAbstractionFormula(), oldState.getAbstractionLocationsOnPath(), pPreviousAbstractionState);
    }

    static PredicateAbstractState mkNonAbstractionState(PathFormula pF, AbstractionFormula pA, PersistentMap<CFANode, Integer> pAbstractionLocations) {
        return new NonAbstractionState(pF, pA, pAbstractionLocations);
    }

    static PredicateAbstractState mkInfeasibleDummyState(PathFormula pF, AbstractionFormula pA, PersistentMap<CFANode, Integer> pAbstractionLocations) {
        return new InfeasibleDummyState(pF, pA, pAbstractionLocations);
    }

    private PredicateAbstractState(PathFormula pf, AbstractionFormula a, PersistentMap<CFANode, Integer> pAbstractionLocations) {
        this.pathFormula = pf;
        this.abstractionFormula = a;
        this.abstractionLocations = pAbstractionLocations;
        this.previousAbstractionState = null;
    }

    private PredicateAbstractState(PathFormula pf, AbstractionFormula a, PersistentMap<CFANode, Integer> pAbstractionLocations, PredicateAbstractState pPreviousAbstractionState) {
        this.pathFormula = pf;
        this.abstractionFormula = a;
        this.abstractionLocations = pAbstractionLocations;
        this.previousAbstractionState = (AbstractionState)pPreviousAbstractionState;
    }

    public abstract boolean isAbstractionState();

    PredicateAbstractState getMergedInto() {
        throw new UnsupportedOperationException("Assuming wrong PredicateAbstractStates were merged!");
    }

    void setMergedInto(PredicateAbstractState pMergedInto) {
        throw new UnsupportedOperationException("Merging wrong PredicateAbstractStates!");
    }

    public PersistentMap<CFANode, Integer> getAbstractionLocationsOnPath() {
        return this.abstractionLocations;
    }

    public AbstractionFormula getAbstractionFormula() {
        return this.abstractionFormula;
    }

    public PredicateAbstractState getPreviousAbstractionState() {
        return this.previousAbstractionState;
    }

    public void setAbstraction(AbstractionFormula pAbstractionFormula) {
        if (!this.isAbstractionState()) {
            throw new UnsupportedOperationException("Changing abstraction formula is only supported for abstraction elements");
        }
        this.abstractionFormula = (AbstractionFormula)Preconditions.checkNotNull((Object)pAbstractionFormula);
    }

    public PathFormula getPathFormula() {
        return this.pathFormula;
    }

    protected Object readResolve() {
        if (this instanceof AbstractionState) {
            return new AbstractionState(this.pathFormula, this.abstractionFormula, (PersistentMap<CFANode, Integer>)PathCopyingPersistentTreeMap.of());
        }
        return new NonAbstractionState(this.pathFormula, this.abstractionFormula, (PersistentMap<CFANode, Integer>)PathCopyingPersistentTreeMap.of());
    }

    @Override
    public AbstractState forkWithReplacements(Collection<AbstractState> pReplacementStates) {
        for (AbstractState state : pReplacementStates) {
            if (!(state instanceof PredicateAbstractState)) continue;
            return state;
        }
        return this;
    }

    public static class InfeasibleDummyState
    extends NonAbstractionState
    implements NonMergeableAbstractState,
    Graphable {
        private static final long serialVersionUID = 4845812617465441779L;

        private InfeasibleDummyState(PathFormula pF, AbstractionFormula pA, PersistentMap<CFANode, Integer> pAbstractionLocations) {
            super(pF, pA, pAbstractionLocations);
        }

        @Override
        public String toString() {
            return "Dummy location";
        }

        @Override
        public String toDOTLabel() {
            return this.toString();
        }

        @Override
        public boolean shouldBeHighlighted() {
            return true;
        }
    }

    private static class NonAbstractionState
    extends PredicateAbstractState {
        private static final long serialVersionUID = -6912172362012773999L;
        private transient PredicateAbstractState mergedInto = null;

        private NonAbstractionState(PathFormula pF, AbstractionFormula pA, PersistentMap<CFANode, Integer> pAbstractionLocations) {
            super(pF, pA, pAbstractionLocations);
        }

        private NonAbstractionState(PathFormula pF, AbstractionFormula pA, PersistentMap<CFANode, Integer> pAbstractionLocations, PredicateAbstractState pPreviousAbstractState) {
            super(pF, pA, pAbstractionLocations, pPreviousAbstractState);
        }

        @Override
        public boolean isAbstractionState() {
            return false;
        }

        @Override
        PredicateAbstractState getMergedInto() {
            return this.mergedInto;
        }

        @Override
        void setMergedInto(PredicateAbstractState pMergedInto) {
            Preconditions.checkNotNull((Object)pMergedInto);
            this.mergedInto = pMergedInto;
        }

        @Override
        public Object getPartitionKey() {
            return this.getAbstractionFormula();
        }

        @Override
        public String toString() {
            return "Abstraction location: false";
        }
    }

    private static class AbstractionState
    extends PredicateAbstractState
    implements Graphable,
    FormulaReportingState,
    ExpressionTreeReportingState {
        private static final long serialVersionUID = 8341054099315063986L;
        private transient PredicateAbstractState mergedInto = null;

        private AbstractionState(PathFormula pf, AbstractionFormula pA, PersistentMap<CFANode, Integer> pAbstractionLocations) {
            super(pf, pA, pAbstractionLocations);
        }

        private AbstractionState(PathFormula pf, AbstractionFormula pA, PersistentMap<CFANode, Integer> pAbstractionLocations, PredicateAbstractState pPreviousAbstractState) {
            super(pf, pA, pAbstractionLocations, pPreviousAbstractState);
        }

        @Override
        public Object getPartitionKey() {
            if (this.abstractionFormula.isFalse()) {
                return Boolean.FALSE;
            }
            return null;
        }

        @Override
        public boolean isAbstractionState() {
            return true;
        }

        @Override
        public String toString() {
            return "Abstraction location: true, Abstraction: " + this.abstractionFormula;
        }

        @Override
        public String toDOTLabel() {
            return this.abstractionFormula.toString();
        }

        @Override
        public boolean shouldBeHighlighted() {
            return true;
        }

        @Override
        public BooleanFormula getFormulaApproximation(FormulaManagerView pManager) {
            return this.abstractionFormula.asFormulaFromOtherSolver(pManager);
        }

        @Override
        public ExpressionTree<Object> getFormulaApproximation(FunctionEntryNode pFunctionScope, CFANode pLocation) throws InterruptedException {
            return this.abstractionFormula.asExpressionTree(pLocation);
        }

        @Override
        PredicateAbstractState getMergedInto() {
            return this.mergedInto;
        }

        @Override
        void setMergedInto(PredicateAbstractState pMergedInto) {
            Preconditions.checkNotNull((Object)pMergedInto);
            this.mergedInto = pMergedInto;
        }
    }
}

