/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.predicate.GlobalRefinementStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionRefinementStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="cpa.predicate")
class PredicateAbstractionGlobalRefinementStrategy
extends GlobalRefinementStrategy {
    @Option(secure=true, name="refinement.sharePredicates", description="During refinement, add all new predicates to the precisions of all abstract states in the reached set.")
    private boolean sharePredicates = false;
    @Option(secure=true, name="refinement.global.restartAfterRefinement", description="Do a complete restart (clearing the reached set) after the refinement")
    private boolean restartAfterRefinement = false;
    private boolean atomicPredicates = false;
    protected final LogManager logger;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManagerView bfmgr;
    private final PredicateAbstractionManager predAbsMgr;
    private StatTimer predicateCreation = new StatTimer(StatKind.SUM, "Predicate creation");
    private StatTimer precisionUpdate = new StatTimer(StatKind.SUM, "Precision update");
    private StatTimer argUpdate = new StatTimer(StatKind.SUM, "ARG update");
    private ListMultimap<CFANode, AbstractionPredicate> newPredicates;
    private ARGReachedSet reached;
    private ARGState refinementRoot;

    protected PredicateAbstractionGlobalRefinementStrategy(Configuration config, LogManager pLogger, PredicateAbstractionManager pPredAbsMgr, Solver pSolver) throws InvalidConfigurationException {
        super(pSolver);
        config.inject((Object)this, PredicateAbstractionGlobalRefinementStrategy.class);
        this.logger = pLogger;
        this.fmgr = pSolver.getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.predAbsMgr = pPredAbsMgr;
    }

    @Override
    protected void startRefinementOfPath() {
    }

    @Override
    public void initializeGlobalRefinement() {
        Preconditions.checkState((this.newPredicates == null ? 1 : 0) != 0);
        this.newPredicates = MultimapBuilder.linkedHashKeys().arrayListValues().build();
    }

    @Override
    public boolean performRefinement(ARGReachedSet pReached, List<ARGState> pAbstractionStatesTrace, List<BooleanFormula> pInterpolants, boolean pRepeatedCounterexample) throws CPAException, InterruptedException {
        Preconditions.checkState((this.newPredicates != null ? 1 : 0) != 0, (Object)"#initializeGlobalRefinement has to be called before performing a refinement.");
        if (this.reached == null) {
            this.reached = pReached;
        } else if (this.reached != pReached) {
            throw new IllegalStateException("During global refinement, reached set may not be changed.");
        }
        return super.performRefinement(this.reached, pAbstractionStatesTrace, pInterpolants, pRepeatedCounterexample);
    }

    @Override
    public void updatePrecisionAndARG() throws InterruptedException {
        PredicatePrecision newPrecision = this.computeNewPrecision();
        this.updateARG(newPrecision, this.refinementRoot);
        this.reached = null;
        this.refinementRoot = null;
        this.newPredicates = null;
    }

    @Override
    public void resetGlobalRefinement() {
        this.reached = null;
        this.refinementRoot = null;
        this.newPredicates = null;
    }

    protected void updateARG(PredicatePrecision pNewPrecision, ARGState pRefinementRoot) throws InterruptedException {
        this.argUpdate.start();
        ArrayList<Precision> precisions = new ArrayList<Precision>(2);
        ArrayList<Predicate<? super Precision>> precisionTypes = new ArrayList<Predicate<? super Precision>>(2);
        precisions.add(pNewPrecision);
        precisionTypes.add(Predicates.instanceOf(PredicatePrecision.class));
        UnmodifiableReachedSet unmodifiableReached = this.reached.asReachedSet();
        if (this.isValuePrecisionAvailable(pRefinementRoot)) {
            precisions.add(this.mergeAllValuePrecisionsFromSubgraph(pRefinementRoot, unmodifiableReached));
            precisionTypes.add(VariableTrackingPrecision.isMatchingCPAClass(ValueAnalysisCPA.class));
        }
        this.reached.removeSubtree(pRefinementRoot, precisions, precisionTypes);
        if (this.sharePredicates) {
            this.reached.updatePrecisionGlobally(pNewPrecision, (Predicate<? super Precision>)Predicates.instanceOf(PredicatePrecision.class));
        }
        this.argUpdate.stop();
    }

    private boolean isValuePrecisionAvailable(ARGState root) {
        if (!this.reached.asReachedSet().contains(root)) {
            return false;
        }
        return Precisions.extractPrecisionByType(this.reached.asReachedSet().getPrecision(root), VariableTrackingPrecision.class) != null;
    }

    private VariableTrackingPrecision mergeAllValuePrecisionsFromSubgraph(ARGState pRefinementRoot, UnmodifiableReachedSet pReached) {
        VariableTrackingPrecision rootPrecision = Precisions.extractPrecisionByType(pReached.getPrecision(pRefinementRoot), VariableTrackingPrecision.class);
        Set precisions = Sets.newIdentityHashSet();
        for (ARGState state : ARGUtils.getNonCoveredStatesInSubgraph(pRefinementRoot)) {
            precisions.add(pReached.getPrecision(state));
        }
        for (Precision prec : precisions) {
            rootPrecision = rootPrecision.join(Precisions.extractPrecisionByType(prec, VariableTrackingPrecision.class));
        }
        return rootPrecision;
    }

    @Override
    protected boolean performRefinementForState(BooleanFormula pInterpolant, ARGState pState) throws InterruptedException, SolverException {
        Preconditions.checkState((this.newPredicates != null ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.bfmgr.isTrue(pInterpolant) ? 1 : 0) != 0);
        this.predicateCreation.start();
        this.newPredicates.putAll((Object)AbstractStates.extractLocation(pState), this.convertInterpolant(pInterpolant));
        this.predicateCreation.stop();
        return false;
    }

    private PredicatePrecision computeNewPrecision() {
        UnmodifiableReachedSet unmodifiableReached = this.reached.asReachedSet();
        this.logger.log(Level.FINEST, new Object[]{"Removing everything below", this.refinementRoot, "from ARG."});
        this.precisionUpdate.start();
        PredicatePrecision basePrecision = PredicateAbstractionRefinementStrategy.findAllPredicatesFromSubgraph(this.refinementRoot, unmodifiableReached);
        this.logger.log(Level.ALL, new Object[]{"Old predicate map is", basePrecision});
        this.logger.log(Level.ALL, new Object[]{"New predicates are", this.newPredicates});
        PredicatePrecision newPrecision = basePrecision.addLocalPredicates(this.newPredicates.entries());
        this.logger.log(Level.ALL, new Object[]{"Predicate map now is", newPrecision});
        assert (basePrecision.calculateDifferenceTo(newPrecision) == 0) : "We forgot predicates during refinement!";
        this.precisionUpdate.stop();
        return newPrecision;
    }

    private Collection<AbstractionPredicate> convertInterpolant(BooleanFormula pInterpolant) {
        BooleanFormula interpolant = pInterpolant;
        if (this.bfmgr.isTrue(interpolant)) {
            return ImmutableSet.of();
        }
        ImmutableList preds = this.atomicPredicates ? this.predAbsMgr.getPredicatesForAtomsOf(interpolant) : ImmutableList.of((Object)this.predAbsMgr.getPredicateFor(interpolant));
        assert (!preds.isEmpty()) : "Interpolant without relevant predicates: " + pInterpolant + "; simplified to " + interpolant;
        this.logger.log(Level.FINEST, new Object[]{"Got predicates", preds});
        return preds;
    }

    @Override
    protected void finishRefinementOfPath(ARGState infeasiblePartOfART, List<ARGState> changedElements, ARGReachedSet pReached, List<ARGState> abstractionStatesTrace, boolean pRepeatedCounterexample) throws CPAException, InterruptedException {
        this.newPredicates.put((Object)AbstractStates.extractLocation(infeasiblePartOfART), (Object)this.predAbsMgr.makeFalsePredicate());
        changedElements.add(infeasiblePartOfART);
        if (this.restartAfterRefinement) {
            this.refinementRoot = (ARGState)this.reached.asReachedSet().getFirstState();
        } else if (this.refinementRoot == null) {
            this.refinementRoot = changedElements.get(0);
        } else {
            PathIterator firstPath = ARGUtils.getOnePathTo(this.refinementRoot).pathIterator();
            PathIterator secondPath = ARGUtils.getOnePathTo(changedElements.get(0)).pathIterator();
            while (firstPath.getAbstractState().equals(secondPath.getAbstractState())) {
                this.refinementRoot = firstPath.getAbstractState();
                if (!firstPath.hasNext() || !secondPath.hasNext()) break;
                firstPath.advance();
                secondPath.advance();
            }
        }
    }
}

