/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantSupplier;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackStateEqualsWrapper;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManagerOptions;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionStatistics;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicateAbstractionsStorage;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionCreator;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.predicates.weakening.InductiveWeakeningManager;
import org.sosy_lab.cpachecker.util.predicates.weakening.WeakeningOptions;
import org.sosy_lab.cpachecker.util.statistics.ThreadSafeTimerContainer;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

public class PredicateAbstractionManager {
    private final PredicateAbstractionStatistics stats;
    private final PredicateAbstractionManagerOptions options;
    private final LogManager logger;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManagerView bfmgr;
    private final PredicateAbstractionsStorage abstractionStorage;
    private final AbstractionManager amgr;
    private final RegionCreator rmgr;
    private final PathFormulaManager pfmgr;
    private final Solver solver;
    private final InvariantSupplier invariantSupplier;
    private final @Nullable InductiveWeakeningManager weakeningManager;
    private final ShutdownNotifier shutdownNotifier;
    private static final Set<Integer> noAbstractionReuse = ImmutableSet.of();
    private boolean warnedOfCartesianAbstraction = false;
    private boolean abstractionReuseDisabledBecauseOfAmbiguity = false;
    private final Map<Pair<BooleanFormula, ImmutableSet<BooleanFormula>>, AbstractionFormula> abstractionCache;
    private final Set<BooleanFormula> unsatisfiabilityCache;
    private final Map<Pair<BooleanFormula, AbstractionPredicate>, Byte> cartesianAbstractionCache;
    private final ThreadSafeTimerContainer.TimerWrapper trivialPredicatesTimer;
    private final ThreadSafeTimerContainer.TimerWrapper quantifierEliminationTimer;
    private final ThreadSafeTimerContainer.TimerWrapper abstractionReuseTimer;
    private final ThreadSafeTimerContainer.TimerWrapper abstractionReuseImplicationTimer;
    private final ThreadSafeTimerContainer.TimerWrapper abstractionSolveTimer;
    private final ThreadSafeTimerContainer.TimerWrapper cartesianAbstractionTimer;
    private final ThreadSafeTimerContainer.TimerWrapper booleanAbstractionTimer;
    private final ThreadSafeTimerContainer.TimerWrapper abstractionModelEnumTimer;
    private final ThreadSafeTimerContainer.TimerWrapper abstractionBddConstructionTimer;

    public PredicateAbstractionManager(AbstractionManager pAmgr, PathFormulaManager pPfmgr, Solver pSolver, PredicateAbstractionManagerOptions pOptions, WeakeningOptions weakeningOptions, PredicateAbstractionsStorage pAbstractionStorage, LogManager pLogger, ShutdownNotifier pShutdownNotifier, PredicateAbstractionStatistics pAbstractionStats, InvariantSupplier pInvariantsSupplier) {
        this.shutdownNotifier = pShutdownNotifier;
        this.options = pOptions;
        this.logger = pLogger;
        this.fmgr = pSolver.getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.amgr = pAmgr;
        this.rmgr = this.amgr.getRegionCreator();
        this.pfmgr = pPfmgr;
        this.solver = pSolver;
        this.invariantSupplier = pInvariantsSupplier;
        this.stats = pAbstractionStats;
        if (this.options.isCartesianAbstraction()) {
            this.options.setAbstractionType(AbstractionType.CARTESIAN);
        }
        if (this.options.getAbstractionType() == AbstractionType.COMBINED) {
            this.warnedOfCartesianAbstraction = true;
        }
        this.weakeningManager = this.options.getAbstractionType() == AbstractionType.CARTESIAN_BY_WEAKENING ? new InductiveWeakeningManager(weakeningOptions, pSolver, pLogger, pShutdownNotifier) : null;
        if (this.options.isUseCache()) {
            this.abstractionCache = new HashMap<Pair<BooleanFormula, ImmutableSet<BooleanFormula>>, AbstractionFormula>();
            this.unsatisfiabilityCache = new HashSet<BooleanFormula>();
        } else {
            this.abstractionCache = null;
            this.unsatisfiabilityCache = null;
        }
        this.cartesianAbstractionCache = this.options.isUseCache() && this.options.getAbstractionType() != AbstractionType.BOOLEAN ? new HashMap<Pair<BooleanFormula, AbstractionPredicate>, Byte>() : null;
        this.abstractionStorage = pAbstractionStorage;
        this.trivialPredicatesTimer = this.stats.trivialPredicatesTime.getNewTimer();
        this.quantifierEliminationTimer = this.stats.quantifierEliminationTime.getNewTimer();
        this.abstractionReuseTimer = this.stats.abstractionReuseTime.getNewTimer();
        this.abstractionReuseImplicationTimer = this.stats.abstractionReuseImplicationTime.getNewTimer();
        this.abstractionSolveTimer = this.stats.abstractionSolveTime.getNewTimer();
        this.cartesianAbstractionTimer = this.stats.cartesianAbstractionTime.getNewTimer();
        this.booleanAbstractionTimer = this.stats.booleanAbstractionTime.getNewTimer();
        this.abstractionModelEnumTimer = this.stats.abstractionModelEnumTime.getNewTimer();
        this.abstractionBddConstructionTimer = this.stats.abstractionBddConstructionTime.getNewTimer();
    }

    public AbstractionFormula buildAbstraction(CFANode location, Optional<CallstackStateEqualsWrapper> callstackInformation, BooleanFormula f, PathFormula blockFormula, Collection<AbstractionPredicate> predicates) throws SolverException, InterruptedException {
        PathFormula pf = PathFormula.createManually(f, blockFormula.getSsa(), blockFormula.getPointerTargetSet(), 0);
        AbstractionFormula emptyAbstraction = this.makeTrueAbstractionFormula(null);
        AbstractionFormula newAbstraction = this.buildAbstraction(Collections.singleton(location), callstackInformation, emptyAbstraction, pf, predicates);
        return new AbstractionFormula(this.fmgr, newAbstraction.asRegion(), newAbstraction.asFormula(), newAbstraction.asInstantiatedFormula(), blockFormula, noAbstractionReuse);
    }

    public void clear() {
        if (this.options.isUseCache()) {
            this.abstractionCache.clear();
            this.unsatisfiabilityCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractionFormula buildAbstraction(Collection<CFANode> locations, Optional<CallstackStateEqualsWrapper> callstackInformation, AbstractionFormula abstractionFormula, PathFormula pathFormula, Collection<AbstractionPredicate> pPredicates) throws SolverException, InterruptedException {
        Object result;
        AbstractionFormula reused;
        int currentAbstractionId = this.stats.numCallsAbstraction.getAndIncrement();
        this.logger.log(Level.FINEST, new Object[]{"Computing abstraction", currentAbstractionId, "with", pPredicates.size(), "predicates"});
        this.logger.log(Level.ALL, new Object[]{"Old abstraction:", abstractionFormula.asFormula()});
        this.logger.log(Level.ALL, new Object[]{"Path formula:", pathFormula});
        this.logger.log(Level.ALL, new Object[]{"Predicates:", pPredicates});
        BooleanFormula absFormula = abstractionFormula.asInstantiatedFormula();
        BooleanFormula symbFormula = this.getFormulaFromPathFormula(pathFormula);
        BooleanFormula primaryFormula = this.bfmgr.and(absFormula, symbFormula);
        SSAMap ssa = pathFormula.getSsa();
        if (this.options.getReuseAbstractionsFrom() != null && !this.abstractionReuseDisabledBecauseOfAmbiguity && (reused = this.reuseAbstractionIfPossible(abstractionFormula, pathFormula, primaryFormula, (CFANode)Iterables.getOnlyElement(locations))) != null) {
            return reused;
        }
        if (pPredicates.isEmpty() && this.options.getAbstractionType() != AbstractionType.ELIMINATION) {
            this.logger.log(Level.FINEST, new Object[]{"Abstraction", currentAbstractionId, "with empty precision is true"});
            this.stats.numSymbolicAbstractions.incrementAndGet();
            return this.makeTrueAbstractionFormula(pathFormula);
        }
        java.util.function.Function<BooleanFormula, BooleanFormula> instantiator = pred -> this.fmgr.instantiate(pred, ssa);
        Collection<AbstractionPredicate> remainingPredicates = this.getRelevantPredicates(pPredicates, primaryFormula, instantiator);
        if (this.fmgr.useBitwiseAxioms()) {
            for (AbstractionPredicate predicate : remainingPredicates) {
                primaryFormula = this.pfmgr.addBitwiseAxiomsIfNeeded(primaryFormula, predicate.getSymbolicAtom());
            }
        }
        BooleanFormula f = primaryFormula;
        Pair<BooleanFormula, ImmutableSet> absKey = null;
        if (this.options.isUseCache()) {
            boolean unsatisfiable;
            ImmutableSet instantiatedPreds = Collections3.transformedImmutableSetCopy(remainingPredicates, pred -> (BooleanFormula)instantiator.apply(pred.getSymbolicAtom()));
            absKey = Pair.of(f, instantiatedPreds);
            result = this.abstractionCache.get(absKey);
            if (result != null) {
                BooleanFormula stateFormula = ((AbstractionFormula)result).asFormula();
                BooleanFormula instantiatedFormula = this.fmgr.instantiate(stateFormula, ssa);
                result = new AbstractionFormula(this.fmgr, ((AbstractionFormula)result).asRegion(), stateFormula, instantiatedFormula, pathFormula, (Set<Integer>)((AbstractionFormula)result).getIdsOfStoredAbstractionReused());
                this.logger.log(Level.FINEST, new Object[]{"Abstraction", currentAbstractionId, "was cached"});
                this.logger.log(Level.ALL, new Object[]{"Abstraction result is", ((AbstractionFormula)result).asFormula()});
                this.stats.numCallsAbstractionCached.incrementAndGet();
                return result;
            }
            boolean bl = unsatisfiable = this.unsatisfiabilityCache.contains(symbFormula) || this.unsatisfiabilityCache.contains(f);
            if (unsatisfiable) {
                this.logger.log(Level.FINEST, new Object[]{"Block feasibility of abstraction", currentAbstractionId, "was cached and is false."});
                this.stats.numCallsAbstractionCached.incrementAndGet();
                return new AbstractionFormula(this.fmgr, this.rmgr.makeFalse(), this.bfmgr.makeFalse(), this.bfmgr.makeFalse(), pathFormula, noAbstractionReuse);
            }
        }
        Region abs = this.rmgr.makeTrue();
        if (this.options.isIdentifyTrivialPredicates()) {
            this.trivialPredicatesTimer.start();
            abs = this.handleTrivialPredicates(remainingPredicates, abstractionFormula, pathFormula);
            this.trivialPredicatesTimer.stop();
        }
        if (this.invariantSupplier != InvariantSupplier.TrivialInvariantSupplier.INSTANCE) {
            for (CFANode location : locations) {
                BooleanFormula invariant = this.invariantSupplier.getInvariantFor(location, callstackInformation, this.fmgr, this.pfmgr, pathFormula);
                if (this.bfmgr.isTrue(invariant)) continue;
                AbstractionPredicate absPred = this.amgr.makePredicate(invariant);
                abs = this.rmgr.makeAnd(abs, absPred.getAbstractVariable());
                Iterables.removeIf(remainingPredicates, (Predicate)Predicates.equalTo((Object)absPred));
            }
        }
        if (this.options.getAbstractionType() == AbstractionType.ELIMINATION) {
            this.quantifierEliminationTimer.start();
            try {
                BooleanFormula eliminationResult = this.fmgr.uninstantiate(this.fmgr.eliminateDeadVariables(f, ssa));
                abs = this.rmgr.makeAnd(abs, this.amgr.convertFormulaToRegion(eliminationResult));
            }
            finally {
                this.quantifierEliminationTimer.stop();
            }
        } else {
            abs = this.options.getAbstractionType() == AbstractionType.CARTESIAN_BY_WEAKENING ? this.rmgr.makeAnd(abs, this.buildCartesianAbstractionUsingWeakening(f, ssa, remainingPredicates)) : this.rmgr.makeAnd(abs, this.computeAbstraction(f, remainingPredicates, instantiator));
        }
        result = this.makeAbstractionFormula(abs, ssa, pathFormula);
        if (this.options.isUseCache()) {
            this.abstractionCache.put(absKey, (AbstractionFormula)result);
            if (((AbstractionFormula)result).isFalse()) {
                this.unsatisfiabilityCache.add(f);
            }
        }
        long abstractionTime = TimeSpan.sum((TimeSpan)this.abstractionSolveTimer.getLengthOfLastInterval(), (TimeSpan)this.abstractionModelEnumTimer.getLengthOfLastInterval()).asMillis();
        this.logger.log(Level.FINEST, new Object[]{"Computing abstraction took", abstractionTime, "ms"});
        this.logger.log(Level.ALL, new Object[]{"Abstraction result is", ((AbstractionFormula)result).asFormula()});
        if (this.options.isDumpHardAbstractions() && abstractionTime > 10000L) {
            this.dumpAbstractionProblem(f, pPredicates, (AbstractionFormula)result, currentAbstractionId);
        }
        return result;
    }

    public BooleanFormula computeAbstraction(BooleanFormula pF, Collection<AbstractionPredicate> pPredicates) throws InterruptedException, SolverException {
        this.stats.numCallsAbstraction.getAndIncrement();
        if (pPredicates.isEmpty()) {
            this.stats.numSymbolicAbstractions.incrementAndGet();
            return this.bfmgr.makeTrue();
        }
        if (this.unsatisfiabilityCache.contains(pF)) {
            this.stats.numCallsAbstractionCached.incrementAndGet();
            return this.bfmgr.makeFalse();
        }
        Function dummyInstantiator = Functions.identity();
        Collection<AbstractionPredicate> predicates = this.getRelevantPredicates(pPredicates, pF, (java.util.function.Function<BooleanFormula, BooleanFormula>)dummyInstantiator);
        Region abs = this.computeAbstraction(pF, predicates, (java.util.function.Function<BooleanFormula, BooleanFormula>)dummyInstantiator);
        BooleanFormula symbolicAbs = this.amgr.convertRegionToFormula(abs);
        if (this.options.isSimplifyAbstractionFormula()) {
            symbolicAbs = this.fmgr.simplify(symbolicAbs);
        }
        if (this.bfmgr.isFalse(symbolicAbs)) {
            this.unsatisfiabilityCache.add(pF);
        }
        return symbolicAbs;
    }

    private BooleanFormula getFormulaFromPathFormula(PathFormula pathFormula) {
        BooleanFormula symbFormula = pathFormula.getFormula();
        return this.pfmgr.addBitwiseAxiomsIfNeeded(symbFormula, symbFormula);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable AbstractionFormula reuseAbstractionIfPossible(AbstractionFormula abstractionFormula, PathFormula pathFormula, BooleanFormula f, CFANode location) throws SolverException, InterruptedException {
        this.abstractionReuseTimer.start();
        try (ProverEnvironment reuseEnv = this.solver.newProverEnvironment(new SolverContext.ProverOptions[0]);){
            reuseEnv.push(f);
            ArrayDeque<Pair<Integer, Integer>> tryReuseBasedOnPredecessors = new ArrayDeque<Pair<Integer, Integer>>();
            ImmutableSet<Integer> idsOfStoredAbstractionReused = abstractionFormula.getIdsOfStoredAbstractionReused();
            for (Integer id : idsOfStoredAbstractionReused) {
                tryReuseBasedOnPredecessors.add(Pair.of(id, 0));
            }
            if (tryReuseBasedOnPredecessors.isEmpty()) {
                tryReuseBasedOnPredecessors.add(Pair.of(this.abstractionStorage.getRootAbstractionId(), 0));
            }
            while (true) {
                if (!tryReuseBasedOnPredecessors.isEmpty()) {
                    Pair tryBasedOn = (Pair)tryReuseBasedOnPredecessors.pop();
                    int tryBasedOnAbstractionId = (Integer)tryBasedOn.getFirst();
                    int tryLevel = (Integer)tryBasedOn.getSecond();
                    if (tryLevel > this.options.getMaxAbstractionReusePrescan()) continue;
                    Set<PredicateAbstractionsStorage.AbstractionNode> candidateAbstractions = this.abstractionStorage.getSuccessorAbstractions(tryBasedOnAbstractionId);
                    Preconditions.checkNotNull(candidateAbstractions);
                    Iterator<PredicateAbstractionsStorage.AbstractionNode> candidateIterator = candidateAbstractions.iterator();
                    while (candidateIterator.hasNext()) {
                        PredicateAbstractionsStorage.AbstractionNode an = candidateIterator.next();
                        Preconditions.checkNotNull((Object)an);
                        tryReuseBasedOnPredecessors.add(Pair.of(an.getId(), tryLevel + 1));
                        if (this.bfmgr.isTrue(an.getFormula())) {
                            candidateIterator.remove();
                            continue;
                        }
                        if (!an.getLocationId().isPresent() || location.getNodeNumber() == an.getLocationId().orElseThrow()) continue;
                        candidateIterator.remove();
                    }
                    if (candidateAbstractions.size() > 1) {
                        this.logger.log(Level.WARNING, new Object[]{"Too many abstraction candidates on location", location, "for abstraction", tryBasedOnAbstractionId, ". Disabling abstraction reuse!"});
                        this.abstractionReuseDisabledBecauseOfAmbiguity = true;
                        tryReuseBasedOnPredecessors.clear();
                        continue;
                    }
                    if (candidateAbstractions.isEmpty()) continue;
                    TreeSet<Integer> reuseIds = new TreeSet<Integer>();
                    BooleanFormula reuseFormula = this.bfmgr.makeTrue();
                    for (PredicateAbstractionsStorage.AbstractionNode an : candidateAbstractions) {
                        reuseFormula = this.bfmgr.and(reuseFormula, an.getFormula());
                        this.abstractionStorage.markAbstractionBeingReused(an.getId());
                        reuseIds.add(an.getId());
                    }
                    BooleanFormula instantiatedReuseFormula = this.fmgr.instantiate(reuseFormula, pathFormula.getSsa());
                    this.abstractionReuseImplicationTimer.start();
                    reuseEnv.push(this.bfmgr.not(instantiatedReuseFormula));
                    boolean implication = reuseEnv.isUnsat();
                    reuseEnv.pop();
                    this.abstractionReuseImplicationTimer.stop();
                    if (!implication) continue;
                    this.stats.numAbstractionReuses.incrementAndGet();
                    Region reuseFormulaRegion = this.amgr.convertFormulaToRegion(reuseFormula);
                    AbstractionFormula abstractionFormula2 = new AbstractionFormula(this.fmgr, reuseFormulaRegion, reuseFormula, instantiatedReuseFormula, pathFormula, reuseIds);
                    return abstractionFormula2;
                    continue;
                }
                break;
            }
        }
        finally {
            this.abstractionReuseTimer.stop();
        }
        return null;
    }

    private Collection<AbstractionPredicate> getRelevantPredicates(Collection<AbstractionPredicate> pPredicates, BooleanFormula f, java.util.function.Function<BooleanFormula, BooleanFormula> instantiator) {
        Set<String> variables = this.fmgr.extractVariableNames((Formula)f);
        LinkedList<AbstractionPredicate> relevantPredicates = new LinkedList<AbstractionPredicate>();
        for (AbstractionPredicate predicate : pPredicates) {
            BooleanFormula predicateTerm = predicate.getSymbolicAtom();
            if (this.bfmgr.isFalse(predicateTerm)) {
                this.logger.log(Level.FINEST, new Object[]{"Ignoring predicate 'false'"});
                continue;
            }
            BooleanFormula instantiatedPredicate = instantiator.apply(predicateTerm);
            Set<String> predVariables = this.fmgr.extractVariableNames((Formula)instantiatedPredicate);
            if (predVariables.isEmpty() || !Sets.intersection(predVariables, variables).isEmpty()) {
                relevantPredicates.add(predicate);
                continue;
            }
            this.logger.log(Level.FINEST, new Object[]{"Ignoring predicate about variables", predVariables});
        }
        this.stats.numTotalPredicates.addAndGet(pPredicates.size());
        this.stats.maxPredicates.accumulateAndGet(pPredicates.size(), Math::max);
        this.stats.numIrrelevantPredicates.addAndGet(pPredicates.size() - relevantPredicates.size());
        return relevantPredicates;
    }

    private Region handleTrivialPredicates(Collection<AbstractionPredicate> pPredicates, AbstractionFormula pOldAbs, PathFormula pBlockFormula) throws SolverException, InterruptedException {
        SSAMap ssa = pBlockFormula.getSsa();
        Set<String> blockVariables = this.fmgr.extractVariableNames((Formula)pBlockFormula.getFormula());
        Region oldAbs = pOldAbs.asRegion();
        RegionManager regionCreator = this.amgr.getRegionCreator();
        Region region = regionCreator.makeTrue();
        Iterator<AbstractionPredicate> predicateIt = pPredicates.iterator();
        while (predicateIt.hasNext()) {
            AbstractionPredicate predicate = predicateIt.next();
            BooleanFormula predicateTerm = predicate.getSymbolicAtom();
            BooleanFormula instantiatedPredicate = this.fmgr.instantiate(predicateTerm, ssa);
            Set<String> predVariables = this.fmgr.extractVariableNames((Formula)instantiatedPredicate);
            if (!Sets.intersection(predVariables, blockVariables).isEmpty()) continue;
            Region predicateVar = predicate.getAbstractVariable();
            if (this.amgr.entails(oldAbs, predicateVar)) {
                region = regionCreator.makeAnd(region, predicateVar);
                predicateIt.remove();
                this.stats.numTrivialPredicates.incrementAndGet();
                this.logger.log(Level.FINEST, new Object[]{"Predicate", predicate, "is unconditionally true in old abstraction and can be copied to the result."});
                continue;
            }
            Region negatedPredicateVar = regionCreator.makeNot(predicateVar);
            if (this.amgr.entails(oldAbs, negatedPredicateVar)) {
                region = regionCreator.makeAnd(region, negatedPredicateVar);
                predicateIt.remove();
                this.stats.numTrivialPredicates.incrementAndGet();
                this.logger.log(Level.FINEST, new Object[]{"Negation of predicate", predicate, "is unconditionally true in old abstraction and can be copied to the result."});
                continue;
            }
            this.logger.log(Level.FINEST, new Object[]{"Predicate", predicate, "is relevant because it appears in the old abstraction."});
        }
        assert (this.amgr.entails(oldAbs, region));
        return region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Region computeAbstraction(BooleanFormula f, Collection<AbstractionPredicate> remainingPredicates, java.util.function.Function<BooleanFormula, BooleanFormula> instantiator) throws SolverException, InterruptedException {
        Region abs;
        block19: {
            abs = this.rmgr.makeTrue();
            try (ProverEnvironment thmProver = this.solver.newProverEnvironment(SolverContext.ProverOptions.GENERATE_ALL_SAT);){
                thmProver.push(f);
                if (remainingPredicates.isEmpty()) {
                    boolean feasibility;
                    this.stats.numSatCheckAbstractions.incrementAndGet();
                    this.abstractionSolveTimer.start();
                    try {
                        feasibility = !thmProver.isUnsat();
                    }
                    finally {
                        this.abstractionSolveTimer.stop();
                    }
                    if (!feasibility) {
                        abs = this.rmgr.makeFalse();
                    }
                    break block19;
                }
                if (this.options.getAbstractionType() != AbstractionType.BOOLEAN) {
                    this.cartesianAbstractionTimer.start();
                    try {
                        abs = this.rmgr.makeAnd(abs, this.computeCartesianAbstraction(f, thmProver, remainingPredicates, instantiator));
                    }
                    finally {
                        this.cartesianAbstractionTimer.stop();
                    }
                }
                if (this.options.getAbstractionType() == AbstractionType.CARTESIAN || remainingPredicates.isEmpty()) break block19;
                this.stats.numBooleanAbsPredicates.addAndGet(remainingPredicates.size());
                this.booleanAbstractionTimer.start();
                try {
                    abs = this.rmgr.makeAnd(abs, this.computeBooleanAbstraction(thmProver, remainingPredicates, instantiator));
                }
                finally {
                    this.booleanAbstractionTimer.stop();
                }
            }
        }
        return abs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Region computeCartesianAbstraction(BooleanFormula f, ProverEnvironment thmProver, Collection<AbstractionPredicate> pPredicates, java.util.function.Function<BooleanFormula, BooleanFormula> instantiator) throws SolverException, InterruptedException {
        this.abstractionSolveTimer.start();
        boolean feasibility = !thmProver.isUnsat();
        this.abstractionSolveTimer.stop();
        if (!feasibility) {
            return this.rmgr.makeFalse();
        }
        if (!this.warnedOfCartesianAbstraction && !this.fmgr.isPurelyConjunctive(f)) {
            this.logger.log(Level.WARNING, new Object[]{"Using cartesian abstraction when formulas contain disjunctions may be imprecise. This might lead to failing refinements."});
            this.warnedOfCartesianAbstraction = true;
        }
        this.abstractionModelEnumTimer.start();
        try {
            Region absbdd = this.rmgr.makeTrue();
            Iterator<AbstractionPredicate> predicateIt = pPredicates.iterator();
            while (predicateIt.hasNext()) {
                AbstractionPredicate p = predicateIt.next();
                Pair<BooleanFormula, AbstractionPredicate> cacheKey = Pair.of(f, p);
                if (this.options.isUseCache() && this.cartesianAbstractionCache.containsKey(cacheKey)) {
                    byte predVal = this.cartesianAbstractionCache.get(cacheKey);
                    this.stats.numCartesianAbsPredicatesCached.incrementAndGet();
                    this.abstractionBddConstructionTimer.start();
                    Region v = p.getAbstractVariable();
                    if (predVal == -1) {
                        this.stats.numCartesianAbsPredicates.incrementAndGet();
                        v = this.rmgr.makeNot(v);
                        absbdd = this.rmgr.makeAnd(absbdd, v);
                    } else if (predVal == 1) {
                        this.stats.numCartesianAbsPredicates.incrementAndGet();
                        absbdd = this.rmgr.makeAnd(absbdd, v);
                    } else assert (predVal == 0) : "predicate value is neither false, true, nor unknown";
                    this.abstractionBddConstructionTimer.stop();
                    continue;
                }
                this.logger.log(Level.ALL, new Object[]{"DEBUG_1", "CHECKING VALUE OF PREDICATE: ", p.getSymbolicAtom()});
                BooleanFormula predTrue = instantiator.apply(p.getSymbolicAtom());
                BooleanFormula predFalse = this.bfmgr.not(predTrue);
                int predVal = 0;
                thmProver.push(predFalse);
                boolean isTrue = thmProver.isUnsat();
                thmProver.pop();
                if (isTrue) {
                    this.stats.numCartesianAbsPredicates.incrementAndGet();
                    this.abstractionBddConstructionTimer.start();
                    Region v = p.getAbstractVariable();
                    absbdd = this.rmgr.makeAnd(absbdd, v);
                    predicateIt.remove();
                    this.abstractionBddConstructionTimer.stop();
                    predVal = 1;
                } else {
                    thmProver.push(predTrue);
                    boolean isFalse = thmProver.isUnsat();
                    thmProver.pop();
                    if (isFalse) {
                        this.stats.numCartesianAbsPredicates.incrementAndGet();
                        this.abstractionBddConstructionTimer.start();
                        Region v = p.getAbstractVariable();
                        v = this.rmgr.makeNot(v);
                        absbdd = this.rmgr.makeAnd(absbdd, v);
                        predicateIt.remove();
                        this.abstractionBddConstructionTimer.stop();
                        predVal = -1;
                    }
                }
                if (!this.options.isUseCache()) continue;
                this.cartesianAbstractionCache.put(cacheKey, (byte)predVal);
            }
            Region region = absbdd;
            return region;
        }
        finally {
            this.abstractionModelEnumTimer.stop();
            this.abstractionBddConstructionTimer.stopIfRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Region buildCartesianAbstractionUsingWeakening(BooleanFormula f, SSAMap ssa, Collection<AbstractionPredicate> pPredicates) throws SolverException, InterruptedException {
        Set<BooleanFormula> filteredLemmas;
        boolean feasibility;
        this.abstractionSolveTimer.start();
        try (ProverEnvironment thmProver = this.solver.newProverEnvironment(new SolverContext.ProverOptions[0]);){
            thmProver.push(f);
            feasibility = !thmProver.isUnsat();
        }
        finally {
            this.abstractionSolveTimer.stop();
        }
        if (!feasibility) {
            return this.rmgr.makeFalse();
        }
        ImmutableMap.Builder infoBuilder = ImmutableMap.builder();
        for (AbstractionPredicate a : pPredicates) {
            BooleanFormula lemma = a.getSymbolicAtom();
            Region r = a.getAbstractVariable();
            infoBuilder.put((Object)lemma, (Object)r);
        }
        ImmutableMap info = infoBuilder.buildOrThrow();
        Set<BooleanFormula> toStateLemmas = info.keySet();
        PathFormula pf = PathFormula.createManually(f, ssa, PointerTargetSet.emptyPointerTargetSet(), 0);
        this.cartesianAbstractionTimer.start();
        try {
            filteredLemmas = this.weakeningManager.findInductiveWeakeningForRCNF(SSAMap.emptySSAMap(), (Set<BooleanFormula>)ImmutableSet.of(), pf, toStateLemmas);
        }
        finally {
            this.cartesianAbstractionTimer.stop();
        }
        Region out = this.rmgr.makeTrue();
        for (BooleanFormula lemma : filteredLemmas) {
            out = this.rmgr.makeAnd(out, (Region)info.get(lemma));
        }
        return out;
    }

    private Region computeBooleanAbstraction(ProverEnvironment thmProver, Collection<AbstractionPredicate> predicates, java.util.function.Function<BooleanFormula, BooleanFormula> instantiator) throws InterruptedException, SolverException {
        BooleanFormula predDef = this.bfmgr.makeTrue();
        ArrayList<BooleanFormula> predVars = new ArrayList<BooleanFormula>(predicates.size());
        for (AbstractionPredicate p : predicates) {
            BooleanFormula var = p.getSymbolicVariable();
            BooleanFormula def = instantiator.apply(p.getSymbolicAtom());
            assert (!this.bfmgr.isFalse(def));
            BooleanFormula equiv = this.bfmgr.equivalence(var, def);
            predDef = this.bfmgr.and(predDef, equiv);
            predVars.add(var);
        }
        thmProver.push(predDef);
        AllSatCallbackImpl callback = new AllSatCallbackImpl();
        Region result = (Region)thmProver.allSat((BasicProverEnvironment.AllSatCallback)callback, predVars);
        int numModels = callback.getCount();
        if (numModels < Integer.MAX_VALUE) {
            this.stats.maxAllSatCount = Math.max(numModels, this.stats.maxAllSatCount);
            this.stats.allSatCount += (long)numModels;
        }
        predicates.clear();
        return result;
    }

    private void dumpAbstractionProblem(BooleanFormula f, Collection<AbstractionPredicate> predicates, AbstractionFormula result, int pCurrentAbstractionId) {
        @Nullable Path dumpFile = this.fmgr.formatFormulaOutputFile("abstraction", pCurrentAbstractionId, "input", 0);
        this.fmgr.dumpFormulaToFile(f, dumpFile);
        dumpFile = this.fmgr.formatFormulaOutputFile("abstraction", pCurrentAbstractionId, "predicates", 0);
        try (Writer w = IO.openOutputFile((Path)dumpFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            Joiner.on((char)'\n').appendTo((Appendable)w, predicates);
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Failed to wrote predicates to file");
        }
        dumpFile = this.fmgr.formatFormulaOutputFile("abstraction", pCurrentAbstractionId, "result", 0);
        this.fmgr.dumpFormulaToFile(result.asInstantiatedFormula(), dumpFile);
    }

    public boolean checkCoverage(AbstractionFormula a1, AbstractionFormula a2) throws SolverException, InterruptedException {
        return this.amgr.entails(a1.asRegion(), a2.asRegion());
    }

    public boolean checkCoverage(AbstractionFormula a1, PathFormula p1, AbstractionFormula a2) throws SolverException, InterruptedException {
        BooleanFormula absFormula = a1.asInstantiatedFormula();
        BooleanFormula symbFormula = this.getFormulaFromPathFormula(p1);
        BooleanFormula a = this.bfmgr.and(absFormula, symbFormula);
        BooleanFormula b = this.fmgr.instantiate(a2.asFormula(), p1.getSsa());
        return this.solver.implies(a, b);
    }

    public boolean unsat(AbstractionFormula abstractionFormula, PathFormula pathFormula) throws SolverException, InterruptedException {
        BooleanFormula absFormula = abstractionFormula.asInstantiatedFormula();
        BooleanFormula symbFormula = this.getFormulaFromPathFormula(pathFormula);
        BooleanFormula f = this.bfmgr.and(absFormula, symbFormula);
        this.logger.log(Level.ALL, new Object[]{"Checking satisfiability of formula", f});
        return this.solver.isUnsat(f);
    }

    public AbstractionFormula asAbstraction(BooleanFormula f, PathFormula blockFormula) throws InterruptedException {
        Region r = this.amgr.convertFormulaToRegion(f);
        return this.makeAbstractionFormula(r, blockFormula.getSsa(), blockFormula);
    }

    public AbstractionFormula makeTrueAbstractionFormula(PathFormula pPreviousBlockFormula) {
        if (pPreviousBlockFormula == null) {
            pPreviousBlockFormula = this.pfmgr.makeEmptyPathFormula();
        }
        return new AbstractionFormula(this.fmgr, this.amgr.getRegionCreator().makeTrue(), this.bfmgr.makeTrue(), this.bfmgr.makeTrue(), pPreviousBlockFormula, noAbstractionReuse);
    }

    public AbstractionFormula makeAnd(AbstractionFormula a1, AbstractionFormula a2) {
        Preconditions.checkArgument((boolean)a1.getBlockFormula().equals(a2.getBlockFormula()));
        Region region = this.amgr.getRegionCreator().makeAnd(a1.asRegion(), a2.asRegion());
        BooleanFormula formula = this.fmgr.makeAnd(a1.asFormula(), a2.asFormula());
        BooleanFormula instantiatedFormula = this.fmgr.makeAnd(a1.asInstantiatedFormula(), a2.asInstantiatedFormula());
        return new AbstractionFormula(this.fmgr, region, formula, instantiatedFormula, a1.getBlockFormula(), noAbstractionReuse);
    }

    public AbstractionFormula makeOr(AbstractionFormula a1, AbstractionFormula a2) throws InterruptedException {
        Region region = this.amgr.getRegionCreator().makeOr(a1.asRegion(), a2.asRegion());
        BooleanFormula formula = this.fmgr.makeOr(a1.asFormula(), a2.asFormula());
        BooleanFormula instantiatedFormula = this.fmgr.makeOr(a1.asInstantiatedFormula(), a2.asInstantiatedFormula());
        PathFormula newBlockFormula = this.pfmgr.makeOr(a1.getBlockFormula(), a2.getBlockFormula());
        return new AbstractionFormula(this.fmgr, region, formula, instantiatedFormula, newBlockFormula, noAbstractionReuse);
    }

    AbstractionFormula makeAbstractionFormula(Region abs, SSAMap ssaMap, PathFormula blockFormula) throws InterruptedException {
        BooleanFormula symbolicAbs = this.amgr.convertRegionToFormula(abs);
        BooleanFormula instantiatedSymbolicAbs = this.fmgr.instantiate(symbolicAbs, ssaMap);
        if (this.options.isSimplifyAbstractionFormula()) {
            symbolicAbs = this.fmgr.simplify(symbolicAbs);
            instantiatedSymbolicAbs = this.fmgr.simplify(instantiatedSymbolicAbs);
        }
        return new AbstractionFormula(this.fmgr, abs, symbolicAbs, instantiatedSymbolicAbs, blockFormula, noAbstractionReuse);
    }

    public ImmutableSet<AbstractionPredicate> getPredicatesForAtomsOf(BooleanFormula pFormula) {
        if (this.bfmgr.isFalse(pFormula)) {
            return ImmutableSet.of((Object)this.amgr.makeFalsePredicate());
        }
        ImmutableSet<BooleanFormula> atoms = this.fmgr.extractAtoms(pFormula, this.options.isSplitItpAtoms());
        ImmutableSet preds = Collections3.transformedImmutableSetCopy(atoms, atom -> this.amgr.makePredicate(this.fmgr.uninstantiate(atom)));
        this.amgr.reorderPredicates();
        return preds;
    }

    public AbstractionPredicate getPredicateFor(BooleanFormula pFormula) {
        Preconditions.checkArgument((!this.bfmgr.isTrue(pFormula) ? 1 : 0) != 0);
        return this.amgr.makePredicate(this.fmgr.uninstantiate(pFormula));
    }

    public AbstractionPredicate makeFalsePredicate() {
        return this.amgr.makeFalsePredicate();
    }

    public Set<AbstractionPredicate> extractPredicates(Region pRegion) {
        return this.amgr.extractPredicates(pRegion);
    }

    private class AllSatCallbackImpl
    implements BasicProverEnvironment.AllSatCallback<Region> {
        private final RegionCreator.RegionBuilder builder;
        private ThreadSafeTimerContainer.TimerWrapper regionTime;
        private int count;
        private Region formula;

        private AllSatCallbackImpl() {
            this.regionTime = PredicateAbstractionManager.this.abstractionBddConstructionTimer;
            this.count = 0;
            this.builder = PredicateAbstractionManager.this.rmgr.builder(PredicateAbstractionManager.this.shutdownNotifier);
            PredicateAbstractionManager.this.abstractionSolveTimer.start();
        }

        public void apply(List<BooleanFormula> model) {
            if (this.count == 0) {
                PredicateAbstractionManager.this.abstractionSolveTimer.stop();
                PredicateAbstractionManager.this.abstractionModelEnumTimer.start();
            }
            this.regionTime.start();
            this.builder.startNewConjunction();
            for (BooleanFormula f : model) {
                Optional<BooleanFormula> inner = PredicateAbstractionManager.this.fmgr.stripNegation(f);
                Region region = PredicateAbstractionManager.this.amgr.getPredicate(inner.orElse(f)).getAbstractVariable();
                if (inner.isPresent()) {
                    this.builder.addNegativeRegion(region);
                    continue;
                }
                this.builder.addPositiveRegion(region);
            }
            this.builder.finishConjunction();
            ++this.count;
            this.regionTime.stop();
        }

        public Region getResult() throws InterruptedException {
            if (PredicateAbstractionManager.this.abstractionSolveTimer.isRunning()) {
                PredicateAbstractionManager.this.abstractionSolveTimer.stop();
            } else {
                PredicateAbstractionManager.this.abstractionModelEnumTimer.stop();
            }
            if (this.formula == null) {
                PredicateAbstractionManager.this.abstractionModelEnumTimer.start();
                PredicateAbstractionManager.this.abstractionBddConstructionTimer.start();
                try {
                    this.formula = this.builder.getResult();
                    this.builder.close();
                }
                finally {
                    PredicateAbstractionManager.this.abstractionModelEnumTimer.stop();
                    PredicateAbstractionManager.this.abstractionBddConstructionTimer.stop();
                }
            }
            return this.formula;
        }

        private int getCount() {
            return this.count;
        }
    }

    static enum AbstractionType {
        CARTESIAN,
        CARTESIAN_BY_WEAKENING,
        BOOLEAN,
        COMBINED,
        ELIMINATION;

    }
}

