/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.predicate.RefinementStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicateMapWriter;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.FormulaMeasuring;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;
import org.sosy_lab.java_smt.api.BooleanFormula;

@Options(prefix="cpa.predicate")
public class PredicateAbstractionRefinementStrategy
extends RefinementStrategy
implements StatisticsProvider {
    @Option(secure=true, name="precision.sharing", description="Where to apply the found predicates to?")
    private PredicateSharing predicateSharing = PredicateSharing.LOCATION;
    @Option(secure=true, name="refinement.predicateBasisStrategy", description="Which predicates should be used as basis for the new precision that will be attached to the refined part of the ARG:\nALL: Collect predicates from the complete ARG.\nSUBGRAPH: Collect predicates from the removed subgraph of the ARG.\nCUTPOINT: Only predicates from the cut-point's (pivot state) precision are kept.\nTARGET: Only predicates from the target state's precision are kept.")
    private PredicateBasisStrategy predicateBasisStrategy = PredicateBasisStrategy.SUBGRAPH;
    @Option(secure=true, name="refinement.restartAfterRefinements", description="Do a complete restart (clearing the reached set) after N refinements. 0 to disable, 1 for always.")
    @IntegerOption(min=0L)
    private int restartAfterRefinements = 0;
    @Option(secure=true, name="refinement.sharePredicates", description="During refinement, add all new predicates to the precisions of all abstract states in the reached set.")
    private boolean sharePredicates = false;
    @Option(secure=true, name="refinement.useBddInterpolantSimplification", description="Use BDDs to simplify interpolants (removing irrelevant predicates)")
    private boolean useBddInterpolantSimplification = false;
    @Option(secure=true, name="refinement.dumpPredicates", description="After each refinement, dump the newly found predicates.")
    private boolean dumpPredicates = false;
    @Option(secure=true, name="refinement.dumpPredicatesFile", description="File name for the predicates dumped after refinements.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate dumpPredicatesFile = PathTemplate.ofFormatString((String)"refinement%04d-predicates.prec");
    protected int refinementCount = 0;
    private boolean atomicPredicates = false;
    protected final LogManager logger;
    protected final PredicateAbstractionManager predAbsMgr;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManagerView bfmgr;
    private final FormulaMeasuring formulaMeasuring;
    private final PredicateMapWriter precisionWriter;
    private StatCounter numberOfRefinementsWithStrategy2 = new StatCounter("Number of refs with location-based cutoff");
    private StatInt irrelevantPredsInItp = new StatInt(StatKind.SUM, "Number of irrelevant preds in interpolants");
    private StatTimer predicateCreation = new StatTimer(StatKind.SUM, "Predicate creation");
    private StatTimer precisionUpdate = new StatTimer(StatKind.SUM, "Precision update");
    protected StatTimer argUpdate = new StatTimer(StatKind.SUM, "ARG update");
    private StatTimer itpSimplification = new StatTimer(StatKind.SUM, "Itp simplification with BDDs");
    private StatInt simplifyDeltaConjunctions = new StatInt(StatKind.SUM, "Conjunctions Delta");
    private StatInt simplifyDeltaDisjunctions = new StatInt(StatKind.SUM, "Disjunctions Delta");
    private StatInt simplifyDeltaNegations = new StatInt(StatKind.SUM, "Negations Delta");
    private StatInt simplifyDeltaAtoms = new StatInt(StatKind.SUM, "Atoms Delta");
    private StatInt simplifyDeltaVariables = new StatInt(StatKind.SUM, "Variables Delta");
    private StatInt simplifyVariablesBefore = new StatInt(StatKind.SUM, "Variables Before");
    private StatInt simplifyVariablesAfter = new StatInt(StatKind.SUM, "Variables After");
    private ListMultimap<PredicatePrecision.LocationInstance, AbstractionPredicate> newPredicates;

    public PredicateAbstractionRefinementStrategy(Configuration config, LogManager pLogger, PredicateAbstractionManager pPredAbsMgr, Solver pSolver) throws InvalidConfigurationException {
        super(pSolver);
        config.inject((Object)this, PredicateAbstractionRefinementStrategy.class);
        this.logger = pLogger;
        this.fmgr = pSolver.getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.predAbsMgr = pPredAbsMgr;
        this.formulaMeasuring = new FormulaMeasuring(this.fmgr);
        this.precisionWriter = this.dumpPredicates && this.dumpPredicatesFile != null ? new PredicateMapWriter(config, this.fmgr) : null;
    }

    final void setUseAtomicPredicates(boolean pAtomicPredicates) {
        this.atomicPredicates = pAtomicPredicates;
    }

    @Override
    protected void startRefinementOfPath() {
        Preconditions.checkState((this.newPredicates == null ? 1 : 0) != 0);
        this.newPredicates = MultimapBuilder.linkedHashKeys().arrayListValues().build();
    }

    @Override
    protected final boolean performRefinementForState(BooleanFormula pInterpolant, ARGState interpolationPoint) throws InterruptedException {
        Preconditions.checkArgument((!this.bfmgr.isTrue(pInterpolant) ? 1 : 0) != 0);
        this.predicateCreation.start();
        PredicateAbstractState predicateState = PredicateAbstractState.getPredicateState(interpolationPoint);
        PathFormula blockFormula = predicateState.getAbstractionFormula().getBlockFormula();
        Collection<AbstractionPredicate> localPreds = this.convertInterpolant(pInterpolant, blockFormula);
        for (CFANode loc : AbstractStates.extractLocations(interpolationPoint)) {
            int locInstance = (Integer)predicateState.getAbstractionLocationsOnPath().get((Object)loc);
            this.storePredicates(new PredicatePrecision.LocationInstance(loc, locInstance), localPreds);
        }
        this.predicateCreation.stop();
        return false;
    }

    protected void storePredicates(PredicatePrecision.LocationInstance pLocInstance, AbstractionPredicate pPredicate) {
        this.storePredicates(pLocInstance, (Collection<AbstractionPredicate>)ImmutableSet.of((Object)pPredicate));
    }

    protected void storePredicates(PredicatePrecision.LocationInstance pLocInstance, Collection<AbstractionPredicate> pPredicates) {
        Preconditions.checkState((this.newPredicates != null ? 1 : 0) != 0);
        this.newPredicates.putAll((Object)pLocInstance, pPredicates);
    }

    private Collection<AbstractionPredicate> convertInterpolant(BooleanFormula pInterpolant, PathFormula blockFormula) throws InterruptedException {
        ImmutableList preds;
        BooleanFormula interpolant = pInterpolant;
        if (this.bfmgr.isTrue(interpolant)) {
            return ImmutableSet.of();
        }
        int allPredsCount = 0;
        if (this.useBddInterpolantSimplification) {
            FormulaMeasuring.FormulaMeasures itpBeforeSimple = this.formulaMeasuring.measure(interpolant);
            this.itpSimplification.start();
            allPredsCount = this.predAbsMgr.getPredicatesForAtomsOf(interpolant).size();
            interpolant = this.predAbsMgr.asAbstraction(this.fmgr.uninstantiate(interpolant), blockFormula).asInstantiatedFormula();
            this.itpSimplification.stop();
            FormulaMeasuring.FormulaMeasures itpAfterSimple = this.formulaMeasuring.measure(interpolant);
            this.simplifyDeltaAtoms.setNextValue(itpAfterSimple.getAtoms() - itpBeforeSimple.getAtoms());
            this.simplifyDeltaDisjunctions.setNextValue(itpAfterSimple.getDisjunctions() - itpBeforeSimple.getDisjunctions());
            this.simplifyDeltaConjunctions.setNextValue(itpAfterSimple.getConjunctions() - itpBeforeSimple.getConjunctions());
            this.simplifyDeltaNegations.setNextValue(itpAfterSimple.getNegations() - itpBeforeSimple.getNegations());
            this.simplifyDeltaVariables.setNextValue(itpAfterSimple.getVariables().size() - itpBeforeSimple.getVariables().size());
            this.simplifyVariablesBefore.setNextValue(itpBeforeSimple.getVariables().size());
            this.simplifyVariablesAfter.setNextValue(itpAfterSimple.getVariables().size());
        }
        if (this.atomicPredicates) {
            preds = this.predAbsMgr.getPredicatesForAtomsOf(interpolant);
            if (this.useBddInterpolantSimplification) {
                this.irrelevantPredsInItp.setNextValue(allPredsCount - preds.size());
            }
        } else {
            preds = ImmutableList.of((Object)this.predAbsMgr.getPredicateFor(interpolant));
        }
        assert (!preds.isEmpty()) : "Interpolant without relevant predicates: " + pInterpolant + "; simplified to " + interpolant;
        this.logger.log(Level.FINEST, new Object[]{"Got predicates", preds});
        return preds;
    }

    @Override
    protected void finishRefinementOfPath(ARGState pUnreachableState, List<ARGState> pAffectedStates, ARGReachedSet pReached, List<ARGState> abstractionStatesTrace, boolean pRepeatedCounterexample) throws CPAException, InterruptedException {
        Pair<PredicatePrecision, ARGState> newPrecAndRefinementRoot = this.computeNewPrecision(pUnreachableState, pAffectedStates, pReached, pRepeatedCounterexample);
        PredicatePrecision newPrecision = newPrecAndRefinementRoot.getFirst();
        ARGState refinementRoot = newPrecAndRefinementRoot.getSecond();
        this.updateARG(newPrecision, refinementRoot, pReached);
        this.newPredicates = null;
    }

    protected void updateARG(PredicatePrecision pNewPrecision, ARGState pRefinementRoot, ARGReachedSet pReached) throws InterruptedException {
        this.argUpdate.start();
        ArrayList<Precision> precisions = new ArrayList<Precision>(2);
        ArrayList<Predicate<? super Precision>> precisionTypes = new ArrayList<Predicate<? super Precision>>(2);
        precisions.add(pNewPrecision);
        precisionTypes.add(Predicates.instanceOf(PredicatePrecision.class));
        UnmodifiableReachedSet reached = pReached.asReachedSet();
        if (this.isValuePrecisionAvailable(pReached, pRefinementRoot)) {
            precisions.add(this.mergeAllValuePrecisionsFromSubgraph(pRefinementRoot, reached));
            precisionTypes.add(VariableTrackingPrecision.isMatchingCPAClass(ValueAnalysisCPA.class));
        }
        pReached.removeSubtree(pRefinementRoot, precisions, precisionTypes);
        assert (this.refinementCount > 0 || reached.size() == 1);
        if (this.sharePredicates) {
            pReached.updatePrecisionGlobally(pNewPrecision, (Predicate<? super Precision>)Predicates.instanceOf(PredicatePrecision.class));
        }
        this.argUpdate.stop();
    }

    private Pair<PredicatePrecision, ARGState> computeNewPrecision(ARGState pUnreachableState, List<ARGState> pAffectedStates, ARGReachedSet pReached, boolean pRepeatedCounterexample) throws RefinementFailedException {
        for (CFANode loc : AbstractStates.extractLocations(pUnreachableState)) {
            int locInstance = (Integer)PredicateAbstractState.getPredicateState(pUnreachableState).getAbstractionLocationsOnPath().get((Object)loc);
            this.storePredicates(new PredicatePrecision.LocationInstance(loc, locInstance), this.predAbsMgr.makeFalsePredicate());
        }
        pAffectedStates.add(pUnreachableState);
        UnmodifiableReachedSet reached = pReached.asReachedSet();
        PredicatePrecision targetStatePrecision = this.extractPredicatePrecision(reached.getPrecision(reached.getLastState()));
        ARGState refinementRoot = this.getRefinementRoot(pAffectedStates, pRepeatedCounterexample, reached, targetStatePrecision.getLocalPredicates());
        this.precisionUpdate.start();
        PredicatePrecision basePrecision = this.getBasePrecision(reached, refinementRoot, targetStatePrecision);
        this.logger.log(Level.ALL, new Object[]{"Old predicate map is", basePrecision});
        this.logger.log(Level.ALL, new Object[]{"New predicates are", this.newPredicates});
        PredicatePrecision newPrecision = this.addPredicatesToPrecision(basePrecision);
        this.logger.log(Level.ALL, new Object[]{"Predicate map now is", newPrecision});
        this.logger.log(Level.ALL, new Object[]{"Difference of predicates is", newPrecision.subtract(basePrecision)});
        assert (basePrecision.calculateDifferenceTo(newPrecision) == 0) : "We forgot predicates during refinement!";
        assert (targetStatePrecision.calculateDifferenceTo(newPrecision) == 0) : "We forgot predicates during refinement!";
        if (this.dumpPredicates && this.dumpPredicatesFile != null) {
            this.dumpNewPredicates();
        }
        this.precisionUpdate.stop();
        return Pair.of(newPrecision, refinementRoot);
    }

    protected ARGState getRefinementRoot(List<ARGState> pAffectedStates, boolean pRepeatedCounterexample, UnmodifiableReachedSet reached, ImmutableSetMultimap<CFANode, AbstractionPredicate> pTargetStatePredicates) throws RefinementFailedException {
        ARGState refinementRoot = this.getPivotState(pAffectedStates, pTargetStatePredicates, pRepeatedCounterexample);
        ++this.refinementCount;
        if (this.restartAfterRefinements > 0 && this.refinementCount >= this.restartAfterRefinements) {
            ARGState root = (ARGState)reached.getFirstState();
            assert (root.getChildren().size() == 1) : "ARG root should have exactly one child";
            refinementRoot = (ARGState)Iterables.getLast(root.getChildren());
            this.logger.log(Level.FINEST, new Object[]{"Restarting analysis after", this.refinementCount, "refinements by clearing the ARG."});
            this.refinementCount = 0;
        } else {
            this.logger.log(Level.FINEST, new Object[]{"Removing everything below", refinementRoot, "from ARG."});
        }
        return refinementRoot;
    }

    private PredicatePrecision getBasePrecision(UnmodifiableReachedSet reached, ARGState refinementRoot, PredicatePrecision targetStatePrecision) {
        PredicatePrecision basePrecision;
        switch (this.predicateBasisStrategy) {
            case ALL: {
                basePrecision = PredicateAbstractionRefinementStrategy.findAllPredicatesFromSubgraph((ARGState)reached.getFirstState(), reached);
                break;
            }
            case SUBGRAPH: {
                basePrecision = PredicateAbstractionRefinementStrategy.findAllPredicatesFromSubgraph(refinementRoot, reached);
                break;
            }
            case TARGET: {
                basePrecision = targetStatePrecision;
                break;
            }
            case CUTPOINT: {
                basePrecision = this.extractPredicatePrecision(reached.getPrecision(refinementRoot));
                break;
            }
            default: {
                throw new AssertionError((Object)"unknown strategy for predicate basis.");
            }
        }
        return basePrecision;
    }

    protected PredicatePrecision addPredicatesToPrecision(PredicatePrecision basePrecision) {
        PredicatePrecision newPrecision;
        switch (this.predicateSharing) {
            case GLOBAL: {
                newPrecision = basePrecision.addGlobalPredicates(this.newPredicates.values());
                break;
            }
            case SCOPE: {
                HashSet<AbstractionPredicate> globalPredicates = new HashSet<AbstractionPredicate>();
                ArrayListMultimap localPredicates = ArrayListMultimap.create();
                this.splitInLocalAndGlobalPredicates(globalPredicates, (ListMultimap<PredicatePrecision.LocationInstance, AbstractionPredicate>)localPredicates);
                newPrecision = basePrecision.addGlobalPredicates(globalPredicates);
                newPrecision = newPrecision.addLocalPredicates(PredicateAbstractionRefinementStrategy.mergePredicatesPerLocation(localPredicates.entries()));
                break;
            }
            case FUNCTION: {
                newPrecision = basePrecision.addFunctionPredicates(PredicateAbstractionRefinementStrategy.mergePredicatesPerFunction(this.newPredicates.entries()));
                break;
            }
            case LOCATION: {
                newPrecision = basePrecision.addLocalPredicates(PredicateAbstractionRefinementStrategy.mergePredicatesPerLocation(this.newPredicates.entries()));
                break;
            }
            case LOCATION_INSTANCE: {
                newPrecision = basePrecision.addLocationInstancePredicates(this.newPredicates.entries());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return newPrecision;
    }

    private PredicatePrecision extractPredicatePrecision(Precision oldPrecision) throws IllegalStateException {
        PredicatePrecision oldPredicatePrecision = Precisions.extractPrecisionByType(oldPrecision, PredicatePrecision.class);
        Preconditions.checkState((oldPredicatePrecision != null ? 1 : 0) != 0, (Object)"Could not find the PredicatePrecision for the error element");
        return oldPredicatePrecision;
    }

    private void splitInLocalAndGlobalPredicates(Set<AbstractionPredicate> globalPredicates, ListMultimap<PredicatePrecision.LocationInstance, AbstractionPredicate> localPredicates) {
        for (Map.Entry predicate : this.newPredicates.entries()) {
            if (((AbstractionPredicate)predicate.getValue()).getSymbolicAtom().toString().contains("::")) {
                localPredicates.put((Object)((PredicatePrecision.LocationInstance)predicate.getKey()), (Object)((AbstractionPredicate)predicate.getValue()));
                continue;
            }
            globalPredicates.add((AbstractionPredicate)predicate.getValue());
        }
    }

    private ARGState getPivotState(List<ARGState> pAffectedStates, ImmutableSetMultimap<CFANode, AbstractionPredicate> pTargetStatePredicates, boolean pRepeatedCounterexample) throws RefinementFailedException {
        boolean newPredicatesFound;
        if (this.newPredicates != null) {
            newPredicatesFound = false;
            for (Map.Entry entry : this.newPredicates.entries()) {
                if (pTargetStatePredicates.containsEntry((Object)((PredicatePrecision.LocationInstance)entry.getKey()).getLocation(), entry.getValue())) continue;
                newPredicatesFound = true;
                break;
            }
        } else {
            newPredicatesFound = true;
        }
        ARGState firstInterpolationPoint = pAffectedStates.get(0);
        if (!newPredicatesFound) {
            if (pRepeatedCounterexample) {
                throw new RefinementFailedException(RefinementFailedException.Reason.RepeatedCounterexample, null);
            }
            this.numberOfRefinementsWithStrategy2.inc();
            CFANode firstInterpolationPointLocation = AbstractStates.extractLocation(firstInterpolationPoint);
            this.logger.log(Level.FINEST, new Object[]{"Found spurious counterexample,", "trying strategy 2: remove everything below node", firstInterpolationPointLocation, "from ARG."});
            ARGState current = firstInterpolationPoint;
            while (!current.getParents().isEmpty()) {
                CFANode loc;
                if (!PredicateAbstractState.getPredicateState(current = (ARGState)Iterables.get(current.getParents(), (int)0)).isAbstractionState() || !(loc = AbstractStates.extractLocation(current)).equals(firstInterpolationPointLocation)) continue;
                firstInterpolationPoint = current;
            }
        }
        return firstInterpolationPoint;
    }

    public static PredicatePrecision findAllPredicatesFromSubgraph(ARGState refinementRoot, UnmodifiableReachedSet reached) {
        return PredicatePrecision.unionOf((Iterable<Precision>)ARGUtils.getNonCoveredStatesInSubgraph(refinementRoot).transform(reached::getPrecision));
    }

    private void dumpNewPredicates() {
        Path precFile = this.dumpPredicatesFile.getPath(new Object[]{this.precisionUpdate.getUpdateCount()});
        try (Writer w = IO.openOutputFile((Path)precFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            this.precisionWriter.writePredicateMap((SetMultimap<PredicatePrecision.LocationInstance, AbstractionPredicate>)ImmutableSetMultimap.copyOf(this.newPredicates), (SetMultimap<CFANode, AbstractionPredicate>)ImmutableSetMultimap.of(), (SetMultimap<String, AbstractionPredicate>)ImmutableSetMultimap.of(), (Set<AbstractionPredicate>)ImmutableSet.of(), this.newPredicates.values(), w);
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not dump precision to file");
        }
    }

    private boolean isValuePrecisionAvailable(ARGReachedSet pReached, ARGState root) {
        if (!pReached.asReachedSet().contains(root)) {
            return false;
        }
        return Precisions.extractPrecisionByType(pReached.asReachedSet().getPrecision(root), VariableTrackingPrecision.class) != null;
    }

    private VariableTrackingPrecision mergeAllValuePrecisionsFromSubgraph(ARGState refinementRoot, UnmodifiableReachedSet reached) {
        VariableTrackingPrecision rootPrecision = Precisions.extractPrecisionByType(reached.getPrecision(refinementRoot), VariableTrackingPrecision.class);
        Set precisions = Sets.newIdentityHashSet();
        for (ARGState state : ARGUtils.getNonCoveredStatesInSubgraph(refinementRoot)) {
            precisions.add(reached.getPrecision(state));
        }
        for (Precision prec : precisions) {
            rootPrecision = rootPrecision.join(Precisions.extractPrecisionByType(prec, VariableTrackingPrecision.class));
        }
        return rootPrecision;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(new Stats());
    }

    private static Iterable<Map.Entry<String, AbstractionPredicate>> mergePredicatesPerFunction(Iterable<Map.Entry<PredicatePrecision.LocationInstance, AbstractionPredicate>> predicates) {
        return FluentIterable.from(predicates).transform(e -> Maps.immutableEntry((Object)((PredicatePrecision.LocationInstance)e.getKey()).getFunctionName(), (Object)((AbstractionPredicate)e.getValue())));
    }

    private static Iterable<Map.Entry<CFANode, AbstractionPredicate>> mergePredicatesPerLocation(Iterable<Map.Entry<PredicatePrecision.LocationInstance, AbstractionPredicate>> predicates) {
        return FluentIterable.from(predicates).transform(e -> Maps.immutableEntry((Object)((PredicatePrecision.LocationInstance)e.getKey()).getLocation(), (Object)((AbstractionPredicate)e.getValue())));
    }

    private class Stats
    implements Statistics {
        private Stats() {
        }

        @Override
        public String getName() {
            return "Predicate-Abstraction Refiner";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            StatisticsWriter w0 = StatisticsWriter.writingStatisticsTo(out);
            StatisticsWriter w1 = w0.beginLevel();
            w1.put(PredicateAbstractionRefinementStrategy.this.predicateCreation).ifUpdatedAtLeastOnce(PredicateAbstractionRefinementStrategy.this.itpSimplification).put(PredicateAbstractionRefinementStrategy.this.itpSimplification).beginLevel().put(PredicateAbstractionRefinementStrategy.this.simplifyDeltaConjunctions).put(PredicateAbstractionRefinementStrategy.this.simplifyDeltaDisjunctions).put(PredicateAbstractionRefinementStrategy.this.simplifyDeltaNegations).put(PredicateAbstractionRefinementStrategy.this.simplifyDeltaAtoms).put(PredicateAbstractionRefinementStrategy.this.simplifyDeltaVariables).put(PredicateAbstractionRefinementStrategy.this.simplifyVariablesBefore).put(PredicateAbstractionRefinementStrategy.this.simplifyVariablesAfter);
            w1.put(PredicateAbstractionRefinementStrategy.this.precisionUpdate).put(PredicateAbstractionRefinementStrategy.this.argUpdate).spacer();
            PredicateAbstractionRefinementStrategy.this.printStatistics(out);
            w0.put(PredicateAbstractionRefinementStrategy.this.numberOfRefinementsWithStrategy2).ifUpdatedAtLeastOnce(PredicateAbstractionRefinementStrategy.this.itpSimplification).put(PredicateAbstractionRefinementStrategy.this.irrelevantPredsInItp);
        }
    }

    private static enum PredicateBasisStrategy {
        ALL,
        SUBGRAPH,
        TARGET,
        CUTPOINT;

    }

    private static enum PredicateSharing {
        GLOBAL,
        SCOPE,
        FUNCTION,
        LOCATION,
        LOCATION_INSTANCE;

    }
}

