/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPARefiner;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.refinement.InfeasiblePrefix;
import org.sosy_lab.cpachecker.util.refinement.PrefixProvider;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="cpa.predicate.refinement")
public class PredicateBasedPrefixProvider
implements PrefixProvider {
    @Option(secure=true, description="Max. number of prefixes to extract")
    private int maxPrefixCount = 64;
    @Option(secure=true, description="Max. length of feasible prefixes to extract from if at least one prefix was already extracted")
    private int maxPrefixLength = 1024;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final Solver solver;

    public PredicateBasedPrefixProvider(Configuration config, LogManager pLogger, Solver pSolver, ShutdownNotifier pShutdownNotifier) {
        try {
            config.inject((Object)this);
        }
        catch (InvalidConfigurationException e) {
            pLogger.log(Level.INFO, new Object[]{"Invalid configuration given to " + this.getClass().getSimpleName() + ". Using defaults instead."});
        }
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.solver = pSolver;
    }

    public static PredicateBasedPrefixProvider create(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        PredicateCPA predicateCpa = CPAs.retrieveCPAOrFail(pCpa, PredicateCPA.class, PredicateBasedPrefixProvider.class);
        return new PredicateBasedPrefixProvider(predicateCpa.getConfiguration(), predicateCpa.getLogger(), predicateCpa.getSolver(), predicateCpa.getShutdownNotifier());
    }

    @Override
    public List<InfeasiblePrefix> extractInfeasiblePrefixes(ARGPath pPath) throws CPAException, InterruptedException {
        List<InfeasiblePrefix.RawInfeasiblePrefix> rawPrefixes;
        List<ARGState> abstractionStates = PredicateCPARefiner.filterAbstractionStates(pPath);
        ImmutableList blockFormulas = FluentIterable.from(abstractionStates).transform(AbstractStates.toState(PredicateAbstractState.class)).transform(PredicateAbstractState::getBlockFormula).toList();
        try (InterpolatingProverEnvironment<?> prover = this.solver.newProverEnvironmentWithInterpolation(new SolverContext.ProverOptions[0]);){
            rawPrefixes = this.extractInfeasiblePrefixes(pPath, (List<BooleanFormula>)blockFormulas, prover);
        }
        ArrayList<InfeasiblePrefix> infeasiblePrefixes = new ArrayList<InfeasiblePrefix>(rawPrefixes.size());
        for (InfeasiblePrefix.RawInfeasiblePrefix rawPrefix : rawPrefixes) {
            infeasiblePrefixes.add(InfeasiblePrefix.buildForPredicateDomain(rawPrefix, this.solver.getFormulaManager()));
        }
        return infeasiblePrefixes;
    }

    private <T> List<InfeasiblePrefix.RawInfeasiblePrefix> extractInfeasiblePrefixes(ARGPath pPath, List<BooleanFormula> blockFormulas, InterpolatingProverEnvironment<T> prover) throws CPAException, InterruptedException {
        ArrayList<InfeasiblePrefix.RawInfeasiblePrefix> rawPrefixes = new ArrayList<InfeasiblePrefix.RawInfeasiblePrefix>();
        ArrayList<Object> terms = new ArrayList<Object>(blockFormulas.size());
        ArrayList<BooleanFormula> pathFormula = new ArrayList<BooleanFormula>();
        int currentBlockIndex = 0;
        PathIterator iterator = pPath.pathIterator();
        while (iterator.hasNext() && !this.shutdownNotifier.shouldShutdown()) {
            ARGState currentState = iterator.getAbstractState();
            if (iterator.getIndex() == 0) assert (this.isAbstractionState(currentState));
            if (this.isAbstractionState(currentState)) {
                BooleanFormula currentBlockFormula = blockFormulas.get(currentBlockIndex);
                pathFormula.add(currentBlockFormula);
                try {
                    Object term = prover.push(currentBlockFormula);
                    terms.add(term);
                    if (this.checkUnsat(pPath, iterator.getOutgoingEdge()) && prover.isUnsat()) {
                        this.logger.log(Level.FINE, new Object[]{"found infeasible prefix, ending with edge ", iterator.getOutgoingEdge(), " in block # ", currentBlockIndex, ", that resulted in an unsat-formula"});
                        ImmutableList<BooleanFormula> interpolantSequence = this.extractInterpolantSequence(terms, prover);
                        ImmutableList finalPathFormula = ImmutableList.copyOf(pathFormula);
                        ARGPath currentPrefixPath = ARGUtils.getOnePathTo(currentState);
                        rawPrefixes.add(new InfeasiblePrefix.RawInfeasiblePrefix(currentPrefixPath, interpolantSequence, (ImmutableList<BooleanFormula>)finalPathFormula));
                        if (currentPrefixPath.size() >= this.maxPrefixLength) break;
                        prover.pop();
                        terms.remove(terms.size() - 1);
                        terms.add(prover.push(this.makeTrue()));
                        pathFormula.remove(pathFormula.size() - 1);
                        pathFormula.add(this.makeTrue());
                    }
                }
                catch (SolverException e) {
                    throw new CPAException("Error during computation of prefixes: " + e.getMessage(), e);
                }
                ++currentBlockIndex;
                if (rawPrefixes.size() == this.maxPrefixCount) break;
            }
            iterator.advance();
        }
        return rawPrefixes;
    }

    private <T> ImmutableList<BooleanFormula> extractInterpolantSequence(List<T> pTerms, InterpolatingProverEnvironment<T> pProver) throws SolverException, InterruptedException {
        ImmutableList.Builder interpolantSequence = ImmutableList.builder();
        for (int i = 1; i < pTerms.size(); ++i) {
            interpolantSequence.add((Object)pProver.getInterpolant(pTerms.subList(0, i)));
        }
        return interpolantSequence.build();
    }

    private boolean checkUnsat(ARGPath pPath, CFAEdge pCfaEdge) {
        if (!this.isSingleBlockEncoded(pPath)) {
            return true;
        }
        if (pCfaEdge == null) {
            return false;
        }
        return pCfaEdge.getEdgeType() == CFAEdgeType.AssumeEdge;
    }

    private boolean isSingleBlockEncoded(ARGPath pPath) {
        return FluentIterable.from(pPath.asStatesList()).allMatch(PredicateAbstractState::containsAbstractionState);
    }

    private boolean isAbstractionState(ARGState pCurrentState) {
        return PredicateAbstractState.getPredicateState(pCurrentState).isAbstractionState();
    }

    private BooleanFormula makeTrue() {
        return this.solver.getFormulaManager().getBooleanFormulaManager().makeTrue();
    }
}

