/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantSupplier;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractDomain;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManagerOptions;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionStatistics;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPAInvariantsManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPAStatistics;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCpaOptions;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateMergeOperator;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateNeverAtAbstractionStopOperator;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePCCStopOperator;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecisionBootstrapper;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateProvider;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateStatistics;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateStopOperator;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateTransferRelation;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicateAbstractionsStorage;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.blocking.BlockedCFAReducer;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.BlockOperator;
import org.sosy_lab.cpachecker.util.predicates.bdd.BDDManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.pathformula.CachingPathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.regions.SymbolicRegionManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.predicates.weakening.WeakeningOptions;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="cpa.predicate")
public class PredicateCPA
implements ConfigurableProgramAnalysis,
StatisticsProvider,
ProofChecker,
AutoCloseable {
    @Option(secure=true, name="abstraction.type", toUppercase=true, values={"BDD", "FORMULA"}, description="What to use for storing abstractions")
    private String abstractionType = "BDD";
    @Option(secure=true, name="blk.useCache", description="use caching of path formulas")
    private boolean useCache = true;
    @Option(secure=true, name="enableBlockreducer", description="Enable the possibility to precompute explicit abstraction locations.")
    private boolean enableBlockreducer = false;
    @Option(secure=true, name="merge", values={"SEP", "ABE"}, toUppercase=true, description="which merge operator to use for predicate cpa (usually ABE should be used)")
    private String mergeType = "ABE";
    @Option(secure=true, name="merge.mergeAbstractionStatesWithSamePredecessor", description="merge two abstraction states if their preceeding abstraction states are the same")
    private boolean mergeAbstractionStates = false;
    @Option(secure=true, name="stop", values={"SEP", "SEPPCC", "SEPNAA"}, toUppercase=true, description="which stop operator to use for predicate cpa (usually SEP should be used in analysis). SEPNAA works the same as SEP, except that it Never stops At Abstraction states. SEPNAA is used in bmc-IMC.properties for config bmc-incremental-ABEl to keep exploring covered states.")
    private String stopType = "SEP";
    @Option(secure=true, description="Direction of the analysis?")
    private AnalysisDirection direction = AnalysisDirection.FORWARD;
    @Option(secure=true, description="whether to include the symbolic path formula in the coverage checks or do only the fast abstract checks")
    private boolean symbolicCoverageCheck = false;
    protected final Configuration config;
    protected final LogManager logger;
    protected final ShutdownNotifier shutdownNotifier;
    private final PredicatePrecision initialPrecision;
    private final PathFormulaManager pathFormulaManager;
    private final Solver solver;
    private final PredicateCPAStatistics stats;
    private final PredicatePrecisionBootstrapper precisionBootstraper;
    private final CFA cfa;
    private final AbstractionManager abstractionManager;
    private final PredicateCPAInvariantsManager invariantsManager;
    private final BlockOperator blk;
    private final PredicateStatistics statistics;
    private final PredicateProvider predicateProvider;
    private final FormulaManagerView formulaManager;
    private final PredicateCpaOptions options;
    private final PredicateAbstractionManagerOptions abstractionOptions;
    private final WeakeningOptions weakeningOptions;
    private final PredicateAbstractionsStorage abstractionStorage;
    private final PredicateAbstractionStatistics abstractionStats = new PredicateAbstractionStatistics();
    private final Map<PredicateAbstractState, PathFormula> computedPathFormulaePcc = new HashMap<PredicateAbstractState, PathFormula>();

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(PredicateCPA.class).withOptions(BlockOperator.class);
    }

    protected PredicateCPA(Configuration config, LogManager logger, BlockOperator pBlk, CFA pCfa, ShutdownNotifier pShutdownNotifier, Specification specification, AggregatedReachedSets pAggregatedReachedSets) throws InvalidConfigurationException, CPAException, InterruptedException {
        RegionManager regionManager;
        config.inject((Object)this, PredicateCPA.class);
        this.config = config;
        this.logger = logger;
        this.shutdownNotifier = pShutdownNotifier;
        this.cfa = pCfa;
        this.blk = pBlk;
        if (this.enableBlockreducer) {
            BlockedCFAReducer blockComputer = new BlockedCFAReducer(config, logger);
            this.blk.setExplicitAbstractionNodes(blockComputer.computeAbstractionNodes(this.cfa));
        }
        this.blk.setCFA(this.cfa);
        this.solver = Solver.create(config, logger, pShutdownNotifier);
        this.formulaManager = this.solver.getFormulaManager();
        Object libraries = this.solver.getVersion();
        PathFormulaManager pfMgr = new PathFormulaManagerImpl(this.formulaManager, config, logger, this.shutdownNotifier, this.cfa, this.direction);
        if (this.useCache) {
            pfMgr = new CachingPathFormulaManager(pfMgr);
        }
        this.pathFormulaManager = pfMgr;
        if (this.abstractionType.equals("FORMULA") || this.blk.alwaysReturnsFalse()) {
            regionManager = new SymbolicRegionManager(this.solver);
        } else {
            assert (this.abstractionType.equals("BDD"));
            regionManager = new BDDManagerFactory(config, logger).createRegionManager();
            libraries = (String)libraries + " and " + regionManager.getVersion();
        }
        logger.log(Level.INFO, new Object[]{"Using predicate analysis with", (String)libraries + "."});
        this.abstractionManager = new AbstractionManager(regionManager, config, logger, this.solver);
        this.invariantsManager = new PredicateCPAInvariantsManager(config, logger, pShutdownNotifier, pCfa, specification, pAggregatedReachedSets);
        this.abstractionOptions = new PredicateAbstractionManagerOptions(config);
        this.abstractionStorage = new PredicateAbstractionsStorage(this.abstractionOptions.getReuseAbstractionsFrom(), logger, this.solver.getFormulaManager(), null);
        this.weakeningOptions = new WeakeningOptions(config);
        this.statistics = new PredicateStatistics();
        this.options = new PredicateCpaOptions(config);
        this.precisionBootstraper = new PredicatePrecisionBootstrapper(config, logger, this.cfa, this.abstractionManager, this.formulaManager, this.shutdownNotifier, this.pathFormulaManager, this.getPredicateManager());
        this.initialPrecision = this.precisionBootstraper.prepareInitialPredicates();
        logger.log(Level.FINEST, new Object[]{"Initial precision is", this.initialPrecision});
        this.predicateProvider = new PredicateProvider(config, pCfa, logger, this.formulaManager, this.getPredicateManager());
        this.stats = new PredicateCPAStatistics(config, logger, pCfa, this.solver, this.pathFormulaManager, this.blk, regionManager, this.abstractionManager, this.abstractionStats, this.statistics);
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return new PredicateAbstractDomain(this.getPredicateManager(), this.symbolicCoverageCheck, this.statistics);
    }

    @Override
    public PredicateTransferRelation getTransferRelation() {
        return new PredicateTransferRelation(this.logger, this.direction, this.formulaManager, this.pathFormulaManager, this.blk, this.getPredicateManager(), this.statistics, this.options);
    }

    @Override
    public MergeOperator getMergeOperator() {
        switch (this.mergeType) {
            case "SEP": {
                return MergeSepOperator.getInstance();
            }
            case "ABE": {
                return new PredicateMergeOperator(this.logger, this.pathFormulaManager, this.statistics, this.mergeAbstractionStates, this.getPredicateManager());
            }
        }
        throw new AssertionError((Object)"Update list of allowed merge operators");
    }

    @Override
    public StopOperator getStopOperator() {
        switch (this.stopType) {
            case "SEP": {
                return new PredicateStopOperator(this.getAbstractDomain());
            }
            case "SEPPCC": {
                return new PredicatePCCStopOperator(this.pathFormulaManager, this.getPredicateManager(), this.solver);
            }
            case "SEPNAA": {
                return new PredicateNeverAtAbstractionStopOperator(this.getAbstractDomain());
            }
        }
        throw new AssertionError((Object)"Update list of allowed stop operators");
    }

    public PredicateAbstractionManager getPredicateManager() {
        return new PredicateAbstractionManager(this.abstractionManager, this.pathFormulaManager, this.solver, this.abstractionOptions, this.weakeningOptions, this.abstractionStorage, this.logger, this.shutdownNotifier, this.abstractionStats, this.invariantsManager.appendToAbstractionFormula() ? this.invariantsManager : InvariantSupplier.TrivialInvariantSupplier.INSTANCE);
    }

    public PathFormulaManager getPathFormulaManager() {
        return this.pathFormulaManager;
    }

    public Solver getSolver() {
        return this.solver;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    LogManager getLogger() {
        return this.logger;
    }

    public ShutdownNotifier getShutdownNotifier() {
        return this.shutdownNotifier;
    }

    @Override
    public AbstractState getInitialState(CFANode node, StateSpacePartition pPartition) {
        return PredicateAbstractState.mkAbstractionState(this.pathFormulaManager.makeEmptyPathFormula(), this.getPredicateManager().makeTrueAbstractionFormula(null), (PersistentMap<CFANode, Integer>)PathCopyingPersistentTreeMap.of());
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        return this.initialPrecision;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return new PredicatePrecisionAdjustment(this.logger, this.formulaManager, this.pathFormulaManager, this.blk, this.getPredicateManager(), this.invariantsManager, this.predicateProvider, this.statistics);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
        this.precisionBootstraper.collectStatistics(pStatsCollection);
        this.invariantsManager.collectStatistics(pStatsCollection);
    }

    @Override
    public void close() {
        this.solver.close();
    }

    @Override
    public boolean areAbstractSuccessors(AbstractState pElement, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors) throws CPATransferException, InterruptedException {
        try {
            return this.getTransferRelation().areAbstractSuccessors(pElement, pCfaEdge, pSuccessors, this.computedPathFormulaePcc);
        }
        catch (SolverException e) {
            throw new CPATransferException("Solver failed during abstract-successor check", e);
        }
    }

    @Override
    public boolean isCoveredBy(AbstractState pElement, AbstractState pOtherElement) throws CPAException, InterruptedException {
        PredicateAbstractState e1 = (PredicateAbstractState)pElement;
        PredicateAbstractState e2 = (PredicateAbstractState)pOtherElement;
        if (e1.isAbstractionState() && e2.isAbstractionState()) {
            try {
                return this.getPredicateManager().checkCoverage(e1.getAbstractionFormula(), this.pathFormulaManager.makeEmptyPathFormulaWithContextFrom(e1.getPathFormula()), e2.getAbstractionFormula());
            }
            catch (SolverException e) {
                throw new CPAException("Solver Failure", e);
            }
        }
        return false;
    }

    public CFA getCfa() {
        return this.cfa;
    }

    public AbstractionManager getAbstractionManager() {
        return this.abstractionManager;
    }

    public PredicateCPAInvariantsManager getInvariantsManager() {
        return this.invariantsManager;
    }

    public void changeExplicitAbstractionNodes(ImmutableSet<CFANode> explicitlyAbstractAt) {
        this.blk.setExplicitAbstractionNodes(explicitlyAbstractAt);
    }
}

