/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.SetMultimap;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.predicate.GlobalRefinementStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="cpa.predicate.refinement.global")
public class PredicateCPAGlobalRefiner
implements Refiner,
StatisticsProvider {
    @Option(secure=true, description="Instead of updating precision and arg we say that the refinement was not successful after N times of refining. A real error state is not necessary to be found. Use 0 for unlimited refinements (default).")
    @IntegerOption(min=0L)
    private int stopAfterNRefinements = 0;
    private final StatTimer totalTime = new StatTimer("Time for refinement");
    private final StatTimer interpolationTime = new StatTimer("Time for interpolation");
    private final StatTimer satCheckTime = new StatTimer("Time for sat-checks");
    private final LogManager logger;
    private final GlobalRefinementStrategy strategy;
    private final Solver solver;
    private final BooleanFormulaManager bfmgr;
    private final ARGCPA argCPA;

    public PredicateCPAGlobalRefiner(LogManager pLogger, FormulaManagerView pFmgr, GlobalRefinementStrategy pStrategy, Solver pSolver, ARGCPA pArgcpa, Configuration pConfig) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.bfmgr = pFmgr.getBooleanFormulaManager();
        this.solver = pSolver;
        this.strategy = pStrategy;
        this.argCPA = pArgcpa;
        this.logger.log(Level.INFO, new Object[]{"Using refinement for predicate analysis with " + this.strategy.getClass().getSimpleName() + " strategy."});
    }

    @Override
    public boolean performRefinement(ReachedSet pReached) throws CPAException, InterruptedException {
        this.totalTime.start();
        try {
            ImmutableList targets = FluentIterable.from((Iterable)pReached).filter(AbstractStates::isTargetState).toList();
            assert (!targets.isEmpty());
            ARGReachedSet argReachedSet = new ARGReachedSet(pReached, this.argCPA);
            this.strategy.initializeGlobalRefinement();
            Optional<ARGState> errorState = this.doPathWiseRefinement(argReachedSet, (List<AbstractState>)targets);
            if (errorState.isPresent() || this.stopAfterNRefinements == this.totalTime.getUpdateCount() + 1) {
                this.strategy.resetGlobalRefinement();
                boolean bl = false;
                return bl;
            }
            this.strategy.updatePrecisionAndARG();
            boolean bl = true;
            return bl;
        }
        catch (SolverException e) {
            throw new CPAException("Solver Exception", e);
        }
        finally {
            this.totalTime.stop();
        }
    }

    private Optional<ARGState> doPathWiseRefinement(ARGReachedSet pReached, List<AbstractState> targets) throws CPAException, InterruptedException, SolverException {
        this.logger.log(Level.FINE, new Object[]{"Starting refinement for", targets.size(), "elements."});
        HashMap<ARGState, ARGState> predecessors = new HashMap<ARGState, ARGState>();
        HashMultimap successors = HashMultimap.create();
        ArrayDeque<AbstractState> todo = new ArrayDeque<AbstractState>(targets);
        while (!todo.isEmpty()) {
            ARGState currentAbstractionState = (ARGState)todo.removeFirst();
            assert (currentAbstractionState.mayCover());
            ARGState currentState = currentAbstractionState;
            while (!PredicateAbstractState.getPredicateState(currentState = currentState.getParents().iterator().next()).isAbstractionState()) {
            }
            if (!currentState.getParents().isEmpty() && !predecessors.containsKey(currentState)) {
                todo.add(currentState);
            }
            predecessors.put(currentAbstractionState, currentState);
            successors.put((Object)currentState, (Object)currentAbstractionState);
        }
        ARGState root = (ARGState)pReached.asReachedSet().getFirstState();
        assert (successors.containsKey((Object)root));
        try (InterpolatingProverEnvironment<?> itpProver = this.solver.newProverEnvironmentWithInterpolation(new SolverContext.ProverOptions[0]);){
            Optional<ARGState> optional = this.doPathWiseRefinement(root, (SetMultimap<ARGState, ARGState>)successors, predecessors, pReached, targets, itpProver);
            return optional;
        }
    }

    private <T> Optional<ARGState> doPathWiseRefinement(ARGState current, SetMultimap<ARGState, ARGState> successors, Map<ARGState, ARGState> predecessors, ARGReachedSet pReached, List<AbstractState> targets, InterpolatingProverEnvironment<T> itpProver) throws InterruptedException, SolverException, CPAException {
        ArrayList itpStack = new ArrayList();
        ArrayDeque<ARGState> currentPath = new ArrayDeque<ARGState>();
        currentPath.add(current);
        Optional<ARGState> errorState = this.step(currentPath, itpStack, successors, predecessors, pReached, targets, itpProver);
        return errorState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Optional<ARGState> step(Deque<ARGState> currentPath, List<T> itpStack, SetMultimap<ARGState, ARGState> successors, Map<ARGState, ARGState> predecessors, ARGReachedSet pReached, List<AbstractState> targets, InterpolatingProverEnvironment<T> itpProver) throws InterruptedException, SolverException, CPAException {
        for (ARGState succ : successors.get((Object)currentPath.getLast())) {
            assert (succ.getChildren().isEmpty() == targets.contains(succ));
            assert (succ.mayCover());
            BooleanFormula blockFormula = PredicateAbstractState.getPredicateState(succ).getAbstractionFormula().getBlockFormula().getFormula();
            itpStack.add(itpProver.push(blockFormula));
            currentPath.add(succ);
            try {
                Object abstractionStatesTrace;
                this.satCheckTime.start();
                boolean isUnsat = itpProver.isUnsat();
                this.satCheckTime.stop();
                if (isUnsat) {
                    this.logger.log(Level.FINE, new Object[]{"Found unreachable state", succ});
                    abstractionStatesTrace = new ArrayList<ARGState>(currentPath);
                    ARGState cur = succ;
                    while (successors.containsKey((Object)cur)) {
                        ARGState tmp = (ARGState)successors.get((Object)cur).iterator().next();
                        abstractionStatesTrace.add(tmp);
                        cur = tmp;
                    }
                    assert (cur.isTarget()) : "Last state in path has to be a target state";
                    this.performRefinementOnPath(Collections.unmodifiableList(itpStack), succ, (List<ARGState>)abstractionStatesTrace, pReached, itpProver);
                    continue;
                }
                if (targets.contains(succ)) {
                    this.logger.log(Level.FINE, new Object[]{"Found reachable target state", succ});
                    abstractionStatesTrace = Optional.of(succ);
                    return abstractionStatesTrace;
                }
                Optional<ARGState> tmp = this.step(currentPath, itpStack, successors, predecessors, pReached, targets, itpProver);
                if (!tmp.isPresent()) continue;
                Optional<ARGState> optional = tmp;
                return optional;
            }
            finally {
                itpStack.remove(itpStack.size() - 1);
                itpProver.pop();
                currentPath.removeLast();
            }
        }
        return Optional.empty();
    }

    private <T> void performRefinementOnPath(List<T> itpStack, ARGState unreachableState, List<ARGState> pAbstractionStatesTrace, ARGReachedSet reached, InterpolatingProverEnvironment<T> itpProver) throws CPAException, SolverException, InterruptedException {
        assert (!itpStack.isEmpty());
        assert (this.bfmgr.isFalse(itpProver.getInterpolant(itpStack)));
        pAbstractionStatesTrace = FluentIterable.from(pAbstractionStatesTrace).skip(1).toList();
        ArrayList<BooleanFormula> interpolants = new ArrayList<BooleanFormula>();
        boolean visitedUnreachable = false;
        int sublistCounter = 1;
        for (ARGState state : pAbstractionStatesTrace) {
            this.interpolationTime.start();
            boolean bl = visitedUnreachable = visitedUnreachable || state.equals(unreachableState);
            if (visitedUnreachable) {
                interpolants.add(this.bfmgr.makeFalse());
            } else {
                interpolants.add(itpProver.getInterpolant(itpStack.subList(0, sublistCounter)));
                ++sublistCounter;
            }
            this.interpolationTime.stop();
        }
        interpolants.remove(interpolants.size() - 1);
        this.strategy.performRefinement(reached, (List<ARGState>)pAbstractionStatesTrace, interpolants, false);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(new Stats());
    }

    private class Stats
    implements Statistics {
        private Stats() {
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
            StatisticsWriter w0 = StatisticsWriter.writingStatisticsTo(out);
            int numberOfRefinements = PredicateCPAGlobalRefiner.this.totalTime.getUpdateCount();
            w0.put("Number of predicate refinements", numberOfRefinements);
            if (numberOfRefinements > 0) {
                w0.put(PredicateCPAGlobalRefiner.this.totalTime).put(PredicateCPAGlobalRefiner.this.interpolationTime).put(PredicateCPAGlobalRefiner.this.satCheckTime);
            }
        }

        @Override
        public String getName() {
            return "Predicate Global Refiner";
        }
    }
}

