/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.errorprone.annotations.FormatMethod;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.TimeSpanOption;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.log.ForwardingLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CProgramScope;
import org.sosy_lab.cpachecker.cfa.DummyScope;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.bmc.CandidateGenerator;
import org.sosy_lab.cpachecker.core.algorithm.bmc.StaticCandidateProvider;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.SingleLocationFormulaInvariant;
import org.sosy_lab.cpachecker.core.algorithm.invariants.CPAInvariantGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantSupplier;
import org.sosy_lab.cpachecker.core.algorithm.invariants.KInductionInvariantChecker;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonParser;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackStateEqualsWrapper;
import org.sosy_lab.cpachecker.cpa.formulaslicing.LoopTransitionFinder;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateBasedPrefixProvider;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.RCNFManager;
import org.sosy_lab.cpachecker.util.predicates.interpolation.InterpolationManager;
import org.sosy_lab.cpachecker.util.predicates.invariants.FormulaInvariantsSupplier;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.predicates.weakening.InductiveWeakeningManager;
import org.sosy_lab.cpachecker.util.predicates.weakening.WeakeningOptions;
import org.sosy_lab.cpachecker.util.refinement.InfeasiblePrefix;
import org.sosy_lab.cpachecker.util.resources.ResourceLimitChecker;
import org.sosy_lab.cpachecker.util.resources.WalltimeLimit;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="cpa.predicate.invariants", deprecatedPrefix="cpa.predicate")
class PredicateCPAInvariantsManager
implements StatisticsProvider,
InvariantSupplier {
    @Option(secure=true, description="Which strategy should be used for generating invariants, a comma separated list can be specified. Usually later specified strategies serve as fallback for earlier ones. (default is no invariant generation at all)")
    private List<InvariantGenerationStrategy> generationStrategy = new ArrayList<InvariantGenerationStrategy>();
    @Option(secure=true, description="Should the strategies be used all-together or only as fallback. If all together, the computation is done until the timeout is hit and the results up to this point are taken.")
    private boolean useAllStrategies = false;
    @Option(secure=true, description="Timelimit for invariant generation which may be used during refinement.\n(Use seconds or specify a unit; 0 for infinite)")
    @TimeSpanOption(codeUnit=TimeUnit.NANOSECONDS, defaultUserUnit=TimeUnit.SECONDS, min=0L)
    private TimeSpan timeForInvariantGeneration = TimeSpan.ofSeconds((long)10L);
    @Option(secure=true, description="Invariants that are not strong enough to refute the counterexample can be ignored with this option. (Weak invariants will lead to repeated counterexamples, thus taking time which could be used for the rest of the analysis, however, the found invariants may also be better for loops as interpolation.)")
    private boolean useStrongInvariantsOnly = true;
    @Option(secure=true, description="Should the automata used for invariant generation be dumped to files?")
    private boolean dumpInvariantGenerationAutomata = false;
    @Option(secure=true, deprecatedName="useInvariantsForAbstraction", description="Strengthen the pathformula during abstraction with invariants if some are generated. Invariants do not need to be generated with the PredicateCPA they can also be given from outside.")
    private boolean appendToPathFormula = false;
    @Option(secure=true, description="Strengthen the abstraction formula during abstraction with invariants if some are generated. Invariants do not need to be generated with the PredicateCPA they can also be given from outside.")
    private boolean appendToAbstractionFormula = false;
    @Option(secure=true, description="Add computed invariants to the precision. Invariants do not need to be generated with the PredicateCPA they can also be given from outside.")
    private boolean addToPrecision = false;
    @Option(secure=true, description="Provide invariants generated with other analyses via the PredicateCPAInvariantsManager.")
    private boolean useGlobalInvariants = true;
    @Option(secure=true, description="Where to dump the automata that are used to narrow the analysis used for invariant generation.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathCounterTemplate dumpInvariantGenerationAutomataFile = PathCounterTemplate.ofFormatString((String)"invgen.%d.spc");
    @Option(secure=true, description="How often should generating invariants from sliced prefixes with k-induction be tried?")
    private int kInductionTries = 3;
    private Solver solver;
    private FormulaManagerView fmgr;
    private BooleanFormulaManager bfmgr;
    private PathFormulaManager pfmgr;
    private final RCNFManager semiCNFConverter;
    private final CFA cfa;
    private final Configuration config;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final Stats stats = new Stats();
    private final Map<CFANode, Set<BooleanFormula>> locationInvariantsCache = new HashMap<CFANode, Set<BooleanFormula>>();
    private final FormulaInvariantsSupplier globalInvariants;
    private final Specification specification;

    public PredicateCPAInvariantsManager(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa, Specification pSpecification, AggregatedReachedSets pAggregatedReachedSets) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.config = pConfig;
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.specification = pSpecification;
        this.cfa = pCfa;
        this.globalInvariants = new FormulaInvariantsSupplier(pAggregatedReachedSets);
        this.updateGlobalInvariants();
        this.semiCNFConverter = this.generationStrategy.contains((Object)InvariantGenerationStrategy.PF_CNF_KIND) || this.generationStrategy.contains((Object)InvariantGenerationStrategy.PF_INDUCTIVE_WEAKENING) ? new RCNFManager(pConfig) : null;
    }

    public boolean appendToAbstractionFormula() {
        return this.appendToAbstractionFormula;
    }

    public boolean appendToPathFormula() {
        return this.appendToPathFormula;
    }

    public boolean addToPrecision() {
        return this.addToPrecision;
    }

    public void updateGlobalInvariants() {
        this.globalInvariants.updateInvariants();
    }

    @Override
    public BooleanFormula getInvariantFor(CFANode pNode, Optional<CallstackStateEqualsWrapper> pCallstackInformation, FormulaManagerView pFormulaManager, PathFormulaManager pPathFormulaManager, PathFormula pContext) throws InterruptedException {
        BooleanFormulaManagerView bfManager = pFormulaManager.getBooleanFormulaManager();
        Set<BooleanFormula> localInvariants = this.locationInvariantsCache.getOrDefault(pNode, (Set<BooleanFormula>)ImmutableSet.of());
        BooleanFormula globalInvariant = bfManager.makeTrue();
        if (this.useGlobalInvariants) {
            globalInvariant = this.globalInvariants.getInvariantFor(pNode, pCallstackInformation, pFormulaManager, pPathFormulaManager, pContext);
        }
        return bfManager.and(globalInvariant, bfManager.and(localInvariants));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BooleanFormula> findPathInvariants(ARGPath allStatesTrace, List<ARGState> abstractionStatesTrace, Set<LoopStructure.Loop> loopsInPath, PathFormulaManager pPfmgr, Solver pSolver) {
        this.pfmgr = (PathFormulaManager)Preconditions.checkNotNull((Object)pPfmgr);
        this.solver = (Solver)Preconditions.checkNotNull((Object)pSolver);
        this.fmgr = this.solver.getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.stats.invgenTime.start();
        this.stats.totalInvGenTries.inc();
        boolean pathInvariantGenerationSuccessful = false;
        ArrayList<BooleanFormula> foundInvariants = new ArrayList<BooleanFormula>();
        try {
            ResourceLimitChecker limits;
            ShutdownManager invariantShutdown = ShutdownManager.createWithParent((ShutdownNotifier)this.shutdownNotifier);
            if (!this.timeForInvariantGeneration.isEmpty()) {
                WalltimeLimit l = WalltimeLimit.fromNowOn(this.timeForInvariantGeneration);
                limits = new ResourceLimitChecker(invariantShutdown, Collections.singletonList(l));
                limits.start();
            } else {
                limits = null;
            }
            this.logger.log(Level.INFO, new Object[]{"Starting path invariant generation"});
            pathInvariantGenerationSuccessful = this.findInvariantsWithGenerator(allStatesTrace, abstractionStatesTrace, loopsInPath, invariantShutdown, foundInvariants);
            if (pathInvariantGenerationSuccessful) {
                this.logger.log(Level.INFO, new Object[]{"Invariant generation successful"});
            } else {
                this.logger.log(Level.INFO, new Object[]{"All invariants were TRUE, ignoring result."});
            }
            if (limits != null) {
                limits.cancel();
            }
        }
        catch (IOException | InterruptedException | InvalidConfigurationException | CPAException e) {
            this.logger.logUserException(Level.INFO, e, "No invariants could be computed");
            foundInvariants.clear();
        }
        finally {
            if (pathInvariantGenerationSuccessful) {
                this.stats.successfulInvGenTries.inc();
            }
        }
        this.stats.invgenTime.stop();
        return foundInvariants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findInvariants(ARGPath allStatesTrace, List<ARGState> abstractionStatesTrace, PathFormulaManager pPfmgr, Solver pSolver) {
        this.updateGlobalInvariants();
        if (this.generationStrategy.isEmpty()) {
            return;
        }
        this.pfmgr = (PathFormulaManager)Preconditions.checkNotNull((Object)pPfmgr);
        this.solver = (Solver)Preconditions.checkNotNull((Object)pSolver);
        this.fmgr = this.solver.getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        ArrayList<Pair<PathFormula, CFANode>> argForPathFormulaBasedGeneration = new ArrayList<Pair<PathFormula, CFANode>>();
        for (ARGState state : abstractionStatesTrace) {
            CFANode node = AbstractStates.extractLocation(state);
            if (this.cfa.getLoopStructure().orElseThrow().getAllLoopHeads().contains((Object)node)) {
                PredicateAbstractState predState = PredicateAbstractState.getPredicateState(state);
                argForPathFormulaBasedGeneration.add(Pair.of(predState.getAbstractionFormula().getBlockFormula(), node));
                continue;
            }
            if (node.equals(AbstractStates.extractLocation(abstractionStatesTrace.get(abstractionStatesTrace.size() - 1)))) continue;
            argForPathFormulaBasedGeneration.add(Pair.of(null, node));
        }
        boolean atLeastOneStrategyFinished = false;
        boolean atLeastOneSuccessful = false;
        int numUsedStrategies = 0;
        this.stats.invgenTime.start();
        this.stats.totalInvGenTries.inc();
        try {
            ResourceLimitChecker limits;
            ShutdownManager invariantShutdown = ShutdownManager.createWithParent((ShutdownNotifier)this.shutdownNotifier);
            if (!this.timeForInvariantGeneration.isEmpty()) {
                WalltimeLimit l = WalltimeLimit.fromNowOn(this.timeForInvariantGeneration);
                limits = new ResourceLimitChecker(invariantShutdown, Collections.singletonList(l));
                limits.start();
            } else {
                limits = null;
            }
            for (InvariantGenerationStrategy generation : this.generationStrategy) {
                this.logger.log(Level.INFO, new Object[]{"Starting invariant generation with", generation});
                ++numUsedStrategies;
                boolean wasSuccessful = false;
                switch (generation) {
                    case PF_CNF_KIND: {
                        for (Pair pair : argForPathFormulaBasedGeneration) {
                            if (pair.getFirst() != null) {
                                wasSuccessful = this.findInvariantPartOfPathFormulaWithKInduction((CFANode)pair.getSecond(), (PathFormula)pair.getFirst(), invariantShutdown.getNotifier()) || wasSuccessful;
                                continue;
                            }
                            this.addResultToCache(this.bfmgr.makeTrue(), (CFANode)pair.getSecond());
                        }
                        break;
                    }
                    case PF_INDUCTIVE_WEAKENING: {
                        for (Pair pair : argForPathFormulaBasedGeneration) {
                            if (pair.getFirst() != null) {
                                wasSuccessful = this.findInvariantPartOfPathFormulaWithWeakening((CFANode)pair.getSecond(), (PathFormula)pair.getFirst(), invariantShutdown.getNotifier()) || wasSuccessful;
                                continue;
                            }
                            this.addResultToCache(this.bfmgr.makeTrue(), (CFANode)pair.getSecond());
                        }
                        break;
                    }
                    case RF_INTERPOLANT_KIND: {
                        wasSuccessful = this.findInvariantInterpolants(allStatesTrace, abstractionStatesTrace, invariantShutdown.getNotifier());
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Unhandled case statement");
                    }
                }
                if (wasSuccessful) {
                    this.logger.log(Level.INFO, new Object[]{"Invariant generation successful"});
                    atLeastOneSuccessful = true;
                } else {
                    this.logger.log(Level.INFO, new Object[]{"All invariants were TRUE, ignoring result."});
                }
                atLeastOneStrategyFinished = true;
                if (!this.useAllStrategies && (this.useAllStrategies || !atLeastOneSuccessful) && !invariantShutdown.getNotifier().shouldShutdown()) continue;
                break;
            }
            if (limits != null) {
                limits.cancel();
            }
        }
        catch (InterruptedException | InvalidConfigurationException | CPAException | SolverException e) {
            if (atLeastOneStrategyFinished) {
                this.logger.logUserException(Level.INFO, e, "Subsequent run of invariant generation failed");
            } else {
                this.logger.logUserException(Level.INFO, e, "No invariants could be computed");
                atLeastOneSuccessful = false;
            }
        }
        finally {
            if (atLeastOneStrategyFinished) {
                this.stats.terminatingInvGenTries.inc();
            }
            if (atLeastOneSuccessful) {
                this.stats.successfulInvGenTries.inc();
            }
            this.stats.usedStrategiesPerTrie.setNextValue(numUsedStrategies);
        }
        this.stats.invgenTime.stop();
    }

    private void addResultToCache(BooleanFormula pInvariant, CFANode pLocation) {
        if (!this.bfmgr.isTrue(pInvariant)) {
            Set<BooleanFormula> foundInvariants = this.locationInvariantsCache.get(pLocation);
            if (foundInvariants != null) {
                foundInvariants.add(pInvariant);
            } else {
                HashSet<BooleanFormula> invariantSet = new HashSet<BooleanFormula>();
                invariantSet.add(pInvariant);
                this.locationInvariantsCache.put(pLocation, invariantSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findInvariantPartOfPathFormulaWithWeakening(CFANode pLocation, PathFormula pBlockFormula, ShutdownNotifier pInvariantShutdown) throws SolverException, InterruptedException, CPATransferException, InvalidConfigurationException {
        assert (this.semiCNFConverter != null);
        try {
            this.stats.pfWeakeningTime.start();
            PointerTargetSet pts = pBlockFormula.getPointerTargetSet();
            SSAMap ssa = pBlockFormula.getSsa();
            PathFormula loopFormula = new LoopTransitionFinder(this.config, this.cfa.getLoopStructure().orElseThrow(), this.pfmgr, this.logger, pInvariantShutdown).generateLoopTransition(ssa, pts, pLocation);
            ImmutableSet lemmas = Collections3.transformedImmutableSetCopy(this.semiCNFConverter.toLemmasInstantiated(pBlockFormula, this.fmgr), this.fmgr::uninstantiate);
            Set<BooleanFormula> inductiveLemmas = new InductiveWeakeningManager(new WeakeningOptions(this.config), this.solver, this.logger, this.shutdownNotifier).findInductiveWeakeningForRCNF(ssa, loopFormula, (Set<BooleanFormula>)lemmas);
            if (lemmas.isEmpty()) {
                this.logger.log(Level.FINER, new Object[]{"Invariant for location", pLocation, "is true, ignoring it"});
                boolean bl = false;
                return bl;
            }
            this.addResultToCache(this.bfmgr.and(inductiveLemmas), pLocation);
            this.logger.log(Level.FINER, new Object[]{"Generated invariant: ", inductiveLemmas});
            boolean bl = true;
            return bl;
        }
        finally {
            this.stats.pfWeakeningTime.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findInvariantPartOfPathFormulaWithKInduction(CFANode pLocation, PathFormula pPathFormula, ShutdownNotifier pInvariantShutdown) throws InterruptedException, CPAException, InvalidConfigurationException {
        assert (this.semiCNFConverter != null);
        try {
            this.stats.pfKindTime.start();
            ImmutableSet conjuncts = Collections3.transformedImmutableSetCopy(this.semiCNFConverter.toLemmasInstantiated(pPathFormula, this.fmgr), this.fmgr::uninstantiate);
            HashMap formulaToRegion = new HashMap();
            StaticCandidateProvider candidateGenerator = new StaticCandidateProvider((Iterable<? extends CandidateInvariant>)FluentIterable.from((Iterable)conjuncts).transform(pInput -> {
                String dumpedFormula = this.fmgr.dumpFormula((BooleanFormula)pInput).toString();
                formulaToRegion.put(dumpedFormula, pInput);
                return SingleLocationFormulaInvariant.makeLocationInvariant(pLocation, dumpedFormula);
            }));
            new KInductionInvariantChecker(this.config, pInvariantShutdown, (LogManager)new OnlyWarningsLogmanager(this.logger), this.cfa, this.specification, candidateGenerator).checkCandidates();
            Set<CandidateInvariant> invariants = candidateGenerator.getConfirmedCandidates();
            BooleanFormula invariant = this.bfmgr.makeTrue();
            for (CandidateInvariant candidate : invariants) {
                invariant = this.bfmgr.and(invariant, (BooleanFormula)formulaToRegion.get(candidate.toString()));
            }
            if (this.bfmgr.isTrue(invariant)) {
                this.logger.log(Level.FINER, new Object[]{"Invariant for location", pLocation, "is true, ignoring it"});
                boolean bl = false;
                return bl;
            }
            this.addResultToCache(invariant, pLocation);
            boolean bl = true;
            return bl;
        }
        finally {
            this.stats.pfKindTime.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findInvariantsWithGenerator(ARGPath allStatesTrace, List<ARGState> abstractionStatesTrace, Set<LoopStructure.Loop> pLoopsInPath, ShutdownManager pInvariantShutdown, List<BooleanFormula> foundInvariants) throws IOException, InvalidConfigurationException, CPAException, InterruptedException {
        try {
            this.stats.rfInvGenTime.start();
            StringBuilder spc = new StringBuilder();
            ARGUtils.producePathAutomatonWithLoops(spc, allStatesTrace.getFirstState(), allStatesTrace.getStateSet(), "invGen", pLoopsInPath);
            if (this.dumpInvariantGenerationAutomata && this.dumpInvariantGenerationAutomataFile != null) {
                Path logPath = this.dumpInvariantGenerationAutomataFile.getFreshPath();
                IO.writeFile((Path)logPath, (Charset)Charset.defaultCharset(), (Object)spc);
            }
            Scope scope = this.cfa.getLanguage() == Language.C ? new CProgramScope(this.cfa, this.logger) : DummyScope.getInstance();
            List<Automaton> automata = AutomatonParser.parseAutomaton(new StringReader(spc.toString()), Optional.empty(), this.config, this.logger, this.cfa.getMachineModel(), scope, this.cfa.getLanguage(), this.shutdownNotifier);
            InvariantGenerator invGen = CPAInvariantGenerator.create(this.config, (LogManager)new OnlyWarningsLogmanager(this.logger), pInvariantShutdown, Optional.empty(), this.cfa, this.specification, automata);
            boolean bl = this.generateInvariants0(abstractionStatesTrace, invGen, foundInvariants);
            return bl;
        }
        finally {
            this.stats.rfInvGenTime.stop();
        }
    }

    private boolean generateInvariants0(List<ARGState> abstractionStatesTrace, InvariantGenerator invGen, List<BooleanFormula> foundInvariants) throws CPAException, InterruptedException {
        invGen.start(this.cfa.getMainFunction());
        InvariantSupplier invSup = invGen.getSupplier();
        if (!this.useStrongInvariantsOnly || invGen.isProgramSafe()) {
            boolean wasSuccessful;
            ArrayList<Pair<BooleanFormula, CFANode>> invariants = new ArrayList<Pair<BooleanFormula, CFANode>>();
            for (ARGState s : abstractionStatesTrace) {
                if (Objects.equals(s, abstractionStatesTrace.get(abstractionStatesTrace.size() - 1))) continue;
                CFANode location = AbstractStates.extractLocation(s);
                Optional<CallstackStateEqualsWrapper> callstack = AbstractStates.extractOptionalCallstackWraper(s);
                PredicateAbstractState pas = PredicateAbstractState.getPredicateState(s);
                BooleanFormula invariant = invSup.getInvariantFor(location, callstack, this.fmgr, this.pfmgr, pas.getPathFormula());
                invariants.add(Pair.of(invariant, location));
                this.logger.log(Level.FINEST, new Object[]{"Invariant for location", location, "is", invariant});
            }
            boolean bl = wasSuccessful = !FluentIterable.from(invariants).transform(Pair::getFirst).allMatch(Predicates.equalTo((Object)this.fmgr.getBooleanFormulaManager().makeTrue()));
            if (wasSuccessful) {
                FluentIterable.from(invariants).transform(Pair::getFirst).copyInto(foundInvariants);
            }
            return wasSuccessful;
        }
        this.logger.log(Level.INFO, new Object[]{"Invariants found, but they are not strong enough to refute the counterexample consider setting \"useStrongInvariantsOnly\" to false if you want to use them. At least for usage during precision adjustment this should be better than nothing."});
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findInvariantInterpolants(ARGPath pPath, List<ARGState> pAbstractionStatesTrace, ShutdownNotifier pInvariantShutdown) throws CPAException, InterruptedException, InvalidConfigurationException {
        this.stats.rfKindTime.start();
        try {
            InvCandidateGenerator candidateGenerator = new InvCandidateGenerator(pPath, pAbstractionStatesTrace);
            KInductionInvariantChecker invChecker = new KInductionInvariantChecker(this.config, pInvariantShutdown, (LogManager)new OnlyWarningsLogmanager(this.logger), this.cfa, this.specification, candidateGenerator);
            invChecker.checkCandidates();
            if (candidateGenerator.hasFoundInvariants()) {
                boolean wasSuccessful;
                List<Pair<BooleanFormula, CFANode>> invariants = candidateGenerator.retrieveConfirmedInvariants();
                boolean bl = wasSuccessful = !FluentIterable.from(invariants).transform(Pair::getFirst).allMatch(Predicates.equalTo((Object)this.fmgr.getBooleanFormulaManager().makeTrue()));
                if (wasSuccessful) {
                    for (Pair<BooleanFormula, CFANode> invariant : invariants) {
                        this.addResultToCache(this.fmgr.uninstantiate(invariant.getFirst()), invariant.getSecond());
                    }
                }
                boolean bl2 = wasSuccessful;
                return bl2;
            }
            this.logger.log(Level.INFO, new Object[]{"No invariants were found."});
        }
        finally {
            this.stats.rfKindTime.stop();
        }
        return false;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
        if (this.semiCNFConverter != null) {
            this.semiCNFConverter.collectStatistics(pStatsCollection);
        }
    }

    private class Stats
    implements Statistics {
        private final StatTimer invgenTime = new StatTimer("Total time for invariant generation");
        private final StatTimer rfKindTime = new StatTimer("Time for checking interpolants with k-induction");
        private final StatTimer rfInvGenTime = new StatTimer("Time for generation invariants with CPAchecker");
        private final StatTimer pfKindTime = new StatTimer("Time for checking pathformula with k-induction");
        private final StatTimer pfWeakeningTime = new StatTimer("Time for inductive weakening");
        private final StatCounter totalInvGenTries = new StatCounter("Total invariant generation tries");
        private final StatInt usedStrategiesPerTrie = new StatInt(StatKind.AVG, "Used strategies per generation try");
        private final StatCounter successfulInvGenTries = new StatCounter("Successful invariant generation tries");
        private final StatCounter terminatingInvGenTries = new StatCounter("Invariant generation tries finishing in time");

        private Stats() {
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
            StatisticsWriter w0 = StatisticsWriter.writingStatisticsTo(out);
            int numberOfInvGenTries = this.totalInvGenTries.getUpdateCount();
            if (numberOfInvGenTries > 0) {
                w0.put(this.totalInvGenTries).beginLevel().put(this.terminatingInvGenTries).put(this.successfulInvGenTries).put(this.usedStrategiesPerTrie).endLevel().spacer().put(this.invgenTime).beginLevel().put(this.rfKindTime).put(this.rfInvGenTime).put(this.pfKindTime).put(this.pfWeakeningTime).endLevel().spacer().put("Size of invariants cache", String.format("%8d", PredicateCPAInvariantsManager.this.locationInvariantsCache.size()));
            }
        }

        @Override
        public String getName() {
            return "Invariant Generation";
        }
    }

    private static class OnlyWarningsLogmanager
    extends ForwardingLogManager {
        private final LogManager logger;

        public OnlyWarningsLogmanager(LogManager pLogger) {
            this.logger = pLogger;
        }

        public LogManager withComponentName(String pName) {
            return new OnlyWarningsLogmanager(this.logger.withComponentName(pName));
        }

        protected LogManager delegate() {
            return this.logger;
        }

        public boolean wouldBeLogged(Level pPriority) {
            return pPriority.intValue() >= Level.WARNING.intValue() && this.logger.wouldBeLogged(pPriority);
        }

        public void log(Level pPriority, Object ... pArgs) {
            if (this.wouldBeLogged(pPriority)) {
                this.logger.log(pPriority, pArgs);
            }
        }

        public void log(Level pPriority, Supplier<String> pMsgSupplier) {
            if (this.wouldBeLogged(pPriority)) {
                super.log(pPriority, pMsgSupplier);
            }
        }

        @FormatMethod
        public void logf(Level pPriority, String pFormat, Object ... pArgs) {
            if (this.wouldBeLogged(pPriority)) {
                this.logger.logf(pPriority, pFormat, pArgs);
            }
        }

        public void logUserException(Level pPriority, Throwable pE, @Nullable String pAdditionalMessage) {
            if (this.wouldBeLogged(pPriority)) {
                this.logger.logUserException(pPriority, pE, pAdditionalMessage);
            }
        }

        public void logException(Level pPriority, Throwable pE, @Nullable String pAdditionalMessage) {
            if (this.wouldBeLogged(pPriority)) {
                this.logger.logException(pPriority, pE, pAdditionalMessage);
            }
        }
    }

    private class InvCandidateGenerator
    implements CandidateGenerator {
        private int trieNum = 0;
        private List<CandidateInvariant> candidates = new ArrayList<CandidateInvariant>();
        private final ARGPath argPath;
        private final List<CFANode> abstractionNodes;
        private final List<ARGState> abstractionStatesTrace;
        private final List<InfeasiblePrefix> infeasiblePrefixes;
        private final List<CandidateInvariant> foundInvariants = new ArrayList<CandidateInvariant>();
        private final InterpolationManager imgr;

        private InvCandidateGenerator(ARGPath pPath, List<ARGState> pAbstractionStatesTrace) throws CPAException, InterruptedException, InvalidConfigurationException {
            this.argPath = pPath;
            this.abstractionNodes = Collections3.transformedImmutableListCopy(pAbstractionStatesTrace, AbstractStates::extractLocation);
            this.abstractionStatesTrace = pAbstractionStatesTrace;
            this.imgr = new InterpolationManager(PredicateCPAInvariantsManager.this.pfmgr, PredicateCPAInvariantsManager.this.solver, PredicateCPAInvariantsManager.this.cfa.getLoopStructure(), PredicateCPAInvariantsManager.this.cfa.getVarClassification(), PredicateCPAInvariantsManager.this.config, PredicateCPAInvariantsManager.this.shutdownNotifier, PredicateCPAInvariantsManager.this.logger);
            this.infeasiblePrefixes = new PredicateBasedPrefixProvider(PredicateCPAInvariantsManager.this.config, PredicateCPAInvariantsManager.this.logger, PredicateCPAInvariantsManager.this.solver, PredicateCPAInvariantsManager.this.shutdownNotifier).extractInfeasiblePrefixes(this.argPath);
        }

        @Override
        public boolean produceMoreCandidates() {
            if (this.trieNum >= PredicateCPAInvariantsManager.this.kInductionTries) {
                return false;
            }
            if (this.infeasiblePrefixes.isEmpty()) {
                PredicateCPAInvariantsManager.this.logger.log(Level.WARNING, new Object[]{"Could not create infeasible prefixes for invariant generation."});
                return false;
            }
            this.candidates = Lists.newArrayList((Iterable)FluentIterable.from(this.infeasiblePrefixes).transformAndConcat(this::getLocationCandidateInvariant));
            ++this.trieNum;
            return true;
        }

        private List<CandidateInvariant> getLocationCandidateInvariant(InfeasiblePrefix pInput) {
            ArrayList<BooleanFormula> interpolants;
            try {
                ArrayList<BooleanFormula> pathFormula = new ArrayList<BooleanFormula>((Collection<BooleanFormula>)pInput.getPathFormulae());
                while (pathFormula.size() < this.abstractionStatesTrace.size()) {
                    pathFormula.add(PredicateCPAInvariantsManager.this.bfmgr.makeTrue());
                }
                interpolants = (ArrayList<BooleanFormula>)this.imgr.interpolate(pathFormula, (List<AbstractState>)ImmutableList.copyOf(this.abstractionStatesTrace)).orElseThrow();
            }
            catch (InterruptedException | CPAException e) {
                PredicateCPAInvariantsManager.this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not compute interpolants for k-induction inv-gen");
                return ImmutableList.of();
            }
            interpolants = new ArrayList<BooleanFormula>(interpolants);
            interpolants.add(PredicateCPAInvariantsManager.this.bfmgr.makeFalse());
            return (List)Streams.zip(this.abstractionNodes.stream(), interpolants.stream(), (abstractionNode, itp) -> SingleLocationFormulaInvariant.makeLocationInvariant(abstractionNode, PredicateCPAInvariantsManager.this.fmgr.dumpFormula(PredicateCPAInvariantsManager.this.fmgr.uninstantiate(itp)).toString())).collect(ImmutableList.toImmutableList());
        }

        @Override
        public boolean hasCandidatesAvailable() {
            return !this.candidates.isEmpty();
        }

        @Override
        public void confirmCandidates(Iterable<CandidateInvariant> pCandidates) {
            for (CandidateInvariant inv : pCandidates) {
                this.candidates.remove(inv);
                this.foundInvariants.add(inv);
            }
        }

        @Override
        public Iterator<CandidateInvariant> iterator() {
            if (this.trieNum == 0) {
                return Collections.emptyIterator();
            }
            return this.candidates.iterator();
        }

        public boolean hasFoundInvariants() {
            return !this.foundInvariants.isEmpty();
        }

        public Set<CandidateInvariant> getConfirmedCandidates() {
            return new HashSet<CandidateInvariant>(this.foundInvariants);
        }

        public List<Pair<BooleanFormula, CFANode>> retrieveConfirmedInvariants() {
            FluentIterable found = FluentIterable.from(this.foundInvariants);
            ArrayList<Pair<BooleanFormula, CFANode>> invariants = new ArrayList<Pair<BooleanFormula, CFANode>>();
            for (CFANode node : this.abstractionNodes) {
                if (node.equals(this.abstractionNodes.get(this.abstractionNodes.size() - 1))) continue;
                invariants.add(Pair.of((BooleanFormula)found.filter(candidateInvariant -> candidateInvariant.appliesTo(node)).first().transform(candidateInvariant -> {
                    try {
                        return candidateInvariant.getFormula(PredicateCPAInvariantsManager.this.fmgr, PredicateCPAInvariantsManager.this.pfmgr, null);
                    }
                    catch (InterruptedException | CPATransferException e) {
                        PredicateCPAInvariantsManager.this.logger.logUserException(Level.WARNING, (Throwable)e, "Invariant could not be retrieved from InvariantGenerator");
                        return PredicateCPAInvariantsManager.this.fmgr.getBooleanFormulaManager().makeTrue();
                    }
                }).or((Object)PredicateCPAInvariantsManager.this.fmgr.getBooleanFormulaManager().makeTrue()), node));
            }
            return invariants;
        }
    }

    private static enum InvariantGenerationStrategy {
        PF_INDUCTIVE_WEAKENING,
        PF_CNF_KIND,
        RF_INTERPOLANT_KIND;

    }
}

