/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackStateEqualsWrapper;
import org.sosy_lab.cpachecker.cpa.predicate.BlockFormulaStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionRefinementStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPAInvariantsManager;
import org.sosy_lab.cpachecker.cpa.predicate.RefinementStrategy;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.cwriter.LoopCollectingEdgeVisitor;
import org.sosy_lab.cpachecker.util.predicates.NewtonRefinementManager;
import org.sosy_lab.cpachecker.util.predicates.PathChecker;
import org.sosy_lab.cpachecker.util.predicates.UCBRefinementManager;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;
import org.sosy_lab.cpachecker.util.predicates.interpolation.InterpolationManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.refinement.InfeasiblePrefix;
import org.sosy_lab.cpachecker.util.refinement.PrefixProvider;
import org.sosy_lab.cpachecker.util.refinement.PrefixSelector;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;
import org.sosy_lab.java_smt.api.BooleanFormula;

@Options(prefix="cpa.predicate.refinement")
public class PredicateCPARefiner
implements ARGBasedRefiner,
StatisticsProvider {
    @Option(secure=true, description="which sliced prefix should be used for interpolation")
    private List<PrefixSelector.PrefixPreference> prefixPreference = PrefixSelector.NO_SELECTION;
    @Option(secure=true, description="use only the atoms from the interpolantsas predicates, and not the whole interpolant")
    private boolean atomicInterpolants = true;
    @Option(secure=true, description="Should the path invariants be created and used (potentially additionally to the other invariants)")
    private boolean usePathInvariants = false;
    @Option(secure=true, description="use Newton-based Algorithm for the CPA-Refinement, experimental feature!")
    private boolean useNewtonRefinement = false;
    @Option(secure=true, description="use UCB predicates for the CPA-Refinement, experimental feature!")
    private boolean useUCBRefinement = false;
    @Option(secure=true, description="Stop after refining the n-th spurious counterexample and export that. If 0, stop after finding the first spurious counterexample but before refinement. If -1, never stop. If this option is used with a value different from -1, option counterexample.export.alwaysUseImpreciseCounterexamples=true should be set. Then, an actually infeasible counterexample will be handed to export. So this option will also not work with additional counterexample checks or similar, because these may reject the (infeasible) counterexample.")
    @IntegerOption(min=-1L)
    private int stopAfter = -1;
    private final StatInt totalPathLength = new StatInt(StatKind.AVG, "Avg. length of target path (in blocks)");
    private final StatTimer totalRefinement = new StatTimer("Time for refinement");
    private final StatTimer prefixExtractionTime = new StatTimer("Extracting infeasible sliced prefixes");
    private final StatTimer errorPathProcessing = new StatTimer("Error-path post-processing");
    private final StatTimer getFormulasForPathTime = new StatTimer("Path-formulas extraction");
    private final StatInt totalPrefixes = new StatInt(StatKind.SUM, "Number of infeasible sliced prefixes");
    private final StatTimer prefixSelectionTime = new StatTimer("Selecting infeasible sliced prefixes");
    private int refinements = 0;
    private final Set<ImmutableList<CFANode>> lastErrorPaths = new HashSet<ImmutableList<CFANode>>();
    private final PathChecker pathChecker;
    private final PredicateCPAInvariantsManager invariantsManager;
    private final LoopCollectingEdgeVisitor loopFinder;
    private boolean wereInvariantsUsedInLastRefinement = false;
    private boolean wereInvariantsusedInCurrentRefinement = false;
    private final Map<CFANode, BooleanFormula> lastInvariantForNode = new HashMap<CFANode, BooleanFormula>();
    private final PrefixProvider prefixProvider;
    private final PrefixSelector prefixSelector;
    private final LogManager logger;
    private final BlockFormulaStrategy blockFormulaStrategy;
    private final Solver solver;
    private final FormulaManagerView fmgr;
    private final PathFormulaManager pfmgr;
    private final InterpolationManager interpolationManager;
    private final RefinementStrategy strategy;
    private final Optional<NewtonRefinementManager> newtonManager;
    private final Optional<UCBRefinementManager> ucbManager;

    public PredicateCPARefiner(Configuration pConfig, LogManager pLogger, Optional<LoopStructure> pLoopStructure, BlockFormulaStrategy pBlockFormulaStrategy, Solver pSolver, PathFormulaManager pPfgmr, InterpolationManager pInterpolationManager, PathChecker pPathChecker, PrefixProvider pPrefixProvider, PrefixSelector pPrefixSelector, PredicateCPAInvariantsManager pInvariantsManager, RefinementStrategy pStrategy) throws InvalidConfigurationException {
        pConfig.inject((Object)this, PredicateCPARefiner.class);
        this.logger = pLogger;
        this.blockFormulaStrategy = pBlockFormulaStrategy;
        this.solver = pSolver;
        this.fmgr = this.solver.getFormulaManager();
        this.pfmgr = pPfgmr;
        this.interpolationManager = pInterpolationManager;
        this.pathChecker = pPathChecker;
        this.strategy = pStrategy;
        this.prefixProvider = pPrefixProvider;
        this.prefixSelector = pPrefixSelector;
        this.invariantsManager = pInvariantsManager;
        if (pLoopStructure.isPresent()) {
            this.loopFinder = new LoopCollectingEdgeVisitor(pLoopStructure.orElseThrow(), pConfig);
        } else {
            this.loopFinder = null;
            if (this.invariantsManager.addToPrecision()) {
                this.logger.log(Level.WARNING, new Object[]{"Invariants should be used during refinement, but loop information is not present."});
            }
        }
        this.newtonManager = this.useNewtonRefinement ? Optional.of(new NewtonRefinementManager(this.logger, this.solver, this.pfmgr, pConfig)) : Optional.empty();
        this.ucbManager = this.useUCBRefinement ? Optional.of(new UCBRefinementManager(this.logger, this.solver, this.pfmgr)) : Optional.empty();
        this.logger.log(Level.INFO, new Object[]{"Using refinement for predicate analysis with " + this.strategy.getClass().getSimpleName() + " strategy."});
    }

    private BlockFormulaStrategy.BlockFormulas createFormulasOnPath(ARGPath allStatesTrace, List<ARGState> abstractionStatesTrace) throws CPAException, InterruptedException {
        BlockFormulaStrategy.BlockFormulas formulas;
        BlockFormulaStrategy.BlockFormulas blockFormulas = formulas = this.isRefinementSelectionEnabled() ? this.performRefinementSelection(allStatesTrace, abstractionStatesTrace) : this.getFormulasForPath(abstractionStatesTrace, allStatesTrace.getFirstState());
        assert (abstractionStatesTrace.size() == formulas.getSize()) : abstractionStatesTrace.size() + " != " + formulas.getSize();
        this.logger.log(Level.ALL, new Object[]{"Error path formulas: ", formulas});
        return formulas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CounterexampleInfo performRefinementForPath(ARGReachedSet pReached, ARGPath allStatesTrace) throws CPAException, InterruptedException {
        this.totalRefinement.start();
        try {
            ++this.refinements;
            ImmutableList errorPath = (ImmutableList)allStatesTrace.asStatesList().stream().map(AbstractStates::extractLocation).filter(x -> x != null).collect(ImmutableList.toImmutableList());
            boolean repeatedCounterexample = this.lastErrorPaths.contains(errorPath);
            this.lastErrorPaths.add((ImmutableList<CFANode>)errorPath);
            List<ARGState> abstractionStatesTrace = PredicateCPARefiner.filterAbstractionStates(allStatesTrace);
            this.totalPathLength.setNextValue(abstractionStatesTrace.size());
            this.logger.log(Level.ALL, new Object[]{"Abstraction trace is", abstractionStatesTrace});
            BlockFormulaStrategy.BlockFormulas formulas = this.createFormulasOnPath(allStatesTrace, abstractionStatesTrace);
            this.invariantsManager.findInvariants(allStatesTrace, abstractionStatesTrace, this.pfmgr, this.solver);
            CounterexampleTraceInfo counterexample = this.checkCounterexample(allStatesTrace, abstractionStatesTrace, formulas, repeatedCounterexample);
            if (counterexample.isSpurious() && (this.stopAfter < 0 || this.refinements <= this.stopAfter)) {
                this.logger.log(Level.FINEST, new Object[]{"Error trace is spurious, refining the abstraction"});
                boolean trackFurtherCEX = this.strategy.performRefinement(pReached, abstractionStatesTrace, (List<BooleanFormula>)counterexample.getInterpolants(), repeatedCounterexample && !this.wereInvariantsUsedInLastRefinement);
                if (!trackFurtherCEX) {
                    this.lastErrorPaths.clear();
                    this.lastErrorPaths.add((ImmutableList<CFANode>)errorPath);
                }
                this.wereInvariantsUsedInLastRefinement = this.wereInvariantsusedInCurrentRefinement;
                this.wereInvariantsusedInCurrentRefinement = false;
                CounterexampleInfo counterexampleInfo = CounterexampleInfo.spurious();
                return counterexampleInfo;
            }
            this.logger.log(Level.FINEST, new Object[]{"Error trace is not spurious"});
            this.errorPathProcessing.start();
            try {
                CounterexampleInfo counterexampleInfo = this.pathChecker.handleFeasibleCounterexample(counterexample, allStatesTrace);
                this.errorPathProcessing.stop();
                return counterexampleInfo;
            }
            catch (Throwable throwable) {
                this.errorPathProcessing.stop();
                throw throwable;
            }
        }
        finally {
            this.totalRefinement.stop();
        }
    }

    private CounterexampleTraceInfo checkCounterexample(ARGPath allStatesTrace, List<ARGState> abstractionStatesTrace, BlockFormulaStrategy.BlockFormulas formulas, boolean repeatedCounterexample) throws CPAException, InterruptedException {
        Preconditions.checkArgument((abstractionStatesTrace.size() == formulas.getSize() ? 1 : 0) != 0, (Object)"each abstraction state should have a block formula");
        Preconditions.checkArgument((abstractionStatesTrace.size() <= allStatesTrace.size() ? 1 : 0) != 0, (Object)"each abstraction state should have a state in the counterexample trace");
        if (this.strategy instanceof PredicateAbstractionRefinementStrategy) {
            ((PredicateAbstractionRefinementStrategy)this.strategy).setUseAtomicPredicates(this.atomicInterpolants);
        }
        if (!repeatedCounterexample && (this.invariantsManager.addToPrecision() || this.usePathInvariants)) {
            return this.performInvariantsRefinement(allStatesTrace, abstractionStatesTrace, formulas);
        }
        if (this.useNewtonRefinement) {
            assert (this.newtonManager.isPresent());
            if (!repeatedCounterexample) {
                try {
                    this.logger.log(Level.FINEST, new Object[]{"Starting Newton-based refinement"});
                    return this.performNewtonRefinement(allStatesTrace, formulas);
                }
                catch (RefinementFailedException e) {
                    if (e.getReason() == RefinementFailedException.Reason.SequenceOfAssertionsToWeak && this.newtonManager.orElseThrow().fallbackToInterpolation()) {
                        this.logger.log(Level.FINEST, new Object[]{"Fallback from Newton-based refinement to interpolation-based refinement"});
                        return this.performInterpolatingRefinement(allStatesTrace, abstractionStatesTrace, formulas);
                    }
                    throw e;
                }
            }
            this.logger.log(Level.FINEST, new Object[]{"Fallback from Newton-based refinement to interpolation-based refinement"});
            return this.performInterpolatingRefinement(allStatesTrace, abstractionStatesTrace, formulas);
        }
        if (this.useUCBRefinement) {
            this.logger.log(Level.FINEST, new Object[]{"Starting unsat-core-based refinement"});
            return this.performUCBRefinement(allStatesTrace, abstractionStatesTrace, formulas);
        }
        this.logger.log(Level.FINEST, new Object[]{"Starting interpolation-based refinement."});
        return this.performInterpolatingRefinement(allStatesTrace, abstractionStatesTrace, formulas);
    }

    private CounterexampleTraceInfo performInterpolatingRefinement(ARGPath allStatesTrace, List<ARGState> abstractionStatesTrace, BlockFormulaStrategy.BlockFormulas formulas) throws CPAException, InterruptedException {
        return this.interpolationManager.buildCounterexampleTrace(formulas, (List<AbstractState>)ImmutableList.copyOf(abstractionStatesTrace), Optional.of(allStatesTrace));
    }

    private CounterexampleTraceInfo performInvariantsRefinement(ARGPath allStatesTrace, List<ARGState> abstractionStatesTrace, BlockFormulaStrategy.BlockFormulas formulas) throws CPAException, InterruptedException {
        CounterexampleTraceInfo counterexample = this.interpolationManager.buildCounterexampleTraceWithoutInterpolation(formulas, Optional.of(allStatesTrace));
        if (counterexample.isSpurious()) {
            this.logger.log(Level.FINEST, new Object[]{"Error trace is spurious, refining the abstraction"});
            List<Object> precisionIncrement = new ArrayList();
            if (this.invariantsManager.addToPrecision()) {
                precisionIncrement = this.addInvariants(abstractionStatesTrace);
            }
            if (this.usePathInvariants) {
                precisionIncrement = this.addPathInvariants(allStatesTrace, abstractionStatesTrace, precisionIncrement);
            }
            if (precisionIncrement.isEmpty()) {
                this.logger.log(Level.FINEST, new Object[]{"Starting interpolation-based refinement because invariant generation was not successful."});
                return this.performInterpolatingRefinement(allStatesTrace, abstractionStatesTrace, formulas);
            }
            this.wereInvariantsusedInCurrentRefinement = true;
            return CounterexampleTraceInfo.infeasible(precisionIncrement);
        }
        return counterexample;
    }

    private CounterexampleTraceInfo performNewtonRefinement(ARGPath pAllStatesTrace, BlockFormulaStrategy.BlockFormulas pFormulas) throws CPAException, InterruptedException {
        return this.newtonManager.orElseThrow().buildCounterexampleTrace(pAllStatesTrace, pFormulas);
    }

    private CounterexampleTraceInfo performUCBRefinement(ARGPath allStatesTrace, List<ARGState> pAbstractionStatesTrace, BlockFormulaStrategy.BlockFormulas pFormulas) throws CPAException, InterruptedException {
        assert (this.ucbManager.isPresent());
        return this.ucbManager.orElseThrow().buildCounterexampleTrace(allStatesTrace, pAbstractionStatesTrace, pFormulas);
    }

    private List<BooleanFormula> addInvariants(List<ARGState> abstractionStatesTrace) throws InterruptedException {
        ArrayList<BooleanFormula> precisionIncrement = new ArrayList<BooleanFormula>();
        boolean invIsTriviallyTrue = true;
        for (ARGState state : FluentIterable.from(abstractionStatesTrace).limit(abstractionStatesTrace.size() - 1)) {
            CFANode location = AbstractStates.extractLocation(state);
            Optional<CallstackStateEqualsWrapper> callstack = AbstractStates.extractOptionalCallstackWraper(state);
            BooleanFormula inv = this.invariantsManager.getInvariantFor(location, callstack, this.fmgr, this.pfmgr, null);
            if (!(!invIsTriviallyTrue || this.fmgr.getBooleanFormulaManager().isTrue(inv) || this.lastInvariantForNode.containsKey(location) && this.lastInvariantForNode.get(location).equals(inv))) {
                invIsTriviallyTrue = false;
                this.lastInvariantForNode.put(location, inv);
            }
            precisionIncrement.add(inv);
        }
        assert (precisionIncrement.size() == abstractionStatesTrace.size() - 1);
        if (invIsTriviallyTrue) {
            precisionIncrement.clear();
        }
        return precisionIncrement;
    }

    private List<BooleanFormula> addPathInvariants(ARGPath allStatesTrace, List<ARGState> abstractionStatesTrace, List<BooleanFormula> precisionIncrement) {
        Set<LoopStructure.Loop> loopsInPath = this.getRelevantLoops(allStatesTrace);
        if (!loopsInPath.isEmpty()) {
            List<BooleanFormula> pathInvariants = this.invariantsManager.findPathInvariants(allStatesTrace, abstractionStatesTrace, loopsInPath, this.pfmgr, this.solver);
            if (precisionIncrement.isEmpty()) {
                precisionIncrement = pathInvariants;
            } else {
                Preconditions.checkState((precisionIncrement.size() == pathInvariants.size() ? 1 : 0) != 0);
                Iterator<BooleanFormula> invIt = precisionIncrement.iterator();
                Iterator<BooleanFormula> pathInvIt = pathInvariants.iterator();
                ArrayList<BooleanFormula> mergeFormulas = new ArrayList<BooleanFormula>();
                while (invIt.hasNext()) {
                    mergeFormulas.add(this.fmgr.getBooleanFormulaManager().and(invIt.next(), pathInvIt.next()));
                }
                precisionIncrement = mergeFormulas;
            }
        } else {
            this.logger.log(Level.WARNING, new Object[]{"Path invariants could not be computed, loop information is missing"});
        }
        return precisionIncrement;
    }

    private Set<LoopStructure.Loop> getRelevantLoops(ARGPath allStatesTrace) {
        if (this.loopFinder == null) {
            return ImmutableSet.of();
        }
        this.loopFinder.reset();
        PathIterator pathIt = allStatesTrace.fullPathIterator();
        while (pathIt.hasNext()) {
            if (pathIt.isPositionWithState()) {
                this.loopFinder.visit(pathIt.getAbstractState(), pathIt.getOutgoingEdge(), null);
            } else {
                this.loopFinder.visit(pathIt.getPreviousAbstractState(), pathIt.getOutgoingEdge(), null);
            }
            pathIt.advance();
        }
        return this.loopFinder.getRelevantLoops().keySet();
    }

    private boolean isRefinementSelectionEnabled() {
        return !this.prefixPreference.equals(PrefixSelector.NO_SELECTION);
    }

    static List<ARGState> filterAbstractionStates(ARGPath pPath) {
        ImmutableList result = FluentIterable.from(pPath.asStatesList()).skip(1).filter(PredicateAbstractState::containsAbstractionState).toList();
        assert (Objects.equals(pPath.getLastState(), result.get(result.size() - 1)));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockFormulaStrategy.BlockFormulas getFormulasForPath(List<ARGState> path, ARGState initialState) throws CPATransferException, InterruptedException {
        this.getFormulasForPathTime.start();
        try {
            BlockFormulaStrategy.BlockFormulas blockFormulas = this.blockFormulaStrategy.getFormulasForPath(initialState, path);
            return blockFormulas;
        }
        finally {
            this.getFormulasForPathTime.stop();
        }
    }

    private BlockFormulaStrategy.BlockFormulas performRefinementSelection(ARGPath pAllStatesTrace, List<ARGState> pAbstractionStatesTrace) throws InterruptedException, CPAException {
        this.prefixExtractionTime.start();
        List<InfeasiblePrefix> infeasiblePrefixes = this.prefixProvider.extractInfeasiblePrefixes(pAllStatesTrace);
        this.prefixExtractionTime.stop();
        this.totalPrefixes.setNextValue(infeasiblePrefixes.size());
        if (infeasiblePrefixes.isEmpty()) {
            return this.getFormulasForPath(pAbstractionStatesTrace, pAllStatesTrace.getFirstState());
        }
        this.prefixSelectionTime.start();
        InfeasiblePrefix selectedPrefix = this.prefixSelector.selectSlicedPrefix(this.prefixPreference, infeasiblePrefixes);
        this.prefixSelectionTime.stop();
        ArrayList<BooleanFormula> formulas = new ArrayList<BooleanFormula>((Collection<BooleanFormula>)selectedPrefix.getPathFormulae());
        while (formulas.size() < pAbstractionStatesTrace.size()) {
            formulas.add(this.fmgr.getBooleanFormulaManager().makeTrue());
        }
        return new BlockFormulaStrategy.BlockFormulas(formulas);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(new Stats());
        if (this.strategy instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.strategy)).collectStatistics(pStatsCollection);
        }
        if (this.useNewtonRefinement) {
            this.newtonManager.orElseThrow().collectStatistics(pStatsCollection);
        }
    }

    private class Stats
    implements Statistics {
        private Stats() {
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
            StatisticsWriter w0 = StatisticsWriter.writingStatisticsTo(out);
            int numberOfRefinements = PredicateCPARefiner.this.totalRefinement.getUpdateCount();
            w0.put("Number of predicate refinements", PredicateCPARefiner.this.totalRefinement.getUpdateCount());
            StatisticsWriter w1 = w0.beginLevel();
            if (numberOfRefinements > 0) {
                w0.put(PredicateCPARefiner.this.totalPathLength).put(PredicateCPARefiner.this.totalPrefixes).spacer().put(PredicateCPARefiner.this.totalRefinement);
                w1.put(PredicateCPARefiner.this.getFormulasForPathTime);
                if (PredicateCPARefiner.this.isRefinementSelectionEnabled()) {
                    w1.put(PredicateCPARefiner.this.prefixExtractionTime);
                    w1.put(PredicateCPARefiner.this.prefixSelectionTime);
                }
            }
            PredicateCPARefiner.this.interpolationManager.printStatistics(w1);
            w1.putIfUpdatedAtLeastOnce(PredicateCPARefiner.this.errorPathProcessing);
        }

        @Override
        public String getName() {
            return "PredicateCPARefiner";
        }
    }
}

