/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.cpa.arg.ARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.predicate.BlockFormulaSlicer;
import org.sosy_lab.cpachecker.cpa.predicate.BlockFormulaStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateBasedPrefixProvider;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPAInvariantsManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPARefiner;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateStaticRefiner;
import org.sosy_lab.cpachecker.cpa.predicate.RefinementStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.SlicingAbstractionsBlockFormulaStrategy;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.predicates.PathChecker;
import org.sosy_lab.cpachecker.util.predicates.interpolation.InterpolationManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.refinement.PrefixSelector;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;

@Options(prefix="cpa.predicate.refinement")
public class PredicateCPARefinerFactory {
    @Option(secure=true, description="slice block formulas, experimental feature!")
    private boolean sliceBlockFormulas = false;
    @Option(secure=true, name="graphblockformulastrategy", description="BlockFormulaStrategy for graph-like ARGs (e.g. Slicing Abstractions)")
    private boolean graphBlockFormulaStrategy = false;
    @Option(secure=true, description="use heuristic to extract predicates from the CFA statically on first refinement")
    private boolean performInitialStaticRefinement = false;
    private final PredicateCPA predicateCpa;
    private @Nullable BlockFormulaStrategy blockFormulaStrategy = null;

    public PredicateCPARefinerFactory(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        this.predicateCpa = CPAs.retrieveCPAOrFail((ConfigurableProgramAnalysis)Preconditions.checkNotNull((Object)pCpa), PredicateCPA.class, PredicateCPARefiner.class);
        this.predicateCpa.getConfiguration().inject((Object)this);
    }

    @CanIgnoreReturnValue
    public PredicateCPARefinerFactory forbidStaticRefinements() throws InvalidConfigurationException {
        if (this.performInitialStaticRefinement) {
            throw new InvalidConfigurationException("Static refinement is not supported with the configured refiner, please turn cpa.predicate.refinement.useStaticRefinement off.");
        }
        return this;
    }

    @CanIgnoreReturnValue
    public PredicateCPARefinerFactory setBlockFormulaStrategy(BlockFormulaStrategy pBlockFormulaStrategy) {
        Preconditions.checkState((this.blockFormulaStrategy == null ? 1 : 0) != 0);
        this.blockFormulaStrategy = (BlockFormulaStrategy)Preconditions.checkNotNull((Object)pBlockFormulaStrategy);
        return this;
    }

    public ARGBasedRefiner create(RefinementStrategy pRefinementStrategy) throws InvalidConfigurationException {
        BlockFormulaStrategy bfs;
        Preconditions.checkNotNull((Object)pRefinementStrategy);
        Configuration config = this.predicateCpa.getConfiguration();
        LogManager logger = this.predicateCpa.getLogger();
        ShutdownNotifier shutdownNotifier = this.predicateCpa.getShutdownNotifier();
        Solver solver = this.predicateCpa.getSolver();
        PathFormulaManager pfmgr = this.predicateCpa.getPathFormulaManager();
        CFA cfa = this.predicateCpa.getCfa();
        MachineModel machineModel = cfa.getMachineModel();
        Optional<VariableClassification> variableClassification = cfa.getVarClassification();
        Optional<LoopStructure> loopStructure = cfa.getLoopStructure();
        PredicateAbstractionManager predAbsManager = this.predicateCpa.getPredicateManager();
        PredicateCPAInvariantsManager invariantsManager = this.predicateCpa.getInvariantsManager();
        PredicateBasedPrefixProvider prefixProvider = new PredicateBasedPrefixProvider(config, logger, solver, shutdownNotifier);
        PrefixSelector prefixSelector = new PrefixSelector(variableClassification, loopStructure, logger);
        InterpolationManager interpolationManager = new InterpolationManager(pfmgr, solver, loopStructure, variableClassification, config, shutdownNotifier, logger);
        PathChecker pathChecker = new PathChecker(config, logger, shutdownNotifier, machineModel, pfmgr, solver);
        if (this.blockFormulaStrategy != null) {
            if (this.sliceBlockFormulas) {
                throw new InvalidConfigurationException("Block-formula slicing is not supported with this refiner, please turn cpa.predicate.refinement.sliceBlockFormula off.");
            }
            bfs = this.blockFormulaStrategy;
        } else {
            bfs = this.sliceBlockFormulas ? new BlockFormulaSlicer(pfmgr) : (this.graphBlockFormulaStrategy ? new SlicingAbstractionsBlockFormulaStrategy(solver, config, pfmgr) : new BlockFormulaStrategy());
        }
        StatisticsProvider refiner = new PredicateCPARefiner(config, logger, loopStructure, bfs, solver, pfmgr, interpolationManager, pathChecker, prefixProvider, prefixSelector, invariantsManager, pRefinementStrategy);
        if (this.performInitialStaticRefinement) {
            refiner = new PredicateStaticRefiner(config, logger, shutdownNotifier, solver, pfmgr, predAbsManager, bfs, interpolationManager, pathChecker, cfa, (ARGBasedRefiner)((Object)refiner));
        }
        return refiner;
    }
}

